/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001B\u001f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\bH\u0016J\b\u0010 \u001a\u00020\bH\u0016J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\bH\u0016J\b\u0010\"\u001a\u00020\u0003H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\f\u0082\u0001\u0002#$\u00a8\u0006%"}, d2={"Lkotlinx/serialization/internal/MapLikeDescriptor;", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialName", "", "keyDescriptor", "valueDescriptor", "(Ljava/lang/String;Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "elementsCount", "", "getElementsCount", "()I", "getKeyDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "kind", "Lkotlinx/serialization/descriptors/SerialKind;", "getKind", "()Lkotlinx/serialization/descriptors/SerialKind;", "getSerialName", "()Ljava/lang/String;", "getValueDescriptor", "equals", "", "other", "", "getElementAnnotations", "", "", "index", "getElementDescriptor", "getElementIndex", "name", "getElementName", "hashCode", "isElementOptional", "toString", "Lkotlinx/serialization/internal/LinkedHashMapClassDesc;", "Lkotlinx/serialization/internal/HashMapClassDesc;", "kotlinx-serialization-core"})
public abstract class MapLikeDescriptor
implements SerialDescriptor {
    @NotNull
    private final String serialName;
    @NotNull
    private final SerialDescriptor keyDescriptor;
    @NotNull
    private final SerialDescriptor valueDescriptor;
    private final int elementsCount;

    private MapLikeDescriptor(String serialName, SerialDescriptor keyDescriptor, SerialDescriptor valueDescriptor) {
        this.serialName = serialName;
        this.keyDescriptor = keyDescriptor;
        this.valueDescriptor = valueDescriptor;
        this.elementsCount = 2;
    }

    @Override
    @NotNull
    public String getSerialName() {
        return this.serialName;
    }

    @NotNull
    public final SerialDescriptor getKeyDescriptor() {
        return this.keyDescriptor;
    }

    @NotNull
    public final SerialDescriptor getValueDescriptor() {
        return this.valueDescriptor;
    }

    @Override
    @NotNull
    public SerialKind getKind() {
        return StructureKind.MAP.INSTANCE;
    }

    @Override
    public int getElementsCount() {
        return this.elementsCount;
    }

    @Override
    @NotNull
    public String getElementName(int index2) {
        return String.valueOf(index2);
    }

    @Override
    public int getElementIndex(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Integer n = StringsKt.toIntOrNull(name2);
        if (n == null) {
            throw new IllegalArgumentException(Intrinsics.stringPlus(name2, " is not a valid map index"));
        }
        return n;
    }

    @Override
    public boolean isElementOptional(int index2) {
        if (!(index2 >= 0)) {
            boolean bl = false;
            String string2 = "Illegal index " + index2 + ", " + this.getSerialName() + " expects only non-negative indices";
            throw new IllegalArgumentException(string2.toString());
        }
        return false;
    }

    @Override
    @NotNull
    public List<Annotation> getElementAnnotations(int index2) {
        if (!(index2 >= 0)) {
            boolean bl = false;
            String string2 = "Illegal index " + index2 + ", " + this.getSerialName() + " expects only non-negative indices";
            throw new IllegalArgumentException(string2.toString());
        }
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public SerialDescriptor getElementDescriptor(int index2) {
        SerialDescriptor serialDescriptor;
        if (!(index2 >= 0)) {
            boolean bl = false;
            String string2 = "Illegal index " + index2 + ", " + this.getSerialName() + " expects only non-negative indices";
            throw new IllegalArgumentException(string2.toString());
        }
        switch (index2 % 2) {
            case 0: {
                serialDescriptor = this.keyDescriptor;
                break;
            }
            case 1: {
                serialDescriptor = this.valueDescriptor;
                break;
            }
            default: {
                throw new IllegalStateException("Unreached".toString());
            }
        }
        return serialDescriptor;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MapLikeDescriptor)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getSerialName(), ((MapLikeDescriptor)other).getSerialName())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.keyDescriptor, ((MapLikeDescriptor)other).keyDescriptor)) {
            return false;
        }
        return Intrinsics.areEqual(this.valueDescriptor, ((MapLikeDescriptor)other).valueDescriptor);
    }

    public int hashCode() {
        int result2 = this.getSerialName().hashCode();
        result2 = 31 * result2 + this.keyDescriptor.hashCode();
        result2 = 31 * result2 + this.valueDescriptor.hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return this.getSerialName() + '(' + this.keyDescriptor + ", " + this.valueDescriptor + ')';
    }

    @Override
    public boolean isNullable() {
        return SerialDescriptor.DefaultImpls.isNullable(this);
    }

    @Override
    public boolean isInline() {
        return SerialDescriptor.DefaultImpls.isInline(this);
    }

    @Override
    @NotNull
    public List<Annotation> getAnnotations() {
        return SerialDescriptor.DefaultImpls.getAnnotations(this);
    }

    public /* synthetic */ MapLikeDescriptor(String serialName, SerialDescriptor keyDescriptor, SerialDescriptor valueDescriptor, DefaultConstructorMarker $constructor_marker) {
        this(serialName, keyDescriptor, valueDescriptor);
    }
}

