/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonNames;
import kotlinx.serialization.json.JsonSchemaCacheKt;
import kotlinx.serialization.json.internal.CreateMapForCacheKt;
import kotlinx.serialization.json.internal.DescriptorSchemaCache;
import kotlinx.serialization.json.internal.JsonException;
import kotlinx.serialization.json.internal.JsonNamesMapKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u001a\u0018\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002*\u00020\nH\u0000\u001a\u001c\u0010\u000b\u001a\u00020\u0004*\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0000\u001a\u001c\u0010\u000f\u001a\u00020\u0004*\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0000\u001aF\u0010\u0010\u001a\u00020\u0011*\u00020\r2\u0006\u0010\u0012\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00142\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014H\u0080\b\u00f8\u0001\u0000\".\u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u00018\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0018"}, d2={"JsonAlternativeNamesKey", "Lkotlinx/serialization/json/internal/DescriptorSchemaCache$Key;", "", "", "", "getJsonAlternativeNamesKey$annotations", "()V", "getJsonAlternativeNamesKey", "()Lkotlinx/serialization/json/internal/DescriptorSchemaCache$Key;", "buildAlternativeNamesMap", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getJsonNameIndex", "json", "Lkotlinx/serialization/json/Json;", "name", "getJsonNameIndexOrThrow", "tryCoerceValue", "", "elementDescriptor", "peekNull", "Lkotlin/Function0;", "peekString", "onEnumCoercing", "", "kotlinx-serialization-json"})
public final class JsonNamesMapKt {
    @NotNull
    private static final DescriptorSchemaCache.Key<Map<String, Integer>> JsonAlternativeNamesKey = new DescriptorSchemaCache.Key();

    @NotNull
    public static final DescriptorSchemaCache.Key<Map<String, Integer>> getJsonAlternativeNamesKey() {
        return JsonAlternativeNamesKey;
    }

    public static /* synthetic */ void getJsonAlternativeNamesKey$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Integer> buildAlternativeNamesMap(@NotNull SerialDescriptor $this$buildAlternativeNamesMap) {
        Intrinsics.checkNotNullParameter($this$buildAlternativeNamesMap, "<this>");
        Map<String, Integer> builder2 = null;
        int n = 0;
        int n2 = $this$buildAlternativeNamesMap.getElementsCount();
        while (n < n2) {
            String[] $this$forEach$iv;
            void $this$filterIsInstanceTo$iv$iv;
            int i = n++;
            Iterable $this$filterIsInstance$iv = $this$buildAlternativeNamesMap.getElementAnnotations(i);
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof JsonNames)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            JsonNames jsonNames = (JsonNames)CollectionsKt.singleOrNull((List)destination$iv$iv);
            if (jsonNames == null || jsonNames.names() == null) continue;
            boolean $i$f$forEach = false;
            String[] stringArray = $this$forEach$iv;
            int n3 = 0;
            int n4 = stringArray.length;
            while (n3 < n4) {
                String element$iv = stringArray[n3];
                ++n3;
                String name2 = element$iv;
                boolean bl = false;
                if (builder2 == null) {
                    builder2 = CreateMapForCacheKt.createMapForCache($this$buildAlternativeNamesMap.getElementsCount());
                }
                Map<String, Integer> map2 = builder2;
                Intrinsics.checkNotNull(map2);
                JsonNamesMapKt.buildAlternativeNamesMap$putOrThrow(map2, $this$buildAlternativeNamesMap, name2, i);
            }
        }
        Map<String, Integer> map3 = builder2;
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        return map3;
    }

    public static final int getJsonNameIndex(@NotNull SerialDescriptor $this$getJsonNameIndex, @NotNull Json json, @NotNull String name2) {
        Intrinsics.checkNotNullParameter($this$getJsonNameIndex, "<this>");
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(name2, "name");
        int index2 = $this$getJsonNameIndex.getElementIndex(name2);
        if (index2 != -3) {
            return index2;
        }
        if (!json.getConfiguration().getUseAlternativeNames()) {
            return index2;
        }
        Map<String, Integer> alternativeNamesMap2 = JsonSchemaCacheKt.getSchemaCache(json).getOrPut($this$getJsonNameIndex, JsonAlternativeNamesKey, (Function0)new Function0<Map<String, ? extends Integer>>((Object)$this$getJsonNameIndex){

            @NotNull
            public final Map<String, Integer> invoke() {
                return JsonNamesMapKt.buildAlternativeNamesMap((SerialDescriptor)this.receiver);
            }
        });
        Integer n = alternativeNamesMap2.get(name2);
        return n == null ? -3 : n;
    }

    public static final int getJsonNameIndexOrThrow(@NotNull SerialDescriptor $this$getJsonNameIndexOrThrow, @NotNull Json json, @NotNull String name2) {
        Intrinsics.checkNotNullParameter($this$getJsonNameIndexOrThrow, "<this>");
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(name2, "name");
        int index2 = JsonNamesMapKt.getJsonNameIndex($this$getJsonNameIndexOrThrow, json, name2);
        if (index2 == -3) {
            throw new SerializationException($this$getJsonNameIndexOrThrow.getSerialName() + " does not contain element with name '" + name2 + '\'');
        }
        return index2;
    }

    public static final boolean tryCoerceValue(@NotNull Json $this$tryCoerceValue, @NotNull SerialDescriptor elementDescriptor2, @NotNull Function0<Boolean> peekNull, @NotNull Function0<String> peekString, @NotNull Function0<Unit> onEnumCoercing) {
        Intrinsics.checkNotNullParameter($this$tryCoerceValue, "<this>");
        Intrinsics.checkNotNullParameter(elementDescriptor2, "elementDescriptor");
        Intrinsics.checkNotNullParameter(peekNull, "peekNull");
        Intrinsics.checkNotNullParameter(peekString, "peekString");
        Intrinsics.checkNotNullParameter(onEnumCoercing, "onEnumCoercing");
        boolean $i$f$tryCoerceValue = false;
        if (!elementDescriptor2.isNullable() && peekNull.invoke().booleanValue()) {
            return true;
        }
        if (Intrinsics.areEqual(elementDescriptor2.getKind(), SerialKind.ENUM.INSTANCE)) {
            String string2 = peekString.invoke();
            if (string2 == null) {
                return false;
            }
            String enumValue = string2;
            int enumIndex = JsonNamesMapKt.getJsonNameIndex(elementDescriptor2, $this$tryCoerceValue, enumValue);
            if (enumIndex == -3) {
                onEnumCoercing.invoke();
                return true;
            }
        }
        return false;
    }

    public static /* synthetic */ boolean tryCoerceValue$default(Json $this$tryCoerceValue_u24default, SerialDescriptor elementDescriptor2, Function0 peekNull, Function0 peekString, Function0 onEnumCoercing, int n, Object object) {
        if ((n & 8) != 0) {
            onEnumCoercing = tryCoerceValue.1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter($this$tryCoerceValue_u24default, "<this>");
        Intrinsics.checkNotNullParameter(elementDescriptor2, "elementDescriptor");
        Intrinsics.checkNotNullParameter(peekNull, "peekNull");
        Intrinsics.checkNotNullParameter(peekString, "peekString");
        Intrinsics.checkNotNullParameter(onEnumCoercing, "onEnumCoercing");
        boolean $i$f$tryCoerceValue = false;
        if (!elementDescriptor2.isNullable() && ((Boolean)peekNull.invoke()).booleanValue()) {
            return true;
        }
        if (Intrinsics.areEqual(elementDescriptor2.getKind(), SerialKind.ENUM.INSTANCE)) {
            String string2 = (String)peekString.invoke();
            if (string2 == null) {
                return false;
            }
            String enumValue = string2;
            int enumIndex = JsonNamesMapKt.getJsonNameIndex(elementDescriptor2, $this$tryCoerceValue_u24default, enumValue);
            if (enumIndex == -3) {
                onEnumCoercing.invoke();
                return true;
            }
        }
        return false;
    }

    private static final void buildAlternativeNamesMap$putOrThrow(Map<String, Integer> $this$buildAlternativeNamesMap_u24putOrThrow, SerialDescriptor $this_buildAlternativeNamesMap, String name2, int index2) {
        if ($this$buildAlternativeNamesMap_u24putOrThrow.containsKey(name2)) {
            throw new JsonException("The suggested name '" + name2 + "' for property " + $this_buildAlternativeNamesMap.getElementName(index2) + " is already one of the names for property " + $this_buildAlternativeNamesMap.getElementName(((Number)MapsKt.getValue($this$buildAlternativeNamesMap_u24putOrThrow, name2)).intValue()) + " in " + $this_buildAlternativeNamesMap);
        }
        Map<String, Integer> map2 = $this$buildAlternativeNamesMap_u24putOrThrow;
        Integer n = index2;
        map2.put(name2, n);
    }
}

