/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class NameFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = 176844364689077340L;
    private final String[] names;
    private final IOCase caseSensitivity;

    public NameFileFilter(List<String> names2) {
        this(names2, null);
    }

    public NameFileFilter(List<String> names2, IOCase caseSensitivity) {
        if (names2 == null) {
            throw new IllegalArgumentException("The list of names must not be null");
        }
        this.names = names2.toArray(EMPTY_STRING_ARRAY);
        this.caseSensitivity = this.toIOCase(caseSensitivity);
    }

    public NameFileFilter(String name2) {
        this(name2, IOCase.SENSITIVE);
    }

    public NameFileFilter(String ... names2) {
        this(names2, IOCase.SENSITIVE);
    }

    public NameFileFilter(String name2, IOCase caseSensitivity) {
        if (name2 == null) {
            throw new IllegalArgumentException("The wildcard must not be null");
        }
        this.names = new String[]{name2};
        this.caseSensitivity = this.toIOCase(caseSensitivity);
    }

    public NameFileFilter(String[] names2, IOCase caseSensitivity) {
        if (names2 == null) {
            throw new IllegalArgumentException("The array of names must not be null");
        }
        this.names = new String[names2.length];
        System.arraycopy(names2, 0, this.names, 0, names2.length);
        this.caseSensitivity = this.toIOCase(caseSensitivity);
    }

    @Override
    public boolean accept(File file2) {
        return this.acceptBaseName(file2.getName());
    }

    @Override
    public boolean accept(File dir, String name2) {
        return this.acceptBaseName(name2);
    }

    @Override
    public FileVisitResult accept(Path file2, BasicFileAttributes attributes2) {
        return NameFileFilter.toFileVisitResult(this.acceptBaseName(Objects.toString(file2.getFileName(), null)), file2);
    }

    private boolean acceptBaseName(String baseName) {
        for (String testName : this.names) {
            if (!this.caseSensitivity.checkEquals(baseName, testName)) continue;
            return true;
        }
        return false;
    }

    private IOCase toIOCase(IOCase caseSensitivity) {
        return caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append("(");
        if (this.names != null) {
            for (int i = 0; i < this.names.length; ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(this.names[i]);
            }
        }
        buffer.append(")");
        return buffer.toString();
    }
}

