/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FileWriterWithEncoding
extends Writer {
    private final Writer out;

    public FileWriterWithEncoding(String fileName, String charsetName) throws IOException {
        this(new File(fileName), charsetName, false);
    }

    public FileWriterWithEncoding(String fileName, String charsetName, boolean append) throws IOException {
        this(new File(fileName), charsetName, append);
    }

    public FileWriterWithEncoding(String fileName, Charset charset) throws IOException {
        this(new File(fileName), charset, false);
    }

    public FileWriterWithEncoding(String fileName, Charset charset, boolean append) throws IOException {
        this(new File(fileName), charset, append);
    }

    public FileWriterWithEncoding(String fileName, CharsetEncoder encoding) throws IOException {
        this(new File(fileName), encoding, false);
    }

    public FileWriterWithEncoding(String fileName, CharsetEncoder charsetEncoder, boolean append) throws IOException {
        this(new File(fileName), charsetEncoder, append);
    }

    public FileWriterWithEncoding(File file2, String charsetName) throws IOException {
        this(file2, charsetName, false);
    }

    public FileWriterWithEncoding(File file2, String charsetName, boolean append) throws IOException {
        this.out = FileWriterWithEncoding.initWriter(file2, charsetName, append);
    }

    public FileWriterWithEncoding(File file2, Charset charset) throws IOException {
        this(file2, charset, false);
    }

    public FileWriterWithEncoding(File file2, Charset encoding, boolean append) throws IOException {
        this.out = FileWriterWithEncoding.initWriter(file2, encoding, append);
    }

    public FileWriterWithEncoding(File file2, CharsetEncoder charsetEncoder) throws IOException {
        this(file2, charsetEncoder, false);
    }

    public FileWriterWithEncoding(File file2, CharsetEncoder charsetEncoder, boolean append) throws IOException {
        this.out = FileWriterWithEncoding.initWriter(file2, charsetEncoder, append);
    }

    private static Writer initWriter(File file2, Object encoding, boolean append) throws IOException {
        Objects.requireNonNull(file2, "file");
        Objects.requireNonNull(encoding, "encoding");
        OutputStream stream = null;
        boolean fileExistedAlready = file2.exists();
        try {
            stream = Files.newOutputStream(file2.toPath(), append ? StandardOpenOption.APPEND : StandardOpenOption.CREATE);
            if (encoding instanceof Charset) {
                return new OutputStreamWriter(stream, (Charset)encoding);
            }
            if (encoding instanceof CharsetEncoder) {
                return new OutputStreamWriter(stream, (CharsetEncoder)encoding);
            }
            return new OutputStreamWriter(stream, (String)encoding);
        }
        catch (IOException | RuntimeException ex) {
            try {
                IOUtils.close(stream);
            }
            catch (IOException e) {
                ex.addSuppressed(e);
            }
            if (!fileExistedAlready) {
                FileUtils.deleteQuietly(file2);
            }
            throw ex;
        }
    }

    @Override
    public void write(int idx) throws IOException {
        this.out.write(idx);
    }

    @Override
    public void write(char[] chr) throws IOException {
        this.out.write(chr);
    }

    @Override
    public void write(char[] chr, int st, int end2) throws IOException {
        this.out.write(chr, st, end2);
    }

    @Override
    public void write(String str) throws IOException {
        this.out.write(str);
    }

    @Override
    public void write(String str, int st, int end2) throws IOException {
        this.out.write(str, st, end2);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

