/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValueKt;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMappingKt;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\u0010*\u00020\u000eH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/GetJavaPrimitiveType;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "()V", "invoke", "Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "codegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ExpressionCodegen;", "data", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;", "putPrimitiveType", "", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "isInlineClassType", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isVoidOrPrimitiveWrapper", "backend.jvm.codegen"})
public final class GetJavaPrimitiveType
extends IntrinsicMethod {
    @NotNull
    public static final GetJavaPrimitiveType INSTANCE = new GetJavaPrimitiveType();

    private GetJavaPrimitiveType() {
    }

    @Override
    @Nullable
    public PromisedValue invoke(@NotNull IrFunctionAccessExpression expression2, @NotNull ExpressionCodegen codegen2, @NotNull BlockInfo data2) {
        PromisedValue promisedValue;
        IrType irType;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(codegen2, "codegen");
        Intrinsics.checkNotNullParameter(data2, "data");
        IrExpression irExpression = expression2.getExtensionReceiver();
        if (irExpression == null) {
            return null;
        }
        IrExpression receiver2 = irExpression;
        IrExpression irExpression2 = receiver2;
        if (irExpression2 instanceof IrGetClass) {
            irType = ((IrGetClass)receiver2).getArgument().getType();
        } else if (irExpression2 instanceof IrClassReference) {
            irType = ((IrClassReference)receiver2).getClassType();
        } else {
            return null;
        }
        IrType argumentType = irType;
        if (IrTypeUtilsKt.isTypeParameter(argumentType)) {
            return null;
        }
        Type argumentAsmType = IrTypeMappingKt.mapTypeAsDeclaration(codegen2.getTypeMapper(), argumentType);
        boolean isPrimitiveTypeOrWrapper = IrTypePredicatesKt.isPrimitiveType$default(argumentType, false, 1, null) || IrTypePredicatesKt.isNullablePrimitiveType(argumentType) || !this.isInlineClassType(argumentType) && this.isVoidOrPrimitiveWrapper(argumentAsmType);
        IrExpression irExpression3 = receiver2;
        if (irExpression3 instanceof IrGetClass) {
            if (!isPrimitiveTypeOrWrapper) {
                return null;
            }
            PromisedValue argumentValue = (PromisedValue)((IrGetClass)receiver2).getArgument().accept(codegen2, data2);
            PromisedValueKt.materialize(argumentValue);
            AsmUtil.pop(codegen2.getMv(), argumentValue.getType());
            this.putPrimitiveType(codegen2, argumentAsmType);
            ExpressionCodegen $this$invoke_u24lambda_u2d0 = codegen2;
            boolean bl = false;
            promisedValue = $this$invoke_u24lambda_u2d0.getOnStack(expression2);
        } else if (irExpression3 instanceof IrClassReference) {
            if (!isPrimitiveTypeOrWrapper) {
                codegen2.getMv().aconst(null);
            } else {
                this.putPrimitiveType(codegen2, argumentAsmType);
            }
            ExpressionCodegen $this$invoke_u24lambda_u2d1 = codegen2;
            boolean bl = false;
            promisedValue = $this$invoke_u24lambda_u2d1.getOnStack(expression2);
        } else {
            throw new AssertionError((Object)("IrGetClass or IrClassReference expected: " + RenderIrElementKt.render(receiver2)));
        }
        return promisedValue;
    }

    private final void putPrimitiveType(ExpressionCodegen codegen2, Type type2) {
        codegen2.getMv().getstatic(AsmUtil.boxType(type2).getInternalName(), "TYPE", "Ljava/lang/Class;");
    }

    private final boolean isInlineClassType(IrType $this$isInlineClassType) {
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$isInlineClassType);
        if (irClassSymbol == null) {
            return false;
        }
        return IrDeclarationsKt.isSingleFieldValueClass((IrClass)irClassSymbol.getOwner());
    }

    private final boolean isVoidOrPrimitiveWrapper(Type $this$isVoidOrPrimitiveWrapper) {
        return Intrinsics.areEqual($this$isVoidOrPrimitiveWrapper, AsmTypes.VOID_WRAPPER_TYPE) || AsmUtil.unboxPrimitiveTypeOrNull($this$isVoidOrPrimitiveWrapper) != null;
    }
}

