/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.base;

import java.util.BitSet;
import org.jetbrains.kotlin.com.google.common.base.CharMatcher;

final class SmallCharMatcher
extends CharMatcher.NamedFastMatcher {
    static final int MAX_SIZE = 1023;
    private final char[] table;
    private final boolean containsZero;
    private final long filter;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private static final double DESIRED_LOAD_FACTOR = 0.5;

    private SmallCharMatcher(char[] table, long filter2, boolean containsZero, String description2) {
        super(description2);
        this.table = table;
        this.filter = filter2;
        this.containsZero = containsZero;
    }

    static int smear(int hashCode2) {
        return 461845907 * Integer.rotateLeft(hashCode2 * -862048943, 15);
    }

    private boolean checkFilter(int c) {
        return 1L == (1L & this.filter >> c);
    }

    static int chooseTableSize(int setSize) {
        if (setSize == 1) {
            return 2;
        }
        int tableSize = Integer.highestOneBit(setSize - 1) << 1;
        while ((double)tableSize * 0.5 < (double)setSize) {
            tableSize <<= 1;
        }
        return tableSize;
    }

    static CharMatcher from(BitSet chars, String description2) {
        long filter2 = 0L;
        int size2 = chars.cardinality();
        boolean containsZero = chars.get(0);
        char[] table = new char[SmallCharMatcher.chooseTableSize(size2)];
        int mask = table.length - 1;
        int c = chars.nextSetBit(0);
        while (c != -1) {
            filter2 |= 1L << c;
            int index2 = SmallCharMatcher.smear(c) & mask;
            while (true) {
                if (table[index2] == '\u0000') break;
                index2 = index2 + 1 & mask;
            }
            table[index2] = (char)c;
            c = chars.nextSetBit(c + 1);
        }
        return new SmallCharMatcher(table, filter2, containsZero, description2);
    }

    @Override
    public boolean matches(char c) {
        int startingIndex;
        if (c == '\u0000') {
            return this.containsZero;
        }
        if (!this.checkFilter(c)) {
            return false;
        }
        int mask = this.table.length - 1;
        int index2 = startingIndex = SmallCharMatcher.smear(c) & mask;
        do {
            if (this.table[index2] == '\u0000') {
                return false;
            }
            if (this.table[index2] != c) continue;
            return true;
        } while ((index2 = index2 + 1 & mask) != startingIndex);
        return false;
    }

    @Override
    void setBits(BitSet table) {
        if (this.containsZero) {
            table.set(0);
        }
        for (char c : this.table) {
            if (c == '\u0000') continue;
            table.set(c);
        }
    }
}

