/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.application.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.com.intellij.diagnostic.Activity;
import org.jetbrains.kotlin.com.intellij.diagnostic.StartUpMeasurer;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginManagerCore;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationNamesInfo;
import org.jetbrains.kotlin.com.intellij.openapi.application.PathManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ex.ApplicationInfoEx;
import org.jetbrains.kotlin.com.intellij.openapi.application.ex.ProgressSlide;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.util.BuildNumber;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.org.jdom.Element;

public final class ApplicationInfoImpl
extends ApplicationInfoEx {
    private String myCodeName;
    private String myMajorVersion;
    private String myMinorVersion;
    private String myMicroVersion;
    private String myPatchVersion;
    private String myFullVersionFormat;
    private String myBuildNumber;
    private String myApiVersion;
    private String myVersionSuffix;
    private String myCompanyName;
    private String myCopyrightStart;
    private String myShortCompanyName;
    private String myCompanyUrl;
    private long myProgressColor;
    private long myCopyrightForeground;
    private long myAboutForeground;
    private long myAboutLinkColor;
    private int[] myAboutLogoRect;
    private String myProgressTailIconName;
    private int myProgressHeight;
    private int myProgressY;
    private String mySplashImageUrl;
    private String myAboutImageUrl;
    private String myIconUrl;
    private String mySmallIconUrl;
    private String myBigIconUrl;
    private String mySvgIconUrl;
    private String mySvgEapIconUrl;
    private String mySmallSvgIconUrl;
    private String mySmallSvgEapIconUrl;
    private String myToolWindowIconUrl;
    private String myWelcomeScreenLogoUrl;
    private Calendar myBuildDate;
    private Calendar myMajorReleaseBuildDate;
    private String myPackageCode;
    private boolean myShowLicensee;
    private String myCustomizeIDEWizardStepsProvider;
    private String myCustomizeIDEWizardDialog;
    private final ApplicationInfoEx.UpdateUrls myUpdateUrls;
    private String myDocumentationUrl;
    private String mySupportUrl;
    private String myYoutrackUrl;
    private String myFeedbackUrl;
    private String myPluginManagerUrl;
    private String myPluginsListUrl;
    private String myChannelsListUrl;
    private String myPluginsDownloadUrl;
    private String myBuiltinPluginsUrl;
    private String myWhatsNewUrl;
    private String myWinKeymapUrl;
    private String myMacKeymapUrl;
    private boolean myEAP;
    private boolean myHasHelp;
    private boolean myHasContextHelp;
    private String myWebHelpUrl;
    private final List<PluginId> myEssentialPluginsIds;
    private final String myEventLogSettingsUrl;
    private String myJetBrainsTvUrl;
    private String myEvalLicenseUrl;
    private String myKeyConversionUrl;
    private String mySubscriptionFormId;
    private String mySubscriptionNewsKey;
    private String mySubscriptionNewsValue;
    private String mySubscriptionTipsKey;
    private boolean mySubscriptionTipsAvailable;
    private String mySubscriptionAdditionalFormData;
    private final List<ProgressSlide> myProgressSlides;
    private static volatile ApplicationInfoImpl instance;
    private static volatile boolean myInStressTest;

    private ApplicationInfoImpl() {
        this(ApplicationNamesInfo.initAndGetRawData());
    }

    ApplicationInfoImpl(@NotNull Element element) {
        Element subscriptionsElement;
        String url2;
        Element licensingElement;
        String url3;
        Element evaluationElement;
        List<Element> essentialPluginsElements;
        Element whatsNewElement;
        Element feedbackElement;
        Element youtrackElement;
        Element supportElement;
        Element updateUrls;
        Element helpElement;
        Element wizardSteps;
        Element welcomeScreen;
        Element showLicensee;
        Element packageElement;
        Element iconEap;
        Element iconElement;
        Element aboutLogoElement;
        Element logoElement;
        Element buildElement;
        Element companyElement;
        if (element == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(0);
        }
        this.myCompanyName = "JetBrains s.r.o.";
        this.myCopyrightStart = "2000";
        this.myCompanyUrl = "https://www.jetbrains.com/";
        this.myProgressColor = -1L;
        this.myCopyrightForeground = -1L;
        this.myAboutForeground = -1L;
        this.myAboutLinkColor = -1L;
        this.myProgressHeight = 2;
        this.myProgressY = 350;
        this.myIconUrl = "/icon.png";
        this.mySmallIconUrl = "/icon_small.png";
        this.myToolWindowIconUrl = "/toolwindows/toolWindowProject.png";
        this.myShowLicensee = true;
        this.myHasHelp = true;
        this.myHasContextHelp = true;
        this.myWebHelpUrl = "https://www.jetbrains.com/idea/webhelp/";
        this.myEvalLicenseUrl = "https://www.jetbrains.com/store/license.html";
        this.myKeyConversionUrl = "https://www.jetbrains.com/shop/eform/keys-exchange";
        this.myProgressSlides = new ArrayList<ProgressSlide>();
        Element versionElement = ApplicationInfoImpl.getChild(element, "version");
        if (versionElement != null) {
            this.myMajorVersion = versionElement.getAttributeValue("major");
            this.myMinorVersion = versionElement.getAttributeValue("minor");
            this.myMicroVersion = versionElement.getAttributeValue("micro");
            this.myPatchVersion = versionElement.getAttributeValue("patch");
            this.myFullVersionFormat = versionElement.getAttributeValue("full");
            this.myCodeName = versionElement.getAttributeValue("codename");
            this.myEAP = Boolean.parseBoolean(versionElement.getAttributeValue("eap"));
            this.myVersionSuffix = versionElement.getAttributeValue("suffix");
            if (this.myVersionSuffix == null && this.myEAP) {
                this.myVersionSuffix = "EAP";
            }
        }
        if ((companyElement = ApplicationInfoImpl.getChild(element, "company")) != null) {
            this.myCompanyName = companyElement.getAttributeValue("name", this.myCompanyName);
            this.myShortCompanyName = companyElement.getAttributeValue("shortName", ApplicationInfoImpl.shortenCompanyName(this.myCompanyName));
            this.myCompanyUrl = companyElement.getAttributeValue("url", this.myCompanyUrl);
            this.myCopyrightStart = companyElement.getAttributeValue("copyrightStart", this.myCopyrightStart);
        }
        if ((buildElement = ApplicationInfoImpl.getChild(element, "build")) != null) {
            this.readBuildInfo(buildElement);
        }
        if ((logoElement = ApplicationInfoImpl.getChild(element, "logo")) != null) {
            this.readLogoInfo(logoElement);
        }
        if ((aboutLogoElement = ApplicationInfoImpl.getChild(element, "about")) != null) {
            String c;
            this.myAboutImageUrl = aboutLogoElement.getAttributeValue("url");
            String v = aboutLogoElement.getAttributeValue("foreground");
            if (v != null) {
                this.myAboutForeground = ApplicationInfoImpl.parseColor(v);
            }
            if ((v = aboutLogoElement.getAttributeValue("copyrightForeground")) != null) {
                this.myCopyrightForeground = ApplicationInfoImpl.parseColor(v);
            }
            if ((c = aboutLogoElement.getAttributeValue("linkColor")) != null) {
                this.myAboutLinkColor = ApplicationInfoImpl.parseColor(c);
            }
            String logoX = aboutLogoElement.getAttributeValue("logoX");
            String logoY = aboutLogoElement.getAttributeValue("logoY");
            String logoW = aboutLogoElement.getAttributeValue("logoW");
            String logoH = aboutLogoElement.getAttributeValue("logoH");
            if (logoX != null && logoY != null && logoW != null && logoH != null) {
                try {
                    this.myAboutLogoRect = new int[]{Integer.parseInt(logoX), Integer.parseInt(logoY), Integer.parseInt(logoW), Integer.parseInt(logoH)};
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if ((iconElement = ApplicationInfoImpl.getChild(element, "icon")) != null) {
            this.myIconUrl = iconElement.getAttributeValue("size32");
            this.mySmallIconUrl = iconElement.getAttributeValue("size16", this.mySmallIconUrl);
            this.myBigIconUrl = ApplicationInfoImpl.getAttributeValue(iconElement, "size128");
            String toolWindowIcon = ApplicationInfoImpl.getAttributeValue(iconElement, "size12");
            if (toolWindowIcon != null) {
                this.myToolWindowIconUrl = toolWindowIcon;
            }
            this.mySvgIconUrl = iconElement.getAttributeValue("svg");
            this.mySmallSvgIconUrl = iconElement.getAttributeValue("svg-small");
        }
        if ((iconEap = ApplicationInfoImpl.getChild(element, "icon-eap")) != null) {
            this.mySvgEapIconUrl = iconEap.getAttributeValue("svg");
            this.mySmallSvgEapIconUrl = iconEap.getAttributeValue("svg-small");
        }
        if ((packageElement = ApplicationInfoImpl.getChild(element, "package")) != null) {
            this.myPackageCode = packageElement.getAttributeValue("code");
        }
        if ((showLicensee = ApplicationInfoImpl.getChild(element, "licensee")) != null) {
            this.myShowLicensee = Boolean.parseBoolean(showLicensee.getAttributeValue("show"));
        }
        if ((welcomeScreen = ApplicationInfoImpl.getChild(element, "welcome-screen")) != null) {
            this.myWelcomeScreenLogoUrl = welcomeScreen.getAttributeValue("logo-url");
        }
        if ((wizardSteps = ApplicationInfoImpl.getChild(element, "customize-ide-wizard")) != null) {
            this.myCustomizeIDEWizardStepsProvider = wizardSteps.getAttributeValue("provider");
            this.myCustomizeIDEWizardDialog = ApplicationInfoImpl.getAttributeValue(wizardSteps, "dialog");
        }
        if ((helpElement = ApplicationInfoImpl.getChild(element, "help")) != null) {
            String attValue;
            String webHelpUrl = ApplicationInfoImpl.getAttributeValue(helpElement, "webhelp-url");
            if (webHelpUrl != null) {
                this.myWebHelpUrl = webHelpUrl;
            }
            this.myHasHelp = (attValue = helpElement.getAttributeValue("has-help")) == null || Boolean.parseBoolean(attValue);
            attValue = helpElement.getAttributeValue("has-context-help");
            this.myHasContextHelp = attValue == null || Boolean.parseBoolean(attValue);
        }
        this.myUpdateUrls = (updateUrls = ApplicationInfoImpl.getChild(element, "update-urls")) == null ? null : new UpdateUrlsImpl(updateUrls);
        Element documentationElement = ApplicationInfoImpl.getChild(element, "documentation");
        if (documentationElement != null) {
            this.myDocumentationUrl = documentationElement.getAttributeValue("url");
        }
        if ((supportElement = ApplicationInfoImpl.getChild(element, "support")) != null) {
            this.mySupportUrl = supportElement.getAttributeValue("url");
        }
        if ((youtrackElement = ApplicationInfoImpl.getChild(element, "youtrack")) != null) {
            this.myYoutrackUrl = youtrackElement.getAttributeValue("url");
        }
        if ((feedbackElement = ApplicationInfoImpl.getChild(element, "feedback")) != null) {
            this.myFeedbackUrl = feedbackElement.getAttributeValue("url");
        }
        if ((whatsNewElement = ApplicationInfoImpl.getChild(element, "whatsnew")) != null) {
            this.myWhatsNewUrl = whatsNewElement.getAttributeValue("url");
        }
        this.readPluginInfo(ApplicationInfoImpl.getChild(element, "plugins"));
        Element keymapElement = ApplicationInfoImpl.getChild(element, "keymap");
        if (keymapElement != null) {
            this.myWinKeymapUrl = keymapElement.getAttributeValue("win");
            this.myMacKeymapUrl = keymapElement.getAttributeValue("mac");
        }
        if ((essentialPluginsElements = ApplicationInfoImpl.getChildren(element, "essential-plugin")).isEmpty()) {
            this.myEssentialPluginsIds = Collections.emptyList();
        } else {
            ArrayList<PluginId> essentialPluginsIds = new ArrayList<PluginId>(essentialPluginsElements.size());
            for (Element element1 : essentialPluginsElements) {
                String id = element1.getTextTrim();
                if (id.isEmpty()) continue;
                essentialPluginsIds.add(PluginId.getId(id));
            }
            essentialPluginsIds.sort(null);
            this.myEssentialPluginsIds = Collections.unmodifiableList(essentialPluginsIds);
        }
        Element statisticsElement = ApplicationInfoImpl.getChild(element, "statistics");
        this.myEventLogSettingsUrl = statisticsElement != null ? statisticsElement.getAttributeValue("event-log-settings") : "https://resources.jetbrains.com/storage/fus/config/v4/%s/%s.json";
        Element tvElement = ApplicationInfoImpl.getChild(element, "jetbrains-tv");
        if (tvElement != null) {
            this.myJetBrainsTvUrl = tvElement.getAttributeValue("url");
        }
        if ((evaluationElement = ApplicationInfoImpl.getChild(element, "evaluation")) != null && (url3 = ApplicationInfoImpl.getAttributeValue(evaluationElement, "license-url")) != null) {
            this.myEvalLicenseUrl = url3.trim();
        }
        if ((licensingElement = ApplicationInfoImpl.getChild(element, "licensing")) != null && (url2 = ApplicationInfoImpl.getAttributeValue(licensingElement, "key-conversion-url")) != null) {
            this.myKeyConversionUrl = url2.trim();
        }
        if ((subscriptionsElement = ApplicationInfoImpl.getChild(element, "subscriptions")) != null) {
            this.mySubscriptionFormId = subscriptionsElement.getAttributeValue("formid");
            this.mySubscriptionNewsKey = subscriptionsElement.getAttributeValue("news-key");
            this.mySubscriptionNewsValue = subscriptionsElement.getAttributeValue("news-value", "yes");
            this.mySubscriptionTipsKey = subscriptionsElement.getAttributeValue("tips-key");
            this.mySubscriptionTipsAvailable = Boolean.parseBoolean(subscriptionsElement.getAttributeValue("tips-available"));
            this.mySubscriptionAdditionalFormData = subscriptionsElement.getAttributeValue("additional-form-data");
        }
    }

    private void readLogoInfo(@NotNull Element element) {
        if (element == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(1);
        }
        this.mySplashImageUrl = ApplicationInfoImpl.getAttributeValue(element, "url");
        String v = ApplicationInfoImpl.getAttributeValue(element, "progressColor");
        if (v != null) {
            this.myProgressColor = ApplicationInfoImpl.parseColor(v);
        }
        if ((v = ApplicationInfoImpl.getAttributeValue(element, "progressTailIcon")) != null) {
            this.myProgressTailIconName = v;
        }
        if ((v = ApplicationInfoImpl.getAttributeValue(element, "progressHeight")) != null) {
            this.myProgressHeight = Integer.parseInt(v);
        }
        if ((v = ApplicationInfoImpl.getAttributeValue(element, "progressY")) != null) {
            this.myProgressY = Integer.parseInt(v);
        }
        for (Element child : ApplicationInfoImpl.getChildren(element, "progressSlide")) {
            String slideUrl = child.getAttributeValue("url");
            assert (slideUrl != null);
            String progressPercentString = child.getAttributeValue("progressPercent");
            assert (progressPercentString != null);
            int progressPercentInt = Integer.parseInt(progressPercentString);
            assert (progressPercentInt <= 100 && progressPercentInt >= 0);
            float progressPercentFloat = (float)progressPercentInt / 100.0f;
            this.myProgressSlides.add(new ProgressSlide(slideUrl, progressPercentFloat));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ApplicationInfoEx getShadowInstance() {
        ApplicationInfoImpl result2 = instance;
        if (result2 != null) {
            ApplicationInfoImpl applicationInfoImpl = result2;
            if (applicationInfoImpl == null) {
                ApplicationInfoImpl.$$$reportNull$$$0(2);
            }
            return applicationInfoImpl;
        }
        Class<ApplicationInfoImpl> clazz = ApplicationInfoImpl.class;
        synchronized (ApplicationInfoImpl.class) {
            result2 = instance;
            if (result2 == null) {
                Activity activity = StartUpMeasurer.startActivity("app info loading");
                try {
                    instance = result2 = new ApplicationInfoImpl(ApplicationNamesInfo.initAndGetRawData());
                }
                finally {
                    activity.end();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ApplicationInfoImpl applicationInfoImpl = result2;
            if (applicationInfoImpl == null) {
                ApplicationInfoImpl.$$$reportNull$$$0(3);
            }
            return applicationInfoImpl;
        }
    }

    @NotNull
    public BuildNumber getBuild() {
        BuildNumber buildNumber = Objects.requireNonNull(BuildNumber.fromString(this.myBuildNumber));
        if (buildNumber == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(4);
        }
        return buildNumber;
    }

    @Override
    @NotNull
    public BuildNumber getApiVersionAsNumber() {
        BuildNumber api;
        BuildNumber build2 = this.getBuild();
        if (this.myApiVersion != null && (api = BuildNumber.fromStringWithProductCode(this.myApiVersion, build2.getProductCode())) != null) {
            BuildNumber buildNumber = api;
            if (buildNumber == null) {
                ApplicationInfoImpl.$$$reportNull$$$0(6);
            }
            return buildNumber;
        }
        BuildNumber buildNumber = build2;
        if (buildNumber == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(7);
        }
        return buildNumber;
    }

    @Nullable
    private static String getAttributeValue(@NotNull Element element, @NotNull String name2) {
        String value2;
        if (element == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(11);
        }
        if (name2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(12);
        }
        return (value2 = element.getAttributeValue(name2)) == null || value2.isEmpty() ? null : value2;
    }

    private void readBuildInfo(@NotNull Element element) {
        String majorReleaseDateString;
        if (element == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(13);
        }
        this.myBuildNumber = ApplicationInfoImpl.getAttributeValue(element, "number");
        this.myApiVersion = ApplicationInfoImpl.getAttributeValue(element, "apiVersion");
        String dateString = element.getAttributeValue("date");
        if ("__BUILD_DATE__".equals(dateString)) {
            this.myBuildDate = new GregorianCalendar();
            try (JarFile bootstrapJar2 = new JarFile(PathManager.getHomePath() + "/lib/bootstrap.jar");){
                JarEntry jarEntry2 = bootstrapJar2.entries().nextElement();
                this.myBuildDate.setTime(new Date(jarEntry2.getTime()));
            }
            catch (Exception bootstrapJar2) {}
        } else {
            this.myBuildDate = dateString == null ? Calendar.getInstance() : ApplicationInfoImpl.parseDate(dateString);
        }
        if ((majorReleaseDateString = element.getAttributeValue("majorReleaseDate")) != null) {
            this.myMajorReleaseBuildDate = ApplicationInfoImpl.parseDate(majorReleaseDateString);
        }
    }

    private void readPluginInfo(@Nullable Element element) {
        String pluginsHost;
        String pluginManagerUrl = "https://plugins.jetbrains.com";
        String pluginsListUrl = null;
        this.myChannelsListUrl = null;
        this.myPluginsDownloadUrl = null;
        if (element != null) {
            String builtinPluginsUrl;
            String downloadUrl;
            String channelListUrl;
            String listUrl;
            String url2 = element.getAttributeValue("url");
            if (url2 != null) {
                String string2 = pluginManagerUrl = url2.endsWith("/") ? url2.substring(0, url2.length() - 1) : url2;
            }
            if ((listUrl = element.getAttributeValue("list-url")) != null) {
                pluginsListUrl = listUrl;
            }
            if ((channelListUrl = element.getAttributeValue("channel-list-url")) != null) {
                this.myChannelsListUrl = channelListUrl;
            }
            if ((downloadUrl = element.getAttributeValue("download-url")) != null) {
                this.myPluginsDownloadUrl = downloadUrl;
            }
            if (StringUtil.isNotEmpty(builtinPluginsUrl = element.getAttributeValue("builtin-url"))) {
                this.myBuiltinPluginsUrl = builtinPluginsUrl;
            }
        }
        if ((pluginsHost = System.getProperty("idea.plugins.host")) != null) {
            pluginManagerUrl = pluginsHost.endsWith("/") ? pluginsHost.substring(0, pluginsHost.length() - 1) : pluginsHost;
            this.myPluginsDownloadUrl = null;
            this.myChannelsListUrl = null;
            pluginsListUrl = null;
        }
        this.myPluginManagerUrl = pluginManagerUrl;
        String string3 = this.myPluginsListUrl = pluginsListUrl == null ? pluginManagerUrl + "/plugins/list/" : pluginsListUrl;
        if (this.myChannelsListUrl == null) {
            this.myChannelsListUrl = pluginManagerUrl + "/channels/list/";
        }
        if (this.myPluginsDownloadUrl == null) {
            this.myPluginsDownloadUrl = pluginManagerUrl + "/pluginManager/";
        }
    }

    @NotNull
    private static List<Element> getChildren(@NotNull Element parentNode, @NotNull String name2) {
        if (parentNode == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(14);
        }
        if (name2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(15);
        }
        List<Element> list2 = parentNode.getChildren(name2, parentNode.getNamespace());
        if (list2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(16);
        }
        return list2;
    }

    private static Element getChild(@NotNull Element parentNode, @NotNull String name2) {
        if (parentNode == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(17);
        }
        if (name2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(18);
        }
        return parentNode.getChild(name2, parentNode.getNamespace());
    }

    @TestOnly
    static String shortenCompanyName(@NotNull String name2) {
        if (name2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(19);
        }
        if (name2.endsWith(" s.r.o.")) {
            name2 = name2.substring(0, name2.length() - " s.r.o.".length());
        }
        if (name2.endsWith(" Inc.")) {
            name2 = name2.substring(0, name2.length() - " Inc.".length());
        }
        return name2;
    }

    @NotNull
    private static GregorianCalendar parseDate(@NotNull String dateString) {
        if (dateString == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(20);
        }
        GregorianCalendar calendar2 = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        try {
            calendar2.set(1, Integer.parseInt(dateString.substring(0, 4)));
            calendar2.set(2, Integer.parseInt(dateString.substring(4, 6)) - 1);
            calendar2.set(5, Integer.parseInt(dateString.substring(6, 8)));
            if (dateString.length() > 8) {
                calendar2.set(11, Integer.parseInt(dateString.substring(8, 10)));
                calendar2.set(12, Integer.parseInt(dateString.substring(10, 12)));
            } else {
                calendar2.set(11, 0);
                calendar2.set(12, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        GregorianCalendar gregorianCalendar = calendar2;
        if (gregorianCalendar == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(21);
        }
        return gregorianCalendar;
    }

    public static long parseColor(@NotNull String colorString) {
        if (colorString == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(22);
        }
        return Long.parseLong(colorString, 16);
    }

    @Override
    public boolean isEssentialPlugin(@NotNull String pluginId) {
        if (pluginId == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(23);
        }
        return "org.jetbrains.kotlin.com.intellij".equals(pluginId) || this.isEssentialPlugin(PluginId.getId(pluginId));
    }

    public boolean isEssentialPlugin(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(24);
        }
        return PluginManagerCore.CORE_ID == pluginId || Collections.binarySearch(this.myEssentialPluginsIds, pluginId) >= 0;
    }

    public static boolean isInStressTest() {
        return myInStressTest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 21: 
            case 25: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 21: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/application/impl/ApplicationInfoImpl";
                break;
            }
            case 12: 
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dateString";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorString";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/application/impl/ApplicationInfoImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShadowInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuild";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getApiVersion";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getApiVersionAsNumber";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullVersion";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStrictVersion";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSmallIconUrl";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDate";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getEssentialPluginsIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readLogoInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 21: 
            case 25: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readBuildInfo";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getChild";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "shortenCompanyName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseDate";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseColor";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isEssentialPlugin";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 21: 
            case 25: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class UpdateUrlsImpl
    implements ApplicationInfoEx.UpdateUrls {
        private final String myCheckingUrl;
        private final String myPatchesUrl;

        private UpdateUrlsImpl(@NotNull Element element) {
            if (element == null) {
                UpdateUrlsImpl.$$$reportNull$$$0(0);
            }
            this.myCheckingUrl = element.getAttributeValue("check");
            this.myPatchesUrl = element.getAttributeValue("patches");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/openapi/application/impl/ApplicationInfoImpl$UpdateUrlsImpl", "<init>"));
        }
    }
}

