/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.progress.impl;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.ConcurrentHashMultiset;
import org.jetbrains.kotlin.com.intellij.codeWithMe.ClientId;
import org.jetbrains.kotlin.com.intellij.diagnostic.ThreadDumper;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityState;
import org.jetbrains.kotlin.com.intellij.openapi.application.ex.ApplicationEx;
import org.jetbrains.kotlin.com.intellij.openapi.application.ex.ApplicationUtil;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.EmptyProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.PerformInBackgroundOption;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.progress.StandardProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.Task;
import org.jetbrains.kotlin.com.intellij.openapi.progress.WrappedProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.impl.NonCancelableIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.impl.ProgressRunner;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.ThrowableComputable;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AppExecutorUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentLongObjectMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.SmartHashSet;

public class CoreProgressManager
extends ProgressManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(CoreProgressManager.class);
    private final AtomicInteger myUnsafeProgressCount = new AtomicInteger(0);
    public static final boolean ENABLED = !"disabled".equals(System.getProperty("idea.ProcessCanceledException"));
    private static CheckCanceledHook ourCheckCanceledHook;
    private ScheduledFuture<?> myCheckCancelledFuture;
    private static final Map<ProgressIndicator, Set<Thread>> threadsUnderIndicator;
    private static final ConcurrentLongObjectMap<ProgressIndicator> currentIndicators;
    private static final ConcurrentLongObjectMap<ProgressIndicator> threadTopLevelIndicators;
    static final Set<Thread> threadsUnderCanceledIndicator;
    @NotNull
    private static volatile CheckCanceledBehavior ourCheckCanceledBehavior;
    private static final Collection<ProgressIndicator> nonStandardIndicators;
    private static final ThreadLocal<Boolean> isInNonCancelableSection;
    private static final long MAX_PRIORITIZATION_NANOS;
    private static final Thread[] NO_THREADS;
    private final Set<Thread> myPrioritizedThreads = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile Thread[] myEffectivePrioritizedThreads = NO_THREADS;
    private int myDeprioritizations;
    private final Object myPrioritizationLock = ObjectUtils.sentinel("myPrioritizationLock");
    private volatile long myPrioritizingStarted;

    private void startBackgroundNonStandardIndicatorsPing() {
        if (this.myCheckCancelledFuture == null) {
            this.myCheckCancelledFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> {
                for (ProgressIndicator indicator : nonStandardIndicators) {
                    try {
                        indicator.checkCanceled();
                    }
                    catch (ProcessCanceledException e) {
                        this.indicatorCanceled(indicator);
                    }
                }
            }, 0L, 10L, TimeUnit.MILLISECONDS);
        }
    }

    private void stopBackgroundNonStandardIndicatorsPing() {
        if (this.myCheckCancelledFuture != null) {
            this.myCheckCancelledFuture.cancel(true);
            this.myCheckCancelledFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            this.stopBackgroundNonStandardIndicatorsPing();
        }
    }

    @ApiStatus.Internal
    public static boolean runCheckCanceledHooks(@Nullable ProgressIndicator indicator) {
        CheckCanceledHook hook = ourCheckCanceledHook;
        return hook != null && hook.runHook(indicator);
    }

    @Override
    protected void doCheckCanceled() throws ProcessCanceledException {
        CheckCanceledBehavior behavior = ourCheckCanceledBehavior;
        if (behavior == CheckCanceledBehavior.NONE) {
            return;
        }
        if (behavior == CheckCanceledBehavior.INDICATOR_PLUS_HOOKS) {
            ProgressIndicator progress = this.getProgressIndicator();
            if (progress != null) {
                progress.checkCanceled();
            }
        } else {
            CoreProgressManager.runCheckCanceledHooks(null);
        }
    }

    @Override
    public boolean hasProgressIndicator() {
        return this.getProgressIndicator() != null;
    }

    @Override
    public boolean hasUnsafeProgressIndicator() {
        return this.myUnsafeProgressCount.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasModalProgressIndicator() {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            return ContainerUtil.or(threadsUnderIndicator.keySet(), i -> i.isModal());
        }
    }

    @Override
    public void runProcess(@NotNull Runnable process2, @Nullable ProgressIndicator progress) {
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(1);
        }
        if (progress != null) {
            CoreProgressManager.assertNoOtherThreadUnder(progress);
        }
        this.executeProcessUnderProgress(() -> {
            try {
                try {
                    if (progress != null && !progress.isRunning()) {
                        progress.start();
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                process2.run();
            }
            finally {
                if (progress != null && progress.isRunning()) {
                    progress.stop();
                    if (progress instanceof ProgressIndicatorEx) {
                        ((ProgressIndicatorEx)progress).processFinish();
                    }
                }
            }
        }, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertNoOtherThreadUnder(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            CoreProgressManager.$$$reportNull$$$0(2);
        }
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            Thread other;
            Collection threads = threadsUnderIndicator.get(progress);
            Thread thread2 = other = threads == null || threads.isEmpty() ? null : (Thread)threads.iterator().next();
            if (other != null) {
                if (other == Thread.currentThread()) {
                    LOG.error("This thread is already running under this indicator, starting/stopping it here might be a data race");
                } else {
                    StringWriter dump2 = new StringWriter();
                    ThreadDumper.dumpCallStack(other, (Writer)dump2, other.getStackTrace());
                    LOG.error("Other thread is already running under this indicator, starting/stopping it here might be a data race. Its thread dump:\n" + dump2);
                }
            }
        }
    }

    @Override
    public void executeNonCancelableSection(@NotNull Runnable runnable) {
        block7: {
            if (runnable == null) {
                CoreProgressManager.$$$reportNull$$$0(3);
            }
            try {
                if (this.isInNonCancelableSection()) {
                    runnable.run();
                    break block7;
                }
                try {
                    isInNonCancelableSection.set(Boolean.TRUE);
                    this.executeProcessUnderProgress(runnable, NonCancelableIndicator.INSTANCE);
                }
                finally {
                    isInNonCancelableSection.remove();
                }
            }
            catch (ProcessCanceledException e) {
                LOG.error("PCE is not expected in non-cancellable section execution", new Exception(e));
            }
        }
    }

    @Override
    public <T, E extends Exception> T computeInNonCancelableSection(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            CoreProgressManager.$$$reportNull$$$0(4);
        }
        Ref result2 = Ref.create();
        Ref exception = Ref.create();
        this.executeNonCancelableSection(() -> {
            try {
                result2.set(computable.compute());
            }
            catch (Exception t) {
                exception.set(t);
            }
        });
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            ExceptionUtil.rethrowUnchecked(t);
            Exception e = (Exception)t;
            throw e;
        }
        return result2.get();
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process2, @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project) {
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(5);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(6);
        }
        return this.runProcessWithProgressSynchronously(process2, progressTitle, canBeCanceled, project, null);
    }

    @Override
    public <T, E extends Exception> T runProcessWithProgressSynchronously(final @NotNull ThrowableComputable<T, E> process2, @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project) throws E {
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(7);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(8);
        }
        final AtomicReference result2 = new AtomicReference();
        final AtomicReference exception = new AtomicReference();
        this.runProcessWithProgressSynchronously(new Task.Modal(project, progressTitle, canBeCanceled){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    Object compute = process2.compute();
                    result2.set(compute);
                }
                catch (Throwable t) {
                    exception.set(t);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager$1", "run"));
            }
        }, null);
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            ExceptionUtil.rethrowUnchecked(t);
            Exception e = (Exception)t;
            throw e;
        }
        return (T)result2.get();
    }

    @Override
    public boolean runProcessWithProgressSynchronously(final @NotNull Runnable process2, @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project, @Nullable JComponent parentComponent) {
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(9);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(10);
        }
        Task.Modal task = new Task.Modal(project, progressTitle, canBeCanceled){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                process2.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager$2", "run"));
            }
        };
        return this.runProcessWithProgressSynchronously(task, parentComponent);
    }

    @Override
    public void runProcessWithProgressAsynchronously(@NotNull Project project, @NotNull String progressTitle, @NotNull Runnable process2, @Nullable Runnable successRunnable, @Nullable Runnable canceledRunnable) {
        if (project == null) {
            CoreProgressManager.$$$reportNull$$$0(11);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(12);
        }
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(13);
        }
        this.runProcessWithProgressAsynchronously(project, progressTitle, process2, successRunnable, canceledRunnable, PerformInBackgroundOption.DEAF);
    }

    @Override
    public void runProcessWithProgressAsynchronously(@NotNull Project project, @NotNull String progressTitle, final @NotNull Runnable process2, final @Nullable Runnable successRunnable, final @Nullable Runnable canceledRunnable, @NotNull PerformInBackgroundOption option) {
        if (project == null) {
            CoreProgressManager.$$$reportNull$$$0(14);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(15);
        }
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(16);
        }
        if (option == null) {
            CoreProgressManager.$$$reportNull$$$0(17);
        }
        this.runProcessWithProgressAsynchronously(new Task.Backgroundable(project, progressTitle, true, option){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                process2.run();
            }

            @Override
            public void onCancel() {
                if (canceledRunnable != null) {
                    canceledRunnable.run();
                }
            }

            @Override
            public void onSuccess() {
                if (successRunnable != null) {
                    successRunnable.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager$3", "run"));
            }
        });
    }

    @ApiStatus.Internal
    public static boolean shouldRunHeadlessTasksSynchronously() {
        return SystemProperties.getBooleanProperty("intellij.progress.task.ignoreHeadless", false);
    }

    @Override
    public void run(@NotNull Task task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(18);
        }
        if (task.isHeadless() && !CoreProgressManager.shouldRunHeadlessTasksSynchronously()) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.runProcessWithProgressSynchronously(task, null);
            } else {
                this.runProcessWithProgressInCurrentThread(task, new EmptyProgressIndicator(), ModalityState.defaultModalityState());
            }
        } else if (task.isModal()) {
            this.runSynchronously(task.asModal());
        } else {
            Task.Backgroundable backgroundable = task.asBackgroundable();
            if (backgroundable.isConditionalModal() && !backgroundable.shouldStartInBackground()) {
                this.runSynchronously(task);
            } else {
                this.runAsynchronously(backgroundable);
            }
        }
    }

    private void runSynchronously(@NotNull Task task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(19);
        }
        this.runProcessWithProgressSynchronously(task, null);
    }

    private void runAsynchronously(@NotNull Task.Backgroundable task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(20);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.runProcessWithProgressAsynchronously(task);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                Project project = task.getProject();
                if (project != null && project.isDisposed()) {
                    LOG.info("Task canceled because of project disposal: " + task);
                    this.finishTask(task, true, null);
                    return;
                }
                this.runProcessWithProgressAsynchronously(task);
            }, ModalityState.defaultModalityState());
        }
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(21);
        }
        Future<?> future = this.runProcessWithProgressAsynchronously(task, new EmptyProgressIndicator(), null);
        if (future == null) {
            CoreProgressManager.$$$reportNull$$$0(22);
        }
        return future;
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation2) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(23);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(24);
        }
        Future<?> future = this.runProcessWithProgressAsynchronously(task, progressIndicator, continuation2, progressIndicator.getModalityState());
        if (future == null) {
            CoreProgressManager.$$$reportNull$$$0(25);
        }
        return future;
    }

    @Deprecated
    @NotNull
    protected TaskRunnable createTaskRunnable(@NotNull Task task, @NotNull ProgressIndicator indicator, @Nullable Runnable continuation2) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(26);
        }
        if (indicator == null) {
            CoreProgressManager.$$$reportNull$$$0(27);
        }
        return new TaskRunnable(task, indicator, continuation2);
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation2, @NotNull ModalityState modalityState) {
        IndicatorDisposable indicatorDisposable;
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(28);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(29);
        }
        if (modalityState == null) {
            CoreProgressManager.$$$reportNull$$$0(30);
        }
        if (progressIndicator instanceof Disposable) {
            indicatorDisposable = new IndicatorDisposable(progressIndicator);
            Disposer.register(ApplicationManager.getApplication(), indicatorDisposable);
        } else {
            indicatorDisposable = null;
        }
        Future<?> future = this.runProcessWithProgressAsync(task, CompletableFuture.completedFuture(progressIndicator), continuation2, indicatorDisposable, modalityState);
        if (future == null) {
            CoreProgressManager.$$$reportNull$$$0(31);
        }
        return future;
    }

    @NotNull
    protected Future<?> runProcessWithProgressAsync(@NotNull Task.Backgroundable task, @NotNull CompletableFuture<? extends ProgressIndicator> progressIndicator, @Nullable Runnable continuation2, @Nullable IndicatorDisposable indicatorDisposable, @Nullable ModalityState modalityState) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(32);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(33);
        }
        AtomicLong elapsed = new AtomicLong();
        CompletionStage completionStage = new ProgressRunner(progress -> {
            long start2 = System.currentTimeMillis();
            try {
                this.createTaskRunnable(task, (ProgressIndicator)progress, continuation2).run();
            }
            finally {
                elapsed.set(System.currentTimeMillis() - start2);
            }
            return null;
        }).onThread(ProgressRunner.ThreadToUse.POOLED).withProgress(progressIndicator).submit().whenComplete(ClientId.decorateBiConsumer((result2, err) -> {
            ModalityState modality;
            if (!result2.isCanceled()) {
                this.notifyTaskFinished(task, elapsed.get());
            }
            if (modalityState != null) {
                modality = modalityState;
            } else {
                try {
                    modality = ((ProgressIndicator)progressIndicator.get()).getModalityState();
                }
                catch (Throwable e) {
                    modality = ModalityState.NON_MODAL;
                }
            }
            ApplicationUtil.invokeLaterSomewhere(() -> {
                this.finishTask(task, result2.isCanceled(), result2.getThrowable() instanceof ProcessCanceledException ? null : result2.getThrowable());
                if (indicatorDisposable != null) {
                    Disposer.dispose(indicatorDisposable);
                }
            }, task.whereToRunCallbacks(), modality);
        }));
        if (completionStage == null) {
            CoreProgressManager.$$$reportNull$$$0(34);
        }
        return completionStage;
    }

    void notifyTaskFinished(@NotNull Task.Backgroundable task, long elapsed) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(35);
        }
    }

    public boolean runProcessWithProgressSynchronously(final @NotNull Task task, @Nullable JComponent parentComponent) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(36);
        }
        final Ref exceptionRef = new Ref();
        TaskContainer taskContainer = new TaskContainer(task){

            @Override
            public void run() {
                try {
                    CoreProgressManager.this.createTaskRunnable(task, CoreProgressManager.this.getProgressIndicator(), null).run();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    exceptionRef.set(e);
                }
            }
        };
        ApplicationEx application = (ApplicationEx)ApplicationManager.getApplication();
        boolean result2 = application.runProcessWithProgressSynchronously(taskContainer, task.getTitle(), task.isCancellable(), task.isModal(), task.getProject(), parentComponent, task.getCancelText());
        ApplicationUtil.invokeAndWaitSomewhere(() -> this.finishTask(task, !result2, (Throwable)exceptionRef.get()), task.whereToRunCallbacks());
        return result2;
    }

    public void runProcessWithProgressInCurrentThread(@NotNull Task task, @NotNull ProgressIndicator progressIndicator, @NotNull ModalityState modalityState) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(37);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(38);
        }
        if (modalityState == null) {
            CoreProgressManager.$$$reportNull$$$0(39);
        }
        if (progressIndicator instanceof Disposable) {
            Disposer.register(ApplicationManager.getApplication(), (Disposable)((Object)progressIndicator));
        }
        TaskRunnable process2 = this.createTaskRunnable(task, progressIndicator, null);
        boolean processCanceled = false;
        Throwable exception = null;
        try {
            this.runProcess(process2, progressIndicator);
        }
        catch (ProcessCanceledException e) {
            processCanceled = true;
        }
        catch (Throwable e) {
            exception = e;
        }
        boolean finalCanceled = processCanceled || progressIndicator.isCanceled();
        Throwable finalException = exception;
        ApplicationUtil.invokeAndWaitSomewhere(() -> this.finishTask(task, finalCanceled, finalException), task.whereToRunCallbacks(), modalityState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishTask(@NotNull Task task, boolean canceled, @Nullable Throwable error) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(40);
        }
        try {
            if (error != null) {
                task.onThrowable(error);
            } else if (canceled) {
                task.onCancel();
            } else {
                task.onSuccess();
            }
        }
        finally {
            task.onFinished();
        }
    }

    @Override
    public void runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator progressIndicator) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(41);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(42);
        }
        this.runProcessWithProgressAsynchronously(task, progressIndicator, null);
    }

    @Override
    public ProgressIndicator getProgressIndicator() {
        return CoreProgressManager.getCurrentIndicator(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeProcessUnderProgress(@NotNull Runnable process2, ProgressIndicator progress) throws ProcessCanceledException {
        block10: {
            if (process2 == null) {
                CoreProgressManager.$$$reportNull$$$0(43);
            }
            if (progress == null) {
                this.myUnsafeProgressCount.incrementAndGet();
            }
            try {
                boolean set2;
                ProgressIndicator oldIndicator = null;
                boolean bl = set2 = progress != null && progress != (oldIndicator = this.getProgressIndicator());
                if (set2) {
                    Thread currentThread = Thread.currentThread();
                    long threadId = currentThread.getId();
                    CoreProgressManager.setCurrentIndicator(threadId, progress);
                    try {
                        this.registerIndicatorAndRun(progress, currentThread, oldIndicator, process2);
                        break block10;
                    }
                    finally {
                        CoreProgressManager.setCurrentIndicator(threadId, oldIndicator);
                    }
                }
                process2.run();
            }
            finally {
                if (progress == null) {
                    this.myUnsafeProgressCount.decrementAndGet();
                }
            }
        }
    }

    @Override
    public boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action, @Nullable ProgressIndicator indicator) {
        if (action == null) {
            CoreProgressManager.$$$reportNull$$$0(44);
        }
        ApplicationManager.getApplication().runReadAction(action);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerIndicatorAndRun(@NotNull ProgressIndicator indicator, @NotNull Thread currentThread, ProgressIndicator oldIndicator, @NotNull Runnable process2) {
        boolean isStandard;
        Set underIndicator;
        if (indicator == null) {
            CoreProgressManager.$$$reportNull$$$0(45);
        }
        if (currentThread == null) {
            CoreProgressManager.$$$reportNull$$$0(46);
        }
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(47);
        }
        ArrayList<Set> threadsUnderThisIndicator = new ArrayList<Set>();
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            boolean oneOfTheIndicatorsIsCanceled = false;
            ProgressIndicator thisIndicator = indicator;
            while (thisIndicator != null) {
                underIndicator = threadsUnderIndicator.computeIfAbsent(thisIndicator, __ -> new SmartHashSet());
                boolean alreadyUnder = !underIndicator.add(currentThread);
                threadsUnderThisIndicator.add(alreadyUnder ? null : underIndicator);
                isStandard = thisIndicator instanceof StandardProgressIndicator;
                if (!isStandard) {
                    nonStandardIndicators.add(thisIndicator);
                    this.startBackgroundNonStandardIndicatorsPing();
                }
                oneOfTheIndicatorsIsCanceled |= thisIndicator.isCanceled();
                thisIndicator = thisIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator() : null;
            }
            this.updateThreadUnderCanceledIndicator(currentThread, oneOfTheIndicatorsIsCanceled);
        }
        try {
            process2.run();
            map2 = threadsUnderIndicator;
        }
        catch (Throwable throwable) {
            Map<ProgressIndicator, Set<Thread>> map3 = threadsUnderIndicator;
            synchronized (map3) {
                ProgressIndicator thisIndicator = null;
                for (int i = 0; i < threadsUnderThisIndicator.size(); ++i) {
                    boolean isStandard2;
                    boolean removed2;
                    thisIndicator = i == 0 ? indicator : ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator();
                    Set underIndicator2 = (Set)threadsUnderThisIndicator.get(i);
                    boolean bl = removed2 = underIndicator2 != null && underIndicator2.remove(currentThread);
                    if (removed2 && underIndicator2.isEmpty()) {
                        threadsUnderIndicator.remove(thisIndicator);
                    }
                    if (isStandard2 = thisIndicator instanceof StandardProgressIndicator) continue;
                    nonStandardIndicators.remove(thisIndicator);
                    if (!nonStandardIndicators.isEmpty()) continue;
                    this.stopBackgroundNonStandardIndicatorsPing();
                }
                this.updateThreadUnderCanceledIndicator(currentThread, oldIndicator != null && oldIndicator.isCanceled());
            }
            throw throwable;
        }
        synchronized (map2) {
            ProgressIndicator thisIndicator = null;
            for (int i = 0; i < threadsUnderThisIndicator.size(); ++i) {
                boolean removed3;
                thisIndicator = i == 0 ? indicator : ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator();
                underIndicator = (Set)threadsUnderThisIndicator.get(i);
                boolean bl = removed3 = underIndicator != null && underIndicator.remove(currentThread);
                if (removed3 && underIndicator.isEmpty()) {
                    threadsUnderIndicator.remove(thisIndicator);
                }
                if (isStandard = thisIndicator instanceof StandardProgressIndicator) continue;
                nonStandardIndicators.remove(thisIndicator);
                if (!nonStandardIndicators.isEmpty()) continue;
                this.stopBackgroundNonStandardIndicatorsPing();
            }
            this.updateThreadUnderCanceledIndicator(currentThread, oldIndicator != null && oldIndicator.isCanceled());
        }
    }

    private void updateThreadUnderCanceledIndicator(@NotNull Thread thread2, boolean underCanceledIndicator) {
        boolean changed;
        if (thread2 == null) {
            CoreProgressManager.$$$reportNull$$$0(48);
        }
        boolean bl = changed = underCanceledIndicator ? threadsUnderCanceledIndicator.add(thread2) : threadsUnderCanceledIndicator.remove(thread2);
        if (changed) {
            this.updateShouldCheckCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateShouldCheckCanceled() {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            CheckCanceledHook hook = this.createCheckCanceledHook();
            boolean hasCanceledIndicator = !threadsUnderCanceledIndicator.isEmpty();
            ourCheckCanceledHook = hook;
            ourCheckCanceledBehavior = hook == null && !hasCanceledIndicator ? CheckCanceledBehavior.NONE : (hasCanceledIndicator && ENABLED ? CheckCanceledBehavior.INDICATOR_PLUS_HOOKS : CheckCanceledBehavior.ONLY_HOOKS);
        }
    }

    @Nullable
    protected CheckCanceledHook createCheckCanceledHook() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void indicatorCanceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CoreProgressManager.$$$reportNull$$$0(49);
        }
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            Set<Thread> threads = threadsUnderIndicator.get(indicator);
            if (threads != null) {
                for (Thread thread2 : threads) {
                    boolean underCancelledIndicator = false;
                    ProgressIndicator currentIndicator = CoreProgressManager.getCurrentIndicator(thread2);
                    while (currentIndicator != null) {
                        if (currentIndicator == indicator) {
                            underCancelledIndicator = true;
                            break;
                        }
                        currentIndicator = currentIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)currentIndicator).getOriginalProgressIndicator() : null;
                    }
                    if (!underCancelledIndicator) continue;
                    threadsUnderCanceledIndicator.add(thread2);
                    this.updateShouldCheckCanceled();
                }
            }
        }
    }

    @Override
    public boolean isInNonCancelableSection() {
        return isInNonCancelableSection.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Throwable> T computePrioritized(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            CoreProgressManager.$$$reportNull$$$0(51);
        }
        Thread thread2 = Thread.currentThread();
        if (!Registry.is("ide.prioritize.threads", true) || this.isPrioritizedThread(thread2)) {
            return computable.compute();
        }
        Object object = this.myPrioritizationLock;
        synchronized (object) {
            if (this.myPrioritizedThreads.isEmpty()) {
                this.myPrioritizingStarted = System.nanoTime();
            }
            this.myPrioritizedThreads.add(thread2);
            this.updateEffectivePrioritized();
        }
        try {
            object = computable.compute();
            return (T)object;
        }
        finally {
            Object object2 = this.myPrioritizationLock;
            synchronized (object2) {
                this.myPrioritizedThreads.remove(thread2);
                this.updateEffectivePrioritized();
            }
        }
    }

    private void updateEffectivePrioritized() {
        Thread[] prev = this.myEffectivePrioritizedThreads;
        Thread[] current = this.myDeprioritizations > 0 || this.myPrioritizedThreads.isEmpty() ? NO_THREADS : this.myPrioritizedThreads.toArray(NO_THREADS);
        this.myEffectivePrioritizedThreads = current;
        if (prev.length == 0 && current.length > 0) {
            this.prioritizingStarted();
        } else if (prev.length > 0 && current.length == 0) {
            this.prioritizingFinished();
        }
    }

    protected void prioritizingStarted() {
    }

    protected void prioritizingFinished() {
    }

    @ApiStatus.Internal
    public boolean isPrioritizedThread(@NotNull Thread from2) {
        if (from2 == null) {
            CoreProgressManager.$$$reportNull$$$0(52);
        }
        return this.myPrioritizedThreads.contains(from2);
    }

    private static void setCurrentIndicator(long threadId, ProgressIndicator indicator) {
        if (indicator == null) {
            currentIndicators.remove(threadId);
            threadTopLevelIndicators.remove(threadId);
        } else {
            currentIndicators.put(threadId, indicator);
            threadTopLevelIndicators.putIfAbsent(threadId, indicator);
        }
    }

    private static ProgressIndicator getCurrentIndicator(@NotNull Thread thread2) {
        if (thread2 == null) {
            CoreProgressManager.$$$reportNull$$$0(54);
        }
        return currentIndicators.get(thread2.getId());
    }

    static {
        threadsUnderIndicator = new HashMap<ProgressIndicator, Set<Thread>>();
        currentIndicators = ContainerUtil.createConcurrentLongObjectMap();
        threadTopLevelIndicators = ContainerUtil.createConcurrentLongObjectMap();
        threadsUnderCanceledIndicator = new HashSet<Thread>();
        ourCheckCanceledBehavior = CheckCanceledBehavior.NONE;
        nonStandardIndicators = ConcurrentHashMultiset.create();
        isInNonCancelableSection = new ThreadLocal();
        MAX_PRIORITIZATION_NANOS = TimeUnit.SECONDS.toNanos(12L);
        NO_THREADS = new Thread[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 16: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 24: 
            case 29: 
            case 33: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 27: 
            case 45: 
            case 49: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 30: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentThread";
                break;
            }
            case 48: 
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentIndicators";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager";
                break;
            }
            case 22: 
            case 25: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcessWithProgressAsynchronously";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcessWithProgressAsync";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentThreadProgressModality";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "assertNoOtherThreadUnder";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeNonCancelableSection";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeInNonCancelableSection";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressSynchronously";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressAsynchronously";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "runSynchronously";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "runAsynchronously";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createTaskRunnable";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressAsync";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "notifyTaskFinished";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressInCurrentThread";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "finishTask";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "executeProcessUnderProgress";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "runInReadActionWithWriteActionPriority";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "registerIndicatorAndRun";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "updateThreadUnderCanceledIndicator";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "indicatorCanceled";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isCanceledThread";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "computePrioritized";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isPrioritizedThread";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentIndicator";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "assertUnderProgress";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    static interface CheckCanceledHook {
        public boolean runHook(@Nullable ProgressIndicator var1);
    }

    @Deprecated
    protected static class TaskRunnable
    extends TaskContainer {
        private final ProgressIndicator myIndicator;
        private final Runnable myContinuation;

        TaskRunnable(@NotNull Task task, @NotNull ProgressIndicator indicator, @Nullable Runnable continuation2) {
            if (task == null) {
                TaskRunnable.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                TaskRunnable.$$$reportNull$$$0(1);
            }
            super(task);
            this.myIndicator = indicator;
            this.myContinuation = continuation2;
        }

        @Override
        public void run() {
            try {
                this.getTask().run(this.myIndicator);
            }
            finally {
                try {
                    if (this.myIndicator instanceof ProgressIndicatorEx) {
                        ((ProgressIndicatorEx)this.myIndicator).finish(this.getTask());
                    }
                }
                finally {
                    if (this.myContinuation != null) {
                        this.myContinuation.run();
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "task";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indicator";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager$TaskRunnable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static abstract class TaskContainer
    implements Runnable {
        private final Task myTask;

        protected TaskContainer(@NotNull Task task) {
            if (task == null) {
                TaskContainer.$$$reportNull$$$0(0);
            }
            this.myTask = task;
        }

        @NotNull
        public Task getTask() {
            Task task = this.myTask;
            if (task == null) {
                TaskContainer.$$$reportNull$$$0(1);
            }
            return task;
        }

        public String toString() {
            return this.myTask.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager$TaskContainer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager$TaskContainer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IndicatorDisposable
    implements Disposable {
        @NotNull
        private final ProgressIndicator myIndicator;

        IndicatorDisposable(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                IndicatorDisposable.$$$reportNull$$$0(0);
            }
            this.myIndicator = indicator;
        }

        @Override
        public void dispose() {
            Disposer.dispose((Disposable)((Object)this.myIndicator), false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager$IndicatorDisposable", "<init>"));
        }
    }

    private static enum CheckCanceledBehavior {
        NONE,
        ONLY_HOOKS,
        INDICATOR_PLUS_HOOKS;

    }
}

