/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.ObjectTree;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public final class Disposer {
    private static final ObjectTree ourTree = new ObjectTree();
    private static boolean ourDebugMode;
    private static final Map<String, Disposable> ourKeyDisposables;

    @NotNull
    @Contract(pure=true, value="->new")
    public static Disposable newDisposable() {
        return Disposer.newDisposable("");
    }

    @NotNull
    @Contract(pure=true, value="_->new")
    public static Disposable newDisposable(final @NotNull @NonNls String debugName) {
        if (debugName == null) {
            Disposer.$$$reportNull$$$0(0);
        }
        return new Disposable(){

            @Override
            public void dispose() {
            }

            public String toString() {
                return debugName;
            }
        };
    }

    public static void register(@NotNull Disposable parent2, @NotNull Disposable child) throws IncorrectOperationException {
        RuntimeException e;
        if (parent2 == null) {
            Disposer.$$$reportNull$$$0(4);
        }
        if (child == null) {
            Disposer.$$$reportNull$$$0(5);
        }
        if ((e = ourTree.register(parent2, child)) != null) {
            throw e;
        }
    }

    public static void dispose(@NotNull Disposable disposable2) {
        if (disposable2 == null) {
            Disposer.$$$reportNull$$$0(14);
        }
        Disposer.dispose(disposable2, true);
    }

    public static void dispose(@NotNull Disposable disposable2, boolean processUnregistered) {
        if (disposable2 == null) {
            Disposer.$$$reportNull$$$0(16);
        }
        ourTree.executeAll(disposable2, processUnregistered);
    }

    @NotNull
    public static ObjectTree getTree() {
        ObjectTree objectTree = ourTree;
        if (objectTree == null) {
            Disposer.$$$reportNull$$$0(17);
        }
        return objectTree;
    }

    public static boolean isDebugMode() {
        return ourDebugMode;
    }

    public static Throwable getDisposalTrace(@NotNull Disposable disposable2) {
        if (disposable2 == null) {
            Disposer.$$$reportNull$$$0(20);
        }
        return ObjectUtils.tryCast(Disposer.getTree().getDisposalInfo(disposable2), Throwable.class);
    }

    static {
        ourKeyDisposables = ContainerUtil.createConcurrentWeakMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/Disposer";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/Disposer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "newDisposable";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newDisposable";
                break;
            }
            case 3: 
            case 17: {
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryRegister";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDisposed";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isDisposing";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "disposeChildren";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findRegisteredObject";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDisposalTrace";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

