/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.codeStyle;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.MatcherWithFallback;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.MinusculeMatcher;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.MinusculeMatcherImpl;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.NameUtil;
import org.jetbrains.kotlin.com.intellij.util.text.KeyboardLayoutUtil;

public class FixingLayoutMatcher
extends MatcherWithFallback {
    public FixingLayoutMatcher(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity options2, String hardSeparators) {
        if (pattern == null) {
            FixingLayoutMatcher.$$$reportNull$$$0(0);
        }
        if (options2 == null) {
            FixingLayoutMatcher.$$$reportNull$$$0(1);
        }
        super(new MinusculeMatcherImpl(pattern, options2, hardSeparators), FixingLayoutMatcher.withFixedLayout(pattern, options2, hardSeparators));
    }

    @Nullable
    public static String fixLayout(String pattern) {
        boolean hasLetters = false;
        boolean onlyWrongLetters = true;
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (!Character.isLetter(c)) continue;
            hasLetters = true;
            if (c > '\u007f') continue;
            onlyWrongLetters = false;
            break;
        }
        if (hasLetters && onlyWrongLetters) {
            char[] alternatePattern = new char[pattern.length()];
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                Character newC = KeyboardLayoutUtil.getAsciiForChar(c);
                alternatePattern[i] = newC == null ? c : newC.charValue();
            }
            return new String(alternatePattern);
        }
        return null;
    }

    @Nullable
    private static MinusculeMatcher withFixedLayout(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity options2, String hardSeparators) {
        String s;
        if (pattern == null) {
            FixingLayoutMatcher.$$$reportNull$$$0(2);
        }
        if (options2 == null) {
            FixingLayoutMatcher.$$$reportNull$$$0(3);
        }
        if ((s = FixingLayoutMatcher.fixLayout(pattern)) != null && !s.equals(pattern)) {
            return new MinusculeMatcherImpl(s, options2, hardSeparators);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/codeStyle/FixingLayoutMatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "withFixedLayout";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

