/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import java.util.Arrays;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.StubBuildingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaModuleStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiClassReferenceListStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiJavaModuleStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiModifierListStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiPackageAccessibilityStatementStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiProvidesStatementStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiRequiresStatementStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiUsesStatementStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ModuleVisitor;

public class ModuleStubBuildingVisitor
extends ClassVisitor {
    private static final Function<String, String> NAME_MAPPER = name1 -> name1.replace('/', '.');
    private final PsiJavaFileStub myParent;
    private PsiJavaModuleStub myResult;
    private PsiModifierListStubImpl myModList;

    public ModuleStubBuildingVisitor(PsiJavaFileStub parent2) {
        super(589824);
        this.myParent = parent2;
    }

    public PsiJavaModuleStub getResult() {
        return this.myResult;
    }

    @Override
    public ModuleVisitor visitModule(String name2, int access, String version2) {
        this.myResult = new PsiJavaModuleStubImpl((StubElement)this.myParent, name2);
        this.myModList = new PsiModifierListStubImpl((StubElement)this.myResult, ModuleStubBuildingVisitor.moduleFlags(access));
        return new ModuleVisitor(589824){

            @Override
            public void visitRequire(String module2, int access, String version2) {
                if (!ModuleStubBuildingVisitor.isGenerated(access)) {
                    PsiRequiresStatementStubImpl statementStub = new PsiRequiresStatementStubImpl((StubElement)ModuleStubBuildingVisitor.this.myResult, module2);
                    new PsiModifierListStubImpl((StubElement)statementStub, ModuleStubBuildingVisitor.requiresFlags(access));
                }
            }

            @Override
            public void visitExport(String packageName, int access, String ... modules) {
                if (!ModuleStubBuildingVisitor.isGenerated(access)) {
                    new PsiPackageAccessibilityStatementStubImpl(ModuleStubBuildingVisitor.this.myResult, JavaStubElementTypes.EXPORTS_STATEMENT, (String)NAME_MAPPER.fun(packageName), modules == null ? null : Arrays.asList(modules));
                }
            }

            @Override
            public void visitOpen(String packageName, int access, String ... modules) {
                if (!ModuleStubBuildingVisitor.isGenerated(access)) {
                    new PsiPackageAccessibilityStatementStubImpl(ModuleStubBuildingVisitor.this.myResult, JavaStubElementTypes.OPENS_STATEMENT, (String)NAME_MAPPER.fun(packageName), modules == null ? null : Arrays.asList(modules));
                }
            }

            @Override
            public void visitUse(String service) {
                new PsiUsesStatementStubImpl((StubElement)ModuleStubBuildingVisitor.this.myResult, (String)NAME_MAPPER.fun(service));
            }

            @Override
            public void visitProvide(String service, String ... providers) {
                PsiProvidesStatementStubImpl statementStub = new PsiProvidesStatementStubImpl((StubElement)ModuleStubBuildingVisitor.this.myResult, (String)NAME_MAPPER.fun(service));
                String[] names2 = ContainerUtil.map2Array(providers, String.class, NAME_MAPPER);
                new PsiClassReferenceListStubImpl(JavaStubElementTypes.PROVIDES_WITH_LIST, (StubElement)statementStub, names2.length == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : names2);
            }
        };
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return StubBuildingVisitor.getAnnotationTextCollector(desc, text2 -> new PsiAnnotationStubImpl((StubElement)this.myModList, (String)text2));
    }

    private static boolean isGenerated(int access) {
        return BitUtil.isSet(access, 4096) || BitUtil.isSet(access, 32768);
    }

    private static int moduleFlags(int access) {
        return BitUtil.isSet(access, 32) ? 8192 : 0;
    }

    private static int requiresFlags(int access) {
        int flags = 0;
        if (BitUtil.isSet(access, 32)) {
            flags |= 0x4000;
        }
        if (BitUtil.isSet(access, 64)) {
            flags |= 8;
        }
        return flags;
    }
}

