/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.search;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.application.QueryExecutorBase;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.search.searches.SuperMethodsSearch;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.kotlin.com.intellij.util.Processor;

public class MethodSuperSearcher
extends QueryExecutorBase<MethodSignatureBackedByPsiMethod, SuperMethodsSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance(MethodSuperSearcher.class);

    public MethodSuperSearcher() {
        super(true);
    }

    @Override
    public void processQuery(@NotNull SuperMethodsSearch.SearchParameters queryParameters2, @NotNull Processor<? super MethodSignatureBackedByPsiMethod> consumer2) {
        if (queryParameters2 == null) {
            MethodSuperSearcher.$$$reportNull$$$0(0);
        }
        if (consumer2 == null) {
            MethodSuperSearcher.$$$reportNull$$$0(1);
        }
        PsiClass parentClass = queryParameters2.getPsiClass();
        PsiMethod method2 = queryParameters2.getMethod();
        HierarchicalMethodSignature signature2 = method2.getHierarchicalMethodSignature();
        boolean checkBases = queryParameters2.isCheckBases();
        boolean allowStaticMethod = queryParameters2.isAllowStaticMethod();
        List<HierarchicalMethodSignature> supers = signature2.getSuperSignatures();
        for (HierarchicalMethodSignature superSignature : supers) {
            if (!MethodSignatureUtil.isSubsignature(superSignature, signature2) || MethodSuperSearcher.addSuperMethods(superSignature, method2, parentClass, allowStaticMethod, checkBases, consumer2)) continue;
            return;
        }
    }

    private static boolean addSuperMethods(HierarchicalMethodSignature signature2, PsiMethod method2, PsiClass parentClass, boolean allowStaticMethod, boolean checkBases, Processor<? super MethodSignatureBackedByPsiMethod> consumer2) {
        PsiMethod signatureMethod = signature2.getMethod();
        PsiClass hisClass = signatureMethod.getContainingClass();
        if ((parentClass == null || InheritanceUtil.isInheritorOrSelf(parentClass, hisClass, true)) && MethodSuperSearcher.isAcceptable(signatureMethod, method2, allowStaticMethod)) {
            if (parentClass != null && !parentClass.equals(hisClass) && !checkBases) {
                return true;
            }
            LOG.assertTrue(signatureMethod != method2, method2);
            return consumer2.process(signature2);
        }
        for (HierarchicalMethodSignature superSignature : signature2.getSuperSignatures()) {
            if (!MethodSignatureUtil.isSubsignature(superSignature, signature2)) continue;
            MethodSuperSearcher.addSuperMethods(superSignature, method2, parentClass, allowStaticMethod, checkBases, consumer2);
        }
        return true;
    }

    private static boolean isAcceptable(PsiMethod superMethod, PsiMethod method2, boolean allowStaticMethod) {
        boolean hisStatic = superMethod.hasModifierProperty("static");
        return hisStatic == method2.hasModifierProperty("static") && (allowStaticMethod || !hisStatic) && JavaPsiFacade.getInstance(method2.getProject()).getResolveHelper().isAccessible(superMethod, method2, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/search/MethodSuperSearcher";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

