/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.util.Couple;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LazyParseableElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.templateLanguages.OuterLanguageElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IStrongWhitespaceHolderElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;

public final class TreeUtil {
    private static final Key<String> UNCLOSED_ELEMENT_PROPERTY = Key.create("UNCLOSED_ELEMENT_PROPERTY");
    public static final Key<FileElement> CONTAINING_FILE_KEY_AFTER_REPARSE = Key.create("CONTAINING_FILE_KEY_AFTER_REPARSE");

    public static void ensureParsed(ASTNode node) {
        if (node != null) {
            node.getFirstChildNode();
        }
    }

    public static boolean isCollapsedChameleon(ASTNode node) {
        return node instanceof LazyParseableElement && !((LazyParseableElement)node).isParsed();
    }

    @Nullable
    public static ASTNode findChildBackward(ASTNode parent2, IElementType type2) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED && parent2 instanceof TreeElement) {
            ((TreeElement)parent2).assertReadAccessAllowed();
        }
        for (ASTNode element = parent2.getLastChildNode(); element != null; element = element.getTreePrev()) {
            if (element.getElementType() != type2) continue;
            return element;
        }
        return null;
    }

    @Nullable
    public static ASTNode skipElements(@Nullable ASTNode element, @NotNull TokenSet types2) {
        ASTNode candidate2;
        if (types2 == null) {
            TreeUtil.$$$reportNull$$$0(0);
        }
        for (candidate2 = element; candidate2 != null && types2.contains(candidate2.getElementType()); candidate2 = candidate2.getTreeNext()) {
        }
        return candidate2;
    }

    @Nullable
    public static ASTNode skipElementsBack(@Nullable ASTNode element, @NotNull TokenSet types2) {
        ASTNode candidate2;
        if (types2 == null) {
            TreeUtil.$$$reportNull$$$0(1);
        }
        for (candidate2 = element; candidate2 != null && types2.contains(candidate2.getElementType()); candidate2 = candidate2.getTreePrev()) {
        }
        return candidate2;
    }

    @Nullable
    public static ASTNode findParent(ASTNode element, IElementType type2) {
        for (ASTNode parent2 = element.getTreeParent(); parent2 != null; parent2 = parent2.getTreeParent()) {
            if (parent2.getElementType() != type2) continue;
            return parent2;
        }
        return null;
    }

    @Nullable
    public static ASTNode findParent(ASTNode element, TokenSet types2) {
        for (ASTNode parent2 = element.getTreeParent(); parent2 != null; parent2 = parent2.getTreeParent()) {
            if (!types2.contains(parent2.getElementType())) continue;
            return parent2;
        }
        return null;
    }

    @Nullable
    public static ASTNode findParent(@NotNull ASTNode element, @NotNull TokenSet types2, @Nullable TokenSet stopAt) {
        if (element == null) {
            TreeUtil.$$$reportNull$$$0(2);
        }
        if (types2 == null) {
            TreeUtil.$$$reportNull$$$0(3);
        }
        for (ASTNode parent2 = element.getTreeParent(); parent2 != null; parent2 = parent2.getTreeParent()) {
            if (types2.contains(parent2.getElementType())) {
                return parent2;
            }
            if (stopAt == null || !stopAt.contains(parent2.getElementType())) continue;
            return null;
        }
        return null;
    }

    @Nullable
    public static LeafElement findFirstLeaf(ASTNode element) {
        return (LeafElement)TreeUtil.findFirstLeaf(element, true);
    }

    public static ASTNode findFirstLeaf(ASTNode element, boolean expandChameleons) {
        if (element instanceof LeafElement || !expandChameleons && TreeUtil.isCollapsedChameleon(element)) {
            return element;
        }
        for (ASTNode child = element.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            ASTNode leaf = TreeUtil.findFirstLeaf(child, expandChameleons);
            if (leaf == null) continue;
            return leaf;
        }
        return null;
    }

    @Nullable
    public static ASTNode findLastLeaf(ASTNode element) {
        return TreeUtil.findLastLeaf(element, true);
    }

    public static ASTNode findLastLeaf(ASTNode element, boolean expandChameleons) {
        if (element instanceof LeafElement || !expandChameleons && TreeUtil.isCollapsedChameleon(element)) {
            return element;
        }
        for (ASTNode child = element.getLastChildNode(); child != null; child = child.getTreePrev()) {
            ASTNode leaf = TreeUtil.findLastLeaf(child);
            if (leaf == null) continue;
            return leaf;
        }
        return null;
    }

    @Nullable
    public static ASTNode findSibling(ASTNode start2, IElementType elementType) {
        ASTNode child = start2;
        while (child != null) {
            if (child.getElementType() == elementType) {
                return child;
            }
            child = child.getTreeNext();
        }
        return null;
    }

    @Nullable
    public static ASTNode findSibling(ASTNode start2, TokenSet types2) {
        ASTNode child = start2;
        while (child != null) {
            if (types2.contains(child.getElementType())) {
                return child;
            }
            child = child.getTreeNext();
        }
        return null;
    }

    @Nullable
    public static ASTNode findSiblingBackward(ASTNode start2, IElementType elementType) {
        ASTNode child = start2;
        while (child != null) {
            if (child.getElementType() == elementType) {
                return child;
            }
            child = child.getTreePrev();
        }
        return null;
    }

    @Nullable
    public static ASTNode findSiblingBackward(ASTNode start2, TokenSet types2) {
        ASTNode child = start2;
        while (child != null) {
            if (types2.contains(child.getElementType())) {
                return child;
            }
            child = child.getTreePrev();
        }
        return null;
    }

    @Nullable
    public static ASTNode findCommonParent(ASTNode one, ASTNode two) {
        if (one == two) {
            return one;
        }
        HashSet<ASTNode> parents2 = new HashSet<ASTNode>(20);
        while (one != null) {
            parents2.add(one);
            one = one.getTreeParent();
        }
        while (two != null) {
            if (parents2.contains(two)) {
                return two;
            }
            two = two.getTreeParent();
        }
        return null;
    }

    public static Couple<ASTNode> findTopmostSiblingParents(ASTNode one, ASTNode two) {
        if (one == two) {
            return Couple.of(null, null);
        }
        LinkedList<ASTNode> oneParents = new LinkedList<ASTNode>();
        while (one != null) {
            oneParents.add(one);
            one = one.getTreeParent();
        }
        LinkedList<ASTNode> twoParents = new LinkedList<ASTNode>();
        while (two != null) {
            twoParents.add(two);
            two = two.getTreeParent();
        }
        while ((one = (ASTNode)oneParents.pollLast()) == (two = (ASTNode)twoParents.pollLast()) && one != null) {
        }
        return Couple.of(one, two);
    }

    public static void clearCaches(@NotNull TreeElement tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(4);
        }
        tree.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            protected void visitNode(TreeElement element) {
                element.clearCaches();
                super.visitNode(element);
            }
        });
    }

    @Nullable
    public static ASTNode nextLeaf(@NotNull ASTNode node) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(5);
        }
        return TreeUtil.nextLeaf((TreeElement)node, null);
    }

    @Nullable
    public static LeafElement nextLeaf(@NotNull LeafElement node) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(6);
        }
        return TreeUtil.nextLeaf(node, null);
    }

    public static FileElement getFileElement(@NotNull TreeElement element) {
        TreeElement parent2;
        if (element == null) {
            TreeUtil.$$$reportNull$$$0(7);
        }
        for (parent2 = element; parent2 != null && !(parent2 instanceof FileElement); parent2 = parent2.getTreeParent()) {
        }
        if (parent2 == null) {
            parent2 = element.getUserData(CONTAINING_FILE_KEY_AFTER_REPARSE);
        }
        return (FileElement)parent2;
    }

    @Nullable
    public static ASTNode prevLeaf(ASTNode node) {
        return TreeUtil.prevLeaf((TreeElement)node, null);
    }

    public static boolean isStrongWhitespaceHolder(IElementType type2) {
        return type2 instanceof IStrongWhitespaceHolderElementType;
    }

    public static String getTokenText(Lexer lexer) {
        return lexer.getBufferSequence().subSequence(lexer.getTokenStart(), lexer.getTokenEnd()).toString();
    }

    @Nullable
    public static LeafElement nextLeaf(@NotNull TreeElement start2, CommonParentState commonParent) {
        if (start2 == null) {
            TreeUtil.$$$reportNull$$$0(8);
        }
        return (LeafElement)TreeUtil.nextLeaf(start2, commonParent, null, true);
    }

    @Nullable
    public static TreeElement nextLeaf(@NotNull TreeElement start2, CommonParentState commonParent, IElementType searchedType, boolean expandChameleons) {
        if (start2 == null) {
            TreeUtil.$$$reportNull$$$0(9);
        }
        for (TreeElement element = start2; element != null; element = element.getTreeParent()) {
            if (commonParent != null) {
                commonParent.startLeafBranchStart = element;
                TreeUtil.initStrongWhitespaceHolder(commonParent, element, true);
            }
            TreeElement nextTree = element;
            TreeElement next = null;
            while (next == null && (nextTree = nextTree.getTreeNext()) != null) {
                if (nextTree.getElementType() == searchedType) {
                    return nextTree;
                }
                next = TreeUtil.findFirstLeafOrType(nextTree, searchedType, commonParent, expandChameleons);
            }
            if (next == null) continue;
            if (commonParent != null) {
                commonParent.nextLeafBranchStart = nextTree;
            }
            return next;
        }
        return null;
    }

    private static void initStrongWhitespaceHolder(CommonParentState commonParent, ASTNode start2, boolean slopeSide) {
        if (start2 instanceof CompositeElement && (TreeUtil.isStrongWhitespaceHolder(start2.getElementType()) || slopeSide && start2.getUserData(UNCLOSED_ELEMENT_PROPERTY) != null)) {
            commonParent.strongWhiteSpaceHolder = (CompositeElement)start2;
            commonParent.isStrongElementOnRisingSlope = slopeSide;
        }
    }

    @Nullable
    private static TreeElement findFirstLeafOrType(@NotNull TreeElement element, final IElementType searchedType, final CommonParentState commonParent, final boolean expandChameleons) {
        if (element == null) {
            TreeUtil.$$$reportNull$$$0(10);
        }
        final class MyVisitor
        extends RecursiveTreeElementWalkingVisitor {
            private TreeElement result;

            MyVisitor(boolean doTransform2) {
                super(doTransform2);
            }

            @Override
            protected void visitNode(TreeElement node) {
                if (this.result != null) {
                    return;
                }
                if (commonParent != null) {
                    TreeUtil.initStrongWhitespaceHolder(commonParent, node, false);
                }
                if (!expandChameleons && TreeUtil.isCollapsedChameleon(node) || node instanceof LeafElement || node.getElementType() == searchedType) {
                    this.result = node;
                    return;
                }
                super.visitNode(node);
            }
        }
        MyVisitor visitor2 = new MyVisitor(expandChameleons);
        element.acceptTree(visitor2);
        return visitor2.result;
    }

    @Nullable
    public static ASTNode prevLeaf(TreeElement start2, @Nullable CommonParentState commonParent) {
        while (start2 != null) {
            if (commonParent != null) {
                if (commonParent.strongWhiteSpaceHolder != null && start2.getUserData(UNCLOSED_ELEMENT_PROPERTY) != null) {
                    commonParent.strongWhiteSpaceHolder = (CompositeElement)start2;
                }
                commonParent.nextLeafBranchStart = start2;
            }
            ASTNode prevTree = start2;
            ASTNode prev = null;
            while (prev == null && (prevTree = prevTree.getTreePrev()) != null) {
                prev = TreeUtil.findLastLeaf(prevTree);
            }
            if (prev != null) {
                if (commonParent != null) {
                    commonParent.startLeafBranchStart = prevTree;
                }
                return prev;
            }
            start2 = start2.getTreeParent();
        }
        return null;
    }

    @Nullable
    public static ASTNode nextLeaf(@Nullable ASTNode start2, boolean expandChameleons) {
        while (start2 != null) {
            for (ASTNode each = start2.getTreeNext(); each != null; each = each.getTreeNext()) {
                ASTNode leaf = TreeUtil.findFirstLeaf(each, expandChameleons);
                if (leaf == null) continue;
                return leaf;
            }
            start2 = start2.getTreeParent();
        }
        return null;
    }

    @Nullable
    public static ASTNode prevLeaf(@Nullable ASTNode start2, boolean expandChameleons) {
        while (start2 != null) {
            for (ASTNode each = start2.getTreePrev(); each != null; each = each.getTreePrev()) {
                ASTNode leaf = TreeUtil.findLastLeaf(each, expandChameleons);
                if (leaf == null) continue;
                return leaf;
            }
            start2 = start2.getTreeParent();
        }
        return null;
    }

    @Nullable
    public static ASTNode getLastChild(ASTNode element) {
        ASTNode child = element;
        while (child != null) {
            element = child;
            child = element.getLastChildNode();
        }
        return element;
    }

    public static boolean containsOuterLanguageElements(@NotNull ASTNode node) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(11);
        }
        final AtomicBoolean result2 = new AtomicBoolean(false);
        ((TreeElement)node).acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            protected void visitNode(TreeElement element) {
                if (element instanceof OuterLanguageElement) {
                    result2.set(true);
                    this.stopWalking();
                    return;
                }
                super.visitNode(element);
            }
        });
        return result2.get();
    }

    @Nullable
    public static ASTNode skipWhitespaceAndComments(@Nullable ASTNode node, boolean forward) {
        return TreeUtil.skipWhitespaceCommentsAndTokens(node, TokenSet.EMPTY, forward);
    }

    @Nullable
    public static ASTNode skipWhitespaceCommentsAndTokens(@Nullable ASTNode node, @NotNull TokenSet alsoSkip, boolean forward) {
        if (alsoSkip == null) {
            TreeUtil.$$$reportNull$$$0(12);
        }
        ASTNode element = node;
        while (true) {
            if (element == null) {
                return null;
            }
            if (!TreeUtil.isWhitespaceOrComment(element) && !alsoSkip.contains(element.getElementType())) break;
            element = forward ? element.getTreeNext() : element.getTreePrev();
        }
        return element;
    }

    public static boolean isWhitespaceOrComment(@NotNull ASTNode element) {
        if (element == null) {
            TreeUtil.$$$reportNull$$$0(13);
        }
        return element.getPsi() instanceof PsiWhiteSpace || element.getPsi() instanceof PsiComment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alsoSkip";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/TreeUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "skipElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "skipElementsBack";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findParent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "clearCaches";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "nextLeaf";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "findFirstLeafOrType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "containsOuterLanguageElements";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "skipWhitespaceCommentsAndTokens";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isWhitespaceOrComment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class CommonParentState {
        TreeElement startLeafBranchStart;
        public ASTNode nextLeafBranchStart;
        CompositeElement strongWhiteSpaceHolder;
        boolean isStrongElementOnRisingSlope = true;
    }
}

