/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.infos;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.projectRoots.JavaSdkVersion;
import org.jetbrains.kotlin.com.intellij.openapi.projectRoots.JavaVersionService;
import org.jetbrains.kotlin.com.intellij.openapi.util.Computable;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.GenericsUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiFunctionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpressionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceType;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiResolveHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.ThreadLocalTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import org.jetbrains.kotlin.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.ThreeState;

public class MethodCandidateInfo
extends CandidateInfo {
    public static final RecursionGuard<PsiElement> ourOverloadGuard = RecursionManager.createGuard("overload.guard");
    @ApplicabilityLevelConstant
    private volatile int myApplicabilityLevel;
    @ApplicabilityLevelConstant
    private volatile int myPertinentApplicabilityLevel;
    private final PsiElement myArgumentList;
    private final PsiType[] myArgumentTypes;
    private final PsiType[] myTypeArguments;
    private PsiSubstitutor myCalcedSubstitutor;
    private volatile String myInferenceError;
    private volatile boolean myApplicabilityError;
    private final LanguageLevel myLanguageLevel;
    private volatile boolean myErased;

    public MethodCandidateInfo(@NotNull PsiElement candidate2, @NotNull PsiSubstitutor substitutor2, boolean accessProblem, boolean staticsProblem, PsiElement argumentList2, PsiElement currFileContext, PsiType @Nullable [] argumentTypes2, PsiType[] typeArguments2) {
        if (candidate2 == null) {
            MethodCandidateInfo.$$$reportNull$$$0(0);
        }
        if (substitutor2 == null) {
            MethodCandidateInfo.$$$reportNull$$$0(1);
        }
        this(candidate2, substitutor2, accessProblem, staticsProblem, argumentList2, currFileContext, argumentTypes2, typeArguments2, PsiUtil.getLanguageLevel(argumentList2));
    }

    public MethodCandidateInfo(@NotNull PsiElement candidate2, @NotNull PsiSubstitutor substitutor2, boolean accessProblem, boolean staticsProblem, PsiElement argumentList2, PsiElement currFileContext, PsiType @Nullable [] argumentTypes2, PsiType[] typeArguments2, @NotNull LanguageLevel languageLevel) {
        if (candidate2 == null) {
            MethodCandidateInfo.$$$reportNull$$$0(2);
        }
        if (substitutor2 == null) {
            MethodCandidateInfo.$$$reportNull$$$0(3);
        }
        if (languageLevel == null) {
            MethodCandidateInfo.$$$reportNull$$$0(4);
        }
        super(candidate2, substitutor2, accessProblem, staticsProblem, currFileContext);
        this.myArgumentList = argumentList2;
        this.myArgumentTypes = argumentTypes2;
        this.myTypeArguments = typeArguments2;
        this.myLanguageLevel = languageLevel;
    }

    public boolean isVarargs() {
        return false;
    }

    public boolean isApplicable() {
        return this.getPertinentApplicabilityLevel() != 1;
    }

    @ApplicabilityLevelConstant
    private int getApplicabilityLevelInner() {
        PsiType[] argumentTypes2 = this.getArgumentTypes();
        if (argumentTypes2 == null) {
            return 1;
        }
        int level = PsiUtil.getApplicabilityLevel(this.getElement(), this.getSubstitutor(), argumentTypes2, this.myLanguageLevel);
        if (level > 1 && !this.isTypeArgumentsApplicable()) {
            level = 1;
        }
        return level;
    }

    @ApplicabilityLevelConstant
    public int getApplicabilityLevel() {
        int result2 = this.myApplicabilityLevel;
        if (result2 == 0) {
            this.myApplicabilityLevel = result2 = this.getApplicabilityLevelInner();
        }
        return result2;
    }

    @ApplicabilityLevelConstant
    public int getPertinentApplicabilityLevel() {
        return this.getPertinentApplicabilityLevel(null);
    }

    @ApplicabilityLevelConstant
    public int getPertinentApplicabilityLevel(@Nullable Map<MethodCandidateInfo, PsiSubstitutor> map2) {
        int result2 = this.myPertinentApplicabilityLevel;
        if (result2 == 0) {
            this.myPertinentApplicabilityLevel = result2 = this.getPertinentApplicabilityLevelInner(() -> map2 != null ? (PsiSubstitutor)map2.get(this) : this.getSubstitutor(false));
        }
        return result2;
    }

    @ApplicabilityLevelConstant
    private int getPertinentApplicabilityLevelInner(Supplier<PsiSubstitutor> substitutorSupplier) {
        if (this.myArgumentList == null || !this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            return this.getApplicabilityLevel();
        }
        PsiMethod method2 = this.getElement();
        if (this.isToInferApplicability()) {
            substitutorSupplier.get();
            if (this.myApplicabilityError || this.isPotentiallyCompatible() != ThreeState.YES) {
                return 1;
            }
            return this.isVarargs() ? 2 : 3;
        }
        PsiSubstitutor substitutor2 = substitutorSupplier.get();
        Computable<Integer> computable = () -> this.computeWithKnownTargetType(() -> {
            PsiType[] argumentTypes2 = this.getArgumentTypes();
            if (argumentTypes2 == null) {
                return 1;
            }
            int level1 = PsiUtil.getApplicabilityLevel(method2, substitutor2, argumentTypes2, this.myLanguageLevel, true, true, (left, right, allowUncheckedConversion, argId) -> MethodCandidateInfo.checkFunctionalInterfaceAcceptance(method2, left, right, allowUncheckedConversion));
            if (!this.isVarargs() && level1 < 3) {
                return 1;
            }
            return level1;
        }, substitutor2);
        int level = Objects.requireNonNull(ourOverloadGuard.doPreventingRecursion(this.myArgumentList, false, computable));
        if (level > 1 && !this.isTypeArgumentsApplicable(() -> substitutor2)) {
            level = 1;
        }
        return level;
    }

    private <T> T computeWithKnownTargetType(Computable<T> computable, PsiSubstitutor substitutor2) {
        if (this.myArgumentList instanceof PsiExpressionList) {
            PsiExpressionList argumentList2 = (PsiExpressionList)this.myArgumentList;
            PsiElement parent2 = argumentList2.getParent();
            boolean prohibitCaching = (Boolean)CachedValuesManager.getCachedValue(parent2, () -> new CachedValueProvider.Result<Boolean>(!(parent2 instanceof PsiCallExpression) || JavaPsiFacade.getInstance(parent2.getProject()).getResolveHelper().hasOverloads((PsiCallExpression)parent2), PsiModificationTracker.MODIFICATION_COUNT));
            PsiExpression[] expressions = (PsiExpression[])Arrays.stream(argumentList2.getExpressions()).map(expression2 -> PsiUtil.skipParenthesizedExprDown(expression2)).filter(expression2 -> expression2 != null && !(expression2 instanceof PsiFunctionalExpression) && PsiPolyExpressionUtil.isPolyExpression(expression2)).toArray(PsiExpression[]::new);
            return (T)ThreadLocalTypes.performWithTypes(expressionTypes -> {
                PsiMethod method2 = this.getElement();
                boolean varargs = this.isVarargs();
                for (PsiExpression context : expressions) {
                    expressionTypes.forceType(context, PsiTypesUtil.getTypeByMethod(context, argumentList2, method2, varargs, substitutor2, false));
                }
                return computable.compute();
            }, prohibitCaching);
        }
        return computable.compute();
    }

    public boolean isOnArgumentList(PsiExpressionList argumentList2) {
        return this.myArgumentList == argumentList2;
    }

    public void setErased() {
        this.myErased = true;
    }

    public boolean isErased() {
        return this.myErased;
    }

    private static boolean checkFunctionalInterfaceAcceptance(PsiMethod method2, PsiType left, PsiType right, boolean allowUncheckedConversion) {
        PsiFunctionalExpression fun = null;
        if (right instanceof PsiLambdaExpressionType) {
            fun = ((PsiLambdaExpressionType)right).getExpression();
        } else if (right instanceof PsiMethodReferenceType) {
            fun = ((PsiMethodReferenceType)right).getExpression();
        }
        return fun != null ? !(left instanceof PsiArrayType) && fun.isAcceptable(left, method2) : TypeConversionUtil.isAssignable(left, right, allowUncheckedConversion);
    }

    public boolean isToInferApplicability() {
        return this.myTypeArguments == null && this.getElement().hasTypeParameters() && !this.isRawSubstitution();
    }

    public ThreeState isPotentiallyCompatible() {
        if (this.myArgumentList instanceof PsiExpressionList) {
            PsiMethod method2 = this.getElement();
            PsiParameter[] parameters2 = method2.getParameterList().getParameters();
            PsiExpression[] expressions = ((PsiExpressionList)this.myArgumentList).getExpressions();
            if (!this.isVarargs() && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                if (expressions.length != parameters2.length) {
                    return ThreeState.NO;
                }
            } else {
                if (expressions.length < parameters2.length - 1) {
                    return ThreeState.NO;
                }
                if (parameters2.length == 0 && expressions.length != parameters2.length) {
                    return ThreeState.NO;
                }
            }
            boolean unsure = false;
            for (int i = 0; i < expressions.length; ++i) {
                ThreeState compatible;
                PsiType formalParameterType;
                PsiExpression expression2 = expressions[i];
                PsiType psiType2 = formalParameterType = i < parameters2.length ? parameters2[i].getType() : parameters2[parameters2.length - 1].getType();
                if (formalParameterType instanceof PsiEllipsisType && this.isVarargs()) {
                    formalParameterType = ((PsiEllipsisType)formalParameterType).getComponentType();
                }
                if ((compatible = MethodCandidateInfo.isPotentialCompatible(expression2, this.getSiteSubstitutor().substitute(formalParameterType), method2)) == ThreeState.NO) {
                    return ThreeState.NO;
                }
                if (compatible != ThreeState.UNSURE) continue;
                unsure = true;
            }
            if (unsure) {
                return ThreeState.UNSURE;
            }
            if (method2.hasTypeParameters() && this.myTypeArguments != null) {
                return ThreeState.fromBoolean(method2.getTypeParameters().length == this.myTypeArguments.length);
            }
        }
        return ThreeState.YES;
    }

    private static ThreeState isPotentialCompatible(PsiExpression expression2, PsiType formalType, PsiMethod method2) {
        if (expression2 instanceof PsiFunctionalExpression) {
            PsiClass targetTypeParameter = PsiUtil.resolveClassInClassTypeOnly(formalType);
            if (targetTypeParameter instanceof PsiTypeParameter && method2.equals(((PsiTypeParameter)targetTypeParameter).getOwner())) {
                return ThreeState.YES;
            }
            if (!LambdaUtil.isFunctionalType(formalType)) {
                return ThreeState.NO;
            }
            if (!((PsiFunctionalExpression)expression2).isPotentiallyCompatible(formalType)) {
                return ThreeState.UNSURE;
            }
        } else {
            if (expression2 instanceof PsiParenthesizedExpression) {
                return MethodCandidateInfo.isPotentialCompatible(((PsiParenthesizedExpression)expression2).getExpression(), formalType, method2);
            }
            if (expression2 instanceof PsiConditionalExpression) {
                ThreeState thenCompatible = MethodCandidateInfo.isPotentialCompatible(((PsiConditionalExpression)expression2).getThenExpression(), formalType, method2);
                ThreeState elseCompatible = MethodCandidateInfo.isPotentialCompatible(((PsiConditionalExpression)expression2).getElseExpression(), formalType, method2);
                if (thenCompatible == ThreeState.NO || elseCompatible == ThreeState.NO) {
                    return ThreeState.NO;
                }
                if (thenCompatible == ThreeState.UNSURE || elseCompatible == ThreeState.UNSURE) {
                    return ThreeState.UNSURE;
                }
            } else if (expression2 instanceof PsiSwitchExpression) {
                Set states = PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)expression2).stream().map(expr -> MethodCandidateInfo.isPotentialCompatible(expr, formalType, method2)).collect(Collectors.toSet());
                if (states.contains((Object)ThreeState.NO)) {
                    return ThreeState.NO;
                }
                if (states.contains((Object)ThreeState.UNSURE)) {
                    return ThreeState.UNSURE;
                }
            }
        }
        return ThreeState.YES;
    }

    @NotNull
    public PsiSubstitutor getSiteSubstitutor() {
        PsiSubstitutor incompleteSubstitutor = super.getSubstitutor();
        if (this.myTypeArguments != null) {
            PsiMethod method2 = this.getElement();
            PsiTypeParameter[] typeParams = method2.getTypeParameters();
            for (int i = 0; i < this.myTypeArguments.length && i < typeParams.length; ++i) {
                incompleteSubstitutor = incompleteSubstitutor.put(typeParams[i], this.myTypeArguments[i]);
            }
        }
        PsiSubstitutor psiSubstitutor = incompleteSubstitutor;
        if (psiSubstitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(5);
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor getSubstitutorFromQualifier() {
        PsiSubstitutor psiSubstitutor = super.getSubstitutor();
        if (psiSubstitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(6);
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.getSubstitutor(true);
        if (psiSubstitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(7);
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor getSubstitutor(boolean includeReturnConstraint) {
        PsiSubstitutor substitutor2 = this.myCalcedSubstitutor;
        if (substitutor2 == null || !includeReturnConstraint && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) || MethodCandidateInfo.isOverloadCheck()) {
            PsiSubstitutor incompleteSubstitutor = super.getSubstitutor();
            PsiMethod method2 = this.getElement();
            if (this.myTypeArguments == null) {
                RecursionGuard.StackStamp stackStamp = RecursionManager.markStack();
                PsiSubstitutor inferredSubstitutor = this.inferTypeArguments(DefaultParameterTypeInferencePolicy.INSTANCE, includeReturnConstraint);
                if (MethodCandidateInfo.isOverloadCheck() || !includeReturnConstraint && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) || this.myArgumentList != null && PsiResolveHelper.ourGraphGuard.currentStack().contains(this.myArgumentList.getParent()) || !stackStamp.mayCacheNow()) {
                    PsiSubstitutor psiSubstitutor = inferredSubstitutor;
                    if (psiSubstitutor == null) {
                        MethodCandidateInfo.$$$reportNull$$$0(8);
                    }
                    return psiSubstitutor;
                }
                this.myCalcedSubstitutor = substitutor2 = inferredSubstitutor;
            } else {
                PsiTypeParameter[] typeParams = method2.getTypeParameters();
                if (this.isRawSubstitution()) {
                    PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory(method2.getProject()).createRawSubstitutor(this.mySubstitutor, typeParams);
                    if (psiSubstitutor == null) {
                        MethodCandidateInfo.$$$reportNull$$$0(9);
                    }
                    return psiSubstitutor;
                }
                for (int i = 0; i < this.myTypeArguments.length && i < typeParams.length; ++i) {
                    incompleteSubstitutor = incompleteSubstitutor.put(typeParams[i], this.myTypeArguments[i]);
                }
                this.myCalcedSubstitutor = substitutor2 = incompleteSubstitutor;
            }
        }
        PsiSubstitutor psiSubstitutor = substitutor2;
        if (psiSubstitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(10);
        }
        return psiSubstitutor;
    }

    public static boolean isOverloadCheck() {
        return !ourOverloadGuard.currentStack().isEmpty();
    }

    public static boolean isOverloadCheck(PsiElement argumentList2) {
        return ourOverloadGuard.currentStack().contains(argumentList2);
    }

    public boolean isTypeArgumentsApplicable() {
        return this.isTypeArgumentsApplicable(() -> this.getSubstitutor(false));
    }

    private boolean isTypeArgumentsApplicable(Computable<? extends PsiSubstitutor> computable) {
        PsiMethod psiMethod = this.getElement();
        PsiTypeParameter[] typeParams = psiMethod.getTypeParameters();
        if (this.myTypeArguments != null && typeParams.length != this.myTypeArguments.length && !PsiUtil.isLanguageLevel7OrHigher(psiMethod)) {
            return typeParams.length == 0 && JavaVersionService.getInstance().isAtLeast(psiMethod, JavaSdkVersion.JDK_1_7);
        }
        return GenericsUtil.isTypeArgumentsApplicable(typeParams, computable.compute(), this.getParent());
    }

    protected PsiElement getParent() {
        return this.myArgumentList != null ? this.myArgumentList.getParent() : null;
    }

    @Override
    public boolean isValidResult() {
        return super.isValidResult() && this.isApplicable();
    }

    @Override
    @NotNull
    public PsiMethod getElement() {
        PsiMethod psiMethod = (PsiMethod)super.getElement();
        if (psiMethod == null) {
            MethodCandidateInfo.$$$reportNull$$$0(11);
        }
        return psiMethod;
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull ParameterTypeInferencePolicy policy, boolean includeReturnConstraint) {
        if (policy == null) {
            MethodCandidateInfo.$$$reportNull$$$0(12);
        }
        PsiSubstitutor psiSubstitutor = this.inferTypeArguments(policy, this.myArgumentList instanceof PsiExpressionList ? ((PsiExpressionList)this.myArgumentList).getExpressions() : PsiExpression.EMPTY_ARRAY, includeReturnConstraint);
        if (psiSubstitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(13);
        }
        return psiSubstitutor;
    }

    public PsiSubstitutor inferSubstitutorFromArgs(@NotNull ParameterTypeInferencePolicy policy, PsiExpression[] arguments2) {
        if (policy == null) {
            MethodCandidateInfo.$$$reportNull$$$0(14);
        }
        if (this.myTypeArguments == null) {
            return this.inferTypeArguments(policy, arguments2, true);
        }
        return this.getSiteSubstitutor();
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull ParameterTypeInferencePolicy policy, PsiExpression @NotNull [] arguments2, boolean includeReturnConstraint) {
        if (policy == null) {
            MethodCandidateInfo.$$$reportNull$$$0(15);
        }
        if (arguments2 == null) {
            MethodCandidateInfo.$$$reportNull$$$0(16);
        }
        Computable<PsiSubstitutor> computable = () -> {
            PsiMethod method2 = this.getElement();
            PsiTypeParameter[] typeParameters2 = method2.getTypeParameters();
            if (this.isRawSubstitution()) {
                return JavaPsiFacade.getElementFactory(method2.getProject()).createRawSubstitutor(this.mySubstitutor, typeParameters2);
            }
            PsiElement parent2 = this.getParent();
            if (parent2 == null) {
                return PsiSubstitutor.EMPTY;
            }
            Project project = method2.getProject();
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance(project);
            return javaPsiFacade.getResolveHelper().inferTypeArguments(typeParameters2, method2.getParameterList().getParameters(), arguments2, this, parent2, policy, this.myLanguageLevel);
        };
        if (!includeReturnConstraint) {
            PsiSubstitutor psiSubstitutor = this.myArgumentList == null ? PsiSubstitutor.EMPTY : Objects.requireNonNull(ourOverloadGuard.doPreventingRecursion(this.myArgumentList, false, computable));
            if (psiSubstitutor == null) {
                MethodCandidateInfo.$$$reportNull$$$0(17);
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = computable.compute();
        if (psiSubstitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(18);
        }
        return psiSubstitutor;
    }

    public boolean isRawSubstitution() {
        PsiClass containingClass;
        PsiMethod method2 = this.getElement();
        return !method2.hasModifierProperty("static") && (containingClass = method2.getContainingClass()) != null && PsiUtil.isRawSubstitutor(containingClass, this.mySubstitutor);
    }

    public boolean isInferencePossible() {
        return this.myArgumentList != null && this.myArgumentList.isValid();
    }

    public PsiType @Nullable [] getArgumentTypes() {
        return this.myArgumentTypes;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.isVarargs() == ((MethodCandidateInfo)o).isVarargs();
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + (this.isVarargs() ? 1 : 0);
    }

    public void setApplicabilityError(@NotNull String applicabilityError) {
        boolean overloadCheck;
        if (applicabilityError == null) {
            MethodCandidateInfo.$$$reportNull$$$0(19);
        }
        if (!(overloadCheck = MethodCandidateInfo.isOverloadCheck())) {
            this.myInferenceError = applicabilityError;
        }
        if (this.myArgumentList == null ? overloadCheck : MethodCandidateInfo.isOverloadCheck(this.myArgumentList)) {
            this.markNotApplicable();
        }
    }

    public void markNotApplicable() {
        this.myApplicabilityError = true;
    }

    public String getInferenceErrorMessage() {
        this.getSubstitutor();
        return this.myInferenceError;
    }

    public String getInferenceErrorMessageAssumeAlreadyComputed() {
        return this.myInferenceError;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 18: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/infos/MethodCandidateInfo";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicabilityError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/infos/MethodCandidateInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiteSubstitutor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutorFromQualifier";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 13: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 18: {
                break;
            }
            case 12: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeArguments";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "inferSubstitutorFromArgs";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setApplicabilityError";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static @interface ApplicabilityLevelConstant {
    }

    public static final class ApplicabilityLevel {
        public static final int NOT_APPLICABLE = 1;
        public static final int VARARGS = 2;
        public static final int FIXED_ARITY = 3;
    }
}

