/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stub;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaDocumentedElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiMemberStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiMethodImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.StubbedSpine;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;

public final class JavaStubImplUtil {
    public static int getMethodStubIndex(PsiMethod method2) {
        if (!(method2 instanceof PsiMethodImpl)) {
            return -1;
        }
        PsiFileImpl file2 = (PsiFileImpl)method2.getContainingFile();
        StubbedSpine spine = file2.getStubbedSpine();
        int result2 = 0;
        for (int i = 0; i < spine.getStubCount(); ++i) {
            if (spine.getStubType(i) != JavaElementType.METHOD) continue;
            if (spine.getStubPsi(i) == method2) {
                return result2;
            }
            ++result2;
        }
        return -1;
    }

    public static <T extends PsiMember & PsiJavaDocumentedElement> boolean isMemberDeprecated(@NotNull T member2, @Nullable PsiMemberStub<?> stub2) {
        if (member2 == null) {
            JavaStubImplUtil.$$$reportNull$$$0(0);
        }
        if (stub2 != null) {
            return stub2.isDeprecated() || stub2.hasDeprecatedAnnotation() && PsiImplUtil.isDeprecatedByAnnotation(member2);
        }
        return PsiImplUtil.isDeprecatedByDocTag(member2) || PsiImplUtil.isDeprecatedByAnnotation(member2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/kotlin/com/intellij/psi/stub/JavaStubImplUtil", "isMemberDeprecated"));
    }
}

