/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.LowMemoryWatcher;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.CompressionUtil;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.containers.SLRUMap;
import org.jetbrains.kotlin.com.intellij.util.io.DataInputOutputUtil;
import org.jetbrains.kotlin.com.intellij.util.io.DataOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.FileChunkKey;
import org.jetbrains.kotlin.com.intellij.util.io.LimitedInputStream;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongArrayList;

public class CompressedAppendableFile {
    private final Path myBaseFile;
    private byte[] myNextChunkBuffer;
    private int myBufferPosition;
    private boolean myDirty;
    private short[] myChunkLengthTable;
    private int myChunkTableLength;
    private long[] myChunkOffsetTable;
    private static final boolean doDebug = SystemProperties.getBooleanProperty("idea.compressed.file.self.check", false);
    private final LongArrayList myCompressedChunksFileOffsets = doDebug ? new LongArrayList() : null;
    public static final int PAGE_LENGTH = SystemProperties.getIntProperty("idea.compressed.file.page.length", 32768);
    private long myFileLength;
    private long myUncompressedFileLength = -1L;
    private final int myAppendBufferLength;
    private static int ourFilesCount;
    private final int myCount = ourFilesCount++;

    public CompressedAppendableFile(Path file2) throws IOException {
        this(file2, 32768);
    }

    private CompressedAppendableFile(Path file2, int bufferSize) throws IOException {
        this.myBaseFile = file2;
        this.myAppendBufferLength = bufferSize;
        assert (bufferSize <= 65535);
        Path parent2 = this.getChunksFile().getParent();
        if (!Files.exists(parent2, new LinkOption[0])) {
            Files.createDirectories(parent2, new FileAttribute[0]);
        }
    }

    @NotNull
    public synchronized DataInputStream getStream(long addr) throws IOException {
        this.initChunkLengthTable();
        this.loadAppendBuffer();
        return new DataInputStream(new SegmentedChunkInputStream(addr, this.myChunkTableLength, this.myNextChunkBuffer, this.myBufferPosition));
    }

    @NotNull
    protected Path getChunkLengthFile() {
        Path path2 = this.myBaseFile.resolveSibling(this.myBaseFile.getFileName() + ".s");
        if (path2 == null) {
            CompressedAppendableFile.$$$reportNull$$$0(0);
        }
        return path2;
    }

    private synchronized void initChunkLengthTable() throws IOException {
        if (this.myChunkLengthTable != null) {
            return;
        }
        Path chunkLengthFile = this.getChunkLengthFile();
        if (Files.exists(chunkLengthFile, new LinkOption[0])) {
            try (DataInputStream chunkLengthStream = new DataInputStream(new BufferedInputStream(new LimitedInputStream(Files.newInputStream(chunkLengthFile, new OpenOption[0]), (int)Files.size(chunkLengthFile)){

                @Override
                public int available() {
                    return this.remainingLimit();
                }
            }, 32768));){
                short[] chunkLengthTable = new short[(int)(Files.size(chunkLengthFile) / 2L)];
                int chunkLengthTableLength = 0;
                long o = 0L;
                while (chunkLengthStream.available() != 0) {
                    int chunkLength = DataInputOutputUtil.readINT(chunkLengthStream);
                    o += (long)chunkLength;
                    if (chunkLengthTableLength == chunkLengthTable.length) {
                        chunkLengthTable = CompressedAppendableFile.reallocShortTable(chunkLengthTable);
                    }
                    chunkLengthTable[chunkLengthTableLength++] = (short)chunkLength;
                    if (!doDebug) continue;
                    this.myCompressedChunksFileOffsets.add(o);
                }
                this.myChunkLengthTable = chunkLengthTable;
                this.myChunkTableLength = chunkLengthTableLength;
                if (this.myChunkTableLength >= 32) {
                    int i;
                    long[] chunkOffsetTable = new long[this.myChunkTableLength / 32];
                    long offset2 = 0L;
                    for (i = 0; i < chunkOffsetTable.length; ++i) {
                        int start2 = i * 32;
                        for (int j = 0; j < 32; ++j) {
                            offset2 += (long)(chunkLengthTable[start2 + j] & 0xFFFF);
                        }
                        chunkOffsetTable[i] = offset2;
                    }
                    this.myChunkOffsetTable = chunkOffsetTable;
                    if (doDebug) {
                        for (i = 0; i < chunkLengthTableLength; ++i) {
                            this.calcOffsetOfPage(i);
                        }
                    }
                } else {
                    this.myChunkOffsetTable = ArrayUtil.EMPTY_LONG_ARRAY;
                }
                this.myFileLength = this.calcOffsetOfPage(this.myChunkTableLength - 1);
            }
        } else {
            this.myChunkLengthTable = ArrayUtilRt.EMPTY_SHORT_ARRAY;
            this.myChunkTableLength = 0;
            this.myChunkOffsetTable = ArrayUtil.EMPTY_LONG_ARRAY;
            this.myFileLength = 0L;
        }
        if (this.myUncompressedFileLength == -1L) {
            long tempFileLength = Files.exists(this.getIncompleteChunkFile(), new LinkOption[0]) ? Files.size(this.getIncompleteChunkFile()) : 0L;
            this.myUncompressedFileLength = (long)this.myChunkTableLength * (long)this.myAppendBufferLength + tempFileLength;
            if (this.myUncompressedFileLength != this.myFileLength + tempFileLength && CompressionUtil.DUMP_COMPRESSION_STATS) {
                System.out.println(this.myUncompressedFileLength + "->" + (this.myFileLength + tempFileLength) + " for " + this.myBaseFile);
            }
        }
    }

    /*
     * Loose catch block
     */
    private synchronized byte @NotNull [] loadChunk(int chunkNumber) throws IOException {
        block16: {
            DataInputStream keysStream;
            block13: {
                byte[] byArray;
                block15: {
                    block14: {
                        if (this.myChunkLengthTable == null) {
                            this.initChunkLengthTable();
                        }
                        assert (chunkNumber < this.myChunkTableLength);
                        keysStream = this.getChunkStream(chunkNumber);
                        if (keysStream.available() <= 0) break block13;
                        byte[] decompressedBytes = this.decompress(keysStream);
                        if (decompressedBytes.length != this.myAppendBufferLength) assert (false);
                        byArray = decompressedBytes;
                        if (keysStream == null) break block14;
                        keysStream.close();
                    }
                    if (byArray != null) break block15;
                    CompressedAppendableFile.$$$reportNull$$$0(1);
                }
                return byArray;
            }
            try {
                block17: {
                    if (keysStream != null) {
                        keysStream.close();
                    }
                    break block17;
                    {
                        catch (Throwable throwable) {
                            if (keysStream != null) {
                                try {
                                    keysStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                }
                assert (false) : "data corruption detected:" + chunkNumber + "," + this.myChunkTableLength;
                if (ArrayUtilRt.EMPTY_BYTE_ARRAY != null) break block16;
            }
            catch (AssertionError | RuntimeException e) {
                throw new IOException((Throwable)e);
            }
            CompressedAppendableFile.$$$reportNull$$$0(2);
        }
        return ArrayUtilRt.EMPTY_BYTE_ARRAY;
    }

    @NotNull
    private DataInputStream getChunkStream(int pageNumber) throws IOException {
        int limit;
        long pageStartOffset;
        long pageEndOffset;
        assert (this.myFileLength != 0L);
        long l = pageEndOffset = pageNumber < this.myChunkTableLength ? this.calcOffsetOfPage(pageNumber) : this.myFileLength;
        if (pageNumber > 0) {
            pageStartOffset = this.calcOffsetOfPage(pageNumber - 1);
            limit = (int)(pageEndOffset - pageStartOffset);
        } else {
            pageStartOffset = 0L;
            limit = (int)pageEndOffset;
        }
        return new DataInputStream(this.getChunkInputStream(pageStartOffset, limit));
    }

    private long calcOffsetOfPage(int pageNumber) {
        int calculatedOffset = (pageNumber + 1) / 32;
        long offset2 = calculatedOffset > 0 ? this.myChunkOffsetTable[calculatedOffset - 1] : 0L;
        int baseOffset = calculatedOffset * 32;
        int len = (pageNumber + 1) % 32;
        for (int index2 = 0; index2 < len; ++index2) {
            offset2 += (long)(this.myChunkLengthTable[baseOffset + index2] & 0xFFFF);
        }
        if (doDebug) assert (this.myCompressedChunksFileOffsets.get(pageNumber) == offset2);
        return offset2;
    }

    @NotNull
    protected InputStream getChunkInputStream(long offset2, int pageSize) throws IOException {
        InputStream in = Files.newInputStream(this.getChunksFile(), new OpenOption[0]);
        if (offset2 > 0L) {
            in.skip(offset2);
        }
        return new BufferedInputStream(new LimitedInputStream(in, pageSize){

            @Override
            public int available() {
                return this.remainingLimit();
            }
        }, pageSize);
    }

    public synchronized void append(byte[] buffer, int offset2, int size2) throws IOException {
        int bytesToWriteInTheBuffer;
        int newBufferSize;
        if (size2 == 0) {
            return;
        }
        if (this.myNextChunkBuffer == null) {
            this.loadAppendBuffer();
        }
        if (this.myNextChunkBuffer.length != this.myAppendBufferLength && this.myBufferPosition + size2 >= this.myNextChunkBuffer.length && (newBufferSize = this.calcBufferSize(this.myBufferPosition + size2)) != this.myNextChunkBuffer.length) {
            this.myNextChunkBuffer = Arrays.copyOf(this.myNextChunkBuffer, newBufferSize);
        }
        int bufferPosition = offset2;
        for (int sizeToWrite = size2; sizeToWrite > 0; sizeToWrite -= bytesToWriteInTheBuffer) {
            bytesToWriteInTheBuffer = Math.min(this.myNextChunkBuffer.length - this.myBufferPosition, sizeToWrite);
            System.arraycopy(buffer, bufferPosition, this.myNextChunkBuffer, this.myBufferPosition, bytesToWriteInTheBuffer);
            this.myBufferPosition += bytesToWriteInTheBuffer;
            bufferPosition += bytesToWriteInTheBuffer;
            this.saveNextChunkIfNeeded();
        }
        if (this.myUncompressedFileLength == -1L) {
            this.length();
        }
        this.myUncompressedFileLength += (long)size2;
        this.myDirty = true;
    }

    private synchronized void loadAppendBuffer() throws IOException {
        if (this.myNextChunkBuffer != null) {
            return;
        }
        Path tempAppendFile = this.getIncompleteChunkFile();
        if (Files.exists(tempAppendFile, new LinkOption[0])) {
            this.myBufferPosition = (int)Files.size(tempAppendFile);
            this.myNextChunkBuffer = new byte[this.calcBufferSize(this.myBufferPosition)];
            try (InputStream stream = Files.newInputStream(tempAppendFile, new OpenOption[0]);){
                stream.read(this.myNextChunkBuffer, 0, this.myBufferPosition);
            }
        } else {
            this.myBufferPosition = 0;
            this.myNextChunkBuffer = new byte[1024];
        }
    }

    private int calcBufferSize(int position) {
        return Math.min(this.myAppendBufferLength, Integer.highestOneBit(Math.max(1023, position)) << 1);
    }

    private void saveNextChunkIfNeeded() throws IOException {
        if (this.myBufferPosition == this.myNextChunkBuffer.length) {
            BufferExposingByteArrayOutputStream compressedOut = new BufferExposingByteArrayOutputStream();
            DataOutputStream compressedDataOut = new DataOutputStream(compressedOut);
            this.compress(compressedDataOut, this.myNextChunkBuffer);
            compressedDataOut.close();
            assert (compressedDataOut.size() <= 65535);
            this.saveChunk(compressedOut);
            this.myBufferPosition = 0;
            this.initChunkLengthTable();
            this.myFileLength += (long)compressedOut.size();
            if (doDebug) {
                this.myCompressedChunksFileOffsets.add(this.myFileLength);
            }
            if (this.myChunkLengthTable.length == this.myChunkTableLength) {
                this.myChunkLengthTable = CompressedAppendableFile.reallocShortTable(this.myChunkLengthTable);
            }
            this.myChunkLengthTable[this.myChunkTableLength++] = (short)compressedOut.size();
            if (this.myChunkTableLength / 32 > this.myChunkOffsetTable.length) {
                long[] newChunkOffsetTable = new long[this.myChunkOffsetTable.length + 1];
                System.arraycopy(this.myChunkOffsetTable, 0, newChunkOffsetTable, 0, this.myChunkOffsetTable.length);
                newChunkOffsetTable[this.myChunkOffsetTable.length] = this.myFileLength;
                this.myChunkOffsetTable = newChunkOffsetTable;
            }
            byte[] bytes = new byte[this.myAppendBufferLength];
            System.arraycopy(this.myNextChunkBuffer, 0, bytes, 0, this.myAppendBufferLength);
            FileChunkReadCache.ourDecompressedCache.put(this, this.myChunkTableLength - 1, bytes);
        }
    }

    private static short @NotNull [] reallocShortTable(short[] table) {
        short[] sArray = ArrayUtil.realloc(table, Math.max(table.length * 8 / 5, table.length + 1));
        if (sArray == null) {
            CompressedAppendableFile.$$$reportNull$$$0(3);
        }
        return sArray;
    }

    protected int compress(DataOutputStream compressedDataOut, byte[] buffer) throws IOException {
        return CompressionUtil.writeCompressedWithoutOriginalBufferLength(compressedDataOut, buffer, this.myAppendBufferLength);
    }

    protected byte @NotNull [] decompress(DataInputStream keysStream) throws IOException {
        byte[] byArray = CompressionUtil.readCompressedWithoutOriginalBufferLength(keysStream, this.myAppendBufferLength);
        if (byArray == null) {
            CompressedAppendableFile.$$$reportNull$$$0(4);
        }
        return byArray;
    }

    private void saveChunk(BufferExposingByteArrayOutputStream compressedChunk) throws IOException {
        try (DataOutputStream stream = this.getChunkAppendStream();){
            stream.write(compressedChunk.getInternalBuffer(), 0, compressedChunk.size());
        }
        try (DataOutputStream chunkLengthStream = this.getChunkLengthAppendStream();){
            DataInputOutputUtil.writeINT(chunkLengthStream, compressedChunk.size());
        }
    }

    @NotNull
    protected DataOutputStream getChunkLengthAppendStream() throws IOException {
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.getChunkLengthFile().toFile(), true)));
    }

    @NotNull
    protected DataOutputStream getChunkAppendStream() throws IOException {
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.getChunksFile().toFile(), true)));
    }

    @NotNull
    protected Path getChunksFile() {
        Path path2 = this.myBaseFile.resolveSibling(this.myBaseFile.getFileName() + ".a");
        if (path2 == null) {
            CompressedAppendableFile.$$$reportNull$$$0(5);
        }
        return path2;
    }

    private void saveIncompleteChunk() {
        if (this.myNextChunkBuffer != null && this.myDirty) {
            block14: {
                Path incompleteChunkFile = this.getIncompleteChunkFile();
                try {
                    this.saveNextChunkIfNeeded();
                    if (this.myBufferPosition != 0) {
                        try (BufferedOutputStream stream = new BufferedOutputStream(Files.newOutputStream(incompleteChunkFile, StandardOpenOption.CREATE));){
                            stream.write(this.myNextChunkBuffer, 0, this.myBufferPosition);
                            break block14;
                        }
                    }
                    if (Files.exists(incompleteChunkFile, new LinkOption[0])) {
                        Files.delete(incompleteChunkFile);
                    }
                }
                catch (NoSuchFileException ex) {
                    Path parentFile = incompleteChunkFile.getParent();
                    if (!Files.exists(parentFile, new LinkOption[0])) {
                        try {
                            Files.createDirectories(parentFile, new FileAttribute[0]);
                            this.saveIncompleteChunk();
                            return;
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to write: " + incompleteChunkFile, ex);
                        }
                    }
                    throw new RuntimeException(ex);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.myDirty = false;
        }
    }

    @NotNull
    private Path getIncompleteChunkFile() {
        Path path2 = this.myBaseFile.resolveSibling(this.myBaseFile.getFileName() + ".at");
        if (path2 == null) {
            CompressedAppendableFile.$$$reportNull$$$0(6);
        }
        return path2;
    }

    public synchronized void force() {
        this.saveIncompleteChunk();
    }

    public synchronized void dispose() {
        this.force();
        FileChunkReadCache.ourDecompressedCache.clear(this);
    }

    public synchronized long length() {
        if (this.myUncompressedFileLength == -1L && this.myChunkLengthTable == null) {
            try {
                this.initChunkLengthTable();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.myUncompressedFileLength;
    }

    public int hashCode() {
        return this.myCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/kotlin/com/intellij/util/io/CompressedAppendableFile";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChunkLengthFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadChunk";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "reallocShortTable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "decompress";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChunksFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncompleteChunkFile";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class SegmentedChunkInputStream
    extends InputStream {
        private final long myAddr;
        private final int myChunkLengthTableSnapshotLength;
        private final byte[] myNextChunkBufferSnapshot;
        private final int myBufferPositionSnapshot;
        private InputStream bytesFromCompressedBlock;
        private InputStream bytesFromTempAppendBlock;
        private int myCurrentPageNumber;
        private int myPageOffset;

        SegmentedChunkInputStream(long addr, int chunkLengthTableSnapshotLength, byte[] tableRef, int position) {
            this.myAddr = addr;
            this.myChunkLengthTableSnapshotLength = chunkLengthTableSnapshotLength;
            this.myNextChunkBufferSnapshot = tableRef;
            this.myBufferPositionSnapshot = position;
            this.myCurrentPageNumber = (int)(this.myAddr / (long)CompressedAppendableFile.this.myAppendBufferLength);
            this.myPageOffset = (int)(this.myAddr % (long)CompressedAppendableFile.this.myAppendBufferLength);
        }

        @Override
        public int read(byte @NotNull [] b, int off, int len) throws IOException {
            if (b == null) {
                SegmentedChunkInputStream.$$$reportNull$$$0(0);
            }
            if (this.bytesFromCompressedBlock == null) {
                byte[] decompressedBytes = this.myCurrentPageNumber < this.myChunkLengthTableSnapshotLength ? FileChunkReadCache.ourDecompressedCache.get(CompressedAppendableFile.this, this.myCurrentPageNumber) : ArrayUtilRt.EMPTY_BYTE_ARRAY;
                this.bytesFromCompressedBlock = new ByteArrayInputStream(decompressedBytes, this.myPageOffset, decompressedBytes.length);
            }
            int readBytesCount = 0;
            if (this.bytesFromCompressedBlock.available() > 0) {
                readBytesCount = this.bytesFromCompressedBlock.read(b, off, len);
                this.myPageOffset += readBytesCount;
                if (this.myPageOffset == CompressedAppendableFile.this.myAppendBufferLength) {
                    ++this.myCurrentPageNumber;
                    this.myPageOffset = 0;
                }
                if (readBytesCount == len) {
                    return readBytesCount;
                }
            }
            while (this.myCurrentPageNumber < this.myChunkLengthTableSnapshotLength) {
                byte[] decompressedBytes = FileChunkReadCache.ourDecompressedCache.get(CompressedAppendableFile.this, this.myCurrentPageNumber);
                this.bytesFromCompressedBlock = new ByteArrayInputStream(decompressedBytes, 0, decompressedBytes.length);
                int read2 = this.bytesFromCompressedBlock.read(b, off + readBytesCount, len - readBytesCount);
                this.myPageOffset += read2;
                if (this.myPageOffset == CompressedAppendableFile.this.myAppendBufferLength) {
                    ++this.myCurrentPageNumber;
                    this.myPageOffset = 0;
                }
                if ((readBytesCount += read2) != len) continue;
                return readBytesCount;
            }
            if (this.bytesFromTempAppendBlock == null) {
                this.bytesFromTempAppendBlock = new ByteArrayInputStream(this.myNextChunkBufferSnapshot, this.myPageOffset, this.myBufferPositionSnapshot);
            }
            return readBytesCount + this.bytesFromTempAppendBlock.read(b, off + readBytesCount, len - readBytesCount);
        }

        @Override
        public int read() throws IOException {
            byte[] buf = new byte[]{0};
            int read2 = this.read(buf);
            if (read2 == -1) {
                return -1;
            }
            return buf[0] & 0xFF;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/kotlin/com/intellij/util/io/CompressedAppendableFile$SegmentedChunkInputStream", "read"));
        }
    }

    private static class FileChunkReadCache
    extends SLRUMap<FileChunkKey<CompressedAppendableFile>, byte[]> {
        private static final FileChunkReadCache ourDecompressedCache = new FileChunkReadCache();
        private final FileChunkKey<CompressedAppendableFile> myKey = new FileChunkKey<Object>(null, 0L);

        FileChunkReadCache() {
            super(64, 64);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        byte @NotNull [] get(CompressedAppendableFile file2, int page) throws IOException {
            FileChunkReadCache fileChunkReadCache = this;
            // MONITORENTER : fileChunkReadCache
            this.myKey.setup(file2, page);
            byte[] bytes = (byte[])this.get(this.myKey);
            if (bytes != null) {
                // MONITOREXIT : fileChunkReadCache
                if (bytes != null) return bytes;
                FileChunkReadCache.$$$reportNull$$$0(0);
                return bytes;
            }
            // MONITOREXIT : fileChunkReadCache
            bytes = file2.loadChunk(page);
            fileChunkReadCache = this;
            // MONITORENTER : fileChunkReadCache
            this.put(file2, page, bytes);
            // MONITOREXIT : fileChunkReadCache
            if (bytes != null) return bytes;
            FileChunkReadCache.$$$reportNull$$$0(1);
            return bytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(CompressedAppendableFile file2, long page, byte[] bytes) {
            FileChunkReadCache fileChunkReadCache = this;
            synchronized (fileChunkReadCache) {
                this.myKey.setup(file2, page);
                this.put(this.myKey, bytes);
            }
        }

        void clear(CompressedAppendableFile file2) {
            HashSet toClean = new HashSet();
            this.iterateKeys(key -> {
                if (key.getOwner() == file2) {
                    toClean.add(key);
                }
            });
            for (FileChunkKey key2 : toClean) {
                this.remove(key2);
            }
        }

        static {
            LowMemoryWatcher lowMemoryWatcher = LowMemoryWatcher.register(() -> {
                FileChunkReadCache fileChunkReadCache = ourDecompressedCache;
                synchronized (fileChunkReadCache) {
                    ourDecompressedCache.clear();
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/io/CompressedAppendableFile$FileChunkReadCache", "get"));
        }
    }
}

