/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.LowMemoryWatcher;
import org.jetbrains.kotlin.com.intellij.openapi.util.ThreadLocalCachedValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.CommonProcessors;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.containers.LimitedPool;
import org.jetbrains.kotlin.com.intellij.util.containers.SLRUCache;
import org.jetbrains.kotlin.com.intellij.util.io.AppendablePersistentMap;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;
import org.jetbrains.kotlin.com.intellij.util.io.DataOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.IOStatistics;
import org.jetbrains.kotlin.com.intellij.util.io.IOUtil;
import org.jetbrains.kotlin.com.intellij.util.io.InlineKeyDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.IntInlineKeyDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.KeyDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentBTreeEnumerator;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentEnumeratorBase;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentEnumeratorDelegate;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentHashMapValueStorage;
import org.jetbrains.kotlin.com.intellij.util.io.StorageLockContext;
import org.jetbrains.kotlin.com.intellij.util.io.UnsyncByteArrayInputStream;

public class PersistentHashMap<Key, Value>
implements AppendablePersistentMap<Key, Value> {
    private static final Logger LOG = Logger.getInstance(PersistentHashMap.class);
    private static final boolean myDoTrace = SystemProperties.getBooleanProperty("idea.trace.persistent.map", false);
    private static final int DEAD_KEY_NUMBER_MASK = -1;
    private final Path myStorageFile;
    private final boolean myIsReadOnly;
    private final KeyDescriptor<Key> myKeyDescriptor;
    private PersistentHashMapValueStorage myValueStorage;
    private final SLRUCache<Key, BufferExposingByteArrayOutputStream> myAppendCache;
    private final LowMemoryWatcher myAppendCacheFlusher;
    private final DataExternalizer<Value> myValueExternalizer;
    private static final long NULL_ADDR = 0L;
    private static final int INITIAL_INDEX_SIZE;
    @NonNls
    static final String DATA_FILE_EXTENSION = ".values";
    private long myLiveAndGarbageKeysCounter;
    private int myReadCompactionGarbageSize;
    private static final long LIVE_KEY_MASK = 0x100000000L;
    private static final long USED_LONG_VALUE_MASK = 0x4000000000000000L;
    private static final int POSITIVE_VALUE_SHIFT = 1;
    private final int myParentValueRefOffset;
    private final ThreadLocal<byte @NotNull []> myRecordBuffer;
    private final ThreadLocal<byte @NotNull []> mySmallRecordBuffer;
    private final boolean myIntMapping;
    private final boolean myDirectlyStoreLongFileOffsetMode;
    private final boolean myCanReEnumerate;
    private int myLargeIndexWatermarkId;
    private boolean myIntAddressForNewRecord;
    private static final boolean doHardConsistencyChecks = false;
    private final PersistentEnumeratorBase<Key> myEnumerator;
    private final LimitedPool<BufferExposingByteArrayOutputStream> myStreamPool;
    private static final int MAX_RECYCLED_BUFFER_SIZE = 4096;
    private static final ThreadLocalCachedValue<AppendStream> ourFlyweightAppenderStream;
    private int smallKeys;
    private int largeKeys;
    private int transformedKeys;
    private int requests;

    @TestOnly
    public boolean isCorrupted() {
        return this.myEnumerator.isCorrupted();
    }

    private boolean canUseIntAddressForNewRecord(long size2) {
        return this.myCanReEnumerate && size2 + 1L < Integer.MAX_VALUE;
    }

    public PersistentHashMap(@NotNull File file2, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer) throws IOException {
        if (file2 == null) {
            PersistentHashMap.$$$reportNull$$$0(0);
        }
        if (keyDescriptor == null) {
            PersistentHashMap.$$$reportNull$$$0(1);
        }
        if (valueExternalizer == null) {
            PersistentHashMap.$$$reportNull$$$0(2);
        }
        this(file2.toPath(), keyDescriptor, valueExternalizer, INITIAL_INDEX_SIZE);
    }

    public PersistentHashMap(@NotNull Path file2, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer) throws IOException {
        if (file2 == null) {
            PersistentHashMap.$$$reportNull$$$0(3);
        }
        if (keyDescriptor == null) {
            PersistentHashMap.$$$reportNull$$$0(4);
        }
        if (valueExternalizer == null) {
            PersistentHashMap.$$$reportNull$$$0(5);
        }
        this(file2, keyDescriptor, valueExternalizer, INITIAL_INDEX_SIZE);
    }

    public PersistentHashMap(@NotNull Path file2, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int initialSize) throws IOException {
        if (file2 == null) {
            PersistentHashMap.$$$reportNull$$$0(6);
        }
        if (keyDescriptor == null) {
            PersistentHashMap.$$$reportNull$$$0(7);
        }
        if (valueExternalizer == null) {
            PersistentHashMap.$$$reportNull$$$0(8);
        }
        this(file2, keyDescriptor, valueExternalizer, initialSize, 0);
    }

    public PersistentHashMap(@NotNull Path file2, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int initialSize, int version2) throws IOException {
        if (file2 == null) {
            PersistentHashMap.$$$reportNull$$$0(9);
        }
        if (keyDescriptor == null) {
            PersistentHashMap.$$$reportNull$$$0(10);
        }
        if (valueExternalizer == null) {
            PersistentHashMap.$$$reportNull$$$0(11);
        }
        this(file2, keyDescriptor, valueExternalizer, initialSize, version2, null);
    }

    public PersistentHashMap(@NotNull Path file2, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int initialSize, int version2, @Nullable StorageLockContext lockContext) throws IOException {
        if (file2 == null) {
            PersistentHashMap.$$$reportNull$$$0(12);
        }
        if (keyDescriptor == null) {
            PersistentHashMap.$$$reportNull$$$0(13);
        }
        if (valueExternalizer == null) {
            PersistentHashMap.$$$reportNull$$$0(14);
        }
        this(file2, keyDescriptor, valueExternalizer, initialSize, version2, lockContext, PersistentHashMapValueStorage.CreationTimeOptions.threadLocalOptions());
    }

    private PersistentHashMap(@NotNull Path file2, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int initialSize, int version2, @Nullable StorageLockContext lockContext, @NotNull PersistentHashMapValueStorage.CreationTimeOptions options2) throws IOException {
        if (file2 == null) {
            PersistentHashMap.$$$reportNull$$$0(15);
        }
        if (keyDescriptor == null) {
            PersistentHashMap.$$$reportNull$$$0(16);
        }
        if (valueExternalizer == null) {
            PersistentHashMap.$$$reportNull$$$0(17);
        }
        if (options2 == null) {
            PersistentHashMap.$$$reportNull$$$0(18);
        }
        this.myStreamPool = new LimitedPool<BufferExposingByteArrayOutputStream>(10, new LimitedPool.ObjectFactory<BufferExposingByteArrayOutputStream>(){

            @Override
            @NotNull
            public BufferExposingByteArrayOutputStream create() {
                return new BufferExposingByteArrayOutputStream();
            }

            @Override
            public void cleanup(@NotNull BufferExposingByteArrayOutputStream appendStream) {
                if (appendStream == null) {
                    1.$$$reportNull$$$0(0);
                }
                appendStream.reset();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appendStream", "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMap$1", "cleanup"));
            }
        });
        this.myIsReadOnly = this.isReadOnly();
        if (this.myIsReadOnly) {
            options2 = options2.setReadOnly();
        }
        this.myEnumerator = PersistentEnumeratorDelegate.createDefaultEnumerator(PersistentHashMap.checkDataFiles(file2), keyDescriptor, initialSize, lockContext, PersistentHashMap.modifyVersionDependingOnOptions(version2, options2));
        this.myStorageFile = file2;
        this.myKeyDescriptor = keyDescriptor;
        final @NotNull PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase<?>> recordHandler = this.myEnumerator.getRecordHandler();
        this.myParentValueRefOffset = recordHandler.getRecordBuffer(this.myEnumerator).length;
        this.myIntMapping = valueExternalizer instanceof IntInlineKeyDescriptor && this.wantNonNegativeIntegralValues();
        this.myDirectlyStoreLongFileOffsetMode = keyDescriptor instanceof InlineKeyDescriptor && this.myEnumerator instanceof PersistentBTreeEnumerator;
        this.myRecordBuffer = ThreadLocal.withInitial(() -> this.myDirectlyStoreLongFileOffsetMode ? ArrayUtilRt.EMPTY_BYTE_ARRAY : new byte[this.myParentValueRefOffset + 8]);
        this.mySmallRecordBuffer = ThreadLocal.withInitial(() -> this.myDirectlyStoreLongFileOffsetMode ? ArrayUtilRt.EMPTY_BYTE_ARRAY : new byte[this.myParentValueRefOffset + 4]);
        this.myEnumerator.setRecordHandler(new PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase<?>>(){

            @Override
            int recordWriteOffset(PersistentEnumeratorBase<?> enumerator, byte[] buf) {
                return recordHandler.recordWriteOffset(enumerator, buf);
            }

            @Override
            byte @NotNull [] getRecordBuffer(PersistentEnumeratorBase<?> enumerator) {
                byte[] byArray = PersistentHashMap.this.myIntAddressForNewRecord ? (byte[])PersistentHashMap.this.mySmallRecordBuffer.get() : (byte[])PersistentHashMap.this.myRecordBuffer.get();
                if (byArray == null) {
                    2.$$$reportNull$$$0(0);
                }
                return byArray;
            }

            @Override
            void setupRecord(PersistentEnumeratorBase enumerator, int hashCode2, int dataOffset, byte @NotNull [] buf) {
                if (buf == null) {
                    2.$$$reportNull$$$0(1);
                }
                recordHandler.setupRecord(enumerator, hashCode2, dataOffset, buf);
                for (int i = PersistentHashMap.this.myParentValueRefOffset; i < buf.length; ++i) {
                    buf[i] = 0;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMap$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "buf";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRecordBuffer";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMap$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "setupRecord";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.myEnumerator.setMarkCleanCallback(new Flushable(){

            @Override
            public void flush() {
                PersistentHashMap.this.myEnumerator.putMetaData(PersistentHashMap.this.myLiveAndGarbageKeysCounter);
                PersistentHashMap.this.myEnumerator.putMetaData2((long)PersistentHashMap.this.myLargeIndexWatermarkId | (long)PersistentHashMap.this.myReadCompactionGarbageSize << 32);
            }
        });
        if (myDoTrace) {
            LOG.info("Opened " + file2);
        }
        try {
            this.myValueExternalizer = valueExternalizer;
            this.myValueStorage = this.myIntMapping ? null : new PersistentHashMapValueStorage(PersistentHashMap.getDataFile(file2), options2);
            this.myAppendCache = this.myIntMapping ? null : this.createAppendCache(keyDescriptor);
            this.myAppendCacheFlusher = this.myIntMapping ? null : LowMemoryWatcher.register(this::dropMemoryCaches);
            this.myLiveAndGarbageKeysCounter = this.myEnumerator.getMetaData();
            long data2 = this.myEnumerator.getMetaData2();
            this.myLargeIndexWatermarkId = (int)(data2 & 0xFFFFFFFFFFFFFFFFL);
            this.myReadCompactionGarbageSize = (int)(data2 >>> 32);
            this.myCanReEnumerate = this.myEnumerator.canReEnumerate();
            if (!options2.isReadOnly() && this.makesSenseToCompact()) {
                this.compact();
            }
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
        catch (Throwable t) {
            LOG.error(t);
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new PersistentEnumeratorBase.CorruptedException(file2);
        }
    }

    private static int modifyVersionDependingOnOptions(int version2, @NotNull PersistentHashMapValueStorage.CreationTimeOptions options2) {
        if (options2 == null) {
            PersistentHashMap.$$$reportNull$$$0(19);
        }
        return version2 + options2.getVersion();
    }

    protected boolean wantNonNegativeIntegralValues() {
        return false;
    }

    protected boolean isReadOnly() {
        return false;
    }

    private SLRUCache<Key, BufferExposingByteArrayOutputStream> createAppendCache(KeyDescriptor<Key> keyDescriptor) {
        return new SLRUCache<Key, BufferExposingByteArrayOutputStream>(16384, 4096, keyDescriptor){

            @Override
            @NotNull
            public BufferExposingByteArrayOutputStream createValue(Key key) {
                BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream = (BufferExposingByteArrayOutputStream)PersistentHashMap.this.myStreamPool.alloc();
                if (bufferExposingByteArrayOutputStream == null) {
                    4.$$$reportNull$$$0(0);
                }
                return bufferExposingByteArrayOutputStream;
            }

            @Override
            protected void onDropFromCache(Key key, @NotNull BufferExposingByteArrayOutputStream bytes) {
                if (bytes == null) {
                    4.$$$reportNull$$$0(1);
                }
                PersistentHashMap.this.myEnumerator.lockStorageWrite();
                try {
                    int id;
                    long previousRecord;
                    if (PersistentHashMap.this.myDirectlyStoreLongFileOffsetMode) {
                        previousRecord = ((PersistentBTreeEnumerator)PersistentHashMap.this.myEnumerator).getNonNegativeValue(key);
                        id = -1;
                    } else {
                        id = PersistentHashMap.this.enumerate(key);
                        previousRecord = PersistentHashMap.this.readValueId(id);
                    }
                    long headerRecord = PersistentHashMap.this.myValueStorage.appendBytes(bytes.toByteArraySequence(), previousRecord);
                    if (PersistentHashMap.this.myDirectlyStoreLongFileOffsetMode) {
                        ((PersistentBTreeEnumerator)PersistentHashMap.this.myEnumerator).putNonNegativeValue(key, headerRecord);
                    } else {
                        PersistentHashMap.this.updateValueId(id, headerRecord, previousRecord, key, 0);
                    }
                    if (previousRecord == 0L) {
                        PersistentHashMap.this.myLiveAndGarbageKeysCounter += 0x100000000L;
                    }
                    if (bytes.getInternalBuffer().length <= 4096) {
                        PersistentHashMap.this.myStreamPool.recycle(bytes);
                    }
                }
                catch (IOException e) {
                    PersistentHashMap.this.myEnumerator.markCorrupted();
                    throw new RuntimeException(e);
                }
                finally {
                    PersistentHashMap.this.myEnumerator.unlockStorageWrite();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMap$4";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "bytes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createValue";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMap$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "onDropFromCache";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public Object getDataAccessLock() {
        Object object = this.myEnumerator.getDataAccessLock();
        if (object == null) {
            PersistentHashMap.$$$reportNull$$$0(20);
        }
        return object;
    }

    private static boolean doNewCompact() {
        return System.getProperty("idea.persistent.hash.map.oldcompact") == null;
    }

    private boolean forceNewCompact() {
        return System.getProperty("idea.persistent.hash.map.newcompact") != null && (int)(this.myLiveAndGarbageKeysCounter & 0xFFFFFFFFFFFFFFFFL) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dropMemoryCaches() {
        if (myDoTrace) {
            LOG.info("Drop memory caches " + this.myStorageFile);
        }
        Object object = this.getDataAccessLock();
        synchronized (object) {
            this.doDropMemoryCaches();
        }
    }

    protected void doDropMemoryCaches() {
        this.myEnumerator.lockStorageWrite();
        try {
            this.clearAppenderCaches();
        }
        finally {
            this.myEnumerator.unlockStorageWrite();
        }
    }

    public int getSize() {
        return (int)(this.myLiveAndGarbageKeysCounter / 0x100000000L);
    }

    int getGarbageSize() {
        return (int)this.myLiveAndGarbageKeysCounter;
    }

    public Path getBaseFile() {
        return this.myEnumerator.myFile;
    }

    @TestOnly
    public boolean makesSenseToCompact() {
        if (!this.isCompactionSupported()) {
            return false;
        }
        long fileSize = this.myValueStorage.getSize();
        int megabyte = 0x100000;
        if (fileSize > 0x500000L) {
            int liveKeys = (int)(this.myLiveAndGarbageKeysCounter / 0x100000000L);
            int deadKeys = (int)(this.myLiveAndGarbageKeysCounter & 0xFFFFFFFFFFFFFFFFL);
            if (fileSize > 0x3200000L && this.forceNewCompact()) {
                return true;
            }
            if (deadKeys < 50) {
                return false;
            }
            long benefitSize = Math.max(0x6400000L, fileSize / 4L);
            long avgValueSize = fileSize / (long)(liveKeys + deadKeys);
            return deadKeys > liveKeys || avgValueSize * (long)deadKeys > benefitSize || (long)this.myReadCompactionGarbageSize > fileSize / 2L;
        }
        return false;
    }

    @NotNull
    private static Path checkDataFiles(@NotNull Path file2) {
        if (file2 == null) {
            PersistentHashMap.$$$reportNull$$$0(21);
        }
        if (!Files.exists(file2, new LinkOption[0])) {
            PersistentHashMap.deleteFilesStartingWith(PersistentHashMap.getDataFile(file2).toFile());
        }
        Path path2 = file2;
        if (path2 == null) {
            PersistentHashMap.$$$reportNull$$$0(22);
        }
        return path2;
    }

    public static void deleteFilesStartingWith(@NotNull File prefixFile) {
        if (prefixFile == null) {
            PersistentHashMap.$$$reportNull$$$0(23);
        }
        IOUtil.deleteAllFilesStartingWith(prefixFile);
    }

    public static void deleteMap(@NotNull PersistentHashMap<?, ?> map2) {
        if (map2 == null) {
            PersistentHashMap.$$$reportNull$$$0(24);
        }
        Path baseFile = map2.getBaseFile();
        try {
            map2.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PersistentHashMap.deleteFilesStartingWith(baseFile.toFile());
    }

    @NotNull
    static Path getDataFile(@NotNull Path file2) {
        if (file2 == null) {
            PersistentHashMap.$$$reportNull$$$0(25);
        }
        Path path2 = file2.resolveSibling(file2.getFileName() + DATA_FILE_EXTENSION);
        if (path2 == null) {
            PersistentHashMap.$$$reportNull$$$0(26);
        }
        return path2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(Key key, Value value2) throws IOException {
        if (this.myIsReadOnly) {
            throw new IncorrectOperationException();
        }
        Object object = this.getDataAccessLock();
        synchronized (object) {
            try {
                this.doPut(key, value2);
            }
            catch (IOException ex) {
                this.myEnumerator.markCorrupted();
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(Key key, Value value2) throws IOException {
        long newValueOffset = -1L;
        if (!this.myIntMapping) {
            BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
            AppendStream appenderStream = ourFlyweightAppenderStream.getValue();
            appenderStream.setOut(bytes);
            this.myValueExternalizer.save(appenderStream, value2);
            appenderStream.setOut(null);
            newValueOffset = this.myValueStorage.appendBytes(bytes.toByteArraySequence(), 0L);
        }
        this.myEnumerator.lockStorageWrite();
        try {
            long oldValueOffset;
            this.myEnumerator.markDirty(true);
            if (this.myAppendCache != null) {
                this.myAppendCache.remove(key);
            }
            if (this.myDirectlyStoreLongFileOffsetMode) {
                if (this.myIntMapping) {
                    ((PersistentBTreeEnumerator)this.myEnumerator).putNonNegativeValue(key, ((Integer)value2).intValue());
                    return;
                }
                oldValueOffset = ((PersistentBTreeEnumerator)this.myEnumerator).getNonNegativeValue(key);
                ((PersistentBTreeEnumerator)this.myEnumerator).putNonNegativeValue(key, newValueOffset);
            } else {
                int id = this.enumerate(key);
                if (this.myIntMapping) {
                    this.myEnumerator.myStorage.putInt(id + this.myParentValueRefOffset, (Integer)value2);
                    return;
                }
                oldValueOffset = this.readValueId(id);
                this.updateValueId(id, newValueOffset, oldValueOffset, key, 0);
            }
            this.myLiveAndGarbageKeysCounter = oldValueOffset != 0L ? ++this.myLiveAndGarbageKeysCounter : (this.myLiveAndGarbageKeysCounter += 0x100000000L);
        }
        finally {
            this.myEnumerator.unlockStorageWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int enumerate(Key name2) throws IOException {
        if (this.myIsReadOnly) {
            throw new IncorrectOperationException();
        }
        Object object = this.getDataAccessLock();
        synchronized (object) {
            this.myIntAddressForNewRecord = this.canUseIntAddressForNewRecord(this.myValueStorage.getSize());
            return this.myEnumerator.enumerate(name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void appendData(Key key, @NotNull ValueDataAppender appender) throws IOException {
        if (appender == null) {
            PersistentHashMap.$$$reportNull$$$0(27);
        }
        if (this.myIsReadOnly) {
            throw new IncorrectOperationException();
        }
        Object object = this.getDataAccessLock();
        synchronized (object) {
            try {
                this.doAppendData(key, appender);
            }
            catch (IOException ex) {
                this.myEnumerator.markCorrupted();
                throw ex;
            }
        }
    }

    private void doAppendData(Key key, @NotNull ValueDataAppender appender) throws IOException {
        if (appender == null) {
            PersistentHashMap.$$$reportNull$$$0(28);
        }
        assert (!this.myIntMapping);
        this.myEnumerator.markDirty(true);
        AppendStream appenderStream = ourFlyweightAppenderStream.getValue();
        BufferExposingByteArrayOutputStream stream = this.myAppendCache.get(key);
        appenderStream.setOut(stream);
        this.myValueStorage.checkAppendsAllowed(stream.size());
        appender.append(appenderStream);
        appenderStream.setOut(null);
    }

    public final boolean processKeys(@NotNull Processor<? super Key> processor2) throws IOException {
        if (processor2 == null) {
            PersistentHashMap.$$$reportNull$$$0(29);
        }
        Object object = this.getDataAccessLock();
        synchronized (object) {
            try {
                if (this.myAppendCache != null) {
                    this.myAppendCache.clear();
                }
                return this.myEnumerator.iterateData(processor2);
            }
            catch (IOException e) {
                this.myEnumerator.markCorrupted();
                throw e;
            }
        }
    }

    public boolean isClosed() {
        return this.myEnumerator.isClosed();
    }

    public boolean isDirty() {
        return this.myEnumerator.isDirty();
    }

    public void markDirty() throws IOException {
        this.myEnumerator.markDirty(true);
    }

    @NotNull
    public Collection<Key> getAllKeysWithExistingMapping() throws IOException {
        ArrayList values2 = new ArrayList();
        this.processKeysWithExistingMapping(new CommonProcessors.CollectProcessor(values2));
        ArrayList arrayList = values2;
        if (arrayList == null) {
            PersistentHashMap.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    public final boolean processKeysWithExistingMapping(@NotNull Processor<? super Key> processor2) throws IOException {
        if (processor2 == null) {
            PersistentHashMap.$$$reportNull$$$0(31);
        }
        Object object = this.getDataAccessLock();
        synchronized (object) {
            try {
                if (this.myAppendCache != null) {
                    this.myAppendCache.clear();
                }
                return this.myEnumerator.processAllDataObject(processor2, new PersistentEnumeratorBase.DataFilter(){

                    @Override
                    public boolean accept(int id) {
                        return PersistentHashMap.this.readValueId(id) != 0L;
                    }
                });
            }
            catch (IOException e) {
                this.myEnumerator.markCorrupted();
                throw e;
            }
        }
    }

    public final Value get(Key key) throws IOException {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            try {
                return this.doGet(key);
            }
            catch (IOException ex) {
                try {
                    this.myEnumerator.markCorrupted();
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Value doGet(Key key) throws IOException {
        Value valueRead;
        int id;
        long valueOffset;
        if (this.myAppendCache != null) {
            this.myAppendCache.remove(key);
        }
        this.myEnumerator.lockStorageRead();
        try {
            if (this.myDirectlyStoreLongFileOffsetMode) {
                valueOffset = ((PersistentBTreeEnumerator)this.myEnumerator).getNonNegativeValue(key);
                if (this.myIntMapping) {
                    Integer n = (int)valueOffset;
                    return (Value)n;
                }
                id = -1;
            } else {
                id = this.myEnumerator.tryEnumerate(key);
                if (id == 0) {
                    Value Value2 = null;
                    return Value2;
                }
                if (this.myIntMapping) {
                    Integer n = this.myEnumerator.myStorage.getInt(id + this.myParentValueRefOffset);
                    return (Value)n;
                }
                valueOffset = this.readValueId(id);
            }
            if (valueOffset == 0L) {
                Value Value3 = null;
                return Value3;
            }
        }
        finally {
            this.myEnumerator.unlockStorageRead();
        }
        PersistentHashMapValueStorage.ReadResult readResult = this.myValueStorage.readBytes(valueOffset);
        try (DataInputStream input = new DataInputStream(new UnsyncByteArrayInputStream(readResult.buffer));){
            valueRead = this.myValueExternalizer.read(input);
        }
        if (this.myValueStorage.performChunksCompaction(readResult.chunksCount)) {
            long newValueOffset = this.myValueStorage.compactChunks(new ValueDataAppender(){

                @Override
                public void append(DataOutput out2) throws IOException {
                    PersistentHashMap.this.myValueExternalizer.save(out2, valueRead);
                }
            }, readResult);
            this.myEnumerator.lockStorageWrite();
            try {
                this.myEnumerator.markDirty(true);
                if (this.myDirectlyStoreLongFileOffsetMode) {
                    ((PersistentBTreeEnumerator)this.myEnumerator).putNonNegativeValue(key, newValueOffset);
                } else {
                    this.updateValueId(id, newValueOffset, valueOffset, key, 0);
                }
                ++this.myLiveAndGarbageKeysCounter;
                this.myReadCompactionGarbageSize += readResult.buffer.length;
            }
            finally {
                this.myEnumerator.unlockStorageWrite();
            }
        }
        return valueRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsMapping(Key key) throws IOException {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            return this.doContainsMapping(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doContainsMapping(Key key) throws IOException {
        if (this.myAppendCache != null) {
            this.myAppendCache.remove(key);
        }
        this.myEnumerator.lockStorageRead();
        try {
            if (this.myDirectlyStoreLongFileOffsetMode) {
                boolean bl = ((PersistentBTreeEnumerator)this.myEnumerator).getNonNegativeValue(key) != 0L;
                return bl;
            }
            int id = this.myEnumerator.tryEnumerate(key);
            if (id == 0) {
                boolean bl = false;
                return bl;
            }
            if (this.myIntMapping) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.readValueId(id) != 0L;
            return bl;
        }
        finally {
            this.myEnumerator.unlockStorageRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(Key key) throws IOException {
        if (this.myIsReadOnly) {
            throw new IncorrectOperationException();
        }
        Object object = this.getDataAccessLock();
        synchronized (object) {
            this.doRemove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRemove(Key key) throws IOException {
        this.myEnumerator.lockStorageWrite();
        try {
            long record2;
            if (this.myAppendCache != null) {
                this.myAppendCache.remove(key);
            }
            if (this.myDirectlyStoreLongFileOffsetMode) {
                assert (!this.myIntMapping);
                record2 = ((PersistentBTreeEnumerator)this.myEnumerator).getNonNegativeValue(key);
                if (record2 != 0L) {
                    ((PersistentBTreeEnumerator)this.myEnumerator).putNonNegativeValue(key, 0L);
                }
            } else {
                int id = this.myEnumerator.tryEnumerate(key);
                if (id == 0) {
                    return;
                }
                assert (!this.myIntMapping);
                this.myEnumerator.markDirty(true);
                record2 = this.readValueId(id);
                this.updateValueId(id, 0L, record2, key, 0);
            }
            if (record2 != 0L) {
                ++this.myLiveAndGarbageKeysCounter;
                this.myLiveAndGarbageKeysCounter -= 0x100000000L;
            }
        }
        finally {
            this.myEnumerator.unlockStorageWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void force() {
        if (this.myIsReadOnly) {
            return;
        }
        if (myDoTrace) {
            LOG.info("Forcing " + this.myStorageFile);
        }
        Object object = this.getDataAccessLock();
        synchronized (object) {
            this.doForce();
        }
    }

    protected void doForce() {
        this.myEnumerator.lockStorageWrite();
        try {
            try {
                this.clearAppenderCaches();
            }
            finally {
                this.myEnumerator.force();
            }
        }
        finally {
            this.myEnumerator.unlockStorageWrite();
        }
    }

    private void clearAppenderCaches() {
        if (this.myIntMapping) {
            return;
        }
        this.myAppendCache.clear();
        this.myValueStorage.force();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        if (myDoTrace) {
            LOG.info("Closed " + this.myStorageFile);
        }
        Object object = this.getDataAccessLock();
        synchronized (object) {
            this.doClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() throws IOException {
        this.myEnumerator.lockStorageWrite();
        try {
            try {
                try {
                    if (this.myAppendCache != null) {
                        this.myAppendCacheFlusher.stop();
                        this.myAppendCache.clear();
                    }
                }
                catch (RuntimeException ex) {
                    Throwable cause = ex.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw ex;
                }
            }
            finally {
                PersistentHashMapValueStorage valueStorage = this.myValueStorage;
                try {
                    if (valueStorage != null) {
                        valueStorage.dispose();
                    }
                }
                finally {
                    this.myEnumerator.close();
                }
            }
        }
        finally {
            this.myEnumerator.unlockStorageWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void compact() throws IOException {
        if (!this.isCompactionSupported()) {
            throw new IncorrectOperationException();
        }
        Object object = this.getDataAccessLock();
        synchronized (object) {
            this.force();
            LOG.info("Compacting " + this.myEnumerator.myFile);
            LOG.info("Live keys:" + (int)(this.myLiveAndGarbageKeysCounter / 0x100000000L) + ", dead keys:" + (int)(this.myLiveAndGarbageKeysCounter & 0xFFFFFFFFFFFFFFFFL) + ", read compaction size:" + this.myReadCompactionGarbageSize);
            long now = System.currentTimeMillis();
            Path oldDataFile = PersistentHashMap.getDataFile(this.myEnumerator.myFile);
            File[] oldFiles = PersistentHashMap.getFilesInDirectoryWithNameStartingWith(oldDataFile);
            Path newPath = oldDataFile.resolveSibling(oldDataFile.getFileName() + ".new");
            PersistentHashMapValueStorage.CreationTimeOptions options2 = this.myValueStorage.getOptions();
            final PersistentHashMapValueStorage newStorage = new PersistentHashMapValueStorage(newPath, options2);
            this.myValueStorage.switchToCompactionMode();
            this.myEnumerator.markDirty(true);
            long sizeBefore = this.myValueStorage.getSize();
            this.myLiveAndGarbageKeysCounter = 0L;
            this.myReadCompactionGarbageSize = 0;
            try {
                if (PersistentHashMap.doNewCompact()) {
                    this.newCompact(newStorage);
                } else {
                    this.myEnumerator.traverseAllRecords(new PersistentEnumeratorBase.RecordsProcessor(){

                        @Override
                        public boolean process(int keyId) throws IOException {
                            long record2 = PersistentHashMap.this.readValueId(keyId);
                            if (record2 != 0L) {
                                PersistentHashMapValueStorage.ReadResult readResult = PersistentHashMap.this.myValueStorage.readBytes(record2);
                                long value2 = newStorage.appendBytes(readResult.buffer, 0, readResult.buffer.length, 0L);
                                PersistentHashMap.this.updateValueId(keyId, value2, record2, null, this.getCurrentKey());
                                PersistentHashMap.this.myLiveAndGarbageKeysCounter += 0x100000000L;
                            }
                            return true;
                        }
                    });
                }
            }
            finally {
                newStorage.dispose();
            }
            this.myValueStorage.dispose();
            for (File f : oldFiles) {
                assert (FileUtil.deleteWithRenaming(f));
            }
            long newSize = newStorage.getSize();
            File[] newFiles = PersistentHashMap.getFilesInDirectoryWithNameStartingWith(newPath);
            File parentFile = newPath.getParent().toFile();
            String newBaseName = newPath.getFileName().toString();
            String oldDataFileBaseName = oldDataFile.getFileName().toString();
            for (File f : newFiles) {
                String nameAfterRename = StringUtil.replace(f.getName(), newBaseName, oldDataFileBaseName);
                FileUtil.rename(f, new File(parentFile, nameAfterRename));
            }
            this.myValueStorage = new PersistentHashMapValueStorage(oldDataFile, options2);
            LOG.info("Compacted " + this.myEnumerator.myFile + ":" + sizeBefore + " bytes into " + newSize + " bytes in " + (System.currentTimeMillis() - now) + "ms.");
            this.myEnumerator.putMetaData(this.myLiveAndGarbageKeysCounter);
            this.myEnumerator.putMetaData2(this.myLargeIndexWatermarkId);
            if (myDoTrace) {
                LOG.assertTrue(this.myEnumerator.isDirty());
            }
        }
    }

    @ApiStatus.Internal
    public boolean isCompactionSupported() {
        return !this.myIsReadOnly && !this.myIntMapping;
    }

    private static File[] getFilesInDirectoryWithNameStartingWith(@NotNull Path fileFromDirectory) throws IOException {
        Path parentFile;
        if (fileFromDirectory == null) {
            PersistentHashMap.$$$reportNull$$$0(32);
        }
        if ((parentFile = fileFromDirectory.getParent()) == null) {
            return ArrayUtil.EMPTY_FILE_ARRAY;
        }
        Path fileName = fileFromDirectory.getFileName();
        try (Stream<Path> children2 = Files.list(parentFile);){
            File[] fileArray = (File[])children2.filter(p -> p.getFileName().toString().startsWith(fileName.toString())).map(p -> p.toFile()).toArray(File[]::new);
            return fileArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newCompact(@NotNull PersistentHashMapValueStorage newStorage) throws IOException {
        if (newStorage == null) {
            PersistentHashMap.$$$reportNull$$$0(33);
        }
        long started2 = System.currentTimeMillis();
        final ArrayList infos = new ArrayList(10000);
        this.myEnumerator.traverseAllRecords(new PersistentEnumeratorBase.RecordsProcessor(){

            @Override
            public boolean process(int keyId) {
                long record2 = PersistentHashMap.this.readValueId(keyId);
                if (record2 != 0L) {
                    infos.add(new CompactionRecordInfo(this.getCurrentKey(), record2, keyId));
                }
                return true;
            }
        });
        LOG.info("Loaded mappings:" + (System.currentTimeMillis() - started2) + "ms, keys:" + infos.size());
        started2 = System.currentTimeMillis();
        long fragments2 = 0L;
        if (!infos.isEmpty()) {
            try {
                fragments2 = this.myValueStorage.compactValues(infos, newStorage);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new IOException("Compaction failed", t);
            }
        }
        LOG.info("Compacted values for:" + (System.currentTimeMillis() - started2) + "ms fragments:" + (int)fragments2 + ", new fragments:" + (fragments2 >> 32));
        started2 = System.currentTimeMillis();
        try {
            this.myEnumerator.lockStorageWrite();
            for (CompactionRecordInfo info : infos) {
                this.updateValueId(info.address, info.newValueAddress, info.valueAddress, null, info.key);
                this.myLiveAndGarbageKeysCounter += 0x100000000L;
            }
        }
        finally {
            this.myEnumerator.unlockStorageWrite();
        }
        LOG.info("Updated mappings:" + (System.currentTimeMillis() - started2) + " ms");
    }

    private long readValueId(int keyId) {
        if (this.myDirectlyStoreLongFileOffsetMode) {
            return ((PersistentBTreeEnumerator)this.myEnumerator).keyIdToNonNegativeOffset(keyId);
        }
        long address = this.myEnumerator.myStorage.getInt(keyId + this.myParentValueRefOffset);
        if (address == 0L || address == -1L) {
            return 0L;
        }
        if (address < 0L) {
            address = -address - 1L;
        } else {
            long value2 = (long)this.myEnumerator.myStorage.getInt(keyId + this.myParentValueRefOffset + 4) & 0xFFFFFFFFL;
            address = (address << 32) + value2 & 0xBFFFFFFFFFFFFFFFL;
        }
        return address;
    }

    private void updateValueId(int keyId, long value2, long oldValue, @Nullable Key key, int processingKey) throws IOException {
        boolean newKey;
        if (this.myDirectlyStoreLongFileOffsetMode) {
            ((PersistentBTreeEnumerator)this.myEnumerator).putNonNegativeValue(((InlineKeyDescriptor)this.myKeyDescriptor).fromInt(processingKey), value2);
            return;
        }
        boolean bl = newKey = oldValue == 0L;
        if (newKey) {
            ++this.requests;
        }
        boolean defaultSizeInfo = true;
        if (this.myCanReEnumerate) {
            if (this.canUseIntAddressForNewRecord(value2)) {
                defaultSizeInfo = false;
                this.myEnumerator.myStorage.putInt(keyId + this.myParentValueRefOffset, -((int)(value2 + 1L)));
                if (newKey) {
                    ++this.smallKeys;
                }
            } else if ((keyId < this.myLargeIndexWatermarkId || this.myLargeIndexWatermarkId == 0) && (newKey || this.canUseIntAddressForNewRecord(oldValue))) {
                this.myIntAddressForNewRecord = false;
                keyId = this.myEnumerator.reEnumerate(key == null ? this.myEnumerator.getValue(keyId, processingKey) : key);
                ++this.transformedKeys;
                if (this.myLargeIndexWatermarkId == 0) {
                    this.myLargeIndexWatermarkId = keyId;
                }
            }
        }
        if (defaultSizeInfo) {
            this.myEnumerator.myStorage.putInt(keyId + this.myParentValueRefOffset, (int)((value2 |= 0x4000000000000000L) >>> 32));
            this.myEnumerator.myStorage.putInt(keyId + this.myParentValueRefOffset + 4, (int)value2);
            if (newKey) {
                ++this.largeKeys;
            }
        }
        if (newKey && IOStatistics.DEBUG && (this.requests & 0xFFFF) == 0) {
            IOStatistics.dump("small:" + this.smallKeys + ", large:" + this.largeKeys + ", transformed:" + this.transformedKeys + ",@" + this.getBaseFile());
        }
    }

    public String toString() {
        return super.toString() + ": " + this.myStorageFile;
    }

    @TestOnly
    PersistentHashMapValueStorage getValueStorage() {
        return this.myValueStorage;
    }

    @TestOnly
    public boolean getReadOnly() {
        return this.myIsReadOnly;
    }

    static {
        String property2 = System.getProperty("idea.initialIndexSize");
        INITIAL_INDEX_SIZE = property2 == null ? 4096 : Integer.valueOf(property2);
        ourFlyweightAppenderStream = new ThreadLocalCachedValue<AppendStream>(){

            @Override
            @NotNull
            protected AppendStream create() {
                return new AppendStream();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 22: 
            case 26: 
            case 30: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 22: 
            case 26: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyDescriptor";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExternalizer";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 20: 
            case 22: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMap";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixFile";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appender";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileFromDirectory";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMap";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataAccessLock";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "checkDataFiles";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFile";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeysWithExistingMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "modifyVersionDependingOnOptions";
                break;
            }
            case 20: 
            case 22: 
            case 26: 
            case 30: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkDataFiles";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "deleteFilesStartingWith";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "deleteMap";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDataFile";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "appendData";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doAppendData";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processKeys";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processKeysWithExistingMapping";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getFilesInDirectoryWithNameStartingWith";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "newCompact";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 20: 
            case 22: 
            case 26: 
            case 30: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class CompactionRecordInfo {
        final int key;
        final int address;
        long valueAddress;
        long newValueAddress;
        byte[] value;

        CompactionRecordInfo(int _key, long _valueAddress, int _address) {
            this.key = _key;
            this.address = _address;
            this.valueAddress = _valueAddress;
        }
    }

    @ApiStatus.Experimental
    public static interface ValueDataAppender {
        public void append(DataOutput var1) throws IOException;
    }

    private static final class AppendStream
    extends DataOutputStream {
        private AppendStream() {
            super(null);
        }

        private void setOut(BufferExposingByteArrayOutputStream stream) {
            this.out = stream;
        }
    }
}

