/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.Forceable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.io.OpenChannelsCache;
import org.jetbrains.kotlin.com.intellij.util.io.Page;
import org.jetbrains.kotlin.com.intellij.util.io.PagePool;

public final class RandomAccessDataFile
implements Forceable,
Closeable {
    private static final Logger LOG = Logger.getInstance(RandomAccessDataFile.class);
    private static final OpenChannelsCache ourCache = new OpenChannelsCache(150, EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE));
    private static final AtomicInteger ourFilesCount = new AtomicInteger();
    private final int myCount;
    private final Path myFile;
    private final PagePool myPool;
    private static final ThreadLocal<byte[]> ourTypedIOBuffer = ThreadLocal.withInitial(() -> new byte[8]);
    private volatile long mySize;
    private volatile boolean myIsDirty;
    private volatile boolean myIsDisposed;
    public static int totalReads;
    public static long totalReadBytes;
    public static int totalWrites;
    public static long totalWriteBytes;

    private <T> T useFileChannel(@NotNull OpenChannelsCache.ChannelProcessor<T> channelConsumer) throws IOException {
        if (channelConsumer == null) {
            RandomAccessDataFile.$$$reportNull$$$0(2);
        }
        return ourCache.useChannel(this.myFile, channelConsumer);
    }

    public long physicalLength() {
        this.assertNotDisposed();
        try {
            return this.useFileChannel(file2 -> file2.size());
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public void dispose() {
        if (this.myIsDisposed) {
            return;
        }
        this.myPool.flushPages(this);
        ourCache.closeChannel(this.myFile);
        this.myIsDisposed = true;
    }

    @Override
    public void close() {
        this.dispose();
    }

    @Override
    public void force() {
        this.assertNotDisposed();
        if (this.isDirty()) {
            this.myPool.flushPages(this);
            this.myIsDirty = false;
        }
    }

    public boolean isDirty() {
        this.assertNotDisposed();
        return this.myIsDirty;
    }

    private void assertNotDisposed() {
        if (this.myIsDisposed) {
            LOG.error("storage file is disposed: " + this.myFile);
        }
    }

    void loadPage(Page page) {
        this.assertNotDisposed();
        try {
            this.useFileChannel(file2 -> {
                ByteBuffer buf = page.getBuf();
                ++totalReads;
                totalReadBytes += (long)Page.PAGE_SIZE;
                return file2.read(ByteBuffer.wrap(buf.array(), 0, Page.PAGE_SIZE), page.getOffset());
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void flushPage(Page page, int start2, int end2) {
        this.assertNotDisposed();
        try {
            this.flush(page.getBuf(), page.getOffset() + (long)start2, start2, end2 - start2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void flush(ByteBuffer buf, long fileOffset, int bufOffset, int length) throws IOException {
        if (fileOffset + (long)length > this.mySize) {
            length = (int)(this.mySize - fileOffset);
        }
        int finalLength = length;
        this.useFileChannel(file2 -> {
            ++totalWrites;
            totalWriteBytes += (long)finalLength;
            return file2.write(ByteBuffer.wrap(buf.array(), bufOffset, finalLength), fileOffset);
        });
    }

    public int hashCode() {
        return this.myCount;
    }

    public String toString() {
        return "RandomAccessFile[" + this.myFile + ", dirty=" + this.myIsDirty + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pool";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channelConsumer";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/RandomAccessDataFile";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "useFileChannel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

