/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.text;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.CharSequenceWithStringHash;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.Strings;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayExternalizable;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.text.StringFactory;

public class CharSequenceSubSequence
implements CharSequenceWithStringHash,
CharArrayExternalizable,
CharSequence {
    private final CharSequence myChars;
    private final int myStart;
    private final int myEnd;
    private transient int hash;

    public CharSequenceSubSequence(@NotNull CharSequence chars, int start2, int end2) {
        if (chars == null) {
            CharSequenceSubSequence.$$$reportNull$$$0(1);
        }
        if (start2 < 0 || end2 > chars.length() || start2 > end2) {
            throw new IndexOutOfBoundsException("chars sequence.length:" + chars.length() + ", start:" + start2 + ", end:" + end2);
        }
        this.myChars = chars;
        this.myStart = start2;
        this.myEnd = end2;
    }

    @Override
    public final int length() {
        return this.myEnd - this.myStart;
    }

    @Override
    public final char charAt(int index2) {
        return this.myChars.charAt(index2 + this.myStart);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start2, int end2) {
        if (start2 == this.myStart && end2 == this.myEnd) {
            CharSequenceSubSequence charSequenceSubSequence = this;
            if (charSequenceSubSequence == null) {
                CharSequenceSubSequence.$$$reportNull$$$0(2);
            }
            return charSequenceSubSequence;
        }
        return new CharSequenceSubSequence(this.myChars, this.myStart + start2, this.myStart + end2);
    }

    @Override
    @NotNull
    public String toString() {
        if (this.myChars instanceof String) {
            String string2 = ((String)this.myChars).substring(this.myStart, this.myEnd);
            if (string2 == null) {
                CharSequenceSubSequence.$$$reportNull$$$0(3);
            }
            return string2;
        }
        String string3 = StringFactory.createShared(CharArrayUtil.fromSequence(this.myChars, this.myStart, this.myEnd));
        if (string3 == null) {
            CharSequenceSubSequence.$$$reportNull$$$0(4);
        }
        return string3;
    }

    @NotNull
    CharSequence getBaseSequence() {
        CharSequence charSequence2 = this.myChars;
        if (charSequence2 == null) {
            CharSequenceSubSequence.$$$reportNull$$$0(5);
        }
        return charSequence2;
    }

    @Override
    public void getChars(int start2, int end2, char @NotNull [] dest, int destPos) {
        if (dest == null) {
            CharSequenceSubSequence.$$$reportNull$$$0(6);
        }
        assert (end2 - start2 <= this.myEnd - this.myStart);
        CharArrayUtil.getChars(this.myChars, dest, start2 + this.myStart, destPos, end2 - start2);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = Strings.stringHashCode(this, 0, this.length());
        }
        return h;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/text/CharSequenceSubSequence";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/text/CharSequenceSubSequence";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "subSequence";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChars";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

