/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.functors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.model.AbstractFunctor;
import org.jetbrains.kotlin.contracts.model.Computation;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESTypeSubstitution;
import org.jetbrains.kotlin.contracts.model.ESValue;
import org.jetbrains.kotlin.contracts.model.SimpleEffect;
import org.jetbrains.kotlin.contracts.model.structure.ESCalls;
import org.jetbrains.kotlin.contracts.model.structure.ESReturns;
import org.jetbrains.kotlin.contracts.model.structure.ESVariable;
import org.jetbrains.kotlin.contracts.model.structure.ValuesKt;
import org.jetbrains.kotlin.contracts.model.visitors.Reducer;
import org.jetbrains.kotlin.contracts.model.visitors.Substitutor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J,\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/contracts/model/functors/SubstitutingFunctor;", "Lorg/jetbrains/kotlin/contracts/model/AbstractFunctor;", "basicEffects", "", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "ownerFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Ljava/util/List;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "combine", "effect", "Lorg/jetbrains/kotlin/contracts/model/SimpleEffect;", "substitutedCondition", "doInvocation", "arguments", "Lorg/jetbrains/kotlin/contracts/model/Computation;", "typeSubstitution", "Lorg/jetbrains/kotlin/contracts/model/ESTypeSubstitution;", "reducer", "Lorg/jetbrains/kotlin/contracts/model/visitors/Reducer;", "toESVariable", "Lorg/jetbrains/kotlin/contracts/model/structure/ESVariable;", "Lorg/jetbrains/kotlin/descriptors/ValueDescriptor;", "resolution"})
public final class SubstitutingFunctor
extends AbstractFunctor {
    @NotNull
    private final List<ESEffect> basicEffects;
    @NotNull
    private final FunctionDescriptor ownerFunction;

    public SubstitutingFunctor(@NotNull List<? extends ESEffect> basicEffects, @NotNull FunctionDescriptor ownerFunction) {
        Intrinsics.checkNotNullParameter(basicEffects, "basicEffects");
        Intrinsics.checkNotNullParameter(ownerFunction, "ownerFunction");
        this.basicEffects = basicEffects;
        this.ownerFunction = ownerFunction;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<ESEffect> doInvocation(@NotNull List<? extends Computation> arguments2, @NotNull ESTypeSubstitution typeSubstitution, @NotNull Reducer reducer) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(typeSubstitution, "typeSubstitution");
        Intrinsics.checkNotNullParameter(reducer, "reducer");
        if (this.basicEffects.isEmpty()) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        ESVariable[] eSVariableArray = new ESVariable[2];
        ReceiverParameterDescriptor receiverParameterDescriptor = this.ownerFunction.getDispatchReceiverParameter();
        eSVariableArray[0] = receiverParameterDescriptor != null ? this.toESVariable(receiverParameterDescriptor) : null;
        ReceiverParameterDescriptor receiverParameterDescriptor2 = this.ownerFunction.getExtensionReceiverParameter();
        eSVariableArray[1] = receiverParameterDescriptor2 != null ? this.toESVariable(receiverParameterDescriptor2) : null;
        List<ESVariable> receiver2 = kotlin.collections.CollectionsKt.listOfNotNull(eSVariableArray);
        Collection collection = receiver2;
        List<ValueParameterDescriptor> list2 = this.ownerFunction.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "ownerFunction.valueParameters");
        Iterable iterable = list2;
        Collection collection2 = collection;
        boolean $i$f$map = false;
        void var8_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            collection3.add(this.toESVariable((ValueDescriptor)it));
        }
        List parameters2 = kotlin.collections.CollectionsKt.plus(collection2, (Iterable)((List)destination$iv$iv));
        boolean bl = $this$map$iv = parameters2.size() == arguments2.size();
        if (_Assertions.ENABLED && !$this$map$iv) {
            boolean $i$a$-assert-SubstitutingFunctor$doInvocation$22 = false;
            String $i$a$-assert-SubstitutingFunctor$doInvocation$22 = "Arguments and parameters size mismatch: arguments.size = " + arguments2.size() + ", parameters.size = " + parameters2.size();
            throw new AssertionError((Object)$i$a$-assert-SubstitutingFunctor$doInvocation$22);
        }
        Map substitutions = MapsKt.toMap(kotlin.collections.CollectionsKt.zip((Iterable)parameters2, (Iterable)arguments2));
        Substitutor substitutor2 = new Substitutor(substitutions, typeSubstitution, reducer);
        List substitutedClauses = new ArrayList();
        for (ESEffect effect : this.basicEffects) {
            ESEffect eSEffect = effect;
            if (eSEffect instanceof ConditionalEffect) {
                Object object = (Computation)((ConditionalEffect)effect).getCondition().accept(substitutor2);
                if (object != null && (object = object.getEffects()) != null) {
                    Iterable $this$forEach$iv = (Iterable)object;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ESEffect it = (ESEffect)element$iv;
                        boolean bl2 = false;
                        CollectionsKt.addIfNotNull(substitutedClauses, this.combine(((ConditionalEffect)effect).getSimpleEffect(), it));
                    }
                }
                continue;
            }
            if (eSEffect instanceof ESCalls) {
                ESValue substitutionForCallable;
                Object v = substitutions.get(((ESCalls)effect).getCallable());
                if ((v instanceof ESValue ? (ESValue)v : null) == null) continue;
                substitutionForCallable = substitutionForCallable;
                ((Collection)substitutedClauses).add(new ESCalls(substitutionForCallable, ((ESCalls)effect).getKind()));
                continue;
            }
            ((Collection)substitutedClauses).add(effect);
        }
        return substitutedClauses;
    }

    private final ESEffect combine(SimpleEffect effect, ESEffect substitutedCondition) {
        if (!(substitutedCondition instanceof ConditionalEffect)) {
            return null;
        }
        SimpleEffect effectFromCondition = ((ConditionalEffect)substitutedCondition).getSimpleEffect();
        if (!(effectFromCondition instanceof ESReturns) || ValuesKt.isWildcard(((ESReturns)effectFromCondition).getValue())) {
            return substitutedCondition;
        }
        if (!ValuesKt.isTrue(((ESReturns)effectFromCondition).getValue())) {
            return null;
        }
        return new ConditionalEffect(((ConditionalEffect)substitutedCondition).getCondition(), effect);
    }

    private final ESVariable toESVariable(ValueDescriptor $this$toESVariable) {
        return new ESVariable($this$toESVariable);
    }
}

