/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.DeclaredVariableCollector;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PathAwareControlFlowInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PathAwarePropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfoCollector;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfoCollectorKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.TraverseDirection;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitor;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeLabel;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.LoopBackPath;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.LoopBlockEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.LoopConditionEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.LoopEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.LoopExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00040\u00030\u0001B\u001d\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J<\u0010\u0011\u001a\u00020\u00022\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\u0018\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00040\u0003H\u0002J\u001e\u0010\u0016\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012\u0004\u0012\u00020\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\"\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\b2\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0002J*\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020 2\u0018\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00040\u0003H\u0016J*\u0010!\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\"2\u0018\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00040\u0003H\u0016J*\u0010#\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020$2\u0018\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00040\u0003H\u0016J*\u0010%\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020&2\u0018\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00040\u0003H\u0016J.\u0010'\u001a\u00020\u00022\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0018\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00040\u0003H\u0016J*\u0010(\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020)2\u0018\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00040\u0003H\u0016J*\u0010*\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020+2\u0018\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00040\u0003H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfoCollector;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitor;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwarePropertyInitializationInfo;", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "localProperties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "declaredVariableCollector", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/DeclaredVariableCollector;", "(Ljava/util/Set;Lorg/jetbrains/kotlin/fir/analysis/cfa/util/DeclaredVariableCollector;)V", "enterCapturingStatement", "statement", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "exitCapturingStatement", "", "filterDeclaredVariableSymbolsInCapturedScope", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "declaredVariableSymbolsInCapturedScope", "data", "getData", "", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "processVariableWithAssignment", "dataForNode", "symbol", "overwriteRange", "", "visitLoopBlockEnterNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/LoopBlockEnterNode;", "visitLoopConditionEnterNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/LoopConditionEnterNode;", "visitLoopEnterNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/LoopEnterNode;", "visitLoopExitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/LoopExitNode;", "visitNode", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "checkers"})
public final class PropertyInitializationInfoCollector
extends ControlFlowGraphVisitor<PathAwarePropertyInitializationInfo, Collection<? extends Pair<? extends EdgeLabel, ? extends PathAwarePropertyInitializationInfo>>> {
    @NotNull
    private final Set<FirPropertySymbol> localProperties;
    @NotNull
    private final DeclaredVariableCollector declaredVariableCollector;

    public PropertyInitializationInfoCollector(@NotNull Set<? extends FirPropertySymbol> localProperties, @NotNull DeclaredVariableCollector declaredVariableCollector) {
        Intrinsics.checkNotNullParameter(localProperties, "localProperties");
        Intrinsics.checkNotNullParameter(declaredVariableCollector, "declaredVariableCollector");
        this.localProperties = localProperties;
        this.declaredVariableCollector = declaredVariableCollector;
    }

    public /* synthetic */ PropertyInitializationInfoCollector(Set set2, DeclaredVariableCollector declaredVariableCollector, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            declaredVariableCollector = new DeclaredVariableCollector();
        }
        this(set2, declaredVariableCollector);
    }

    @Override
    @NotNull
    public PathAwarePropertyInitializationInfo visitNode(@NotNull CFGNode<?> node, @NotNull Collection<? extends Pair<? extends EdgeLabel, PathAwarePropertyInitializationInfo>> data2) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(data2, "data");
        PathAwarePropertyInitializationInfo result2 = null;
        for (Pair<? extends EdgeLabel, PathAwarePropertyInitializationInfo> pair : data2) {
            EdgeLabel label = pair.component1();
            PathAwarePropertyInitializationInfo info = pair.component2();
            PathAwarePropertyInitializationInfo resultItem = (PathAwarePropertyInitializationInfo)info.applyLabel(node, label);
            PathAwarePropertyInitializationInfo pathAwarePropertyInitializationInfo = result2;
            if (pathAwarePropertyInitializationInfo == null || (pathAwarePropertyInitializationInfo = (PathAwarePropertyInitializationInfo)pathAwarePropertyInitializationInfo.merge((PathAwareControlFlowInfo)resultItem)) == null) {
                pathAwarePropertyInitializationInfo = resultItem;
            }
            result2 = pathAwarePropertyInitializationInfo;
        }
        PathAwarePropertyInitializationInfo pathAwarePropertyInitializationInfo = result2;
        if (pathAwarePropertyInitializationInfo == null) {
            pathAwarePropertyInitializationInfo = PathAwarePropertyInitializationInfo.Companion.getEMPTY();
        }
        return pathAwarePropertyInitializationInfo;
    }

    @Override
    @NotNull
    public PathAwarePropertyInitializationInfo visitVariableAssignmentNode(@NotNull VariableAssignmentNode node, @NotNull Collection<? extends Pair<? extends EdgeLabel, PathAwarePropertyInitializationInfo>> data2) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(data2, "data");
        PathAwarePropertyInitializationInfo dataForNode = this.visitNode((CFGNode)node, data2);
        FirPropertySymbol firPropertySymbol = FirDeclarationUtilKt.getReferredPropertySymbol(node.getFir());
        if (firPropertySymbol == null) {
            return dataForNode;
        }
        FirPropertySymbol symbol2 = firPropertySymbol;
        return !this.localProperties.contains(symbol2) ? dataForNode : PropertyInitializationInfoCollector.processVariableWithAssignment$default(this, dataForNode, symbol2, false, 4, null);
    }

    @Override
    @NotNull
    public PathAwarePropertyInitializationInfo visitVariableDeclarationNode(@NotNull VariableDeclarationNode node, @NotNull Collection<? extends Pair<? extends EdgeLabel, PathAwarePropertyInitializationInfo>> data2) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(data2, "data");
        PathAwarePropertyInitializationInfo dataForNode = this.visitNode((CFGNode)node, data2);
        return this.processVariableWithAssignment(dataForNode, node.getFir().getSymbol(), node.getFir().getInitializer() == null && node.getFir().getDelegate() == null);
    }

    @NotNull
    public final Map<CFGNode<?>, PathAwarePropertyInitializationInfo> getData(@NotNull ControlFlowGraph graph2) {
        Intrinsics.checkNotNullParameter(graph2, "graph");
        return CfgTraverserKt.collectDataForNode$default(graph2, TraverseDirection.Forward, PathAwarePropertyInitializationInfo.Companion.getEMPTY(), this, false, 8, null);
    }

    private final PathAwarePropertyInitializationInfo processVariableWithAssignment(PathAwarePropertyInitializationInfo dataForNode, FirPropertySymbol symbol2, boolean overwriteRange) {
        boolean bl;
        boolean bl2 = bl = !((Collection)dataForNode.keySet()).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return overwriteRange ? (PathAwarePropertyInitializationInfo)PropertyInitializationInfoCollectorKt.access$overwriteRange(dataForNode, symbol2, EventOccurrencesRange.ZERO, processVariableWithAssignment.1.INSTANCE) : (PathAwarePropertyInitializationInfo)PropertyInitializationInfoCollectorKt.addRange((PathAwareControlFlowInfo)dataForNode, symbol2, EventOccurrencesRange.EXACTLY_ONCE, processVariableWithAssignment.2.INSTANCE);
    }

    static /* synthetic */ PathAwarePropertyInitializationInfo processVariableWithAssignment$default(PropertyInitializationInfoCollector propertyInitializationInfoCollector, PathAwarePropertyInitializationInfo pathAwarePropertyInitializationInfo, FirPropertySymbol firPropertySymbol, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return propertyInitializationInfoCollector.processVariableWithAssignment(pathAwarePropertyInitializationInfo, firPropertySymbol, bl);
    }

    private final Set<FirPropertySymbol> enterCapturingStatement(FirStatement statement2) {
        return this.declaredVariableCollector.enterCapturingStatement(statement2);
    }

    private final void exitCapturingStatement(FirStatement statement2) {
        this.declaredVariableCollector.exitCapturingStatement(statement2);
    }

    @Override
    @NotNull
    public PathAwarePropertyInitializationInfo visitLoopEnterNode(@NotNull LoopEnterNode node, @NotNull Collection<? extends Pair<? extends EdgeLabel, PathAwarePropertyInitializationInfo>> data2) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(data2, "data");
        Set<FirPropertySymbol> declaredVariableSymbolsInLoop = this.enterCapturingStatement(node.getFir());
        if (declaredVariableSymbolsInLoop.isEmpty()) {
            return this.visitNode((CFGNode)node, data2);
        }
        return this.filterDeclaredVariableSymbolsInCapturedScope(node, (Collection<? extends FirPropertySymbol>)declaredVariableSymbolsInLoop, data2);
    }

    @Override
    @NotNull
    public PathAwarePropertyInitializationInfo visitLoopConditionEnterNode(@NotNull LoopConditionEnterNode node, @NotNull Collection<? extends Pair<? extends EdgeLabel, PathAwarePropertyInitializationInfo>> data2) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(data2, "data");
        Set declaredVariableSymbolsInLoop = (Set)this.declaredVariableCollector.getDeclaredVariablesPerElement().get(node.getLoop());
        if (declaredVariableSymbolsInLoop.isEmpty()) {
            return this.visitNode((CFGNode)node, data2);
        }
        return this.filterDeclaredVariableSymbolsInCapturedScope(node, declaredVariableSymbolsInLoop, data2);
    }

    @Override
    @NotNull
    public PathAwarePropertyInitializationInfo visitLoopBlockEnterNode(@NotNull LoopBlockEnterNode node, @NotNull Collection<? extends Pair<? extends EdgeLabel, PathAwarePropertyInitializationInfo>> data2) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(data2, "data");
        Set declaredVariableSymbolsInLoop = (Set)this.declaredVariableCollector.getDeclaredVariablesPerElement().get(node.getFir());
        if (declaredVariableSymbolsInLoop.isEmpty()) {
            return this.visitNode((CFGNode)node, data2);
        }
        return this.filterDeclaredVariableSymbolsInCapturedScope(node, declaredVariableSymbolsInLoop, data2);
    }

    /*
     * WARNING - void declaration
     */
    private final PathAwarePropertyInitializationInfo filterDeclaredVariableSymbolsInCapturedScope(CFGNode<?> node, Collection<? extends FirPropertySymbol> declaredVariableSymbolsInCapturedScope, Collection<? extends Pair<? extends EdgeLabel, PathAwarePropertyInitializationInfo>> data2) {
        Collection filteredData = data2;
        for (FirPropertySymbol firPropertySymbol : declaredVariableSymbolsInCapturedScope) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = filteredData;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                EdgeLabel label = (EdgeLabel)pair.component1();
                PathAwarePropertyInitializationInfo pathAwareInfo = (PathAwarePropertyInitializationInfo)pair.component2();
                collection.add(TuplesKt.to(label, label instanceof LoopBackPath ? (PathAwarePropertyInitializationInfo)PropertyInitializationInfoCollectorKt.access$removeRange(pathAwareInfo, firPropertySymbol, filterDeclaredVariableSymbolsInCapturedScope.1.1.INSTANCE) : pathAwareInfo));
            }
            filteredData = (List)destination$iv$iv;
        }
        return this.visitNode(node, filteredData);
    }

    @Override
    @NotNull
    public PathAwarePropertyInitializationInfo visitLoopExitNode(@NotNull LoopExitNode node, @NotNull Collection<? extends Pair<? extends EdgeLabel, PathAwarePropertyInitializationInfo>> data2) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.exitCapturingStatement(node.getFir());
        return this.visitNode((CFGNode)node, data2);
    }
}

