/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.MutableDiagnosticContext;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirInlineDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollectorVisitor;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirExpressionWithSmartcast;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLambdaArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PublishedApiEffectiveVisibilityKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001%B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J%\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u000eJ(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J6\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00162\u0014\u0010\u0018\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\u001a0\u00192\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J(\u0010\u001f\u001a\u00020\u0006*\u00020 2\u0006\u0010!\u001a\u00020\t2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0#H\u0002J\"\u0010$\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\u001a0\u0019*\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkCallableDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "checkCallableDeclaration$checkers", "checkCanBeInlined", "", "effectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "checkInlineFunctionBody", "function", "checkNothingToInline", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "checkParameters", "overriddenSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "checkParametersInNotInline", "isInlinableDefaultValue", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkChildrenWithCustomVisitor", "Lorg/jetbrains/kotlin/fir/FirElement;", "parentContext", "visitorVoid", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "getOverriddenSymbols", "Visitor", "checkers"})
public final class FirInlineDeclarationChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirInlineDeclarationChecker INSTANCE = new FirInlineDeclarationChecker();

    private FirInlineDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        CheckerContext ctx;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter2, "reporter");
        FirMemberDeclaration $this$isInline$iv = declaration;
        boolean $i$f$isInline = false;
        if (!$this$isInline$iv.getStatus().isInline()) {
            this.checkParametersInNotInline(declaration, context, reporter2);
            return;
        }
        if (DeclarationUtilsKt.isLocalMember(declaration)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getNOT_YET_SUPPORTED_IN_INLINE(), (Object)"Local inline functions", (DiagnosticContext)context, null, 16, null);
            return;
        }
        if (!(declaration instanceof FirPropertyAccessor) && !(declaration instanceof FirSimpleFunction)) {
            return;
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        Object effectiveVisibility = object;
        boolean $i$f$withSuppressedDiagnostics = false;
        List<String> arguments$iv = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(declaration);
        if (arguments$iv != null) {
            DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context).addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
            if (diagnosticContext == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
            }
            ctx = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
            boolean bl = false;
            INSTANCE.checkInlineFunctionBody(declaration, (EffectiveVisibility)effectiveVisibility, ctx, reporter2);
            INSTANCE.checkCallableDeclaration$checkers(declaration, ctx, reporter2);
        } else {
            ctx = (CheckerContext)((MutableDiagnosticContext)context);
            boolean bl = false;
            INSTANCE.checkInlineFunctionBody(declaration, (EffectiveVisibility)effectiveVisibility, ctx, reporter2);
            INSTANCE.checkCallableDeclaration$checkers(declaration, ctx, reporter2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkInlineFunctionBody(FirFunction function, EffectiveVisibility effectiveVisibility, CheckerContext context, DiagnosticReporter reporter) {
        v0 = function.getBody();
        if (v0 == null) {
            return;
        }
        body = v0;
        $this$filter$iv = function.getValueParameters();
        $i$f$filter = false;
        var9_8 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block8: {
                block7: {
                    it = (FirValueParameter)element$iv$iv;
                    $i$a$-filter-FirInlineDeclarationChecker$checkInlineFunctionBody$inalienableParameters$1 = false;
                    if (!it.isNoinline()) break block7;
                    v1 = false;
                    break block8;
                }
                type = FirTypeUtilsKt.getConeType(it.getReturnTypeRef());
                if (ConeTypeUtilsKt.isMarkedNullable(type)) ** GOTO lbl-1000
                var17_16 = type;
                session$iv = context.getSession();
                $i$f$isFunctionalType = false;
                if (InferenceUtilsKt.functionClassKind((ConeKotlinType)$this$isFunctionalType$iv, session$iv) == null) {
                    v2 = false;
                } else {
                    kind = kind$iv;
                    $i$a$-isFunctionalType-FirInlineDeclarationChecker$checkInlineFunctionBody$inalienableParameters$1$1 = false;
                    v2 = kind.isReflectType() == false;
                }
                if (v2) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            it = (FirValueParameter)item$iv$iv;
            var23_22 = destination$iv$iv;
            $i$a$-map-FirInlineDeclarationChecker$checkInlineFunctionBody$inalienableParameters$2 = false;
            var23_22.add(it.getSymbol());
        }
        inalienableParameters = (List)destination$iv$iv;
        visitor = new Visitor(function, effectiveVisibility, inalienableParameters, context.getSession(), reporter);
        context.withDeclaration(function, (Function1)new Function1<CheckerContext, Unit>(body, visitor){
            final /* synthetic */ FirBlock $body;
            final /* synthetic */ Visitor $visitor;
            {
                this.$body = $body;
                this.$visitor = $visitor;
                super(1);
            }

            public final void invoke(@NotNull CheckerContext it) {
                Intrinsics.checkNotNullParameter(it, "it");
                FirInlineDeclarationChecker.access$checkChildrenWithCustomVisitor(FirInlineDeclarationChecker.INSTANCE, this.$body, it, this.$visitor);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void checkParameters(FirSimpleFunction function2, List<? extends FirCallableSymbol<? extends FirCallableDeclaration>> overriddenSymbols2, CheckerContext context, DiagnosticReporter reporter2) {
        boolean bl;
        void $this$flatMapTo$iv$iv;
        for (FirValueParameter firValueParameter : function2.getValueParameters()) {
            ConeKotlinType coneType = FirTypeUtilsKt.getConeType(firValueParameter.getReturnTypeRef());
            boolean isFunctionalType = InferenceUtilsKt.isFunctionalType(coneType, context.getSession());
            boolean isSuspendFunctionalType = InferenceUtilsKt.isSuspendFunctionType(coneType, context.getSession());
            FirExpression defaultValue = firValueParameter.getDefaultValue();
            if (!isFunctionalType && !isSuspendFunctionalType && (firValueParameter.isNoinline() || firValueParameter.isCrossinline())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)firValueParameter.getSource(), FirErrors.INSTANCE.getILLEGAL_INLINE_PARAMETER_MODIFIER(), (DiagnosticContext)context, null, 8, null);
            }
            if (firValueParameter.isNoinline()) continue;
            FirMemberDeclaration $this$isSuspend$iv = function2;
            boolean $i$f$isSuspend = false;
            if ($this$isSuspend$iv.getStatus().isSuspend() && defaultValue != null && isSuspendFunctionalType) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)firValueParameter.getSource(), FirErrors.INSTANCE.getNOT_YET_SUPPORTED_IN_INLINE(), (Object)"Suspend functional parameters with default values", (DiagnosticContext)context, null, 16, null);
            }
            if (isSuspendFunctionalType && !firValueParameter.isCrossinline()) {
                $this$isSuspend$iv = function2;
                $i$f$isSuspend = false;
                if ($this$isSuspend$iv.getStatus().isSuspend()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)firValueParameter.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getREDUNDANT_INLINE_SUSPEND_FUNCTION_TYPE(), (DiagnosticContext)context, null, 8, null);
                } else {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)firValueParameter.getSource(), FirErrors.INSTANCE.getINLINE_SUSPEND_FUNCTION_TYPE_UNSUPPORTED(), (DiagnosticContext)context, null, 8, null);
                }
            }
            if (ConeTypeUtilsKt.isNullable(coneType) && isFunctionalType) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)firValueParameter.getSource(), FirErrors.INSTANCE.getNULLABLE_INLINE_PARAMETER(), (Object)firValueParameter.getSymbol(), (Object)function2.getSymbol(), (DiagnosticContext)context, null, 32, null);
            }
            if (!isFunctionalType || defaultValue == null || this.isInlinableDefaultValue(defaultValue)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)defaultValue.getSource(), FirErrors.INSTANCE.getINVALID_DEFAULT_FUNCTIONAL_PARAMETER_FOR_INLINE(), (Object)defaultValue, (Object)firValueParameter.getSymbol(), (DiagnosticContext)context, null, 32, null);
        }
        if (!((Collection)overriddenSymbols2).isEmpty()) {
            for (FirTypeParameter firTypeParameter : function2.getTypeParameters()) {
                if (!firTypeParameter.isReified()) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)firTypeParameter.getSource(), FirErrors.INSTANCE.getREIFIED_TYPE_PARAMETER_IN_OVERRIDE(), (DiagnosticContext)context, null, 8, null);
            }
        }
        Iterable iterable = overriddenSymbols2;
        boolean $i$f$flatMap = false;
        Iterable isFunctionalType = iterable;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list2;
            FirCallableSymbol it = (FirCallableSymbol)element$iv$iv;
            bl = false;
            if (!(it instanceof FirFunctionSymbol)) {
                list2 = CollectionsKt.emptyList();
            } else {
                void $this$mapIndexedNotNullTo$iv$iv;
                Iterable $this$mapIndexedNotNull$iv = ((FirFunctionSymbol)it).getValueParameterSymbols();
                boolean $i$f$mapIndexedNotNull = false;
                Iterable iterable2 = $this$mapIndexedNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapIndexedNotNullTo = false;
                void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv$iv$iv = 0;
                for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                    Integer it$iv$iv;
                    void param;
                    void element$iv$iv2;
                    int n;
                    if ((n = index$iv$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t = item$iv$iv$iv;
                    int index$iv$iv = n;
                    boolean bl2 = false;
                    FirValueParameterSymbol firValueParameterSymbol = (FirValueParameterSymbol)element$iv$iv2;
                    int idx = index$iv$iv;
                    boolean bl3 = false;
                    Integer n2 = idx;
                    int it2 = ((Number)n2).intValue();
                    boolean bl4 = false;
                    if ((param.getHasDefaultValue() ? n2 : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv2;
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Set paramsWithDefaults = CollectionsKt.toSet((List)destination$iv$iv);
        Iterable iterable3 = function2.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : iterable3) {
            void param;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirValueParameter element$iv$iv = (FirValueParameter)item$iv;
            int idx = n;
            bl = false;
            if (param.getDefaultValue() != null || !paramsWithDefaults.contains(idx)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)param.getSource(), FirErrors.INSTANCE.getNOT_YET_SUPPORTED_IN_INLINE(), (Object)"Functional parameters with inherited default values", (DiagnosticContext)context, null, 16, null);
        }
    }

    private final void checkParametersInNotInline(FirFunction function2, CheckerContext context, DiagnosticReporter reporter2) {
        for (FirValueParameter param : function2.getValueParameters()) {
            if (!param.isNoinline() && !param.isCrossinline()) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)param.getSource(), FirErrors.INSTANCE.getILLEGAL_INLINE_PARAMETER_MODIFIER(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final List<FirCallableSymbol<? extends FirCallableDeclaration>> getOverriddenSymbols(FirCallableDeclaration $this$getOverriddenSymbols, CheckerContext context) {
        FirMemberDeclaration $this$isOverride$iv = $this$getOverriddenSymbols;
        boolean $i$f$isOverride = false;
        if (!$this$isOverride$iv.getStatus().isOverride()) {
            return CollectionsKt.emptyList();
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass($this$getOverriddenSymbols);
        FirClassLikeSymbol<?> firClassLikeSymbol = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context.getSession()) : null;
        FirClassSymbol firClassSymbol = firClassLikeSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassLikeSymbol : null;
        if (firClassSymbol == null) {
            return CollectionsKt.emptyList();
        }
        FirClassSymbol classSymbol = firClassSymbol;
        FirTypeScope scope2 = FirHelpersKt.unsubstitutedScope(classSymbol, context);
        scope2.processFunctionsByName($this$getOverriddenSymbols.getSymbol().getName(), getOverriddenSymbols.1.INSTANCE);
        return FirTypeScopeKt.getDirectOverriddenMembers(scope2, $this$getOverriddenSymbols.getSymbol(), true);
    }

    private final void checkNothingToInline(FirSimpleFunction function2, CheckerContext context, DiagnosticReporter reporter2) {
        boolean hasInlinableParameters;
        block14: {
            boolean bl;
            boolean bl2;
            block13: {
                block16: {
                    block15: {
                        FirMemberDeclaration $this$isExpect$iv = function2;
                        boolean $i$f$isExpect = false;
                        if ($this$isExpect$iv.getStatus().isExpect()) break block15;
                        FirMemberDeclaration $this$isSuspend$iv = function2;
                        boolean $i$f$isSuspend = false;
                        if (!$this$isSuspend$iv.getStatus().isSuspend()) break block16;
                    }
                    return;
                }
                Iterable $this$any$iv = function2.getTypeParameters();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeParameter it = (FirTypeParameter)element$iv;
                        boolean bl3 = false;
                        if (!it.getSymbol().isReified()) continue;
                        bl2 = true;
                        break block13;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return;
            }
            Iterable $this$any$iv = function2.getValueParameters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirValueParameter param = (FirValueParameter)element$iv;
                    boolean bl4 = false;
                    ConeKotlinType type2 = FirTypeUtilsKt.getConeType(param.getReturnTypeRef());
                    boolean bl5 = !param.isNoinline() && !ConeTypeUtilsKt.isNullable(type2) && (InferenceUtilsKt.isFunctionalType(type2, context.getSession()) || InferenceUtilsKt.isSuspendFunctionType(type2, context.getSession()));
                    if (!bl5) continue;
                    bl = true;
                    break block14;
                }
                bl = hasInlinableParameters = false;
            }
        }
        if (hasInlinableParameters) {
            return;
        }
        if (FirHelpersKt.isInlineOnly(function2)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)function2.getSource(), FirErrors.INSTANCE.getNOTHING_TO_INLINE(), (DiagnosticContext)context, null, 8, null);
    }

    private final boolean checkCanBeInlined(FirCallableDeclaration declaration, EffectiveVisibility effectiveVisibility, CheckerContext context, DiagnosticReporter reporter2) {
        Modality modality$iv;
        if (ClassMembersKt.containingClass(declaration) == null) {
            return true;
        }
        if (Intrinsics.areEqual(effectiveVisibility, EffectiveVisibility.PrivateInClass.INSTANCE)) {
            return true;
        }
        FirMemberDeclaration $this$isFinal$iv = declaration;
        boolean $i$f$isFinal = false;
        Modality modality = $this$isFinal$iv.getStatus().getModality();
        if (!(modality == null ? true : (modality$iv = modality) == Modality.FINAL)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getDECLARATION_CANT_BE_INLINED(), (DiagnosticContext)context, null, 8, null);
            return false;
        }
        return true;
    }

    private final boolean isInlinableDefaultValue(FirExpression expression2) {
        return expression2 instanceof FirCallableReferenceAccess || expression2 instanceof FirFunctionCall || expression2 instanceof FirLambdaArgumentExpression || expression2 instanceof FirAnonymousFunctionExpression || expression2 instanceof FirConstExpression && ((FirConstExpression)expression2).getValue() == null;
    }

    public final void checkCallableDeclaration$checkers(@NotNull FirCallableDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        boolean canBeInlined;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter2, "reporter");
        if (declaration instanceof FirPropertyAccessor) {
            return;
        }
        List<FirCallableSymbol<? extends FirCallableDeclaration>> overriddenSymbols2 = this.getOverriddenSymbols(declaration, context);
        if (declaration instanceof FirSimpleFunction) {
            this.checkParameters((FirSimpleFunction)declaration, overriddenSymbols2, context, reporter2);
            this.checkNothingToInline((FirSimpleFunction)declaration, context, reporter2);
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if ((canBeInlined = this.checkCanBeInlined(declaration, (EffectiveVisibility)object, context, reporter2)) && !((Collection)overriddenSymbols2).isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getOVERRIDE_BY_INLINE(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final void checkChildrenWithCustomVisitor(FirElement $this$checkChildrenWithCustomVisitor, CheckerContext parentContext, FirVisitor<Unit, ? super CheckerContext> visitorVoid) {
        AbstractDiagnosticCollectorVisitor collectingVisitor2 = new AbstractDiagnosticCollectorVisitor(parentContext, visitorVoid){
            final /* synthetic */ FirVisitor<Unit, CheckerContext> $visitorVoid;
            {
                this.$visitorVoid = $visitorVoid;
                super($parentContext);
            }

            protected void checkElement(@NotNull FirElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                element.accept(this.$visitorVoid, this.getContext());
            }
        };
        $this$checkChildrenWithCustomVisitor.accept(collectingVisitor2, null);
    }

    public static final /* synthetic */ void access$checkChildrenWithCustomVisitor(FirInlineDeclarationChecker $this, FirElement $receiver, CheckerContext parentContext, FirVisitor visitorVoid) {
        $this.checkChildrenWithCustomVisitor($receiver, parentContext, visitorVoid);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ&\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0003H\u0002J$\u0010#\u001a\u00020\u00022\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020\u0003H\u0002J&\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*2\f\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0003H\u0002J.\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\f\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0003H\u0002J&\u00100\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-2\f\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0003H\u0002J$\u00101\u001a\u00020\u00022\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020\u0003H\u0002J$\u00102\u001a\u00020\u00022\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u00103\u001a\u00020*2\u0006\u0010\"\u001a\u00020\u0003H\u0002J.\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u00020*2\f\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u0016\u00106\u001a\u00020\u00172\f\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010!H\u0002J\u0018\u00107\u001a\u00020\u00022\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0003H\u0016J\u0018\u0010;\u001a\u00020\u00022\u0006\u0010<\u001a\u00020=2\u0006\u0010:\u001a\u00020\u0003H\u0016J\u0018\u0010>\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020\u0003H\u0016J\u0018\u0010?\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-2\u0006\u0010:\u001a\u00020\u0003H\u0016J\u0018\u0010@\u001a\u00020\u00022\u0006\u0010A\u001a\u00020B2\u0006\u0010:\u001a\u00020\u0003H\u0016J\u0018\u0010C\u001a\u00020\u00022\u0006\u0010D\u001a\u00020E2\u0006\u0010:\u001a\u00020\u0003H\u0016J\u0018\u0010F\u001a\u00020\u00022\u0006\u0010G\u001a\u00020H2\u0006\u0010:\u001a\u00020\u0003H\u0016J\u0010\u0010I\u001a\u00020\u0017*\u0006\u0012\u0002\b\u00030JH\u0002J\u0010\u0010K\u001a\u00020\u0017*\u0006\u0012\u0002\b\u00030%H\u0002J\u0014\u0010L\u001a\u00020\u0017*\u00020*2\u0006\u0010\"\u001a\u00020\u0003H\u0002R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006M"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$Visitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "inlineFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "inlineFunEffectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "inalienableParameters", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;Ljava/util/List;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "getInalienableParameters", "()Ljava/util/List;", "getInlineFunEffectiveVisibility", "()Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "getInlineFunction", "()Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "isEffectivelyPrivateApiFunction", "", "prohibitProtectedCallFromInline", "getReporter", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "checkArgumentsOfCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "targetSymbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "context", "checkPrivateClassMemberAccess", "calledDeclaration", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkQualifiedAccess", "qualifiedAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;", "checkReceiver", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "receiverExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkReceiversOfQualifiedAccessExpression", "checkRecursion", "checkSuperCalls", "callExpression", "checkVisibilityAndAccess", "accessExpression", "isInvokeOrInlineExtension", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitExpressionWithSmartcast", "expressionWithSmartcast", "Lorg/jetbrains/kotlin/fir/expressions/FirExpressionWithSmartcast;", "visitFunctionCall", "visitQualifiedAccessExpression", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitVariableAssignment", "variableAssignment", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "isDefinedInInlineFunction", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "isInsidePrivateClass", "partOfCall", "checkers"})
    private static final class Visitor
    extends FirDefaultVisitor<Unit, CheckerContext> {
        @NotNull
        private final FirFunction inlineFunction;
        @NotNull
        private final EffectiveVisibility inlineFunEffectiveVisibility;
        @NotNull
        private final List<FirValueParameterSymbol> inalienableParameters;
        @NotNull
        private final FirSession session;
        @NotNull
        private final DiagnosticReporter reporter;
        private final boolean isEffectivelyPrivateApiFunction;
        private final boolean prohibitProtectedCallFromInline;

        public Visitor(@NotNull FirFunction inlineFunction2, @NotNull EffectiveVisibility inlineFunEffectiveVisibility, @NotNull List<FirValueParameterSymbol> inalienableParameters, @NotNull FirSession session2, @NotNull DiagnosticReporter reporter2) {
            Intrinsics.checkNotNullParameter(inlineFunction2, "inlineFunction");
            Intrinsics.checkNotNullParameter(inlineFunEffectiveVisibility, "inlineFunEffectiveVisibility");
            Intrinsics.checkNotNullParameter(inalienableParameters, "inalienableParameters");
            Intrinsics.checkNotNullParameter(session2, "session");
            Intrinsics.checkNotNullParameter(reporter2, "reporter");
            this.inlineFunction = inlineFunction2;
            this.inlineFunEffectiveVisibility = inlineFunEffectiveVisibility;
            this.inalienableParameters = inalienableParameters;
            this.session = session2;
            this.reporter = reporter2;
            this.isEffectivelyPrivateApiFunction = this.inlineFunEffectiveVisibility.getPrivateApi();
            this.prohibitProtectedCallFromInline = FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session).supportsFeature(LanguageFeature.ProhibitProtectedCallFromInline);
        }

        @NotNull
        public final FirFunction getInlineFunction() {
            return this.inlineFunction;
        }

        @NotNull
        public final EffectiveVisibility getInlineFunEffectiveVisibility() {
            return this.inlineFunEffectiveVisibility;
        }

        @NotNull
        public final List<FirValueParameterSymbol> getInalienableParameters() {
            return this.inalienableParameters;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        @NotNull
        public final DiagnosticReporter getReporter() {
            return this.reporter;
        }

        @Override
        public void visitElement(@NotNull FirElement element, @NotNull CheckerContext data2) {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(data2, "data");
        }

        @Override
        public void visitFunctionCall(@NotNull FirFunctionCall functionCall, @NotNull CheckerContext data2) {
            Intrinsics.checkNotNullParameter(functionCall, "functionCall");
            Intrinsics.checkNotNullParameter(data2, "data");
            FirCallableSymbol<?> targetSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(functionCall);
            if (targetSymbol != null) {
                this.checkReceiversOfQualifiedAccessExpression(functionCall, (FirBasedSymbol)targetSymbol, data2);
                this.checkArgumentsOfCall(functionCall, (FirBasedSymbol)targetSymbol, data2);
                this.checkQualifiedAccess(functionCall, (FirBasedSymbol)targetSymbol, data2);
            }
        }

        @Override
        public void visitQualifiedAccessExpression(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression, @NotNull CheckerContext data2) {
            Intrinsics.checkNotNullParameter(qualifiedAccessExpression, "qualifiedAccessExpression");
            Intrinsics.checkNotNullParameter(data2, "data");
            FirCallableSymbol<?> targetSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(qualifiedAccessExpression);
            this.checkQualifiedAccess(qualifiedAccessExpression, (FirBasedSymbol)targetSymbol, data2);
            this.checkReceiversOfQualifiedAccessExpression(qualifiedAccessExpression, (FirBasedSymbol)targetSymbol, data2);
        }

        @Override
        public void visitExpressionWithSmartcast(@NotNull FirExpressionWithSmartcast expressionWithSmartcast, @NotNull CheckerContext data2) {
            Intrinsics.checkNotNullParameter(expressionWithSmartcast, "expressionWithSmartcast");
            Intrinsics.checkNotNullParameter(data2, "data");
        }

        @Override
        public void visitVariableAssignment(@NotNull FirVariableAssignment variableAssignment, @NotNull CheckerContext data2) {
            Intrinsics.checkNotNullParameter(variableAssignment, "variableAssignment");
            Intrinsics.checkNotNullParameter(data2, "data");
            FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(variableAssignment.getCalleeReference());
            FirPropertySymbol firPropertySymbol = firCallableSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)firCallableSymbol : null;
            if (firPropertySymbol == null) {
                return;
            }
            FirPropertySymbol propertySymbol = firPropertySymbol;
            FirPropertyAccessorSymbol firPropertyAccessorSymbol = propertySymbol.getSetterSymbol();
            if (firPropertyAccessorSymbol == null) {
                return;
            }
            FirPropertyAccessorSymbol setterSymbol = firPropertyAccessorSymbol;
            this.checkQualifiedAccess(variableAssignment, setterSymbol, data2);
        }

        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull CheckerContext data2) {
            Intrinsics.checkNotNullParameter(regularClass, "regularClass");
            Intrinsics.checkNotNullParameter(data2, "data");
            if (!regularClass.getClassKind().isSingleton() && CollectionsKt.lastOrNull(data2.getContainingDeclarations()) == this.inlineFunction) {
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)regularClass.getSource(), FirErrors.INSTANCE.getNOT_YET_SUPPORTED_IN_INLINE(), (Object)"Local classes", (DiagnosticContext)data2, null, 16, null);
            } else {
                super.visitRegularClass(regularClass, data2);
            }
        }

        @Override
        public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull CheckerContext data2) {
            Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
            Intrinsics.checkNotNullParameter(data2, "data");
            if (CollectionsKt.lastOrNull(data2.getContainingDeclarations()) == this.inlineFunction) {
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)simpleFunction.getSource(), FirErrors.INSTANCE.getNOT_YET_SUPPORTED_IN_INLINE(), (Object)"Local functions", (DiagnosticContext)data2, null, 16, null);
            } else {
                super.visitSimpleFunction(simpleFunction, data2);
            }
        }

        private final void checkReceiversOfQualifiedAccessExpression(FirQualifiedAccessExpression qualifiedAccessExpression, FirBasedSymbol<?> targetSymbol, CheckerContext context) {
            this.checkReceiver(qualifiedAccessExpression, qualifiedAccessExpression.getDispatchReceiver(), targetSymbol, context);
            this.checkReceiver(qualifiedAccessExpression, qualifiedAccessExpression.getExtensionReceiver(), targetSymbol, context);
        }

        private final void checkArgumentsOfCall(FirFunctionCall functionCall, FirBasedSymbol<?> targetSymbol, CheckerContext context) {
            FirNamedFunctionSymbol firNamedFunctionSymbol = targetSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)targetSymbol : null;
            if (firNamedFunctionSymbol == null) {
                return;
            }
            FirNamedFunctionSymbol calledFunctionSymbol = firNamedFunctionSymbol;
            FirCall $this$resolvedArgumentMapping$iv = functionCall;
            boolean $i$f$getResolvedArgumentMapping = false;
            FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
            Map map2 = argumentList$iv instanceof FirResolvedArgumentList ? (Map)((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
            if (map2 == null) {
                return;
            }
            Map argumentMapping = map2;
            for (Map.Entry entry : argumentMapping.entrySet()) {
                KtDiagnosticFactory1<FirBasedSymbol<?>> ktDiagnosticFactory1;
                FirValueParameterSymbol valueParameterOfOriginalInlineFunction;
                Object v2;
                FirExpression argument2;
                FirValueParameter valueParameter2;
                block8: {
                    FirVariableSymbol resolvedArgumentSymbol;
                    FirExpression wrappedArgument = (FirExpression)entry.getKey();
                    valueParameter2 = (FirValueParameter)entry.getValue();
                    argument2 = FirExpressionUtilKt.unwrapArgument(wrappedArgument);
                    FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(argument2);
                    if ((firCallableSymbol instanceof FirVariableSymbol ? (FirVariableSymbol)firCallableSymbol : null) == null) continue;
                    resolvedArgumentSymbol = resolvedArgumentSymbol;
                    Iterable $this$firstOrNull$iv = this.inalienableParameters;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it, resolvedArgumentSymbol)) continue;
                        v2 = element$iv;
                        break block8;
                    }
                    v2 = null;
                }
                if ((valueParameterOfOriginalInlineFunction = (FirValueParameterSymbol)v2) == null) continue;
                FirCallableSymbol $this$isInline$iv = calledFunctionSymbol;
                boolean $i$f$isInline = false;
                if ($this$isInline$iv.getResolvedStatus().isInline()) {
                    if (valueParameter2.isNoinline()) {
                        ktDiagnosticFactory1 = FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE();
                    } else {
                        if (!valueParameter2.isCrossinline() || valueParameterOfOriginalInlineFunction.isCrossinline()) continue;
                        ktDiagnosticFactory1 = FirErrors.INSTANCE.getNON_LOCAL_RETURN_NOT_ALLOWED();
                    }
                } else {
                    ktDiagnosticFactory1 = FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE();
                }
                KtDiagnosticFactory1<FirBasedSymbol<?>> factory2 = ktDiagnosticFactory1;
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)argument2.getSource(), factory2, (Object)valueParameterOfOriginalInlineFunction, (DiagnosticContext)context, null, 16, null);
            }
        }

        private final void checkReceiver(FirQualifiedAccessExpression qualifiedAccessExpression, FirExpression receiverExpression, FirBasedSymbol<?> targetSymbol, CheckerContext context) {
            FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(receiverExpression);
            if (firCallableSymbol == null) {
                return;
            }
            FirCallableSymbol<?> receiverSymbol = firCallableSymbol;
            if (CollectionsKt.contains((Iterable)this.inalienableParameters, receiverSymbol) && !this.isInvokeOrInlineExtension(targetSymbol)) {
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)qualifiedAccessExpression.getSource(), FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE(), receiverSymbol, (DiagnosticContext)context, null, 16, null);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isInvokeOrInlineExtension(FirBasedSymbol<?> targetSymbol) {
            if (!(targetSymbol instanceof FirNamedFunctionSymbol)) {
                return false;
            }
            FirCallableSymbol $this$isInline$iv = (FirCallableSymbol)targetSymbol;
            boolean $i$f$isInline = false;
            if ($this$isInline$iv.getResolvedStatus().isInline()) {
                return true;
            }
            if (!Intrinsics.areEqual(((FirNamedFunctionSymbol)targetSymbol).getName(), OperatorNameConventions.INVOKE)) return false;
            ConeSimpleKotlinType coneSimpleKotlinType = ((FirNamedFunctionSymbol)targetSymbol).getDispatchReceiverType();
            if (coneSimpleKotlinType == null) return false;
            if (!InferenceUtilsKt.isBuiltinFunctionalType(coneSimpleKotlinType, this.session)) return false;
            return true;
        }

        private final void checkQualifiedAccess(FirQualifiedAccess qualifiedAccess, FirBasedSymbol<?> targetSymbol, CheckerContext context) {
            KtSourceElement ktSourceElement = qualifiedAccess.getSource();
            if (ktSourceElement == null) {
                return;
            }
            KtSourceElement source = ktSourceElement;
            if (!(targetSymbol instanceof FirCallableSymbol)) {
                return;
            }
            if (CollectionsKt.contains((Iterable)this.inalienableParameters, targetSymbol) && !this.partOfCall(qualifiedAccess, context)) {
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE(), targetSymbol, (DiagnosticContext)context, null, 16, null);
            }
            this.checkVisibilityAndAccess(qualifiedAccess, (FirCallableSymbol)targetSymbol, source, context);
            this.checkRecursion(targetSymbol, source, context);
        }

        /*
         * WARNING - void declaration
         */
        private final boolean partOfCall(FirQualifiedAccess $this$partOfCall, CheckerContext context) {
            boolean bl;
            block7: {
                void $this$any$iv;
                if (!($this$partOfCall instanceof FirExpression)) {
                    return false;
                }
                FirStatement firStatement = CollectionsKt.getOrNull(context.getQualifiedAccessOrAnnotationCalls(), context.getQualifiedAccessOrAnnotationCalls().size() - 2);
                if (firStatement == null) {
                    return false;
                }
                FirStatement containingQualifiedAccess = firStatement;
                FirQualifiedAccess firQualifiedAccess = containingQualifiedAccess instanceof FirQualifiedAccess ? (FirQualifiedAccess)containingQualifiedAccess : null;
                if (Intrinsics.areEqual($this$partOfCall, firQualifiedAccess != null ? firQualifiedAccess.getExplicitReceiver() : null)) {
                    return true;
                }
                FirCall firCall = containingQualifiedAccess instanceof FirCall ? (FirCall)containingQualifiedAccess : null;
                if (firCall == null) {
                    return false;
                }
                FirCall call2 = firCall;
                Object $this$arguments$iv = call2;
                boolean $i$f$getArguments = false;
                $this$arguments$iv = $this$arguments$iv.getArgumentList().getArguments();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirExpression it = (FirExpression)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(FirExpressionUtilKt.unwrapArgument(it), $this$partOfCall)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * Unable to fully structure code
         */
        private final void checkVisibilityAndAccess(FirQualifiedAccess accessExpression, FirCallableSymbol<?> calledDeclaration, KtSourceElement source, CheckerContext context) {
            if (calledDeclaration == null || Intrinsics.areEqual(calledDeclaration.getCallableId().getCallableName(), StandardNames.BACKING_FIELD)) {
                return;
            }
            $this$publishedApiEffectiveVisibility$iv = calledDeclaration;
            $i$f$getPublishedApiEffectiveVisibility = false;
            FirPhaseManagerKt.ensureResolved((FirBasedSymbol)$this$publishedApiEffectiveVisibility$iv, FirResolvePhase.STATUS);
            v0 = PublishedApiEffectiveVisibilityKt.getPublishedApiEffectiveVisibility($this$publishedApiEffectiveVisibility$iv.getFir());
            if (v0 == null) {
                $this$effectiveVisibility$iv = calledDeclaration;
                $i$f$getEffectiveVisibility = false;
                v0 = $this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility();
            }
            it = recordedEffectiveVisibility = v0;
            $i$a$-let-FirInlineDeclarationChecker$Visitor$checkVisibilityAndAccess$calledFunEffectiveVisibility$1 = false;
            calledFunEffectiveVisibility = Intrinsics.areEqual(it, EffectiveVisibility.Local.INSTANCE) ? (EffectiveVisibility)EffectiveVisibility.Public.INSTANCE : it;
            isCalledFunPublicOrPublishedApi = calledFunEffectiveVisibility.getPublicApi();
            isInlineFunPublicOrPublishedApi = this.inlineFunEffectiveVisibility.getPublicApi();
            if (!isInlineFunPublicOrPublishedApi || isCalledFunPublicOrPublishedApi) ** GOTO lbl-1000
            $this$visibility$iv = calledDeclaration;
            $i$f$getVisibility = false;
            if ($this$visibility$iv.getResolvedStatus().getVisibility() != Visibilities.Local.INSTANCE) {
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNON_PUBLIC_CALL_FROM_PUBLIC_INLINE(), calledDeclaration, this.inlineFunction.getSymbol(), (DiagnosticContext)context, null, 32, null);
            } else lbl-1000:
            // 2 sources

            {
                this.checkPrivateClassMemberAccess(calledDeclaration, source, context);
                if (isInlineFunPublicOrPublishedApi) {
                    this.checkSuperCalls(calledDeclaration, accessExpression, context);
                }
            }
            isConstructorCall = calledDeclaration instanceof FirConstructorSymbol;
            if (isInlineFunPublicOrPublishedApi && this.inlineFunEffectiveVisibility.toVisibility() != Visibilities.Protected.INSTANCE && calledFunEffectiveVisibility.toVisibility() == Visibilities.Protected.INSTANCE) {
                factory = isConstructorCall != false ? FirErrors.INSTANCE.getPROTECTED_CONSTRUCTOR_CALL_FROM_PUBLIC_INLINE() : (this.prohibitProtectedCallFromInline != false ? FirErrors.INSTANCE.getPROTECTED_CALL_FROM_PUBLIC_INLINE_ERROR() : FirErrors.INSTANCE.getPROTECTED_CALL_FROM_PUBLIC_INLINE());
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)source, factory, calledDeclaration, this.inlineFunction.getSymbol(), (DiagnosticContext)context, null, 32, null);
            }
        }

        private final void checkPrivateClassMemberAccess(FirCallableSymbol<?> calledDeclaration, KtSourceElement source, CheckerContext context) {
            if (!this.isEffectivelyPrivateApiFunction && this.isInsidePrivateClass(calledDeclaration)) {
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getPRIVATE_CLASS_MEMBER_FROM_INLINE(), calledDeclaration, this.inlineFunction.getSymbol(), (DiagnosticContext)context, null, 32, null);
            }
        }

        private final void checkSuperCalls(FirCallableSymbol<?> calledDeclaration, FirQualifiedAccess callExpression, CheckerContext context) {
            FirExpression firExpression2 = callExpression.getDispatchReceiver();
            FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
            if (firQualifiedAccessExpression == null) {
                return;
            }
            FirQualifiedAccessExpression receiver2 = firQualifiedAccessExpression;
            if (receiver2.getCalleeReference() instanceof FirSuperReference) {
                ConeKotlinType dispatchReceiverType = FirTypeUtilsKt.getConeType(receiver2.getDispatchReceiver().getTypeRef());
                FirClassifierSymbol<?> firClassifierSymbol = TypeUtilsKt.toSymbol(dispatchReceiverType, this.session);
                if (firClassifierSymbol == null) {
                    return;
                }
                FirClassifierSymbol<?> classSymbol = firClassifierSymbol;
                if (!this.isDefinedInInlineFunction(classSymbol)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)callExpression.getDispatchReceiver().getSource(), FirErrors.INSTANCE.getSUPER_CALL_FROM_PUBLIC_INLINE(), calledDeclaration, (DiagnosticContext)context, null, 16, null);
                }
            }
        }

        private final boolean isDefinedInInlineFunction(FirClassifierSymbol<?> $this$isDefinedInInlineFunction) {
            boolean bl;
            FirClassifierSymbol<?> symbol2 = $this$isDefinedInInlineFunction;
            if (symbol2 instanceof FirAnonymousObjectSymbol) {
                bl = true;
            } else if (symbol2 instanceof FirRegularClassSymbol) {
                bl = ((FirRegularClassSymbol)symbol2).getClassId().isLocal();
            } else {
                if (symbol2 instanceof FirTypeAliasSymbol ? true : symbol2 instanceof FirTypeParameterSymbol) {
                    throw new IllegalStateException(("Unexpected classifier declaration type: " + symbol2).toString());
                }
                throw new NoWhenBranchMatchedException();
            }
            return bl;
        }

        private final void checkRecursion(FirBasedSymbol<?> targetSymbol, KtSourceElement source, CheckerContext context) {
            if (Intrinsics.areEqual(targetSymbol, this.inlineFunction.getSymbol())) {
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getRECURSION_IN_INLINE(), targetSymbol, (DiagnosticContext)context, null, 16, null);
            }
        }

        private final boolean isInsidePrivateClass(FirCallableSymbol<?> $this$isInsidePrivateClass) {
            Visibility visibility2;
            boolean $i$f$getVisibility;
            FirClassLikeSymbol $this$visibility$iv;
            Object object = ClassMembersKt.containingClass($this$isInsidePrivateClass);
            if (object == null || (object = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, this.session)) == null) {
                return false;
            }
            Object containingClassSymbol = object;
            Object object2 = containingClassSymbol;
            if (object2 instanceof FirAnonymousObjectSymbol) {
                return false;
            }
            if (object2 instanceof FirRegularClassSymbol) {
                $this$visibility$iv = (FirClassSymbol)containingClassSymbol;
                $i$f$getVisibility = false;
                visibility2 = ((FirClassSymbol)$this$visibility$iv).getResolvedStatus().getVisibility();
            } else if (object2 instanceof FirTypeAliasSymbol) {
                $this$visibility$iv = (FirTypeAliasSymbol)containingClassSymbol;
                $i$f$getVisibility = false;
                visibility2 = ((FirTypeAliasSymbol)$this$visibility$iv).getResolvedStatus().getVisibility();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Visibility containingClassVisibility = visibility2;
            return Intrinsics.areEqual(containingClassVisibility, Visibilities.Private.INSTANCE) || Intrinsics.areEqual(containingClassVisibility, Visibilities.PrivateToThis.INSTANCE);
        }
    }
}

