/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentsKt;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.InapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.calls.MultipleContextReceiversApplicableForExtensionReceivers;
import org.jetbrains.kotlin.fir.resolve.calls.ReceiverDescription;
import org.jetbrains.kotlin.fir.resolve.calls.ReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionStage;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionStagesKt;
import org.jetbrains.kotlin.fir.resolve.inference.ConstraintSystemCompleterKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ?\u0010\u000e\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0013*\u00020\u0006H\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/CheckExtensionReceiver;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionStage;", "()V", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolveExtensionReceiver", "receivers", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverDescription;", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Ljava/util/List;Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getExpectedReceiverType", "resolve"})
public final class CheckExtensionReceiver
extends ResolutionStage {
    @NotNull
    public static final CheckExtensionReceiver INSTANCE = new CheckExtensionReceiver();

    private CheckExtensionReceiver() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate2, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context, @NotNull Continuation<? super Unit> $completion) {
        ResolutionDiagnostic diagnostic$iv;
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        ConeKotlinType coneKotlinType = this.getExpectedReceiverType(candidate2);
        if (coneKotlinType == null) {
            return Unit.INSTANCE;
        }
        ConeKotlinType expectedReceiverType = coneKotlinType;
        ConeKotlinType expectedType = candidate2.getSubstitutor().substituteOrSelf(expectedReceiverType.getType());
        if (candidate2.getGivenExtensionReceiverOptions().isEmpty()) {
            return Unit.INSTANCE;
        }
        Iterable $this$map$iv = candidate2.getGivenExtensionReceiverOptions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ReceiverValue receiverValue = (ReceiverValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ResolutionStagesKt.access$prepareReceivers(candidate2, (ReceiverValue)it, expectedType, context));
        }
        List preparedReceivers = (List)destination$iv$iv;
        if (preparedReceivers.size() == 1) {
            Object object = this.resolveExtensionReceiver(preparedReceivers, candidate2, expectedType, sink, context, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Iterable $this$filter$iv = preparedReceivers;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ReceiverDescription it = (ReceiverDescription)element$iv$iv;
            boolean bl = false;
            if (!ConstraintSystemBuilderKt.isSubtypeConstraintCompatible(candidate2.getSystem(), it.getType(), expectedType, SimpleConstraintSystemConstraintPosition.INSTANCE)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List successfulReceivers = (List)destination$iv$iv2;
        switch (successfulReceivers.size()) {
            case 0: {
                void $this$yieldDiagnostic$iv;
                CheckerSink $i$f$filter2 = sink;
                diagnostic$iv = new InapplicableWrongReceiver(null, null, 3, null);
                boolean $i$f$yieldDiagnostic = false;
                $this$yieldDiagnostic$iv.reportDiagnostic(diagnostic$iv);
                void $this$yieldIfNeed$iv$iv = $this$yieldDiagnostic$iv;
                boolean $i$f$yieldIfNeed = false;
                if ($this$yieldIfNeed$iv$iv.getNeedYielding()) {
                    Object object = $this$yieldIfNeed$iv$iv.yield($completion);
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                }
                return Unit.INSTANCE;
            }
            case 1: {
                Object object = this.resolveExtensionReceiver(successfulReceivers, candidate2, expectedType, sink, context, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }
        CheckerSink $this$yieldDiagnostic$iv = sink;
        diagnostic$iv = new MultipleContextReceiversApplicableForExtensionReceivers();
        boolean $i$f$yieldDiagnostic = false;
        $this$yieldDiagnostic$iv.reportDiagnostic(diagnostic$iv);
        CheckerSink $this$yieldIfNeed$iv$iv = $this$yieldDiagnostic$iv;
        boolean $i$f$yieldIfNeed = false;
        if ($this$yieldIfNeed$iv$iv.getNeedYielding()) {
            Object object = $this$yieldIfNeed$iv$iv.yield($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
        }
        return Unit.INSTANCE;
    }

    private final Object resolveExtensionReceiver(List<ReceiverDescription> receivers, Candidate candidate2, ConeKotlinType expectedType, CheckerSink sink, ResolutionContext context, Continuation<? super Unit> $completion) {
        ReceiverDescription receiver2 = CollectionsKt.single(receivers);
        ArgumentsKt.resolvePlainArgumentType$default(candidate2, ConstraintSystemCompleterKt.getCsBuilder(candidate2), receiver2.getExpression(), receiver2.getType(), expectedType, sink, context, true, false, false, 256, null);
        CheckerSink $this$yieldIfNeed$iv = sink;
        boolean $i$f$yieldIfNeed = false;
        if ($this$yieldIfNeed$iv.getNeedYielding()) {
            Object object = $this$yieldIfNeed$iv.yield($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
        }
        return Unit.INSTANCE;
    }

    private final ConeKotlinType getExpectedReceiverType(Candidate $this$getExpectedReceiverType) {
        FirBasedSymbol<?> firBasedSymbol = $this$getExpectedReceiverType.getSymbol();
        FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        if (firCallableSymbol == null) {
            return null;
        }
        FirCallableSymbol callableSymbol = firCallableSymbol;
        FirTypeRef firTypeRef = ((FirCallableDeclaration)callableSymbol.getFir()).getReceiverTypeRef();
        return firTypeRef != null ? FirTypeUtilsKt.getConeType(firTypeRef) : null;
    }

    public static final /* synthetic */ Object access$resolveExtensionReceiver(CheckExtensionReceiver $this, List receivers, Candidate candidate2, ConeKotlinType expectedType, CheckerSink sink, ResolutionContext context, Continuation $completion) {
        return $this.resolveExtensionReceiver(receivers, candidate2, expectedType, sink, context, $completion);
    }
}

