/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirTypeParametersOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeCyclicTypeBound;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSpecificTypeResolverTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.ScopeClassDeclaration;
import org.jetbrains.kotlin.fir.resolve.transformers.StoreType;
import org.jetbrains.kotlin.fir.resolve.transformers.TransformUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.ImportingScopesKt;
import org.jetbrains.kotlin.fir.scopes.ScopesKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirMemberTypeParameterScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeWithSubstitutionKt;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;
import org.jetbrains.kotlin.kotlinx.collections.immutable.ExtensionsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00f4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001BA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001eH\u0002J\u001a\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000e2\b\u0010\"\u001a\u0004\u0018\u00010\u0002H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u001a\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020)2\b\u0010\"\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020,2\b\u0010\"\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020/2\b\u0010\"\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00100\u001a\u00020 2\u0006\u00101\u001a\u0002022\b\u0010\"\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00103\u001a\u0002042\u0006\u00105\u001a\u0002042\b\u0010\"\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00106\u001a\u0002072\u0006\u00108\u001a\u0002072\b\u0010\"\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:2\b\u0010\"\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010<\u001a\u00020\u000b2\u0006\u0010=\u001a\u00020\u000b2\b\u0010\"\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\b\u0010\"\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020C2\b\u0010\"\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010E\u001a\u00020 2\u0006\u0010F\u001a\u00020G2\b\u0010\"\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020I2\b\u0010\"\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020L2\b\u0010\"\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020?2\b\u0010\"\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010Q\u001a\u00020 2\u0006\u0010R\u001a\u00020S2\b\u0010\"\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010T\u001a\u00020$2\u0006\u0010U\u001a\u00020VH\u0002J$\u0010W\u001a\u0002HX\"\u0004\b\u0000\u0010X2\u000e\b\u0004\u0010Y\u001a\b\u0012\u0004\u0012\u0002HX0ZH\u0082\b\u00a2\u0006\u0002\u0010[J\f\u0010\\\u001a\u00020$*\u00020]H\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirTypeResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "initialScopes", "", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "initialCurrentFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "classDeclarationsStack", "Lkotlin/collections/ArrayDeque;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Ljava/util/List;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lkotlin/collections/ArrayDeque;)V", "currentFile", "scopes", "", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "towerScope", "typeResolverTransformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer;", "hasSupertypePathToParameter", "", "currentTypeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "typeParameter", "visited", "", "resolveClassContent", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "firClass", "data", "resolveConstructedTypeRefForDelegatedConstructorCall", "", "delegatedConstructorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirDelegatedConstructorCall;", "transformAnnotation", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "transformAnnotationCall", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "transformAnonymousObject", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "transformBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "transformConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "constructor", "transformEnumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "enumEntry", "transformField", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "field", "transformFile", "file", "transformImplicitTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "implicitTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirImplicitTypeRef;", "transformProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "property", "transformRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "transformSimpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "simpleFunction", "transformTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "typeAlias", "transformTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "typeRef", "transformValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "unboundCyclesInTypeParametersSupertypes", "typeParametersOwner", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRefsOwner;", "withScopeCleanup", "T", "l", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "addTypeParametersScope", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "resolve"})
public class FirTypeResolveTransformer
extends FirAbstractTreeTransformer<Object> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final ArrayDeque<FirClass> classDeclarationsStack;
    @NotNull
    private final List<FirScope> scopes;
    @NotNull
    private final List<FirScope> towerScope;
    @NotNull
    private final FirSpecificTypeResolverTransformer typeResolverTransformer;
    @Nullable
    private FirFile currentFile;

    public FirTypeResolveTransformer(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull List<? extends FirScope> initialScopes, @Nullable FirFile initialCurrentFile, @NotNull ArrayDeque<FirClass> classDeclarationsStack) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Intrinsics.checkNotNullParameter(initialScopes, "initialScopes");
        Intrinsics.checkNotNullParameter(classDeclarationsStack, "classDeclarationsStack");
        super(FirResolvePhase.TYPES);
        this.session = session2;
        this.scopeSession = scopeSession;
        this.classDeclarationsStack = classDeclarationsStack;
        this.scopes = new ArrayList();
        this.towerScope = CollectionsKt.asReversedMutable(this.scopes);
        this.scopes.addAll((Collection<FirScope>)CollectionsKt.asReversed(initialScopes));
        this.typeResolverTransformer = new FirSpecificTypeResolverTransformer(this.session, false, null, 6, null);
        this.currentFile = initialCurrentFile;
    }

    public /* synthetic */ FirTypeResolveTransformer(FirSession firSession, ScopeSession scopeSession, List list2, FirFile firFile, ArrayDeque arrayDeque, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            firFile = null;
        }
        if ((n & 0x10) != 0) {
            arrayDeque = new ArrayDeque<FirClass>();
        }
        this(firSession, scopeSession, list2, firFile, arrayDeque);
    }

    @Override
    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable Object data2) {
        int n;
        Intrinsics.checkNotNullParameter(file2, "file");
        this.checkSessionConsistency(file2);
        this.currentFile = file2;
        FirTypeResolveTransformer this_$iv = this;
        boolean $i$f$withScopeCleanup = false;
        int sizeBefore$iv = this_$iv.scopes.size();
        boolean bl = false;
        this.scopes.addAll(ImportingScopesKt.createImportingScopes$default(file2, this.getSession(), this.scopeSession, false, 8, null));
        FirFile result$iv = FirTypeResolveTransformer.super.transformFile(file2, data2);
        int size$iv = this_$iv.scopes.size();
        int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        n = size$iv - sizeBefore$iv;
        int n3 = 0;
        while (n3 < n) {
            int it$iv = n3++;
            boolean bl2 = false;
            this_$iv.scopes.remove(CollectionsKt.getLastIndex(this_$iv.scopes));
        }
        return result$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        ArrayDeque<FirClass> classDeclarations$iv = this.classDeclarationsStack;
        boolean $i$f$withClassDeclarationCleanup = false;
        classDeclarations$iv.addLast(regularClass);
        try {
            int n;
            boolean bl = false;
            FirTypeResolveTransformer this_$iv = this;
            boolean $i$f$withScopeCleanup = false;
            int sizeBefore$iv = this_$iv.scopes.size();
            boolean bl2 = false;
            this.addTypeParametersScope(regularClass);
            Iterable $this$forEach$iv = regularClass.getTypeParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
                boolean bl3 = false;
                it.accept(this, data2);
            }
            this.unboundCyclesInTypeParametersSupertypes(regularClass);
            Unit result$iv = Unit.INSTANCE;
            int size$iv = this_$iv.scopes.size();
            int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            n = size$iv - sizeBefore$iv;
            int n3 = 0;
            while (n3 < n) {
                int it$iv = n3++;
                boolean bl4 = false;
                this_$iv.scopes.remove(CollectionsKt.getLastIndex(this_$iv.scopes));
            }
            FirStatement firStatement = this.resolveClassContent(regularClass, data2);
            return firStatement;
        }
        finally {
            classDeclarations$iv.removeLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FirStatement transformAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(anonymousObject, "anonymousObject");
        ArrayDeque<FirClass> classDeclarations$iv = this.classDeclarationsStack;
        boolean $i$f$withClassDeclarationCleanup = false;
        classDeclarations$iv.addLast(anonymousObject);
        try {
            boolean bl = false;
            FirStatement firStatement = this.resolveClassContent(anonymousObject, data2);
            return firStatement;
        }
        finally {
            classDeclarations$iv.removeLast();
        }
    }

    @NotNull
    public FirConstructor transformConstructor(@NotNull FirConstructor constructor2, @Nullable Object data2) {
        int n;
        Intrinsics.checkNotNullParameter(constructor2, "constructor");
        FirTypeResolveTransformer this_$iv = this;
        boolean $i$f$withScopeCleanup = false;
        int sizeBefore$iv = this_$iv.scopes.size();
        boolean bl = false;
        this.addTypeParametersScope(constructor2);
        FirDeclaration result$iv = this.transformDeclaration(constructor2, data2);
        int size$iv = this_$iv.scopes.size();
        int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        n = size$iv - sizeBefore$iv;
        int n3 = 0;
        while (n3 < n) {
            int it$iv = n3++;
            boolean bl2 = false;
            this_$iv.scopes.remove(CollectionsKt.getLastIndex(this_$iv.scopes));
        }
        FirDeclaration firDeclaration = result$iv;
        Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirConstructor");
        return (FirConstructor)firDeclaration;
    }

    @NotNull
    public FirTypeAlias transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Object data2) {
        int n;
        Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
        FirTypeResolveTransformer this_$iv = this;
        boolean $i$f$withScopeCleanup = false;
        int sizeBefore$iv = this_$iv.scopes.size();
        boolean bl = false;
        this.addTypeParametersScope(typeAlias);
        FirDeclaration result$iv = this.transformDeclaration(typeAlias, data2);
        int size$iv = this_$iv.scopes.size();
        int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        n = size$iv - sizeBefore$iv;
        int n3 = 0;
        while (n3 < n) {
            int it$iv = n3++;
            boolean bl2 = false;
            this_$iv.scopes.remove(CollectionsKt.getLastIndex(this_$iv.scopes));
        }
        FirDeclaration firDeclaration = result$iv;
        Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirTypeAlias");
        return (FirTypeAlias)firDeclaration;
    }

    @NotNull
    public FirEnumEntry transformEnumEntry(@NotNull FirEnumEntry enumEntry, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
        enumEntry.transformReturnTypeRef(this, data2);
        enumEntry.transformTypeParameters(this, data2);
        enumEntry.transformAnnotations(this, data2);
        return enumEntry;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public FirProperty transformProperty(@NotNull FirProperty property2, @Nullable Object data2) {
        int n;
        Intrinsics.checkNotNullParameter(property2, "property");
        FirTypeResolveTransformer this_$iv = this;
        boolean $i$f$withScopeCleanup = false;
        int sizeBefore$iv = this_$iv.scopes.size();
        boolean bl = false;
        this.addTypeParametersScope(property2);
        property2.transformTypeParameters(this, data2).transformReturnTypeRef(this, data2).transformReceiverTypeRef(this, data2).transformGetter(this, data2).transformSetter(this, data2).transformBackingField(this, data2).transformAnnotations(this, data2);
        if (Intrinsics.areEqual(DeclarationAttributesKt.isFromVararg(property2), true)) {
            Object object;
            TransformUtilsKt.transformTypeToArrayType(property2);
            FirPropertyAccessor firPropertyAccessor = property2.getGetter();
            if (firPropertyAccessor != null) {
                firPropertyAccessor.transformReturnTypeRef(StoreType.INSTANCE, property2.getReturnTypeRef());
            }
            if ((object = property2.getSetter()) != null && (object = ((FirPropertyAccessor)object).getValueParameters()) != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.transformReturnTypeRef(StoreType.INSTANCE, property2.getReturnTypeRef()));
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
            }
        }
        this.unboundCyclesInTypeParametersSupertypes(property2);
        FirProperty result$iv = property2;
        int size$iv = this_$iv.scopes.size();
        int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        n = size$iv - sizeBefore$iv;
        int n3 = 0;
        while (n3 < n) {
            int it$iv = n3++;
            boolean bl3 = false;
            this_$iv.scopes.remove(CollectionsKt.getLastIndex(this_$iv.scopes));
        }
        return result$iv;
    }

    @NotNull
    public FirField transformField(@NotNull FirField field2, @Nullable Object data2) {
        int n;
        Intrinsics.checkNotNullParameter(field2, "field");
        FirTypeResolveTransformer this_$iv = this;
        boolean $i$f$withScopeCleanup = false;
        int sizeBefore$iv = this_$iv.scopes.size();
        boolean bl = false;
        field2.transformReturnTypeRef(this, data2).transformAnnotations(this, data2);
        FirField result$iv = field2;
        int size$iv = this_$iv.scopes.size();
        int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        n = size$iv - sizeBefore$iv;
        int n3 = 0;
        while (n3 < n) {
            int it$iv = n3++;
            boolean bl2 = false;
            this_$iv.scopes.remove(CollectionsKt.getLastIndex(this_$iv.scopes));
        }
        return result$iv;
    }

    @NotNull
    public FirSimpleFunction transformSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @Nullable Object data2) {
        int n;
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
        FirTypeResolveTransformer this_$iv = this;
        boolean $i$f$withScopeCleanup = false;
        int sizeBefore$iv = this_$iv.scopes.size();
        boolean bl = false;
        this.addTypeParametersScope(simpleFunction);
        FirDeclaration it = firDeclaration = this.transformDeclaration(simpleFunction, data2);
        boolean bl2 = false;
        Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirTypeParametersOwner");
        this.unboundCyclesInTypeParametersSupertypes((FirTypeParametersOwner)((Object)it));
        FirDeclaration result$iv = firDeclaration;
        int size$iv = this_$iv.scopes.size();
        int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        n = size$iv - sizeBefore$iv;
        int n3 = 0;
        while (n3 < n) {
            int it$iv = n3++;
            boolean bl3 = false;
            this_$iv.scopes.remove(CollectionsKt.getLastIndex(this_$iv.scopes));
        }
        FirDeclaration firDeclaration2 = result$iv;
        Intrinsics.checkNotNull(firDeclaration2, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirSimpleFunction");
        return (FirSimpleFunction)firDeclaration2;
    }

    private final void unboundCyclesInTypeParametersSupertypes(FirTypeParameterRefsOwner typeParametersOwner) {
        for (FirTypeParameterRef typeParameter : typeParametersOwner.getTypeParameters()) {
            FirErrorTypeRefBuilder firErrorTypeRefBuilder;
            if (!(typeParameter instanceof FirTypeParameter) || !this.hasSupertypePathToParameter((FirTypeParameter)typeParameter, (FirTypeParameter)typeParameter, new LinkedHashSet())) continue;
            boolean $i$f$buildErrorTypeRef = false;
            FirErrorTypeRefBuilder $this$unboundCyclesInTypeParametersSupertypes_u24lambda_u2d12 = firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
            boolean bl = false;
            $this$unboundCyclesInTypeParametersSupertypes_u24lambda_u2d12.setDiagnostic(new ConeCyclicTypeBound(typeParameter.getSymbol(), ExtensionsKt.toImmutableList((Iterable)((FirTypeParameter)typeParameter).getBounds())));
            FirErrorTypeRef errorType = firErrorTypeRefBuilder.build();
            ((FirTypeParameter)typeParameter).replaceBounds(CollectionsKt.listOf(errorType));
        }
    }

    private final boolean hasSupertypePathToParameter(FirTypeParameter currentTypeParameter, FirTypeParameter typeParameter, Set<FirTypeParameter> visited2) {
        boolean bl;
        block8: {
            if (!((Collection)visited2).isEmpty() && Intrinsics.areEqual(currentTypeParameter, typeParameter)) {
                return true;
            }
            if (!visited2.add(currentTypeParameter)) {
                return false;
            }
            Iterable $this$any$iv = currentTypeParameter.getBounds();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    Object object;
                    FirTypeRef it = (FirTypeRef)element$iv;
                    boolean bl3 = false;
                    FirTypeRef $this$coneTypeSafe$iv = it;
                    boolean $i$f$coneTypeSafe = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                    if (!(coneKotlinType instanceof ConeTypeParameterType)) {
                        coneKotlinType = null;
                    }
                    if ((object = (ConeTypeParameterType)((ConeKotlinType)((ConeTypeParameterType)coneKotlinType))) == null || (object = ((ConeTypeParameterType)object).getLookupTag()) == null || (object = ((ConeTypeParameterLookupTag)object).getTypeParameterSymbol()) == null || (object = (FirTypeParameter)((FirBasedSymbol)object).getFir()) == null) {
                        bl2 = false;
                    } else {
                        Object nextTypeParameter = object;
                        bl2 = this.hasSupertypePathToParameter((FirTypeParameter)nextTypeParameter, typeParameter, visited2);
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public FirTypeRef transformImplicitTypeRef(@NotNull FirImplicitTypeRef implicitTypeRef, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(implicitTypeRef, "implicitTypeRef");
        return implicitTypeRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public FirResolvedTypeRef transformTypeRef(@NotNull FirTypeRef typeRef, @Nullable Object data2) {
        FirResolvedTypeRef firResolvedTypeRef;
        void this_$iv;
        Intrinsics.checkNotNullParameter(typeRef, "typeRef");
        FirSpecificTypeResolverTransformer firSpecificTypeResolverTransformer = this.typeResolverTransformer;
        FirFile file$iv = this.currentFile;
        boolean $i$f$withFile = false;
        FirFile oldValue$iv = this_$iv.currentFile;
        this_$iv.currentFile = file$iv;
        try {
            void $this$transformTypeRef_u24lambda_u2d14 = this_$iv;
            boolean bl = false;
            firResolvedTypeRef = (FirResolvedTypeRef)typeRef.transform(this.typeResolverTransformer, new ScopeClassDeclaration(this.towerScope, this.classDeclarationsStack, null, 4, null));
        }
        finally {
            this_$iv.currentFile = oldValue$iv;
        }
        return firResolvedTypeRef;
    }

    @Override
    @NotNull
    public FirStatement transformValueParameter(@NotNull FirValueParameter valueParameter2, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(valueParameter2, "valueParameter");
        valueParameter2.transformReturnTypeRef(this, data2);
        valueParameter2.transformAnnotations(this, data2);
        TransformUtilsKt.transformVarargTypeToArrayType(valueParameter2);
        return valueParameter2;
    }

    @Override
    @NotNull
    public FirStatement transformBlock(@NotNull FirBlock block2, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(block2, "block");
        return block2;
    }

    @Override
    @NotNull
    public FirStatement transformAnnotation(@NotNull FirAnnotation annotation2, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(annotation2, "annotation");
        annotation2.transformAnnotationTypeRef(this, data2);
        return annotation2;
    }

    @Override
    @NotNull
    public FirStatement transformAnnotationCall(@NotNull FirAnnotationCall annotationCall, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(annotationCall, "annotationCall");
        return this.transformAnnotation((FirAnnotation)annotationCall, data2);
    }

    /*
     * WARNING - void declaration
     */
    private final FirStatement resolveClassContent(FirClass firClass, Object data2) {
        Object object;
        int it$iv;
        int n;
        Object constructor222;
        void $this$filterIsInstanceTo$iv$iv;
        FirTypeResolveTransformer this_$iv = this;
        boolean $i$f$withScopeCleanup = false;
        int sizeBefore$iv = this_$iv.scopes.size();
        boolean bl2 = false;
        firClass.transformAnnotations(this, null);
        if (firClass instanceof FirRegularClass) {
            this.addTypeParametersScope(firClass);
        }
        Iterable $this$filterIsInstance$iv = firClass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Object object2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirConstructor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Object constructor222 : (List)destination$iv$iv) {
            FirDelegatedConstructorCall p0;
            if (((FirConstructor)constructor222).getDelegatedConstructor() == null) continue;
            boolean bl3 = false;
            this.resolveConstructedTypeRefForDelegatedConstructorCall(p0);
        }
        Object result$iv = Unit.INSTANCE;
        int size$iv = this_$iv.scopes.size();
        int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        n = size$iv - sizeBefore$iv;
        int n3 = 0;
        while (n3 < n) {
            it$iv = n3++;
            boolean bl = false;
            this_$iv.scopes.remove(CollectionsKt.getLastIndex(this_$iv.scopes));
        }
        this_$iv = this;
        $i$f$withScopeCleanup = false;
        sizeBefore$iv = this_$iv.scopes.size();
        boolean bl4 = false;
        constructor222 = this.getSession();
        List<ConeClassLikeType> superTypes2 = CollectionsKt.asReversed(SupertypeUtilsKt.lookupSuperTypes$default(firClass, false, true, (FirSession)constructor222, true, null, 32, null));
        for (ConeClassLikeType superType2 : superTypes2) {
            FirContainingNamesAwareScope nestedClassifierScope;
            if (ScopesKt.getNestedClassifierScope(superType2.getLookupTag(), this.getSession(), this.scopeSession) == null) continue;
            boolean bl5 = false;
            FirContainingNamesAwareScope scope2 = FirNestedClassifierScopeWithSubstitutionKt.wrapNestedClassifierScopeWithSubstitutionForSuperType(nestedClassifierScope, superType2, this.getSession());
            this.scopes.add(scope2);
        }
        FirNestedClassifierScope firNestedClassifierScope = FirDeclaredMemberScopeProviderKt.nestedClassifierScope(this.getSession(), firClass);
        if (firNestedClassifierScope != null) {
            object2 = firNestedClassifierScope;
            object = this.scopes;
            FirScope p0 = (FirScope)object2;
            boolean bl6 = false;
            object.add(p0);
        }
        if (firClass instanceof FirRegularClass) {
            FirRegularClass companionObject;
            FirRegularClassSymbol firRegularClassSymbol = ((FirRegularClass)firClass).getCompanionObjectSymbol();
            FirRegularClass firRegularClass = companionObject = firRegularClassSymbol != null ? (FirRegularClass)firRegularClassSymbol.getFir() : null;
            if (companionObject != null) {
                FirNestedClassifierScope firNestedClassifierScope2 = FirDeclaredMemberScopeProviderKt.nestedClassifierScope(this.getSession(), companionObject);
                if (firNestedClassifierScope2 != null) {
                    object = firNestedClassifierScope2;
                    List list2 = this.scopes;
                    FirScope p0 = (FirScope)object;
                    boolean bl7 = false;
                    list2.add(p0);
                }
            }
            this.addTypeParametersScope(firClass);
        }
        result$iv = (FirClass)this.transformElement((FirElement)firClass, data2);
        size$iv = this_$iv.scopes.size();
        int n4 = n = size$iv >= sizeBefore$iv ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        n = size$iv - sizeBefore$iv;
        n3 = 0;
        while (n3 < n) {
            it$iv = n3++;
            boolean bl = false;
            this_$iv.scopes.remove(CollectionsKt.getLastIndex(this_$iv.scopes));
        }
        return (FirStatement)result$iv;
    }

    private final void resolveConstructedTypeRefForDelegatedConstructorCall(FirDelegatedConstructorCall delegatedConstructorCall) {
        delegatedConstructorCall.replaceConstructedTypeRef((FirTypeRef)delegatedConstructorCall.getConstructedTypeRef().transform(this, null));
        delegatedConstructorCall.transformCalleeReference(this, null);
    }

    private final void addTypeParametersScope(FirMemberDeclaration $this$addTypeParametersScope) {
        if (!((Collection)$this$addTypeParametersScope.getTypeParameters()).isEmpty()) {
            this.scopes.add(new FirMemberTypeParameterScope($this$addTypeParametersScope));
        }
    }
}

