/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.JsScopesCollector;
import org.jetbrains.kotlin.ir.backend.js.lower.KotlinLocalsUsageCollector;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsCodeKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContextKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u000eJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000fJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020%H\u0016J%\u0010&\u001a\u0002H'\"\u0004\b\u0000\u0010'2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0)H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR#\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsCodeOutlineTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "backendContext", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getContainer", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "localScopes", "", "", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "getLocalScopes", "()Ljava/util/List;", "findValueDeclarationWithName", "name", "outlineJsCodeIfNeeded", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "registerValueDeclaration", "", "irValueDeclaration", "visitCall", "visitContainerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitValueParameterNew", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "visitVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "withLocalScope", "T", "body", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "backend.js"})
final class JsCodeOutlineTransformer
extends IrElementTransformerVoidWithContext {
    @NotNull
    private final JsIrBackendContext backendContext;
    @NotNull
    private final IrDeclaration container;
    @NotNull
    private final List<Map<String, IrValueDeclaration>> localScopes;

    public JsCodeOutlineTransformer(@NotNull JsIrBackendContext backendContext, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(backendContext, "backendContext");
        Intrinsics.checkNotNullParameter(container, "container");
        this.backendContext = backendContext;
        this.container = container;
        Map[] mapArray = new Map[]{new LinkedHashMap()};
        this.localScopes = CollectionsKt.mutableListOf(mapArray);
        if (this.container instanceof IrFunction) {
            Iterable $this$forEach$iv = ((IrFunction)this.container).getValueParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl = false;
                this.registerValueDeclaration(it);
            }
        }
    }

    @NotNull
    public final JsIrBackendContext getBackendContext() {
        return this.backendContext;
    }

    @NotNull
    public final IrDeclaration getContainer() {
        return this.container;
    }

    @NotNull
    public final List<Map<String, IrValueDeclaration>> getLocalScopes() {
        return this.localScopes;
    }

    public final <T> T withLocalScope(@NotNull Function0<? extends T> body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        boolean $i$f$withLocalScope = false;
        UtilsKt.push(this.getLocalScopes(), (Map)new LinkedHashMap());
        T res2 = body2.invoke();
        UtilsKt.pop(this.getLocalScopes());
        return res2;
    }

    public final void registerValueDeclaration(@NotNull IrValueDeclaration irValueDeclaration) {
        Intrinsics.checkNotNullParameter(irValueDeclaration, "irValueDeclaration");
        Name name2 = irValueDeclaration.getName();
        if (!name2.isSpecial()) {
            String string2 = name2.getIdentifier();
            Intrinsics.checkNotNullExpressionValue(string2, "name.identifier");
            String identifier = string2;
            Map<String, IrValueDeclaration> map2 = CollectionsKt.lastOrNull(this.localScopes);
            if (map2 == null) {
                CompilationExceptionKt.compilationException("Expecting a scope", irValueDeclaration);
                throw null;
            }
            Map<String, IrValueDeclaration> currentScope2 = map2;
            currentScope2.put(identifier, irValueDeclaration);
        }
    }

    @Nullable
    public final IrValueDeclaration findValueDeclarationWithName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        for (int i = this.localScopes.size() - 1; -1 < i; --i) {
            Map<String, IrValueDeclaration> scope2 = this.localScopes.get(i);
            IrValueDeclaration irValueDeclaration = scope2.get(name2);
            if (irValueDeclaration == null) continue;
            return irValueDeclaration;
        }
        return null;
    }

    @Override
    @NotNull
    public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        JsCodeOutlineTransformer this_$iv = this;
        boolean $i$f$withLocalScope = false;
        UtilsKt.push(this_$iv.getLocalScopes(), (Map)new LinkedHashMap());
        boolean bl = false;
        IrExpression res$iv = super.visitContainerExpression(expression2);
        UtilsKt.pop(this_$iv.getLocalScopes());
        return res$iv;
    }

    @Override
    @NotNull
    public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        JsCodeOutlineTransformer this_$iv = this;
        boolean $i$f$withLocalScope = false;
        UtilsKt.push(this_$iv.getLocalScopes(), (Map)new LinkedHashMap());
        boolean bl = false;
        IrStatement res$iv = super.visitDeclaration(declaration);
        UtilsKt.pop(this_$iv.getLocalScopes());
        return res$iv;
    }

    @Override
    @NotNull
    public IrStatement visitValueParameterNew(@NotNull IrValueParameter declaration) {
        IrStatement irStatement;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrStatement it = irStatement = super.visitValueParameterNew(declaration);
        boolean bl = false;
        this.registerValueDeclaration(declaration);
        return irStatement;
    }

    @Override
    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration) {
        IrStatement irStatement;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrStatement it = irStatement = super.visitVariable(declaration);
        boolean bl = false;
        this.registerValueDeclaration(declaration);
        return irStatement;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrExpression irExpression = this.outlineJsCodeIfNeeded(expression2);
        if (irExpression == null) {
            irExpression = super.visitCall(expression2);
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final IrExpression outlineJsCodeIfNeeded(@NotNull IrCall expression2) {
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (!Intrinsics.areEqual(expression2.getSymbol(), this.backendContext.getIntrinsics().getJsCode())) {
            return null;
        }
        IrExpression irExpression = expression2.getValueArgument(0);
        if (irExpression == null) {
            CompilationExceptionKt.compilationException("Expected js code string", expression2);
            throw null;
        }
        IrExpression jsCodeArg = irExpression;
        List<JsStatement> list2 = JsCodeKt.translateJsCodeIntoStatementList(jsCodeArg, this.backendContext);
        if (list2 == null) {
            return null;
        }
        List<JsStatement> jsStatements = list2;
        JsScopesCollector jsScopesCollector = new JsScopesCollector();
        RecursiveJsVisitor $this$outlineJsCodeIfNeeded_u24lambda_u2d5 = jsScopesCollector;
        boolean bl = false;
        $this$outlineJsCodeIfNeeded_u24lambda_u2d5.acceptList(jsStatements);
        JsScopesCollector scope2 = jsScopesCollector;
        RecursiveJsVisitor $this$outlineJsCodeIfNeeded_u24lambda_u2d6 = $this$outlineJsCodeIfNeeded_u24lambda_u2d5 = new KotlinLocalsUsageCollector(scope2, (Function1<? super String, ? extends IrValueDeclaration>)new Function1<String, IrValueDeclaration>((Object)this){

            @Nullable
            public final IrValueDeclaration invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((JsCodeOutlineTransformer)this.receiver).findValueDeclarationWithName(p0);
            }

            @NotNull
            public final String getSignature() {
                return "findValueDeclarationWithName(Ljava/lang/String;)Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;";
            }

            @NotNull
            public final String getName() {
                return "findValueDeclarationWithName";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(JsCodeOutlineTransformer.class);
            }
        });
        boolean bl2 = false;
        $this$outlineJsCodeIfNeeded_u24lambda_u2d6.acceptList(jsStatements);
        RecursiveJsVisitor localsUsageCollector2 = $this$outlineJsCodeIfNeeded_u24lambda_u2d5;
        List<IrValueDeclaration> kotlinLocalsUsedInJs = ((KotlinLocalsUsageCollector)localsUsageCollector2).getUsedLocals();
        if (kotlinLocalsUsedInJs.isEmpty()) {
            return null;
        }
        IrFactory $this$buildFun$iv = this.backendContext.getIrFactory();
        boolean $i$f$buildFun = false;
        Object $this$buildFun_u24lambda_u2d16$iv = new IrFunctionBuilder();
        boolean bl3 = false;
        IrFunctionBuilder $this$outlineJsCodeIfNeeded_u24lambda_u2d7 = $this$buildFun_u24lambda_u2d16$iv;
        boolean bl4 = false;
        Name name2 = Name.identifier("outlinedJsCode$");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"outlinedJsCode$\")");
        $this$outlineJsCodeIfNeeded_u24lambda_u2d7.setName(name2);
        $this$outlineJsCodeIfNeeded_u24lambda_u2d7.setReturnType(this.backendContext.getDynamicType());
        $this$outlineJsCodeIfNeeded_u24lambda_u2d7.setExternal(true);
        $this$outlineJsCodeIfNeeded_u24lambda_u2d7.setOrigin(JsIrBackendContext.Companion.getCallableClosureOrigin());
        IrSimpleFunction outlinedFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2d16$iv);
        outlinedFunction.setBody(this.backendContext.getIrFactory().createBlockBody(-1, -1));
        outlinedFunction.setParent(this.container instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)this.container) : this.container.getParent());
        Iterable $this$forEach$iv = kotlinLocalsUsedInJs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrValueParameter irValueParameter;
            IrValueDeclaration local2 = (IrValueDeclaration)element$iv;
            boolean bl5 = false;
            IrFunction $this$addValueParameter$iv = outlinedFunction;
            boolean $i$f$addValueParameter = false;
            IrValueParameterBuilder $this$addValueParameter_u24lambda_u2d28$iv = new IrValueParameterBuilder();
            boolean bl6 = false;
            IrValueParameterBuilder $this$outlineJsCodeIfNeeded_u24lambda_u2d9_u24lambda_u2d8 = $this$addValueParameter_u24lambda_u2d28$iv;
            boolean bl7 = false;
            $this$outlineJsCodeIfNeeded_u24lambda_u2d9_u24lambda_u2d8.setName(local2.getName());
            $this$outlineJsCodeIfNeeded_u24lambda_u2d9_u24lambda_u2d8.setType(local2.getType());
            if ($this$addValueParameter_u24lambda_u2d28$iv.getIndex() == -1) {
                $this$addValueParameter_u24lambda_u2d28$iv.setIndex($this$addValueParameter$iv.getValueParameters().size());
            }
            IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u2d28$iv, $this$addValueParameter$iv);
            boolean bl8 = false;
            $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), valueParameter$iv));
        }
        JsStatement lastStatement = CollectionsKt.last(jsStatements);
        List<JsStatement> newStatements = CollectionsKt.toMutableList((Collection)jsStatements);
        $this$buildFun_u24lambda_u2d16$iv = lastStatement;
        if (!($this$buildFun_u24lambda_u2d16$iv instanceof JsReturn)) {
            if ($this$buildFun_u24lambda_u2d16$iv instanceof JsExpressionStatement) {
                newStatements.set(CollectionsKt.getLastIndex(jsStatements), new JsReturn(((JsExpressionStatement)lastStatement).getExpression()));
            } else {
                ((Collection)newStatements).add(new JsReturn(new JsPrefixOperation(JsUnaryOperator.VOID, new JsIntLiteral(3))));
            }
        }
        JsFunction newFun = new JsFunction(JsGenerationContextKt.getEmptyScope(), new JsBlock(newStatements), "");
        Iterable $this$forEach$iv2 = kotlinLocalsUsedInJs;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            IrValueDeclaration irParameter2 = (IrValueDeclaration)element$iv;
            boolean bl9 = false;
            newFun.getParameters().add(new JsParameter(new JsName(irParameter2.getName().getIdentifier(), false)));
        }
        DeclarationIrBuilder $this$outlineJsCodeIfNeeded_u24lambda_u2d15 = LowerUtilsKt.createIrBuilder$default(this.backendContext, this.container.getSymbol(), 0, 0, 6, null);
        boolean bl10 = false;
        IrConstructorSymbol jsFunCtor = SequencesKt.single(IrUtilsKt.getConstructors(this.backendContext.getIntrinsics().getJsFunAnnotationSymbol()));
        IrConstructorCall irParameter2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$outlineJsCodeIfNeeded_u24lambda_u2d15, jsFunCtor);
        IrFunctionAccessExpression $this$outlineJsCodeIfNeeded_u24lambda_u2d15_u24lambda_u2d11 = irParameter2;
        boolean bl11 = false;
        IrBuilderWithScope irBuilderWithScope = $this$outlineJsCodeIfNeeded_u24lambda_u2d15;
        String string2 = newFun.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "newFun.toString()");
        $this$outlineJsCodeIfNeeded_u24lambda_u2d15_u24lambda_u2d11.putValueArgument(0, ExpressionHelpersKt.irString(irBuilderWithScope, string2));
        IrConstructorCall jsFunCall = irParameter2;
        outlinedFunction.setAnnotations(CollectionsKt.listOf(jsFunCall));
        IrFunctionAccessExpression $this$outlineJsCodeIfNeeded_u24lambda_u2d15_u24lambda_u2d13 = $this$outlineJsCodeIfNeeded_u24lambda_u2d15_u24lambda_u2d11 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$outlineJsCodeIfNeeded_u24lambda_u2d15, outlinedFunction);
        boolean bl12 = false;
        Iterable $this$forEachIndexed$iv = kotlinLocalsUsedInJs;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void local3;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueDeclaration irValueDeclaration = (IrValueDeclaration)item$iv;
            int index2 = n;
            boolean bl13 = false;
            $this$outlineJsCodeIfNeeded_u24lambda_u2d15_u24lambda_u2d13.putValueArgument(index2, ExpressionHelpersKt.irGet($this$outlineJsCodeIfNeeded_u24lambda_u2d15, (IrValueDeclaration)local3));
        }
        IrFunctionAccessExpression outlinedFunctionCall = $this$outlineJsCodeIfNeeded_u24lambda_u2d15_u24lambda_u2d11;
        IrBuilderWithScope $this$irComposite_u24default$iv = $this$outlineJsCodeIfNeeded_u24lambda_u2d15;
        int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irComposite = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
        boolean $i$f$block = false;
        void $this$outlineJsCodeIfNeeded_u24lambda_u2d15_u24lambda_u2d14 = this_$iv$iv;
        boolean bl14 = false;
        $this$outlineJsCodeIfNeeded_u24lambda_u2d15_u24lambda_u2d14.unaryPlus(outlinedFunction);
        $this$outlineJsCodeIfNeeded_u24lambda_u2d15_u24lambda_u2d14.unaryPlus(outlinedFunctionCall);
        return this_$iv$iv.doBuild();
    }
}

