/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.IrGeneratorContext;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.types.IrType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001aH\u0014J%\u0010\u001e\u001a\u00020\u00022\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001c0 \u00a2\u0006\u0002\b!H\u0086\b\u00f8\u0001\u0000J\b\u0010\"\u001a\u00020\u0002H\u0016R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0011R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/ir/builders/IrBlockBuilder;", "Lorg/jetbrains/kotlin/ir/builders/IrStatementsBuilder;", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "context", "Lorg/jetbrains/kotlin/ir/builders/IrGeneratorContext;", "scope", "Lorg/jetbrains/kotlin/ir/builders/Scope;", "startOffset", "", "endOffset", "origin", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "resultType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isTransparent", "", "(Lorg/jetbrains/kotlin/ir/builders/IrGeneratorContext;Lorg/jetbrains/kotlin/ir/builders/Scope;IILorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;Lorg/jetbrains/kotlin/ir/types/IrType;Z)V", "()Z", "getOrigin", "()Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "getResultType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "setResultType", "(Lorg/jetbrains/kotlin/ir/types/IrType;)V", "statements", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/ir/IrStatement;", "addStatement", "", "irStatement", "block", "body", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "doBuild", "ir.tree"})
public final class IrBlockBuilder
extends IrStatementsBuilder<IrContainerExpression> {
    @Nullable
    private final IrStatementOrigin origin;
    @Nullable
    private IrType resultType;
    private final boolean isTransparent;
    @NotNull
    private final ArrayList<IrStatement> statements;

    public IrBlockBuilder(@NotNull IrGeneratorContext context, @NotNull Scope scope2, int startOffset, int endOffset, @Nullable IrStatementOrigin origin2, @Nullable IrType resultType, boolean isTransparent) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        super(context, scope2, startOffset, endOffset);
        this.origin = origin2;
        this.resultType = resultType;
        this.isTransparent = isTransparent;
        this.statements = new ArrayList();
    }

    public /* synthetic */ IrBlockBuilder(IrGeneratorContext irGeneratorContext, Scope scope2, int n, int n2, IrStatementOrigin irStatementOrigin, IrType irType, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            irStatementOrigin = null;
        }
        if ((n3 & 0x20) != 0) {
            irType = null;
        }
        if ((n3 & 0x40) != 0) {
            bl = false;
        }
        this(irGeneratorContext, scope2, n, n2, irStatementOrigin, irType, bl);
    }

    @Nullable
    public final IrStatementOrigin getOrigin() {
        return this.origin;
    }

    @Nullable
    public final IrType getResultType() {
        return this.resultType;
    }

    public final void setResultType(@Nullable IrType irType) {
        this.resultType = irType;
    }

    public final boolean isTransparent() {
        return this.isTransparent;
    }

    @NotNull
    public final IrContainerExpression block(@NotNull Function1<? super IrBlockBuilder, Unit> body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        boolean $i$f$block = false;
        body2.invoke(this);
        return this.doBuild();
    }

    @Override
    protected void addStatement(@NotNull IrStatement irStatement) {
        Intrinsics.checkNotNullParameter(irStatement, "irStatement");
        this.statements.add(irStatement);
    }

    @Override
    @NotNull
    public IrContainerExpression doBuild() {
        IrType irType = this.resultType;
        if (irType == null) {
            Object $this$safeAs$iv = CollectionsKt.lastOrNull((List)this.statements);
            boolean $i$f$safeAs = false;
            Object t = $this$safeAs$iv;
            if (!(t instanceof IrExpression)) {
                t = null;
            }
            IrExpression irExpression = (IrExpression)t;
            irType = irExpression != null ? irExpression.getType() : null;
            if (irType == null) {
                irType = this.getContext().getIrBuiltIns().getUnitType();
            }
        }
        IrType resultType = irType;
        IrContainerExpression irBlock = this.isTransparent ? (IrContainerExpression)new IrCompositeImpl(this.getStartOffset(), this.getEndOffset(), resultType, this.origin) : (IrContainerExpression)new IrBlockImpl(this.getStartOffset(), this.getEndOffset(), resultType, this.origin);
        irBlock.getStatements().addAll((Collection<IrStatement>)this.statements);
        return irBlock;
    }
}

