/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles;

import java.util.Comparator;
import java.util.List;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleComparator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleComparators;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleListIterator;

public interface DoubleList
extends DoubleCollection,
Comparable<List<? extends Double>>,
List<Double> {
    @Override
    public DoubleListIterator iterator();

    public DoubleListIterator listIterator();

    public DoubleListIterator listIterator(int var1);

    public DoubleList subList(int var1, int var2);

    public void removeElements(int var1, int var2);

    default public void setElements(double[] a) {
        this.setElements(0, a);
    }

    default public void setElements(int index2, double[] a) {
        this.setElements(index2, a, 0, a.length);
    }

    default public void setElements(int index2, double[] a, int offset2, int length) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than list size (" + this.size() + ")");
        }
        DoubleArrays.ensureOffsetLength(a, offset2, length);
        if (index2 + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (index2 + length) + ") is greater than list size (" + this.size() + ")");
        }
        DoubleListIterator iter = this.listIterator(index2);
        int i = 0;
        while (i < length) {
            iter.nextDouble();
            iter.set(a[offset2 + i++]);
        }
    }

    @Override
    public boolean add(double var1);

    @Override
    public void add(int var1, double var2);

    @Override
    @Deprecated
    default public void add(int index2, Double key) {
        this.add(index2, (double)key);
    }

    @Override
    public double set(int var1, double var2);

    public double getDouble(int var1);

    public int indexOf(double var1);

    public int lastIndexOf(double var1);

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        return DoubleCollection.super.contains(key);
    }

    @Override
    @Deprecated
    default public Double get(int index2) {
        return this.getDouble(index2);
    }

    @Override
    @Deprecated
    default public int indexOf(Object o) {
        return this.indexOf((Double)o);
    }

    @Override
    @Deprecated
    default public int lastIndexOf(Object o) {
        return this.lastIndexOf((Double)o);
    }

    @Override
    @Deprecated
    default public boolean add(Double k) {
        return this.add((double)k);
    }

    public double removeDouble(int var1);

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        return DoubleCollection.super.remove(key);
    }

    @Override
    @Deprecated
    default public Double remove(int index2) {
        return this.removeDouble(index2);
    }

    @Override
    @Deprecated
    default public Double set(int index2, Double k) {
        return this.set(index2, (double)k);
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super Double> comparator2) {
        this.sort(DoubleComparators.asDoubleComparator(comparator2));
    }

    default public void sort(DoubleComparator comparator2) {
        double[] elements = this.toDoubleArray();
        if (comparator2 == null) {
            DoubleArrays.stableSort(elements);
        } else {
            DoubleArrays.stableSort(elements, comparator2);
        }
        this.setElements(elements);
    }
}

