/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats;

import java.util.Comparator;
import java.util.List;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.FloatArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.FloatCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.FloatComparator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.FloatComparators;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.FloatListIterator;

public interface FloatList
extends FloatCollection,
Comparable<List<? extends Float>>,
List<Float> {
    @Override
    public FloatListIterator iterator();

    public FloatListIterator listIterator();

    public FloatListIterator listIterator(int var1);

    public FloatList subList(int var1, int var2);

    default public void setElements(float[] a) {
        this.setElements(0, a);
    }

    default public void setElements(int index2, float[] a) {
        this.setElements(index2, a, 0, a.length);
    }

    default public void setElements(int index2, float[] a, int offset2, int length) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than list size (" + this.size() + ")");
        }
        FloatArrays.ensureOffsetLength(a, offset2, length);
        if (index2 + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (index2 + length) + ") is greater than list size (" + this.size() + ")");
        }
        FloatListIterator iter = this.listIterator(index2);
        int i = 0;
        while (i < length) {
            iter.nextFloat();
            iter.set(a[offset2 + i++]);
        }
    }

    @Override
    public boolean add(float var1);

    @Override
    public void add(int var1, float var2);

    @Override
    @Deprecated
    default public void add(int index2, Float key) {
        this.add(index2, key.floatValue());
    }

    @Override
    public float set(int var1, float var2);

    public float getFloat(int var1);

    public int indexOf(float var1);

    public int lastIndexOf(float var1);

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        return FloatCollection.super.contains(key);
    }

    @Override
    @Deprecated
    default public Float get(int index2) {
        return Float.valueOf(this.getFloat(index2));
    }

    @Override
    @Deprecated
    default public int indexOf(Object o) {
        return this.indexOf(((Float)o).floatValue());
    }

    @Override
    @Deprecated
    default public int lastIndexOf(Object o) {
        return this.lastIndexOf(((Float)o).floatValue());
    }

    @Override
    @Deprecated
    default public boolean add(Float k) {
        return this.add(k.floatValue());
    }

    public float removeFloat(int var1);

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        return FloatCollection.super.remove(key);
    }

    @Override
    @Deprecated
    default public Float remove(int index2) {
        return Float.valueOf(this.removeFloat(index2));
    }

    @Override
    @Deprecated
    default public Float set(int index2, Float k) {
        return Float.valueOf(this.set(index2, k.floatValue()));
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super Float> comparator2) {
        this.sort(FloatComparators.asFloatComparator(comparator2));
    }

    default public void sort(FloatComparator comparator2) {
        float[] elements = this.toFloatArray();
        if (comparator2 == null) {
            FloatArrays.stableSort(elements);
        } else {
            FloatArrays.stableSort(elements, comparator2);
        }
        this.setElements(elements);
    }
}

