/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts;

import java.io.Serializable;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Arrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Hash;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortComparator;

public final class ShortArrays {
    public static final short[] EMPTY_ARRAY = new short[0];
    public static final short[] DEFAULT_EMPTY_ARRAY = new short[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<short[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static void ensureOffsetLength(short[] a, int offset2, int length) {
        Arrays.ensureOffsetLength(a.length, offset2, length);
    }

    public static void swap(short[] x, int a, int b) {
        short t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    public static void swap(short[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ShortArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(short[] x, int a, int b, int c, ShortComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(short[] a, int from2, int to, ShortComparator comp) {
        for (int i = from2; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (comp.compare(a[j], a[m]) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            short u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static void insertionSort(short[] a, int from2, int to, ShortComparator comp) {
        int i = from2;
        while (++i < to) {
            short t = a[i];
            int j = i;
            short u = a[j - 1];
            while (comp.compare(t, u) < 0) {
                a[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void quickSort(short[] x, int from2, int to, ShortComparator comp) {
        int c;
        int a;
        int len = to - from2;
        if (len < 16) {
            ShortArrays.selectionSort(x, from2, to, comp);
            return;
        }
        int m = from2 + len / 2;
        int l = from2;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = ShortArrays.med3(x, l, l + s, l + 2 * s, comp);
            m = ShortArrays.med3(x, m - s, m, m + s, comp);
            n = ShortArrays.med3(x, n - 2 * s, n - s, n, comp);
        }
        m = ShortArrays.med3(x, l, m, n, comp);
        short v = x[m];
        int b = a = from2;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    ShortArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    ShortArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ShortArrays.swap(x, b++, c--);
        }
        int s = Math.min(a - from2, b - a);
        ShortArrays.swap(x, from2, b - s, s);
        s = Math.min(d - c, to - d - 1);
        ShortArrays.swap(x, b, to - s, s);
        s = b - a;
        if (s > 1) {
            ShortArrays.quickSort(x, from2, from2 + s, comp);
        }
        if ((s = d - c) > 1) {
            ShortArrays.quickSort(x, to - s, to, comp);
        }
    }

    private static int med3(short[] x, int a, int b, int c) {
        int ab = Short.compare(x[a], x[b]);
        int ac = Short.compare(x[a], x[c]);
        int bc = Short.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(short[] a, int from2, int to) {
        for (int i = from2; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (a[j] >= a[m]) continue;
                m = j;
            }
            if (m == i) continue;
            short u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    public static void quickSort(short[] x, int from2, int to) {
        int c;
        int a;
        int len = to - from2;
        if (len < 16) {
            ShortArrays.selectionSort(x, from2, to);
            return;
        }
        int m = from2 + len / 2;
        int l = from2;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = ShortArrays.med3(x, l, l + s, l + 2 * s);
            m = ShortArrays.med3(x, m - s, m, m + s);
            n = ShortArrays.med3(x, n - 2 * s, n - s, n);
        }
        m = ShortArrays.med3(x, l, m, n);
        short v = x[m];
        int b = a = from2;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = Short.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    ShortArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = Short.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    ShortArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ShortArrays.swap(x, b++, c--);
        }
        int s = Math.min(a - from2, b - a);
        ShortArrays.swap(x, from2, b - s, s);
        s = Math.min(d - c, to - d - 1);
        ShortArrays.swap(x, b, to - s, s);
        s = b - a;
        if (s > 1) {
            ShortArrays.quickSort(x, from2, from2 + s);
        }
        if ((s = d - c) > 1) {
            ShortArrays.quickSort(x, to - s, to);
        }
    }

    public static void unstableSort(short[] a, int from2, int to) {
        if (to - from2 >= 1000) {
            ShortArrays.radixSort(a, from2, to);
        } else {
            ShortArrays.quickSort(a, from2, to);
        }
    }

    public static void unstableSort(short[] a) {
        ShortArrays.unstableSort(a, 0, a.length);
    }

    public static void unstableSort(short[] a, int from2, int to, ShortComparator comp) {
        ShortArrays.quickSort(a, from2, to, comp);
    }

    public static void unstableSort(short[] a, ShortComparator comp) {
        ShortArrays.unstableSort(a, 0, a.length, comp);
    }

    public static void mergeSort(short[] a, int from2, int to, ShortComparator comp, short[] supp) {
        int len = to - from2;
        if (len < 16) {
            ShortArrays.insertionSort(a, from2, to, comp);
            return;
        }
        int mid = from2 + to >>> 1;
        ShortArrays.mergeSort(supp, from2, mid, comp, a);
        ShortArrays.mergeSort(supp, mid, to, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a, from2, len);
            return;
        }
        int p = from2;
        int q = mid;
        for (int i = from2; i < to; ++i) {
            a[i] = q >= to || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(short[] a, int from2, int to, ShortComparator comp) {
        ShortArrays.mergeSort(a, from2, to, comp, (short[])a.clone());
    }

    public static void stableSort(short[] a, int from2, int to, ShortComparator comp) {
        ShortArrays.mergeSort(a, from2, to, comp);
    }

    public static void stableSort(short[] a, ShortComparator comp) {
        ShortArrays.stableSort(a, 0, a.length, comp);
    }

    public static void radixSort(short[] a, int from2, int to) {
        if (to - from2 < 1024) {
            ShortArrays.quickSort(a, from2, to);
            return;
        }
        boolean maxLevel = true;
        int stackSize = 256;
        int stackPos = 0;
        int[] offsetStack = new int[256];
        int[] lengthStack = new int[256];
        int[] levelStack = new int[256];
        offsetStack[stackPos] = from2;
        lengthStack[stackPos] = to - from2;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        while (stackPos > 0) {
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 2 == 0 ? 128 : 0;
            int shift = (1 - level % 2) * 8;
            int i = first2 + length;
            while (i-- != first2) {
                int n = a[i] >>> shift & 0xFF ^ signMask;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int p = first2;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0) {
                    lastUsed = i2;
                }
                pos[i2] = p += count2[i2];
            }
            int end2 = first2 + length - count2[lastUsed];
            int c = -1;
            for (int i3 = first2; i3 <= end2; i3 += count2[c]) {
                short t = a[i3];
                c = t >>> shift & 0xFF ^ signMask;
                if (i3 < end2) {
                    while (true) {
                        int n = c;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i3) break;
                        short z = t;
                        t = a[d];
                        a[d] = z;
                        c = t >>> shift & 0xFF ^ signMask;
                    }
                    a[i3] = t;
                }
                if (level < 1 && count2[c] > 1) {
                    if (count2[c] < 1024) {
                        ShortArrays.quickSort(a, i3, i3 + count2[c]);
                    } else {
                        offsetStack[stackPos] = i3;
                        lengthStack[stackPos] = count2[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset2, int length, int level) {
            this.offset = offset2;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<short[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(short[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(short[] a, short[] b) {
            return java.util.Arrays.equals(a, b);
        }
    }
}

