/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.operation.IncrementTranslator;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtUnaryExpression;

public class DynamicIncrementTranslator
extends IncrementTranslator {
    @NotNull
    public static JsExpression doTranslate(@NotNull KtUnaryExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            DynamicIncrementTranslator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DynamicIncrementTranslator.$$$reportNull$$$0(1);
        }
        return new DynamicIncrementTranslator(expression2, context).translate();
    }

    private DynamicIncrementTranslator(@NotNull KtUnaryExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            DynamicIncrementTranslator.$$$reportNull$$$0(2);
        }
        if (context == null) {
            DynamicIncrementTranslator.$$$reportNull$$$0(3);
        }
        super(expression2, context);
    }

    @NotNull
    private JsExpression translate() {
        if (TranslationUtils.isSimpleNameExpressionNotDelegatedLocalVar(this.expression.getBaseExpression(), this.context())) {
            return this.primitiveExpressionIncrement();
        }
        JsExpression jsExpression = this.translateIncrementExpression();
        if (jsExpression == null) {
            DynamicIncrementTranslator.$$$reportNull$$$0(4);
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression primitiveExpressionIncrement() {
        JsUnaryOperator operator = OperatorTable.getUnaryOperator(PsiUtils.getOperationToken(this.expression));
        JsExpression getExpression = this.accessTranslator.translateAsGet();
        if (PsiUtils.isPrefix(this.expression)) {
            return new JsPrefixOperation(operator, getExpression);
        }
        return new JsPostfixOperation(operator, getExpression);
    }

    @Override
    @NotNull
    protected JsExpression operationExpression(@NotNull TranslationContext context, @NotNull JsExpression receiver2) {
        if (context == null) {
            DynamicIncrementTranslator.$$$reportNull$$$0(5);
        }
        if (receiver2 == null) {
            DynamicIncrementTranslator.$$$reportNull$$$0(6);
        }
        return this.unaryAsBinary(receiver2);
    }

    @NotNull
    private JsBinaryOperation unaryAsBinary(@NotNull JsExpression leftExpression) {
        if (leftExpression == null) {
            DynamicIncrementTranslator.$$$reportNull$$$0(7);
        }
        JsIntLiteral oneLiteral = new JsIntLiteral(1);
        KtToken token2 = PsiUtils.getOperationToken(this.expression);
        if (token2.equals(KtTokens.PLUSPLUS)) {
            return new JsBinaryOperation(JsBinaryOperator.ADD, leftExpression, oneLiteral);
        }
        if (token2.equals(KtTokens.MINUSMINUS)) {
            return new JsBinaryOperation(JsBinaryOperator.SUB, leftExpression, oneLiteral);
        }
        throw new AssertionError((Object)"This method should be called only for increment and decrement operators");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/operation/DynamicIncrementTranslator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/operation/DynamicIncrementTranslator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTranslate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "operationExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "unaryAsBinary";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

