/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.QualifiedExpressionTranslator;
import org.jetbrains.kotlin.psi.KtCallExpression;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0001H\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/QualifiedExpressionWithCallSelectorAccessTranslator;", "Lorg/jetbrains/kotlin/js/translate/reference/AccessTranslator;", "selector", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "receiver", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "getCached", "translateAsGet", "translateAsSet", "setTo", "js.translator"})
public final class QualifiedExpressionWithCallSelectorAccessTranslator
implements AccessTranslator {
    @NotNull
    private final KtCallExpression selector;
    @Nullable
    private final JsExpression receiver;
    @NotNull
    private final TranslationContext context;

    public QualifiedExpressionWithCallSelectorAccessTranslator(@NotNull KtCallExpression selector, @Nullable JsExpression receiver2, @NotNull TranslationContext context) {
        Intrinsics.checkNotNullParameter(selector, "selector");
        Intrinsics.checkNotNullParameter(context, "context");
        this.selector = selector;
        this.receiver = receiver2;
        this.context = context;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        JsNode jsNode = QualifiedExpressionTranslator.invokeCallExpressionTranslator(this.receiver, this.selector, this.context);
        Intrinsics.checkNotNull(jsNode, "null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsExpression");
        return (JsExpression)jsNode;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression setTo) {
        Intrinsics.checkNotNullParameter(setTo, "setTo");
        throw new IllegalStateException("Set access is not supported for " + this.getClass().getSimpleName());
    }

    @Override
    @NotNull
    public AccessTranslator getCached() {
        throw new IllegalStateException("Cashed access is not supported for " + this.getClass().getSimpleName());
    }
}

