/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jdom.output;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import org.jetbrains.kotlin.org.jdom.Attribute;
import org.jetbrains.kotlin.org.jdom.CDATA;
import org.jetbrains.kotlin.org.jdom.Comment;
import org.jetbrains.kotlin.org.jdom.Content;
import org.jetbrains.kotlin.org.jdom.DocType;
import org.jetbrains.kotlin.org.jdom.Document;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.EntityRef;
import org.jetbrains.kotlin.org.jdom.IllegalDataException;
import org.jetbrains.kotlin.org.jdom.Namespace;
import org.jetbrains.kotlin.org.jdom.ProcessingInstruction;
import org.jetbrains.kotlin.org.jdom.Text;
import org.jetbrains.kotlin.org.jdom.Verifier;
import org.jetbrains.kotlin.org.jdom.output.EscapeStrategy;
import org.jetbrains.kotlin.org.jdom.output.Format;

public class XMLOutputter
implements Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: XMLOutputter.java,v $ $Revision: 1.117 $ $Date: 2009/07/23 05:54:23 $ $Name:  $";
    private Format userFormat;
    protected static final Format preserveFormat = Format.getRawFormat();
    protected Format currentFormat;
    private boolean escapeOutput;

    public XMLOutputter() {
        this.currentFormat = this.userFormat = Format.getRawFormat();
        this.escapeOutput = true;
    }

    public XMLOutputter(Format format) {
        this.currentFormat = this.userFormat = Format.getRawFormat();
        this.escapeOutput = true;
        this.currentFormat = this.userFormat = format.clone();
    }

    public XMLOutputter(XMLOutputter that) {
        this.currentFormat = this.userFormat = Format.getRawFormat();
        this.escapeOutput = true;
        this.currentFormat = this.userFormat = that.userFormat.clone();
    }

    public void setFormat(Format newFormat) {
        this.currentFormat = this.userFormat = newFormat.clone();
    }

    public Format getFormat() {
        return this.userFormat.clone();
    }

    public void output(Document doc, OutputStream out2) throws IOException {
        Writer writer = this.makeWriter(out2);
        this.output(doc, writer);
    }

    public void output(DocType doctype, OutputStream out2) throws IOException {
        Writer writer = this.makeWriter(out2);
        this.output(doctype, writer);
    }

    public void output(Element element, OutputStream out2) throws IOException {
        Writer writer = this.makeWriter(out2);
        this.output(element, writer);
    }

    public void outputElementContent(Element element, OutputStream out2) throws IOException {
        Writer writer = this.makeWriter(out2);
        this.outputElementContent(element, writer);
    }

    public void output(List list2, OutputStream out2) throws IOException {
        Writer writer = this.makeWriter(out2);
        this.output(list2, writer);
    }

    public void output(CDATA cdata, OutputStream out2) throws IOException {
        Writer writer = this.makeWriter(out2);
        this.output(cdata, writer);
    }

    public void output(Text text2, OutputStream out2) throws IOException {
        Writer writer = this.makeWriter(out2);
        this.output(text2, writer);
    }

    public void output(Comment comment, OutputStream out2) throws IOException {
        Writer writer = this.makeWriter(out2);
        this.output(comment, writer);
    }

    public void output(ProcessingInstruction pi, OutputStream out2) throws IOException {
        Writer writer = this.makeWriter(out2);
        this.output(pi, writer);
    }

    public void output(EntityRef entity, OutputStream out2) throws IOException {
        Writer writer = this.makeWriter(out2);
        this.output(entity, writer);
    }

    private Writer makeWriter(OutputStream out2) throws UnsupportedEncodingException {
        return XMLOutputter.makeWriter(out2, this.userFormat.encoding);
    }

    private static Writer makeWriter(OutputStream out2, String enc) throws UnsupportedEncodingException {
        if ("UTF-8".equals(enc)) {
            enc = "UTF8";
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(out2), enc));
        return writer;
    }

    public void output(Document doc, Writer out2) throws IOException {
        this.printDeclaration(out2, doc, this.userFormat.encoding);
        List<Content> content2 = doc.getContent();
        int size2 = content2.size();
        for (int i = 0; i < size2; ++i) {
            Content obj = content2.get(i);
            if (obj instanceof Element) {
                this.printElement(out2, doc.getRootElement(), 0, this.createNamespaceStack());
            } else if (obj instanceof Comment) {
                this.printComment(out2, (Comment)obj);
            } else if (obj instanceof ProcessingInstruction) {
                this.printProcessingInstruction(out2, (ProcessingInstruction)obj);
            } else if (obj instanceof DocType) {
                this.printDocType(out2, doc.getDocType());
                this.writeLineSeparator(out2);
            }
            this.newline(out2);
            this.indent(out2, 0);
        }
        this.writeLineSeparator(out2);
        out2.flush();
    }

    private void writeLineSeparator(Writer out2) throws IOException {
        if (this.currentFormat.lineSeparator != null) {
            out2.write(this.currentFormat.lineSeparator);
        }
    }

    public void output(DocType doctype, Writer out2) throws IOException {
        this.printDocType(out2, doctype);
        out2.flush();
    }

    public void output(Element element, Writer out2) throws IOException {
        this.printElement(out2, element, 0, this.createNamespaceStack());
        out2.flush();
    }

    public void outputElementContent(Element element, Writer out2) throws IOException {
        List<Content> content2 = element.getContent();
        this.printContentRange(out2, content2, 0, content2.size(), 0, this.createNamespaceStack());
        out2.flush();
    }

    public void output(List list2, Writer out2) throws IOException {
        this.printContentRange(out2, list2, 0, list2.size(), 0, this.createNamespaceStack());
        out2.flush();
    }

    public void output(CDATA cdata, Writer out2) throws IOException {
        this.printCDATA(out2, cdata);
        out2.flush();
    }

    public void output(Text text2, Writer out2) throws IOException {
        this.printText(out2, text2);
        out2.flush();
    }

    public void output(Comment comment, Writer out2) throws IOException {
        this.printComment(out2, comment);
        out2.flush();
    }

    public void output(ProcessingInstruction pi, Writer out2) throws IOException {
        boolean currentEscapingPolicy = this.currentFormat.ignoreTrAXEscapingPIs;
        this.currentFormat.setIgnoreTrAXEscapingPIs(true);
        this.printProcessingInstruction(out2, pi);
        this.currentFormat.setIgnoreTrAXEscapingPIs(currentEscapingPolicy);
        out2.flush();
    }

    public void output(EntityRef entity, Writer out2) throws IOException {
        this.printEntityRef(out2, entity);
        out2.flush();
    }

    public String outputString(Document doc) {
        StringWriter out2 = new StringWriter();
        try {
            this.output(doc, (Writer)out2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out2.toString();
    }

    public String outputString(DocType doctype) {
        StringWriter out2 = new StringWriter();
        try {
            this.output(doctype, (Writer)out2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out2.toString();
    }

    public String outputString(Element element) {
        StringWriter out2 = new StringWriter();
        try {
            this.output(element, (Writer)out2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out2.toString();
    }

    public String outputString(List list2) {
        StringWriter out2 = new StringWriter();
        try {
            this.output(list2, (Writer)out2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out2.toString();
    }

    public String outputString(CDATA cdata) {
        StringWriter out2 = new StringWriter();
        try {
            this.output(cdata, (Writer)out2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out2.toString();
    }

    public String outputString(Text text2) {
        StringWriter out2 = new StringWriter();
        try {
            this.output(text2, (Writer)out2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out2.toString();
    }

    public String outputString(Comment comment) {
        StringWriter out2 = new StringWriter();
        try {
            this.output(comment, (Writer)out2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out2.toString();
    }

    public String outputString(ProcessingInstruction pi) {
        StringWriter out2 = new StringWriter();
        try {
            this.output(pi, (Writer)out2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out2.toString();
    }

    public String outputString(EntityRef entity) {
        StringWriter out2 = new StringWriter();
        try {
            this.output(entity, (Writer)out2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out2.toString();
    }

    protected void printDeclaration(Writer out2, Document doc, String encoding) throws IOException {
        if (!this.userFormat.omitDeclaration) {
            out2.write("<?xml version=\"1.0\"");
            if (!this.userFormat.omitEncoding) {
                out2.write(" encoding=\"" + encoding + "\"");
            }
            out2.write("?>");
            this.writeLineSeparator(out2);
        }
    }

    protected void printDocType(Writer out2, DocType docType) throws IOException {
        String publicID = docType.getPublicID();
        String systemID = docType.getSystemID();
        String internalSubset = docType.getInternalSubset();
        boolean hasPublic = false;
        out2.write("<!DOCTYPE ");
        out2.write(docType.getElementName());
        if (publicID != null) {
            out2.write(" PUBLIC \"");
            out2.write(publicID);
            out2.write("\"");
            hasPublic = true;
        }
        if (systemID != null) {
            if (!hasPublic) {
                out2.write(" SYSTEM");
            }
            out2.write(" \"");
            out2.write(systemID);
            out2.write("\"");
        }
        if (internalSubset != null && !internalSubset.equals("")) {
            out2.write(" [");
            this.writeLineSeparator(out2);
            out2.write(docType.getInternalSubset());
            out2.write("]");
        }
        out2.write(">");
    }

    protected void printComment(Writer out2, Comment comment) throws IOException {
        out2.write("<!--");
        out2.write(comment.getText());
        out2.write("-->");
    }

    protected void printProcessingInstruction(Writer out2, ProcessingInstruction pi) throws IOException {
        String target = pi.getTarget();
        boolean piProcessed = false;
        if (!this.currentFormat.ignoreTrAXEscapingPIs) {
            if (target.equals("javax.xml.transform.disable-output-escaping")) {
                this.escapeOutput = false;
                piProcessed = true;
            } else if (target.equals("javax.xml.transform.enable-output-escaping")) {
                this.escapeOutput = true;
                piProcessed = true;
            }
        }
        if (!piProcessed) {
            String rawData = pi.getData();
            if (!"".equals(rawData)) {
                out2.write("<?");
                out2.write(target);
                out2.write(" ");
                out2.write(rawData);
                out2.write("?>");
            } else {
                out2.write("<?");
                out2.write(target);
                out2.write("?>");
            }
        }
    }

    protected void printEntityRef(Writer out2, EntityRef entity) throws IOException {
        out2.write("&");
        out2.write(entity.getName());
        out2.write(";");
    }

    protected void printCDATA(Writer out2, CDATA cdata) throws IOException {
        String str = this.currentFormat.mode == Format.TextMode.NORMALIZE ? cdata.getTextNormalize() : (this.currentFormat.mode == Format.TextMode.TRIM ? cdata.getText().trim() : cdata.getText());
        out2.write("<![CDATA[");
        out2.write(str);
        out2.write("]]>");
    }

    protected void printText(Writer out2, Text text2) throws IOException {
        String str = this.currentFormat.mode == Format.TextMode.NORMALIZE ? text2.getTextNormalize() : (this.currentFormat.mode == Format.TextMode.TRIM ? text2.getText().trim() : text2.getText());
        out2.write(this.escapeElementEntities(str));
    }

    private void printString(Writer out2, String str) throws IOException {
        if (this.currentFormat.mode == Format.TextMode.NORMALIZE) {
            str = Text.normalizeString(str);
        } else if (this.currentFormat.mode == Format.TextMode.TRIM) {
            str = str.trim();
        }
        out2.write(this.escapeElementEntities(str));
    }

    protected void printElement(Writer out2, Element element, int level, NamespaceStack namespaces) throws IOException {
        int size2;
        int start2;
        List<Attribute> attributes2 = element.getAttributes();
        List<Content> content2 = element.getContent();
        String space = null;
        if (attributes2 != null) {
            space = element.getAttributeValue("space", Namespace.XML_NAMESPACE);
        }
        Format previousFormat = this.currentFormat;
        if ("default".equals(space)) {
            this.currentFormat = this.userFormat;
        } else if ("preserve".equals(space)) {
            this.currentFormat = preserveFormat;
        }
        out2.write("<");
        this.printQualifiedName(out2, element);
        int previouslyDeclaredNamespaces = namespaces.size();
        this.printElementNamespace(out2, element, namespaces);
        this.printAdditionalNamespaces(out2, element, namespaces);
        if (attributes2 != null) {
            this.printAttributes(out2, attributes2, element, namespaces);
        }
        if ((start2 = this.skipLeadingWhite(content2, 0)) >= (size2 = content2.size())) {
            if (this.currentFormat.expandEmptyElements) {
                out2.write("></");
                this.printQualifiedName(out2, element);
                out2.write(">");
            } else {
                out2.write(" />");
            }
        } else {
            out2.write(">");
            if (XMLOutputter.nextNonText(content2, start2) < size2) {
                this.newline(out2);
                this.printContentRange(out2, content2, start2, size2, level + 1, namespaces);
                this.newline(out2);
                this.indent(out2, level);
            } else {
                this.printTextRange(out2, content2, start2, size2);
            }
            out2.write("</");
            this.printQualifiedName(out2, element);
            out2.write(">");
        }
        while (namespaces.size() > previouslyDeclaredNamespaces) {
            namespaces.pop();
        }
        this.currentFormat = previousFormat;
    }

    private void printContentRange(Writer out2, List content2, int start2, int end2, int level, NamespaceStack namespaces) throws IOException {
        int index2 = start2;
        while (index2 < end2) {
            boolean firstNode = index2 == start2;
            Object next = content2.get(index2);
            if (next instanceof Text || next instanceof EntityRef) {
                int first2 = this.skipLeadingWhite(content2, index2);
                if (first2 >= (index2 = XMLOutputter.nextNonText(content2, first2))) continue;
                if (!firstNode) {
                    this.newline(out2);
                }
                this.indent(out2, level);
                this.printTextRange(out2, content2, first2, index2);
                continue;
            }
            if (!firstNode) {
                this.newline(out2);
            }
            this.indent(out2, level);
            if (next instanceof Comment) {
                this.printComment(out2, (Comment)next);
            } else if (next instanceof Element) {
                this.printElement(out2, (Element)next, level, namespaces);
            } else if (next instanceof ProcessingInstruction) {
                this.printProcessingInstruction(out2, (ProcessingInstruction)next);
            }
            ++index2;
        }
    }

    private void printTextRange(Writer out2, List content2, int start2, int end2) throws IOException {
        int size2;
        String previous = null;
        if ((start2 = this.skipLeadingWhite(content2, start2)) < (size2 = content2.size())) {
            end2 = this.skipTrailingWhite(content2, end2);
            for (int i = start2; i < end2; ++i) {
                String next;
                Object node = content2.get(i);
                if (node instanceof Text) {
                    next = ((Text)node).getText();
                } else if (node instanceof EntityRef) {
                    next = "&" + ((EntityRef)node).getValue() + ";";
                } else {
                    throw new IllegalStateException("Should see only CDATA, Text, or EntityRef");
                }
                if (next == null || "".equals(next)) continue;
                if (previous != null && (this.currentFormat.mode == Format.TextMode.NORMALIZE || this.currentFormat.mode == Format.TextMode.TRIM) && (this.endsWithWhite(previous) || this.startsWithWhite(next))) {
                    out2.write(" ");
                }
                if (node instanceof CDATA) {
                    this.printCDATA(out2, (CDATA)node);
                } else if (node instanceof EntityRef) {
                    this.printEntityRef(out2, (EntityRef)node);
                } else {
                    this.printString(out2, next);
                }
                previous = next;
            }
        }
    }

    private void printNamespace(Writer out2, Namespace ns, NamespaceStack namespaces) throws IOException {
        String prefix = ns.getPrefix();
        String uri2 = ns.getURI();
        if (uri2.equals(namespaces.getURI(prefix))) {
            return;
        }
        out2.write(" xmlns");
        if (!prefix.equals("")) {
            out2.write(":");
            out2.write(prefix);
        }
        out2.write("=\"");
        out2.write(this.escapeAttributeEntities(uri2));
        out2.write("\"");
        namespaces.push(ns);
    }

    protected void printAttributes(Writer out2, List attributes2, Element parent2, NamespaceStack namespaces) throws IOException {
        for (int i = 0; i < attributes2.size(); ++i) {
            Attribute attribute = (Attribute)attributes2.get(i);
            Namespace ns = attribute.getNamespace();
            if (ns != Namespace.NO_NAMESPACE && ns != Namespace.XML_NAMESPACE) {
                this.printNamespace(out2, ns, namespaces);
            }
            out2.write(" ");
            this.printQualifiedName(out2, attribute);
            out2.write("=");
            out2.write("\"");
            out2.write(this.escapeAttributeEntities(attribute.getValue()));
            out2.write("\"");
        }
    }

    private void printElementNamespace(Writer out2, Element element, NamespaceStack namespaces) throws IOException {
        Namespace ns = element.getNamespace();
        if (ns == Namespace.XML_NAMESPACE) {
            return;
        }
        if (ns != Namespace.NO_NAMESPACE || namespaces.getURI("") != null) {
            this.printNamespace(out2, ns, namespaces);
        }
    }

    private void printAdditionalNamespaces(Writer out2, Element element, NamespaceStack namespaces) throws IOException {
        List<Namespace> list2 = element.getAdditionalNamespaces();
        if (list2 != null) {
            for (int i = 0; i < list2.size(); ++i) {
                Namespace additional = list2.get(i);
                this.printNamespace(out2, additional, namespaces);
            }
        }
    }

    private void newline(Writer out2) throws IOException {
        if (this.currentFormat.indent != null) {
            this.writeLineSeparator(out2);
        }
    }

    private void indent(Writer out2, int level) throws IOException {
        if (this.currentFormat.indent == null || this.currentFormat.indent.equals("")) {
            return;
        }
        for (int i = 0; i < level; ++i) {
            out2.write(this.currentFormat.indent);
        }
    }

    private int skipLeadingWhite(List content2, int start2) {
        int index2;
        if (start2 < 0) {
            start2 = 0;
        }
        int size2 = content2.size();
        if (this.currentFormat.mode == Format.TextMode.TRIM_FULL_WHITE || this.currentFormat.mode == Format.TextMode.NORMALIZE || this.currentFormat.mode == Format.TextMode.TRIM) {
            for (index2 = start2; index2 < size2; ++index2) {
                if (this.isAllWhitespace(content2.get(index2))) continue;
                return index2;
            }
        }
        return index2;
    }

    private int skipTrailingWhite(List content2, int start2) {
        int index2;
        int size2 = content2.size();
        if (start2 > size2) {
            start2 = size2;
        }
        if (this.currentFormat.mode == Format.TextMode.TRIM_FULL_WHITE || this.currentFormat.mode == Format.TextMode.NORMALIZE || this.currentFormat.mode == Format.TextMode.TRIM) {
            for (index2 = start2; index2 >= 0 && this.isAllWhitespace(content2.get(index2 - 1)); --index2) {
            }
        }
        return index2;
    }

    private static int nextNonText(List content2, int start2) {
        if (start2 < 0) {
            start2 = 0;
        }
        int size2 = content2.size();
        for (int index2 = start2; index2 < size2; ++index2) {
            Object node = content2.get(index2);
            if (node instanceof Text || node instanceof EntityRef) continue;
            return index2;
        }
        return size2;
    }

    private boolean isAllWhitespace(Object obj) {
        String str = null;
        if (obj instanceof String) {
            str = (String)obj;
        } else if (obj instanceof Text) {
            str = ((Text)obj).getText();
        } else {
            if (obj instanceof EntityRef) {
                return false;
            }
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Verifier.isXMLWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean startsWithWhite(String str) {
        return str != null && str.length() > 0 && Verifier.isXMLWhitespace(str.charAt(0));
    }

    private boolean endsWithWhite(String str) {
        return str != null && str.length() > 0 && Verifier.isXMLWhitespace(str.charAt(str.length() - 1));
    }

    public String escapeAttributeEntities(String str) {
        EscapeStrategy strategy = this.currentFormat.escapeStrategy;
        StringBuffer buffer = null;
        for (int i = 0; i < str.length(); ++i) {
            String entity;
            int ch = str.charAt(i);
            int pos = i++;
            switch (ch) {
                case 60: {
                    entity = "&lt;";
                    break;
                }
                case 62: {
                    entity = "&gt;";
                    break;
                }
                case 34: {
                    entity = "&quot;";
                    break;
                }
                case 38: {
                    entity = "&amp;";
                    break;
                }
                case 13: {
                    entity = "&#xD;";
                    break;
                }
                case 9: {
                    entity = "&#x9;";
                    break;
                }
                case 10: {
                    entity = "&#xA;";
                    break;
                }
                default: {
                    if (strategy.shouldEscape((char)ch)) {
                        if (Verifier.isHighSurrogate((char)ch)) {
                            if (i < str.length()) {
                                char low = str.charAt(i);
                                if (!Verifier.isLowSurrogate(low)) {
                                    throw new IllegalDataException("Could not decode surrogate pair 0x" + Integer.toHexString(ch) + " / 0x" + Integer.toHexString(low));
                                }
                                ch = Verifier.decodeSurrogatePair((char)ch, low);
                            } else {
                                throw new IllegalDataException("Surrogate pair 0x" + Integer.toHexString(ch) + " truncated");
                            }
                        }
                        entity = "&#x" + Integer.toHexString(ch) + ";";
                        break;
                    }
                    entity = null;
                }
            }
            if (buffer == null) {
                if (entity == null) continue;
                buffer = new StringBuffer(str.length() + 20);
                buffer.append(str.substring(0, pos));
                buffer.append(entity);
                continue;
            }
            if (entity == null) {
                buffer.append((char)ch);
                continue;
            }
            buffer.append(entity);
        }
        return buffer == null ? str : buffer.toString();
    }

    public String escapeElementEntities(String str) {
        if (!this.escapeOutput) {
            return str;
        }
        EscapeStrategy strategy = this.currentFormat.escapeStrategy;
        StringBuffer buffer = null;
        for (int i = 0; i < str.length(); ++i) {
            String entity;
            int ch = str.charAt(i);
            int pos = i++;
            switch (ch) {
                case 60: {
                    entity = "&lt;";
                    break;
                }
                case 62: {
                    entity = "&gt;";
                    break;
                }
                case 38: {
                    entity = "&amp;";
                    break;
                }
                case 13: {
                    entity = "&#xD;";
                    break;
                }
                case 10: {
                    entity = this.currentFormat.lineSeparator;
                    break;
                }
                default: {
                    if (strategy.shouldEscape((char)ch)) {
                        if (Verifier.isHighSurrogate((char)ch)) {
                            if (i < str.length()) {
                                char low = str.charAt(i);
                                if (!Verifier.isLowSurrogate(low)) {
                                    throw new IllegalDataException("Could not decode surrogate pair 0x" + Integer.toHexString(ch) + " / 0x" + Integer.toHexString(low));
                                }
                                ch = Verifier.decodeSurrogatePair((char)ch, low);
                            } else {
                                throw new IllegalDataException("Surrogate pair 0x" + Integer.toHexString(ch) + " truncated");
                            }
                        }
                        entity = "&#x" + Integer.toHexString(ch) + ";";
                        break;
                    }
                    entity = null;
                }
            }
            if (buffer == null) {
                if (entity == null) continue;
                buffer = new StringBuffer(str.length() + 20);
                buffer.append(str.substring(0, pos));
                buffer.append(entity);
                continue;
            }
            if (entity == null) {
                buffer.append((char)ch);
                continue;
            }
            buffer.append(entity);
        }
        return buffer == null ? str : buffer.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.userFormat.lineSeparator != null) {
            block5: for (int i = 0; i < this.userFormat.lineSeparator.length(); ++i) {
                char ch = this.userFormat.lineSeparator.charAt(i);
                switch (ch) {
                    case '\r': {
                        buffer.append("\\r");
                        continue block5;
                    }
                    case '\n': {
                        buffer.append("\\n");
                        continue block5;
                    }
                    case '\t': {
                        buffer.append("\\t");
                        continue block5;
                    }
                    default: {
                        buffer.append("[" + ch + "]");
                    }
                }
            }
        } else {
            buffer.append("null");
        }
        return "XMLOutputter[omitDeclaration = " + this.userFormat.omitDeclaration + ", " + "encoding = " + this.userFormat.encoding + ", " + "omitEncoding = " + this.userFormat.omitEncoding + ", " + "indent = '" + this.userFormat.indent + "'" + ", " + "expandEmptyElements = " + this.userFormat.expandEmptyElements + ", " + "lineSeparator = '" + buffer.toString() + "', " + "textMode = " + (Object)((Object)this.userFormat.mode) + "]";
    }

    private NamespaceStack createNamespaceStack() {
        return new NamespaceStack();
    }

    private void printQualifiedName(Writer out2, Element e) throws IOException {
        if (e.getNamespace().getPrefix().length() == 0) {
            out2.write(e.getName());
        } else {
            out2.write(e.getNamespace().getPrefix());
            out2.write(58);
            out2.write(e.getName());
        }
    }

    private void printQualifiedName(Writer out2, Attribute a) throws IOException {
        String prefix = a.getNamespace().getPrefix();
        if (prefix != null && !prefix.equals("")) {
            out2.write(prefix);
            out2.write(58);
            out2.write(a.getName());
        } else {
            out2.write(a.getName());
        }
    }

    protected class NamespaceStack
    extends org.jetbrains.kotlin.org.jdom.output.NamespaceStack {
        protected NamespaceStack() {
        }
    }
}

