/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jdom.output.support;

import java.io.IOException;
import java.io.Writer;
import org.jetbrains.kotlin.org.jdom.Comment;
import org.jetbrains.kotlin.org.jdom.DocType;
import org.jetbrains.kotlin.org.jdom.ProcessingInstruction;
import org.jetbrains.kotlin.org.jdom.output.Format;
import org.jetbrains.kotlin.org.jdom.output.support.AbstractOutputProcessor;
import org.jetbrains.kotlin.org.jdom.output.support.FormatStack;
import org.jetbrains.kotlin.org.jdom.output.support.XMLOutputProcessor;

public abstract class AbstractXMLOutputProcessor
extends AbstractOutputProcessor
implements XMLOutputProcessor {
    @Override
    public void process(Writer out2, Format format, DocType doctype) throws IOException {
        this.printDocType(out2, new FormatStack(format), doctype);
        out2.flush();
    }

    @Override
    public void process(Writer out2, Format format, Comment comment) throws IOException {
        this.printComment(out2, new FormatStack(format), comment);
        out2.flush();
    }

    @Override
    public void process(Writer out2, Format format, ProcessingInstruction pi) throws IOException {
        FormatStack fstack = new FormatStack(format);
        fstack.setIgnoreTrAXEscapingPIs(true);
        this.printProcessingInstruction(out2, fstack, pi);
        out2.flush();
    }

    protected void write(Writer out2, String str) throws IOException {
        if (str == null) {
            return;
        }
        out2.write(str);
    }

    protected void printDocType(Writer out2, FormatStack fstack, DocType docType) throws IOException {
        String publicID = docType.getPublicID();
        String systemID = docType.getSystemID();
        String internalSubset = docType.getInternalSubset();
        boolean hasPublic = false;
        this.write(out2, "<!DOCTYPE ");
        this.write(out2, docType.getElementName());
        if (publicID != null) {
            this.write(out2, " PUBLIC \"");
            this.write(out2, publicID);
            this.write(out2, "\"");
            hasPublic = true;
        }
        if (systemID != null) {
            if (!hasPublic) {
                this.write(out2, " SYSTEM");
            }
            this.write(out2, " \"");
            this.write(out2, systemID);
            this.write(out2, "\"");
        }
        if (internalSubset != null && !internalSubset.equals("")) {
            this.write(out2, " [");
            this.write(out2, fstack.getLineSeparator());
            this.write(out2, docType.getInternalSubset());
            this.write(out2, "]");
        }
        this.write(out2, ">");
    }

    protected void printProcessingInstruction(Writer out2, FormatStack fstack, ProcessingInstruction pi) throws IOException {
        String target = pi.getTarget();
        boolean piProcessed = false;
        if (!fstack.isIgnoreTrAXEscapingPIs()) {
            if (target.equals("javax.xml.transform.disable-output-escaping")) {
                fstack.setEscapeOutput(false);
                piProcessed = true;
            } else if (target.equals("javax.xml.transform.enable-output-escaping")) {
                fstack.setEscapeOutput(true);
                piProcessed = true;
            }
        }
        if (!piProcessed) {
            String rawData = pi.getData();
            if (!"".equals(rawData)) {
                this.write(out2, "<?");
                this.write(out2, target);
                this.write(out2, " ");
                this.write(out2, rawData);
                this.write(out2, "?>");
            } else {
                this.write(out2, "<?");
                this.write(out2, target);
                this.write(out2, "?>");
            }
        }
    }

    protected void printComment(Writer out2, FormatStack fstack, Comment comment) throws IOException {
        this.write(out2, "<!--");
        this.write(out2, comment.getText());
        this.write(out2, "-->");
    }
}

