/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.terminal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.kotlin.org.jline.terminal.Terminal;
import org.jetbrains.kotlin.org.jline.terminal.impl.AbstractPosixTerminal;
import org.jetbrains.kotlin.org.jline.terminal.spi.Pty;
import org.jetbrains.kotlin.org.jline.utils.ClosedException;
import org.jetbrains.kotlin.org.jline.utils.InputStreamReader;
import org.jetbrains.kotlin.org.jline.utils.NonBlockingReader;

public class PosixPtyTerminal
extends AbstractPosixTerminal {
    private final InputStreamWrapper input;
    private final OutputStream output;
    private final InputStreamReader innerReader;
    private final NonBlockingReader reader;
    private final PrintWriter writer;
    private final Thread inputPumpThread;
    private final Thread outputPumpThread;

    public PosixPtyTerminal(String name2, String type2, Pty pty, InputStream in, OutputStream out2, String encoding, Terminal.SignalHandler signalHandler) throws IOException {
        super(name2, type2, pty, signalHandler);
        Objects.requireNonNull(in);
        Objects.requireNonNull(out2);
        this.input = new InputStreamWrapper(pty.getSlaveInput());
        this.output = pty.getSlaveOutput();
        this.innerReader = new InputStreamReader(this.input, encoding);
        this.reader = new NonBlockingReader(name2, this.innerReader);
        this.writer = new PrintWriter(new OutputStreamWriter(this.output, encoding));
        this.inputPumpThread = new PumpThread(in, this.getPty().getMasterOutput());
        this.outputPumpThread = new PumpThread(this.getPty().getMasterInput(), out2);
        this.parseInfoCmp();
        this.inputPumpThread.start();
        this.outputPumpThread.start();
    }

    @Override
    public NonBlockingReader reader() {
        return this.reader;
    }

    @Override
    public PrintWriter writer() {
        return this.writer;
    }

    private class PumpThread
    extends Thread {
        private final InputStream in;
        private final OutputStream out;

        public PumpThread(InputStream in, OutputStream out2) {
            this.in = in;
            this.out = out2;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    int b;
                    if ((b = this.in.read()) < 0) {
                        PosixPtyTerminal.this.input.close();
                        break;
                    }
                    this.out.write(b);
                    this.out.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class InputStreamWrapper
    extends InputStream {
        private final InputStream in;
        private final AtomicBoolean closed = new AtomicBoolean();

        protected InputStreamWrapper(InputStream in) {
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            if (this.closed.get()) {
                throw new ClosedException();
            }
            return this.in.read();
        }

        @Override
        public void close() throws IOException {
            this.closed.set(true);
        }
    }
}

