/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.terminal.impl.jansi;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import org.jetbrains.kotlin.org.fusesource.jansi.internal.CLibrary;
import org.jetbrains.kotlin.org.jline.terminal.Attributes;
import org.jetbrains.kotlin.org.jline.terminal.Size;
import org.jetbrains.kotlin.org.jline.terminal.impl.jansi.JansiSupportImpl;
import org.jetbrains.kotlin.org.jline.terminal.spi.Pty;
import org.jetbrains.kotlin.org.jline.utils.ExecHelper;
import org.jetbrains.kotlin.org.jline.utils.OSUtils;

public abstract class JansiNativePty
implements Pty {
    private final int master;
    private final int slave;
    private final String name;
    private final FileDescriptor masterFD;
    private final FileDescriptor slaveFD;

    public JansiNativePty(int master, FileDescriptor masterFD, int slave, FileDescriptor slaveFD, String name2) {
        this.master = master;
        this.slave = slave;
        this.name = name2;
        this.masterFD = masterFD;
        this.slaveFD = slaveFD;
    }

    protected static String ttyname() throws IOException {
        String name2;
        if (JansiSupportImpl.JANSI_MAJOR_VERSION > 1 || JansiSupportImpl.JANSI_MAJOR_VERSION == 1 && JansiSupportImpl.JANSI_MINOR_VERSION >= 16) {
            name2 = CLibrary.ttyname(0);
        } else {
            try {
                name2 = ExecHelper.exec(true, OSUtils.TTY_COMMAND);
            }
            catch (IOException e) {
                throw new IOException("Not a tty", e);
            }
        }
        if (name2 != null) {
            name2 = name2.trim();
        }
        if (name2 == null || name2.isEmpty()) {
            throw new IOException("Not a tty");
        }
        return name2;
    }

    @Override
    public void close() throws IOException {
        if (this.master > 0) {
            this.getMasterInput().close();
        }
        if (this.slave > 0) {
            this.getSlaveInput().close();
        }
    }

    public String getName() {
        return this.name;
    }

    public FileDescriptor getMasterFD() {
        return this.masterFD;
    }

    public FileDescriptor getSlaveFD() {
        return this.slaveFD;
    }

    @Override
    public InputStream getMasterInput() {
        return new FileInputStream(this.getMasterFD());
    }

    @Override
    public OutputStream getMasterOutput() {
        return new FileOutputStream(this.getMasterFD());
    }

    @Override
    public InputStream getSlaveInput() {
        return new FileInputStream(this.getSlaveFD());
    }

    @Override
    public OutputStream getSlaveOutput() {
        return new FileOutputStream(this.getSlaveFD());
    }

    @Override
    public Attributes getAttr() throws IOException {
        CLibrary.Termios tios = new CLibrary.Termios();
        CLibrary.tcgetattr(this.slave, tios);
        return this.toAttributes(tios);
    }

    @Override
    public void setAttr(Attributes attr) throws IOException {
        CLibrary.Termios tios = this.toTermios(attr);
        CLibrary.tcsetattr(this.slave, CLibrary.TCSANOW, tios);
    }

    @Override
    public Size getSize() throws IOException {
        CLibrary.WinSize sz = new CLibrary.WinSize();
        CLibrary.ioctl(this.slave, CLibrary.TIOCGWINSZ, sz);
        return new Size(sz.ws_col, sz.ws_row);
    }

    @Override
    public void setSize(Size size2) throws IOException {
        CLibrary.WinSize sz = new CLibrary.WinSize((short)size2.getRows(), (short)size2.getColumns());
        CLibrary.ioctl(this.slave, CLibrary.TIOCSWINSZ, sz);
    }

    protected abstract CLibrary.Termios toTermios(Attributes var1);

    protected abstract Attributes toAttributes(CLibrary.Termios var1);

    public String toString() {
        return "JansiNativePty[" + this.getName() + "]";
    }

    protected static FileDescriptor newDescriptor(int fd) {
        try {
            Constructor cns = FileDescriptor.class.getDeclaredConstructor(Integer.TYPE);
            cns.setAccessible(true);
            return (FileDescriptor)cns.newInstance(fd);
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to create FileDescriptor", e);
        }
    }
}

