/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.utils;

import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.kotlin.org.jline.utils.AttributedCharSequence;
import org.jetbrains.kotlin.org.jline.utils.AttributedStringBuilder;
import org.jetbrains.kotlin.org.jline.utils.AttributedStyle;

public class AttributedString
extends AttributedCharSequence {
    final char[] buffer;
    final int[] style;
    final int start;
    final int end;
    public static final AttributedString EMPTY = new AttributedString("");
    public static final AttributedString NEWLINE = new AttributedString("\n");

    public AttributedString(CharSequence str) {
        this(str, 0, str.length(), null);
    }

    public AttributedString(CharSequence str, int start2, int end2) {
        this(str, start2, end2, null);
    }

    public AttributedString(CharSequence str, AttributedStyle s) {
        this(str, 0, str.length(), s);
    }

    public AttributedString(CharSequence str, int start2, int end2, AttributedStyle s) {
        if (end2 < start2) {
            throw new InvalidParameterException();
        }
        if (str instanceof AttributedString) {
            AttributedString as = (AttributedString)str;
            this.buffer = as.buffer;
            if (s != null) {
                this.style = (int[])as.style.clone();
                for (int i = 0; i < this.style.length; ++i) {
                    this.style[i] = this.style[i] & ~s.getMask() | s.getStyle();
                }
            } else {
                this.style = as.style;
            }
            this.start = as.start + start2;
            this.end = as.start + end2;
        } else if (str instanceof AttributedStringBuilder) {
            AttributedStringBuilder asb = (AttributedStringBuilder)str;
            AttributedString as = asb.subSequence(start2, end2);
            this.buffer = as.buffer;
            this.style = as.style;
            if (s != null) {
                for (int i = 0; i < this.style.length; ++i) {
                    this.style[i] = this.style[i] & ~s.getMask() | s.getStyle();
                }
            }
            this.start = as.start;
            this.end = as.end;
        } else {
            int l = end2 - start2;
            this.buffer = new char[l];
            for (int i = 0; i < l; ++i) {
                this.buffer[i] = str.charAt(start2 + i);
            }
            this.style = new int[l];
            if (s != null) {
                Arrays.fill(this.style, s.getStyle());
            }
            this.start = 0;
            this.end = l;
        }
    }

    AttributedString(char[] buffer, int[] style, int start2, int end2) {
        this.buffer = buffer;
        this.style = style;
        this.start = start2;
        this.end = end2;
    }

    public static AttributedString fromAnsi(String ansi) {
        return AttributedString.fromAnsi(ansi, 0);
    }

    public static AttributedString fromAnsi(String ansi, int tabs) {
        if (ansi == null) {
            return null;
        }
        AttributedStringBuilder sb = new AttributedStringBuilder(ansi.length());
        sb.tabs(tabs);
        sb.appendAnsi(ansi);
        return sb.toAttributedString();
    }

    @Override
    protected char[] buffer() {
        return this.buffer;
    }

    @Override
    protected int offset() {
        return this.start;
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public AttributedStyle styleAt(int index2) {
        return new AttributedStyle(this.style[this.start + index2], this.style[this.start + index2]);
    }

    @Override
    int styleCodeAt(int index2) {
        return this.style[this.start + index2];
    }

    @Override
    public AttributedString subSequence(int start2, int end2) {
        return new AttributedString(this, start2, end2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributedString that = (AttributedString)o;
        return this.end - this.start == that.end - that.start && this.arrEq(this.buffer, that.buffer, this.start, that.start, this.end - this.start) && this.arrEq(this.style, that.style, this.start, that.start, this.end - this.start);
    }

    private boolean arrEq(char[] a1, char[] a2, int s1, int s2, int l) {
        for (int i = 0; i < l; ++i) {
            if (a1[s1 + i] == a2[s2 + i]) continue;
            return false;
        }
        return true;
    }

    private boolean arrEq(int[] a1, int[] a2, int s1, int s2, int l) {
        for (int i = 0; i < l; ++i) {
            if (a1[s1 + i] == a2[s2 + i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result2 = Arrays.hashCode(this.buffer);
        result2 = 31 * result2 + Arrays.hashCode(this.style);
        result2 = 31 * result2 + this.start;
        result2 = 31 * result2 + this.end;
        return result2;
    }

    public static AttributedString join(AttributedString delimiter, Iterable<AttributedString> elements) {
        Objects.requireNonNull(elements);
        AttributedStringBuilder sb = new AttributedStringBuilder();
        int i = 0;
        for (AttributedString str : elements) {
            if (i++ > 0 && delimiter != null) {
                sb.append(delimiter);
            }
            sb.append(str);
        }
        return sb.toAttributedString();
    }
}

