/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.utils;

import java.io.IOException;
import java.io.Writer;
import java.util.Stack;

public final class Curses {
    private static Object[] sv = new Object[26];
    private static Object[] dv = new Object[26];

    public static void tputs(Writer out2, String str, Object ... params) throws IOException {
        int index2 = 0;
        int length = str.length();
        int ifte = 0;
        boolean exec = true;
        Stack<Object> stack = new Stack<Object>();
        block48: while (index2 < length) {
            char ch = str.charAt(index2++);
            block1 : switch (ch) {
                case '\\': {
                    ch = str.charAt(index2++);
                    if (ch >= '0' && ch <= '9') {
                        throw new UnsupportedOperationException();
                    }
                    switch (ch) {
                        case 'E': 
                        case 'e': {
                            if (!exec) continue block48;
                            out2.write(27);
                            break block1;
                        }
                        case 'n': {
                            out2.write(10);
                            break block1;
                        }
                        case 'r': {
                            if (!exec) continue block48;
                            out2.write(13);
                            break block1;
                        }
                        case 't': {
                            if (!exec) continue block48;
                            out2.write(9);
                            break block1;
                        }
                        case 'b': {
                            if (!exec) continue block48;
                            out2.write(8);
                            break block1;
                        }
                        case 'f': {
                            if (!exec) continue block48;
                            out2.write(12);
                            break block1;
                        }
                        case 's': {
                            if (!exec) continue block48;
                            out2.write(32);
                            break block1;
                        }
                        case ':': 
                        case '\\': 
                        case '^': {
                            if (!exec) continue block48;
                            out2.write(ch);
                            break block1;
                        }
                    }
                    throw new IllegalArgumentException();
                }
                case '^': {
                    ch = str.charAt(index2++);
                    if (!exec) continue block48;
                    out2.write(ch - 64);
                    break;
                }
                case '%': {
                    ch = str.charAt(index2++);
                    switch (ch) {
                        case '%': {
                            if (!exec) continue block48;
                            out2.write(37);
                            break block1;
                        }
                        case 'p': {
                            ch = str.charAt(index2++);
                            if (!exec) continue block48;
                            stack.push(params[ch - 49]);
                            break block1;
                        }
                        case 'P': {
                            ch = str.charAt(index2++);
                            if (ch >= 'a' && ch <= 'z') {
                                if (!exec) continue block48;
                                Curses.dv[ch - 97] = stack.pop();
                                break block1;
                            }
                            if (ch >= 'A' && ch <= 'Z') {
                                if (!exec) continue block48;
                                Curses.sv[ch - 65] = stack.pop();
                                break block1;
                            }
                            throw new IllegalArgumentException();
                        }
                        case 'g': {
                            ch = str.charAt(index2++);
                            if (ch >= 'a' && ch <= 'z') {
                                if (!exec) continue block48;
                                stack.push(dv[ch - 97]);
                                break block1;
                            }
                            if (ch >= 'A' && ch <= 'Z') {
                                if (!exec) continue block48;
                                stack.push(sv[ch - 65]);
                                break block1;
                            }
                            throw new IllegalArgumentException();
                        }
                        case '\'': {
                            ch = str.charAt(index2++);
                            if (exec) {
                                stack.push(Integer.valueOf(ch));
                            }
                            if ((ch = str.charAt(index2++)) == '\'') continue block48;
                            throw new IllegalArgumentException();
                        }
                        case '{': {
                            int start2 = index2;
                            while (str.charAt(index2++) != '}') {
                            }
                            if (!exec) continue block48;
                            int v = Integer.valueOf(str.substring(start2, index2 - 1));
                            stack.push(v);
                            break block1;
                        }
                        case 'l': {
                            if (!exec) continue block48;
                            stack.push(stack.pop().toString().length());
                            break block1;
                        }
                        case '+': {
                            if (!exec) continue block48;
                            int v2 = Curses.toInteger(stack.pop());
                            int v1 = Curses.toInteger(stack.pop());
                            stack.push(v1 + v2);
                            break block1;
                        }
                        case '-': {
                            if (!exec) continue block48;
                            int v2 = Curses.toInteger(stack.pop());
                            int v1 = Curses.toInteger(stack.pop());
                            stack.push(v1 - v2);
                            break block1;
                        }
                        case '*': {
                            if (!exec) continue block48;
                            int v2 = Curses.toInteger(stack.pop());
                            int v1 = Curses.toInteger(stack.pop());
                            stack.push(v1 * v2);
                            break block1;
                        }
                        case '/': {
                            if (!exec) continue block48;
                            int v2 = Curses.toInteger(stack.pop());
                            int v1 = Curses.toInteger(stack.pop());
                            stack.push(v1 / v2);
                            break block1;
                        }
                        case 'm': {
                            if (!exec) continue block48;
                            int v2 = Curses.toInteger(stack.pop());
                            int v1 = Curses.toInteger(stack.pop());
                            stack.push(v1 % v2);
                            break block1;
                        }
                        case '&': {
                            if (!exec) continue block48;
                            int v2 = Curses.toInteger(stack.pop());
                            int v1 = Curses.toInteger(stack.pop());
                            stack.push(v1 & v2);
                            break block1;
                        }
                        case '|': {
                            if (!exec) continue block48;
                            int v2 = Curses.toInteger(stack.pop());
                            int v1 = Curses.toInteger(stack.pop());
                            stack.push(v1 | v2);
                            break block1;
                        }
                        case '^': {
                            if (!exec) continue block48;
                            int v2 = Curses.toInteger(stack.pop());
                            int v1 = Curses.toInteger(stack.pop());
                            stack.push(v1 ^ v2);
                            break block1;
                        }
                        case '=': {
                            if (!exec) continue block48;
                            int v2 = Curses.toInteger(stack.pop());
                            int v1 = Curses.toInteger(stack.pop());
                            stack.push(v1 == v2);
                            break block1;
                        }
                        case '>': {
                            if (!exec) continue block48;
                            int v2 = Curses.toInteger(stack.pop());
                            int v1 = Curses.toInteger(stack.pop());
                            stack.push(v1 > v2);
                            break block1;
                        }
                        case '<': {
                            if (!exec) continue block48;
                            int v2 = Curses.toInteger(stack.pop());
                            int v1 = Curses.toInteger(stack.pop());
                            stack.push(v1 < v2);
                            break block1;
                        }
                        case 'A': {
                            if (!exec) continue block48;
                            int v2 = Curses.toInteger(stack.pop());
                            int v1 = Curses.toInteger(stack.pop());
                            stack.push(v1 != 0 && v2 != 0);
                            break block1;
                        }
                        case '!': {
                            if (!exec) continue block48;
                            int v1 = Curses.toInteger(stack.pop());
                            stack.push(v1 == 0);
                            break block1;
                        }
                        case '~': {
                            if (!exec) continue block48;
                            int v1 = Curses.toInteger(stack.pop());
                            stack.push(~v1);
                            break block1;
                        }
                        case 'O': {
                            if (!exec) continue block48;
                            int v2 = Curses.toInteger(stack.pop());
                            int v1 = Curses.toInteger(stack.pop());
                            stack.push(v1 != 0 || v2 != 0);
                            break block1;
                        }
                        case '?': {
                            if (ifte != 0) {
                                throw new IllegalArgumentException();
                            }
                            ifte = 1;
                            break block1;
                        }
                        case 't': {
                            if (ifte != 1 && ifte != 3) {
                                throw new IllegalArgumentException();
                            }
                            ifte = 2;
                            exec = Curses.toInteger(stack.pop()) != 0;
                            break block1;
                        }
                        case 'e': {
                            if (ifte != 2) {
                                throw new IllegalArgumentException();
                            }
                            ifte = 3;
                            exec = !exec;
                            break block1;
                        }
                        case ';': {
                            if (ifte == 0 || ifte == 1) {
                                throw new IllegalArgumentException();
                            }
                            ifte = 0;
                            exec = true;
                            break block1;
                        }
                        case 'i': {
                            if (params.length >= 1) {
                                params[0] = Curses.toInteger(params[0]) + 1;
                            }
                            if (params.length < 2) continue block48;
                            params[1] = Curses.toInteger(params[1]) + 1;
                            break block1;
                        }
                        case 'd': {
                            out2.write(Integer.toString(Curses.toInteger(stack.pop())));
                            break block1;
                        }
                    }
                    throw new UnsupportedOperationException();
                }
                case '$': {
                    if (str.charAt(index2) == '<') {
                        int nb = 0;
                        while ((ch = str.charAt(++index2)) != '>') {
                            if (ch >= '0' && ch <= '9') {
                                nb = nb * 10 + (ch - 48);
                                continue;
                            }
                            if (ch == '*' || ch != '/') continue;
                        }
                        ++index2;
                        try {
                            out2.flush();
                            Thread.sleep(nb);
                        }
                        catch (InterruptedException interruptedException) {}
                        break;
                    }
                    if (!exec) continue block48;
                    out2.write(ch);
                    break;
                }
                default: {
                    if (!exec) continue block48;
                    out2.write(ch);
                }
            }
        }
    }

    private static int toInteger(Object pop2) {
        if (pop2 instanceof Number) {
            return ((Number)pop2).intValue();
        }
        if (pop2 instanceof Boolean) {
            return (Boolean)pop2 != false ? 1 : 0;
        }
        return Integer.valueOf(pop2.toString());
    }
}

