/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.contracts.EffectSystem;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImplicitIntegerCoercion;
import org.jetbrains.kotlin.resolve.MissingSupertypesResolver;
import org.jetbrains.kotlin.resolve.RecursiveContractHelperKt;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.StatementFilterKt;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.CandidateResolver;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolverKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.util.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.checkers.MissingDependencySupertypeChecker;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.error.ErrorScopeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u001a\u001a\u00020\u0017\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001eH\u0002J(\u0010\u001f\u001a\u00020\u0017\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001eH\u0002J4\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001e\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001e2\u0006\u0010!\u001a\u00020\"J\u001e\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001e2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J@\u0010+\u001a\u00020\u0017\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u000e\u0010,\u001a\n\u0012\u0004\u0012\u0002H\u001b\u0018\u00010-2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010.\u001a\u0004\u0018\u00010/2\n\u00100\u001a\u0006\u0012\u0002\b\u000301H\u0002J\u0018\u00102\u001a\u0002032\u0006\u0010$\u001a\u00020%2\u0006\u00104\u001a\u000205H\u0002J6\u00106\u001a\u0004\u0018\u0001072\b\u00108\u001a\u0004\u0018\u0001072\b\u00109\u001a\u0004\u0018\u0001072\u0006\u0010:\u001a\u00020%2\u0006\u0010;\u001a\u00020<2\u0006\u00104\u001a\u000205H\u0002J,\u0010=\u001a\u00020\u0017\"\b\b\u0000\u0010\u001b*\u00020\u001c*\b\u0012\u0004\u0012\u0002H\u001b0-2\u0006\u0010>\u001a\u0002072\u0006\u00104\u001a\u000205H\u0002J,\u0010?\u001a\u00020\u0017\"\b\b\u0000\u0010\u001b*\u00020\u001c*\b\u0012\u0004\u0012\u0002H\u001b0-2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010@\u001a\u00020\u0017*\u0006\u0012\u0002\b\u00030-2\u0006\u0010A\u001a\u000205H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;", "", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "candidateResolver", "Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "callCheckers", "", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "deprecationResolver", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;", "effectSystem", "Lorg/jetbrains/kotlin/contracts/EffectSystem;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "missingSupertypesResolver", "Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;", "(Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Ljava/lang/Iterable;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;Lorg/jetbrains/kotlin/contracts/EffectSystem;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;)V", "checkMissingSupertypes", "", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "completeAllCandidates", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "results", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;", "completeArguments", "completeCall", "tracing", "Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "completeCallForArgument", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "completeOneArgument", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "completeResolvedCallAndArguments", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/MutableResolvedCall;", "createTypeForConvertableConstant", "Lorg/jetbrains/kotlin/types/SimpleType;", "constant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "hasNecessarySafeCall", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "updateRecordedTypeForArgument", "Lorg/jetbrains/kotlin/types/KotlinType;", "updatedType", "recordedType", "argumentExpression", "statementFilter", "Lorg/jetbrains/kotlin/resolve/StatementFilter;", "completeConstraintSystem", "expectedType", "updateResolutionStatusFromConstraintSystem", "updateResultDataFlowInfoUsingEffects", "bindingTrace", "frontend"})
public final class CallCompleter {
    @NotNull
    private final ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private final CandidateResolver candidateResolver;
    @NotNull
    private final DataFlowAnalyzer dataFlowAnalyzer;
    @NotNull
    private final Iterable<CallChecker> callCheckers;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final DeprecationResolver deprecationResolver;
    @NotNull
    private final EffectSystem effectSystem;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;
    @NotNull
    private final MissingSupertypesResolver missingSupertypesResolver;

    public CallCompleter(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull CandidateResolver candidateResolver, @NotNull DataFlowAnalyzer dataFlowAnalyzer, @NotNull Iterable<? extends CallChecker> callCheckers, @NotNull ModuleDescriptor moduleDescriptor, @NotNull DeprecationResolver deprecationResolver, @NotNull EffectSystem effectSystem, @NotNull DataFlowValueFactory dataFlowValueFactory, @NotNull MissingSupertypesResolver missingSupertypesResolver) {
        Intrinsics.checkNotNullParameter(argumentTypeResolver, "argumentTypeResolver");
        Intrinsics.checkNotNullParameter(candidateResolver, "candidateResolver");
        Intrinsics.checkNotNullParameter(dataFlowAnalyzer, "dataFlowAnalyzer");
        Intrinsics.checkNotNullParameter(callCheckers, "callCheckers");
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(deprecationResolver, "deprecationResolver");
        Intrinsics.checkNotNullParameter(effectSystem, "effectSystem");
        Intrinsics.checkNotNullParameter(dataFlowValueFactory, "dataFlowValueFactory");
        Intrinsics.checkNotNullParameter(missingSupertypesResolver, "missingSupertypesResolver");
        this.argumentTypeResolver = argumentTypeResolver;
        this.candidateResolver = candidateResolver;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
        this.callCheckers = callCheckers;
        this.moduleDescriptor = moduleDescriptor;
        this.deprecationResolver = deprecationResolver;
        this.effectSystem = effectSystem;
        this.dataFlowValueFactory = dataFlowValueFactory;
        this.missingSupertypesResolver = missingSupertypesResolver;
    }

    @NotNull
    public final <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> completeCall(@NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<D> results, @NotNull TracingStrategy tracing) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(results, "results");
        Intrinsics.checkNotNullParameter(tracing, "tracing");
        ResolvedCall resolvedCall2 = results.isSingleResult() ? results.getResultingCall() : null;
        Call call2 = context.call;
        Intrinsics.checkNotNullExpressionValue(call2, "context.call");
        if (!CallResolverUtilKt.isInvokeCallOnVariable(call2)) {
            this.completeResolvedCallAndArguments((MutableResolvedCall<D>)resolvedCall2, results, context, tracing);
            this.completeAllCandidates(context, results);
        }
        if (context.trace.wantsDiagnostics()) {
            if (resolvedCall2 == null) {
                this.checkMissingSupertypes(context, this.missingSupertypesResolver);
            } else {
                KtExpression calleeExpression = resolvedCall2 instanceof VariableAsFunctionResolvedCall ? ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getCall().getCalleeExpression() : resolvedCall2.getCall().getCalleeExpression();
                KtElement ktElement = calleeExpression != null && !CallUtilKt.isFakeElement(calleeExpression) ? (KtElement)calleeExpression : resolvedCall2.getCall().getCallElement();
                Intrinsics.checkNotNullExpressionValue(ktElement, "if (calleeExpression != \u2026lvedCall.call.callElement");
                KtElement reportOn = ktElement;
                CallCheckerContext callCheckerContext = new CallCheckerContext(context, this.deprecationResolver, this.moduleDescriptor, this.missingSupertypesResolver, null, 16, null);
                for (CallChecker callChecker : this.callCheckers) {
                    callChecker.check(resolvedCall2, reportOn, callCheckerContext);
                    if (!(resolvedCall2 instanceof VariableAsFunctionResolvedCall)) continue;
                    callChecker.check(((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall(), reportOn, callCheckerContext);
                }
            }
        }
        if (results.isSingleResult() && results.getResultingCall().getStatus().isSuccess()) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = results.changeStatusToSuccess();
            Intrinsics.checkNotNullExpressionValue(overloadResolutionResultsImpl, "results.changeStatusToSuccess()");
            return overloadResolutionResultsImpl;
        }
        return results;
    }

    private final void checkMissingSupertypes(BasicCallResolutionContext context, MissingSupertypesResolver missingSupertypesResolver) {
        Call call2 = context.call;
        Intrinsics.checkNotNullExpressionValue(call2, "context.call");
        Call call3 = call2;
        Receiver $this$safeAs$iv = call3.getExplicitReceiver();
        boolean $i$f$safeAs = false;
        Receiver receiver2 = $this$safeAs$iv;
        if (!(receiver2 instanceof ReceiverValue)) {
            receiver2 = null;
        }
        ReceiverValue receiverValue = (ReceiverValue)receiver2;
        if (receiverValue == null) {
            return;
        }
        ReceiverValue explicitReceiver = receiverValue;
        KotlinType kotlinType = explicitReceiver.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "explicitReceiver.type");
        KtElement ktElement = call3.getCallElement();
        Intrinsics.checkNotNullExpressionValue(ktElement, "call.callElement");
        PsiElement psiElement = ktElement;
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "context.trace");
        MissingDependencySupertypeChecker.INSTANCE.checkSupertypes(kotlinType, psiElement, bindingTrace, missingSupertypesResolver);
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor> void completeAllCandidates(BasicCallResolutionContext context, OverloadResolutionResultsImpl<D> results) {
        void $this$forEach$iv;
        void $this$filterNotTo$iv$iv;
        Collection<ResolvedCall<D>> collection;
        if (context.collectAllCandidates) {
            Collection<ResolvedCall<D>> collection2 = results.getAllCandidates();
            Intrinsics.checkNotNull(collection2);
            collection = collection2;
            Intrinsics.checkNotNullExpressionValue(collection2, "{\n            results.allCandidates!!\n        }");
        } else {
            Collection<MutableResolvedCall<D>> collection3 = results.getResultingCalls();
            collection = collection3;
            Intrinsics.checkNotNullExpressionValue(collection3, "{\n            results.resultingCalls\n        }");
        }
        Collection<ResolvedCall<D>> candidates2 = collection;
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context.trace, "Trace to complete a candidate that is not a resulting call");
        Intrinsics.checkNotNullExpressionValue(temporaryBindingTrace, "create(context.trace, \"T\u2026is not a resulting call\")");
        TemporaryBindingTrace temporaryBindingTrace2 = temporaryBindingTrace;
        Iterable $this$filterNot$iv = candidates2;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            MutableResolvedCall resolvedCall2 = (MutableResolvedCall)element$iv$iv;
            boolean bl = false;
            if (resolvedCall2.isCompleted()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MutableResolvedCall resolvedCall3 = (MutableResolvedCall)element$iv;
            boolean bl = false;
            Object Context2 = context.replaceBindingTrace(temporaryBindingTrace2);
            Intrinsics.checkNotNullExpressionValue(Context2, "context.replaceBindingTrace(temporaryBindingTrace)");
            BasicCallResolutionContext basicCallResolutionContext = (BasicCallResolutionContext)Context2;
            TracingStrategy tracingStrategy = TracingStrategy.EMPTY;
            Intrinsics.checkNotNullExpressionValue(tracingStrategy, "EMPTY");
            this.completeResolvedCallAndArguments(resolvedCall3, results, basicCallResolutionContext, tracingStrategy);
        }
    }

    private final <D extends CallableDescriptor> void completeResolvedCallAndArguments(MutableResolvedCall<D> resolvedCall2, OverloadResolutionResultsImpl<D> results, BasicCallResolutionContext context, TracingStrategy tracing) {
        Call call2 = context.call;
        Intrinsics.checkNotNullExpressionValue(call2, "context.call");
        MutableResolvedCall<D> mutableResolvedCall = resolvedCall2;
        Object object = mutableResolvedCall != null ? mutableResolvedCall.getResultingDescriptor() : null;
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkNotNullExpressionValue(lexicalScope, "context.scope");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "context.trace");
        RecursiveContractHelperKt.disableContractsInsideContractsBlock(call2, object, lexicalScope, bindingTrace);
        if (resolvedCall2 == null || resolvedCall2.isCompleted() || resolvedCall2.getConstraintSystem() == null) {
            this.completeArguments(context, results);
            MutableResolvedCall<D> mutableResolvedCall2 = resolvedCall2;
            if (mutableResolvedCall2 != null) {
                BindingTrace bindingTrace2 = context.trace;
                Intrinsics.checkNotNullExpressionValue(bindingTrace2, "context.trace");
                this.updateResultDataFlowInfoUsingEffects(mutableResolvedCall2, bindingTrace2);
            }
            MutableResolvedCall<D> mutableResolvedCall3 = resolvedCall2;
            if (mutableResolvedCall3 != null) {
                mutableResolvedCall3.markCallAsCompleted();
            }
            return;
        }
        KotlinType kotlinType = context.expectedType;
        Intrinsics.checkNotNullExpressionValue(kotlinType, "context.expectedType");
        BindingTrace bindingTrace3 = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace3, "context.trace");
        this.completeConstraintSystem(resolvedCall2, kotlinType, bindingTrace3);
        this.completeArguments(context, results);
        this.updateResolutionStatusFromConstraintSystem(resolvedCall2, context, tracing);
        BindingTrace bindingTrace4 = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace4, "context.trace");
        this.updateResultDataFlowInfoUsingEffects(resolvedCall2, bindingTrace4);
        resolvedCall2.markCallAsCompleted();
    }

    private final <D extends CallableDescriptor> void completeConstraintSystem(MutableResolvedCall<D> $this$completeConstraintSystem, KotlinType expectedType, BindingTrace trace) {
        ConstraintSystemCompleter constraintSystemCompleter;
        KotlinType expectedReturnType;
        KotlinType kotlinType;
        KotlinType returnType2 = $this$completeConstraintSystem.getCandidateDescriptor().getReturnType();
        Call call2 = $this$completeConstraintSystem.getCall();
        Intrinsics.checkNotNullExpressionValue(call2, "call");
        if (CallUtilKt.isCallableReference(call2)) {
            if (!TypeUtils.noExpectedType(expectedType) && FunctionTypesKt.isFunctionOrSuspendFunctionType(expectedType)) {
                kotlinType = FunctionTypesKt.getReturnTypeFromFunctionType(expectedType);
            } else {
                SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkNotNullExpressionValue(simpleType2, "NO_EXPECTED_TYPE");
                kotlinType = simpleType2;
            }
        } else {
            kotlinType = expectedReturnType = expectedType;
        }
        if (returnType2 != null && !TypeUtils.noExpectedType(expectedReturnType)) {
            CallCompleter.completeConstraintSystem$updateSystemIfNeeded($this$completeConstraintSystem, (Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)new Function1<ConstraintSystem.Builder, ConstraintSystem>(returnType2, expectedReturnType, $this$completeConstraintSystem){
                final /* synthetic */ KotlinType $returnType;
                final /* synthetic */ KotlinType $expectedReturnType;
                final /* synthetic */ MutableResolvedCall<D> $this_completeConstraintSystem;
                {
                    this.$returnType = $returnType;
                    this.$expectedReturnType = $expectedReturnType;
                    this.$this_completeConstraintSystem = $receiver;
                    super(1);
                }

                @Nullable
                public final ConstraintSystem invoke(@NotNull ConstraintSystem.Builder builder2) {
                    ConstraintSystem constraintSystem;
                    Intrinsics.checkNotNullParameter(builder2, "builder");
                    KotlinType returnTypeInSystem = CallCompleter.access$completeConstraintSystem$typeInSystem(builder2, this.$this_completeConstraintSystem, this.$returnType);
                    if (returnTypeInSystem != null) {
                        builder2.addSubtypeConstraint(returnTypeInSystem, this.$expectedReturnType, ConstraintPositionKind.EXPECTED_TYPE_POSITION.position());
                        constraintSystem = builder2.build();
                    } else {
                        constraintSystem = null;
                    }
                    return constraintSystem;
                }
            });
        }
        if ((constraintSystemCompleter = (ConstraintSystemCompleter)trace.get(BindingContext.CONSTRAINT_SYSTEM_COMPLETER, $this$completeConstraintSystem.getCall().getCalleeExpression())) != null) {
            CallCompleter.completeConstraintSystem$updateSystemIfNeeded($this$completeConstraintSystem, (Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)new Function1<ConstraintSystem.Builder, ConstraintSystem>(constraintSystemCompleter, $this$completeConstraintSystem){
                final /* synthetic */ ConstraintSystemCompleter $constraintSystemCompleter;
                final /* synthetic */ MutableResolvedCall<D> $this_completeConstraintSystem;
                {
                    this.$constraintSystemCompleter = $constraintSystemCompleter;
                    this.$this_completeConstraintSystem = $receiver;
                    super(1);
                }

                @Nullable
                public final ConstraintSystem invoke(@NotNull ConstraintSystem.Builder builder2) {
                    Intrinsics.checkNotNullParameter(builder2, "builder");
                    this.$constraintSystemCompleter.completeConstraintSystem(builder2, (ResolvedCall)this.$this_completeConstraintSystem);
                    ConstraintSystem system2 = builder2.build();
                    ConstraintSystemStatus status2 = ConstraintSystemUtilsKt.filterConstraintsOut(system2, ConstraintPositionKind.TYPE_BOUND_POSITION).getStatus();
                    return status2.hasOnlyErrorsDerivedFrom(ConstraintPositionKind.FROM_COMPLETER) ? null : system2;
                }
            });
        }
        if (returnType2 != null && expectedReturnType == TypeUtils.UNIT_EXPECTED_TYPE) {
            CallCompleter.completeConstraintSystem$updateSystemIfNeeded($this$completeConstraintSystem, (Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)new Function1<ConstraintSystem.Builder, ConstraintSystem>(returnType2, this, $this$completeConstraintSystem){
                final /* synthetic */ KotlinType $returnType;
                final /* synthetic */ CallCompleter this$0;
                final /* synthetic */ MutableResolvedCall<D> $this_completeConstraintSystem;
                {
                    this.$returnType = $returnType;
                    this.this$0 = $receiver;
                    this.$this_completeConstraintSystem = $receiver2;
                    super(1);
                }

                @Nullable
                public final ConstraintSystem invoke(@NotNull ConstraintSystem.Builder builder2) {
                    ConstraintSystem constraintSystem;
                    Intrinsics.checkNotNullParameter(builder2, "builder");
                    KotlinType returnTypeInSystem = CallCompleter.access$completeConstraintSystem$typeInSystem(builder2, this.$this_completeConstraintSystem, this.$returnType);
                    if (returnTypeInSystem != null) {
                        builder2.addSubtypeConstraint(returnTypeInSystem, CallCompleter.access$getModuleDescriptor$p(this.this$0).getBuiltIns().getUnitType(), ConstraintPositionKind.EXPECTED_TYPE_POSITION.position());
                        ConstraintSystem system2 = builder2.build();
                        constraintSystem = system2.getStatus().isSuccessful() ? system2 : null;
                    } else {
                        constraintSystem = null;
                    }
                    return constraintSystem;
                }
            });
        }
        Call call3 = $this$completeConstraintSystem.getCall();
        Intrinsics.checkNotNullExpressionValue(call3, "call");
        if (CallUtilKt.isCallableReference(call3) && !TypeUtils.noExpectedType(expectedType) && FunctionTypesKt.isFunctionOrSuspendFunctionType(expectedType)) {
            CallCompleter.completeConstraintSystem$updateSystemIfNeeded($this$completeConstraintSystem, (Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)new Function1<ConstraintSystem.Builder, ConstraintSystem>($this$completeConstraintSystem, expectedType){
                final /* synthetic */ MutableResolvedCall<D> $this_completeConstraintSystem;
                final /* synthetic */ KotlinType $expectedType;
                {
                    this.$this_completeConstraintSystem = $receiver;
                    this.$expectedType = $expectedType;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final ConstraintSystem invoke(@NotNull ConstraintSystem.Builder builder2) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter(builder2, "builder");
                    List<ValueParameterDescriptor> list2 = this.$this_completeConstraintSystem.getCandidateDescriptor().getValueParameters();
                    Intrinsics.checkNotNullExpressionValue(list2, "candidateDescriptor.valueParameters");
                    Iterable iterable = CollectionsKt.zip((Iterable)list2, (Iterable)FunctionTypesKt.getValueParameterTypesFromFunctionType(this.$expectedType));
                    MutableResolvedCall<D> mutableResolvedCall = this.$this_completeConstraintSystem;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Pair pair = (Pair)element$iv;
                        boolean bl = false;
                        ValueParameterDescriptor parameter = (ValueParameterDescriptor)pair.component1();
                        TypeProjection argument2 = (TypeProjection)pair.component2();
                        KotlinType valueParameterInSystem = CallCompleter.access$completeConstraintSystem$typeInSystem(builder2, mutableResolvedCall, parameter.getType());
                        builder2.addSubtypeConstraint(valueParameterInSystem, argument2.getType(), ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(parameter.getIndex()));
                    }
                    return builder2.build();
                }
            });
        }
        ConstraintSystem constraintSystem = $this$completeConstraintSystem.getConstraintSystem();
        Intrinsics.checkNotNull(constraintSystem);
        ConstraintSystem.Builder builder2 = ConstraintSystem.DefaultImpls.toBuilder$default(constraintSystem, null, 1, null);
        builder2.fixVariables();
        ConstraintSystem system2 = builder2.build();
        $this$completeConstraintSystem.setConstraintSystem(system2);
        boolean isNewInferenceEnabled = this.effectSystem.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference);
        TypeSubstitutor typeSubstitutor2 = isNewInferenceEnabled ? system2.getResultingSubstitutor().replaceWithContravariantApproximatingSubstitution() : system2.getResultingSubstitutor();
        Intrinsics.checkNotNullExpressionValue(typeSubstitutor2, "if (isNewInferenceEnable\u2026stem.resultingSubstitutor");
        TypeSubstitutor resultingSubstitutor2 = typeSubstitutor2;
        $this$completeConstraintSystem.setSubstitutor(resultingSubstitutor2);
    }

    private final <D extends CallableDescriptor> void updateResolutionStatusFromConstraintSystem(MutableResolvedCall<D> $this$updateResolutionStatusFromConstraintSystem, BasicCallResolutionContext context, TracingStrategy tracing) {
        CallCandidateResolutionContext<D> callCandidateResolutionContext = CallCandidateResolutionContext.createForCallBeingAnalyzed($this$updateResolutionStatusFromConstraintSystem, context, tracing);
        Intrinsics.checkNotNullExpressionValue(callCandidateResolutionContext, "createForCallBeingAnalyzed(this, context, tracing)");
        CallCandidateResolutionContext<D> contextWithResolvedCall = callCandidateResolutionContext;
        CandidateResolver.ValueArgumentsCheckingResult valueArgumentsCheckingResult = this.candidateResolver.checkAllValueArguments(contextWithResolvedCall, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        ResolutionStatus resolutionStatus = $this$updateResolutionStatusFromConstraintSystem.getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)resolutionStatus, "status");
        ResolutionStatus status2 = resolutionStatus;
        ConstraintSystem constraintSystem = $this$updateResolutionStatusFromConstraintSystem.getConstraintSystem();
        Intrinsics.checkNotNull(constraintSystem);
        if (constraintSystem.getStatus().isSuccessful()) {
            if (status2 == ResolutionStatus.UNKNOWN_STATUS || status2 == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) {
                $this$updateResolutionStatusFromConstraintSystem.setStatusToSuccess();
            }
            return;
        }
        ReceiverValue receiverValue = $this$updateResolutionStatusFromConstraintSystem.getExtensionReceiver();
        KotlinType receiverType = receiverValue != null ? receiverValue.getType() : null;
        Object d = $this$updateResolutionStatusFromConstraintSystem.getCandidateDescriptor();
        ConstraintSystem constraintSystem2 = $this$updateResolutionStatusFromConstraintSystem.getConstraintSystem();
        Intrinsics.checkNotNull(constraintSystem2);
        InferenceErrorData inferenceErrorData = InferenceErrorData.create(d, constraintSystem2, valueArgumentsCheckingResult.getArgumentTypes(), receiverType, context.expectedType, context.call);
        Intrinsics.checkNotNullExpressionValue(inferenceErrorData, "create(\n            cand\u2026e, context.call\n        )");
        InferenceErrorData errorData = inferenceErrorData;
        tracing.typeInferenceFailed(context, errorData);
        $this$updateResolutionStatusFromConstraintSystem.addStatus(ResolutionStatus.OTHER_ERROR);
    }

    private final <D extends CallableDescriptor> void completeArguments(BasicCallResolutionContext context, OverloadResolutionResultsImpl<D> results) {
        if (context.checkArguments != CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            return;
        }
        Function1 getArgumentMapping = null;
        Function1 getDataFlowInfoForArgument = null;
        if (results.isSingleResult()) {
            ResolvedCall resolvedCall2 = results.getResultingCall();
            Intrinsics.checkNotNullExpressionValue(resolvedCall2, "results.resultingCall");
            ResolvedCall resolvedCall3 = resolvedCall2;
            getArgumentMapping = new Function1<ValueArgument, ArgumentMapping>(resolvedCall3){
                final /* synthetic */ MutableResolvedCall<D> $resolvedCall;
                {
                    this.$resolvedCall = $resolvedCall;
                    super(1);
                }

                @NotNull
                public final ArgumentMapping invoke(@NotNull ValueArgument argument2) {
                    Intrinsics.checkNotNullParameter(argument2, "argument");
                    ArgumentMapping argumentMapping = this.$resolvedCall.getArgumentMapping(argument2);
                    Intrinsics.checkNotNullExpressionValue(argumentMapping, "resolvedCall.getArgumentMapping(argument)");
                    return argumentMapping;
                }
            };
            getDataFlowInfoForArgument = new Function1<ValueArgument, DataFlowInfo>(resolvedCall3){
                final /* synthetic */ MutableResolvedCall<D> $resolvedCall;
                {
                    this.$resolvedCall = $resolvedCall;
                    super(1);
                }

                @NotNull
                public final DataFlowInfo invoke(@NotNull ValueArgument argument2) {
                    Intrinsics.checkNotNullParameter(argument2, "argument");
                    DataFlowInfo dataFlowInfo = this.$resolvedCall.getDataFlowInfoForArguments().getInfo(argument2);
                    Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "resolvedCall.dataFlowInf\u2026guments.getInfo(argument)");
                    return dataFlowInfo;
                }
            };
        } else {
            getArgumentMapping = completeArguments.3.INSTANCE;
            getDataFlowInfoForArgument = new Function1<ValueArgument, DataFlowInfo>(context){
                final /* synthetic */ BasicCallResolutionContext $context;
                {
                    this.$context = $context;
                    super(1);
                }

                @NotNull
                public final DataFlowInfo invoke(@NotNull ValueArgument it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    DataFlowInfo dataFlowInfo = this.$context.dataFlowInfo;
                    Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "context.dataFlowInfo");
                    return dataFlowInfo;
                }
            };
        }
        Iterator<? extends ValueArgument> iterator2 = context.call.getValueArguments().iterator();
        while (iterator2.hasNext()) {
            ValueArgument valueArgument;
            ValueArgument valueArgument2 = valueArgument = iterator2.next();
            Intrinsics.checkNotNull(valueArgument2);
            ArgumentMapping argumentMapping = (ArgumentMapping)getArgumentMapping.invoke(valueArgument2);
            KotlinType expectedType = null;
            CallPosition callPosition = null;
            ValueParameterDescriptor parameter = null;
            if (argumentMapping instanceof ArgumentMatch) {
                expectedType = CallResolverUtilKt.getEffectiveExpectedType(((ArgumentMatch)argumentMapping).getValueParameter(), valueArgument, context);
                ResolvedCall resolvedCall4 = results.getResultingCall();
                Intrinsics.checkNotNullExpressionValue(resolvedCall4, "results.resultingCall");
                callPosition = new CallPosition.ValueArgumentPosition(resolvedCall4, ((ArgumentMatch)argumentMapping).getValueParameter(), valueArgument);
                parameter = ((ArgumentMatch)argumentMapping).getValueParameter();
            } else {
                SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkNotNullExpressionValue(simpleType2, "NO_EXPECTED_TYPE");
                expectedType = simpleType2;
                callPosition = CallPosition.Unknown.INSTANCE;
                parameter = null;
            }
            Object Context2 = ((BasicCallResolutionContext)((BasicCallResolutionContext)context.replaceDataFlowInfo((DataFlowInfo)getDataFlowInfoForArgument.invoke(valueArgument))).replaceExpectedType(expectedType)).replaceCallPosition(callPosition);
            Intrinsics.checkNotNullExpressionValue(Context2, "context.replaceDataFlowI\u2026allPosition(callPosition)");
            BasicCallResolutionContext newContext = (BasicCallResolutionContext)Context2;
            this.completeOneArgument(valueArgument, parameter, newContext);
        }
    }

    private final SimpleType createTypeForConvertableConstant(CompileTimeConstant<?> constant) {
        SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkNotNullExpressionValue(simpleType2, "NO_EXPECTED_TYPE");
        Object $this$safeAs$iv = constant.getValue(simpleType2);
        boolean $i$f$safeAs = false;
        Object obj = $this$safeAs$iv;
        if (!(obj instanceof Number)) {
            obj = null;
        }
        Number number2 = (Number)obj;
        if (number2 == null) {
            return null;
        }
        long value2 = number2.longValue();
        IntegerValueTypeConstructor typeConstructor2 = new IntegerValueTypeConstructor(value2, this.moduleDescriptor, constant.getParameters());
        String[] stringArray = new String[]{typeConstructor2.toString()};
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(TypeAttributes.Companion.getEmpty(), typeConstructor2, CollectionsKt.emptyList(), false, ErrorUtils.createErrorScope(ErrorScopeKind.INTEGER_LITERAL_TYPE_SCOPE, true, stringArray));
    }

    private final void completeOneArgument(ValueArgument argument2, ValueParameterDescriptor parameter, BasicCallResolutionContext context) {
        KotlinType kotlinType;
        boolean convertedConst;
        KotlinType recordedType;
        if (argument2.isExternal()) {
            return;
        }
        KtExpression ktExpression = argument2.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression expression2 = ktExpression;
        KtExpression ktExpression2 = KtPsiUtil.getLastElementDeparenthesized(expression2, context.statementFilter);
        if (ktExpression2 == null) {
            return;
        }
        KtExpression deparenthesized = ktExpression2;
        KotlinType updatedType = recordedType = context.trace.getType(expression2);
        OverloadResolutionResultsImpl<?> results = this.completeCallForArgument(deparenthesized, context);
        CompileTimeConstant constant = (CompileTimeConstant)context.trace.get(BindingContext.COMPILE_TIME_VALUE, deparenthesized);
        boolean bl = convertedConst = constant instanceof IntegerValueTypeConstant && ((IntegerValueTypeConstant)constant).getConvertedFromSigned();
        if (results != null && results.isSingleResult()) {
            ResolvedCall resolvedCall2 = results.getResultingCall();
            Intrinsics.checkNotNullExpressionValue(resolvedCall2, "results.resultingCall");
            ResolvedCall resolvedCall3 = resolvedCall2;
            if (!convertedConst) {
                KotlinType kotlinType2;
                if (resolvedCall3.hasInferredReturnType()) {
                    Object d = resolvedCall3.getResultingDescriptor();
                    kotlinType2 = ResolvedCallUtilKt.makeNullableTypeIfSafeReceiver(resolvedCall3, d != null ? d.getReturnType() : null, context);
                } else {
                    kotlinType2 = updatedType = null;
                }
            }
        }
        if (recordedType != null && !recordedType.getConstructor().isDenotable() && (kotlinType = this.argumentTypeResolver.updateResultArgumentTypeIfNotDenotable(context, expression2)) == null) {
            kotlinType = updatedType = updatedType;
        }
        if (parameter != null && ImplicitIntegerCoercion.INSTANCE.isEnabledForParameter(parameter)) {
            SimpleType generalNumberType;
            CompileTimeConstant argumentCompileTimeValue = (CompileTimeConstant)context.trace.get(BindingContext.COMPILE_TIME_VALUE, deparenthesized);
            if (argumentCompileTimeValue != null && argumentCompileTimeValue.getParameters().isConvertableConstVal() && (generalNumberType = this.createTypeForConvertableConstant(argumentCompileTimeValue)) != null) {
                updatedType = this.argumentTypeResolver.updateResultArgumentTypeIfNotDenotable(context.trace, context.statementFilter, context.expectedType, generalNumberType, expression2);
            }
        } else if (convertedConst) {
            context.trace.report(Errors.SIGNED_CONSTANT_CONVERTED_TO_UNSIGNED.on((KtExpression)((PsiElement)deparenthesized)));
        }
        StatementFilter statementFilter = context.statementFilter;
        Intrinsics.checkNotNullExpressionValue(statementFilter, "context.statementFilter");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "context.trace");
        updatedType = this.updateRecordedTypeForArgument(updatedType, recordedType, expression2, statementFilter, bindingTrace);
        KtFunction ktFunction = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context);
        if (ktFunction != null) {
            KtFunction functionLiteralArgument = ktFunction;
            boolean bl2 = false;
            this.argumentTypeResolver.getFunctionLiteralTypeInfo(expression2, functionLiteralArgument, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS, false);
        }
        KtCallableReferenceExpression ktCallableReferenceExpression = ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression2, context);
        if (ktCallableReferenceExpression != null) {
            KtCallableReferenceExpression callableReferenceArgument = ktCallableReferenceExpression;
            boolean bl3 = false;
            this.argumentTypeResolver.getCallableReferenceTypeInfo(expression2, callableReferenceArgument, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        }
        this.dataFlowAnalyzer.checkType(updatedType, deparenthesized, (ResolutionContext)context);
    }

    private final OverloadResolutionResultsImpl<?> completeCallForArgument(KtExpression expression2, BasicCallResolutionContext context) {
        ResolutionResultsCache.CachedData cachedData = GenericCandidateResolverKt.getResolutionResultsCachedData(expression2, context);
        if (cachedData == null) {
            return null;
        }
        ResolutionResultsCache.CachedData cachedData2 = cachedData;
        OverloadResolutionResultsImpl<?> cachedResolutionResults = cachedData2.component1();
        BasicCallResolutionContext cachedContext = cachedData2.component2();
        TracingStrategy tracing = cachedData2.component3();
        Object Context2 = ((BasicCallResolutionContext)((BasicCallResolutionContext)((BasicCallResolutionContext)cachedContext.replaceBindingTrace(context.trace)).replaceExpectedType(context.expectedType)).replaceCollectAllCandidates(false)).replaceCallPosition(context.callPosition);
        Intrinsics.checkNotNullExpressionValue(Context2, "cachedContext.replaceBin\u2026ion(context.callPosition)");
        BasicCallResolutionContext contextForArgument = (BasicCallResolutionContext)Context2;
        return this.completeCall(contextForArgument, cachedResolutionResults, tracing);
    }

    private final KotlinType updateRecordedTypeForArgument(KotlinType updatedType, KotlinType recordedType, KtExpression argumentExpression, StatementFilter statementFilter, BindingTrace trace) {
        if (!ErrorUtils.INSTANCE.containsErrorType(recordedType) && Intrinsics.areEqual(recordedType, updatedType) || updatedType == null) {
            return updatedType;
        }
        ArrayList<KtExpression> expressions = new ArrayList<KtExpression>();
        KtExpression expression2 = argumentExpression;
        while (expression2 != null) {
            expressions.add(expression2);
            expression2 = CallCompleter.updateRecordedTypeForArgument$deparenthesizeOrGetSelector(statementFilter, expression2);
        }
        boolean shouldBeMadeNullable = false;
        Iterable $this$forEach$iv = CollectionsKt.asReversedMutable((List)expressions);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtExpression ktExpression = (KtExpression)element$iv;
            boolean bl = false;
            if (!(ktExpression instanceof KtParenthesizedExpression || ktExpression instanceof KtLabeledExpression || ktExpression instanceof KtAnnotatedExpression)) {
                shouldBeMadeNullable = this.hasNecessarySafeCall(ktExpression, trace);
            }
            BindingContextUtils.updateRecordedType(updatedType, ktExpression, trace, shouldBeMadeNullable);
        }
        return trace.getType(argumentExpression);
    }

    private final boolean hasNecessarySafeCall(KtExpression expression2, BindingTrace trace) {
        if (!(expression2 instanceof KtSafeQualifiedExpression)) {
            return false;
        }
        KotlinType expressionType = trace.getType(((KtSafeQualifiedExpression)expression2).getReceiverExpression());
        return expressionType != null && TypeUtils.isNullableType(expressionType);
    }

    private final void updateResultDataFlowInfoUsingEffects(MutableResolvedCall<?> $this$updateResultDataFlowInfoUsingEffects, BindingTrace bindingTrace) {
        if ($this$updateResultDataFlowInfoUsingEffects.getDataFlowInfoForArguments() instanceof MutableDataFlowInfoForArguments.WithoutArgumentsCheck) {
            return;
        }
        Object d = $this$updateResultDataFlowInfoUsingEffects.getResultingDescriptor();
        if (d == null || (d = d.getContainingDeclaration()) == null) {
            return;
        }
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule(d);
        Intrinsics.checkNotNullExpressionValue(moduleDescriptor, "getContainingModule(this\u2026ingDeclaration ?: return)");
        ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
        DataFlowInfo resultDFIfromES = this.effectSystem.getDataFlowInfoForFinishedCall((ResolvedCall)$this$updateResultDataFlowInfoUsingEffects, bindingTrace, moduleDescriptor2);
        $this$updateResultDataFlowInfoUsingEffects.getDataFlowInfoForArguments().updateResultInfo(resultDFIfromES);
        this.effectSystem.recordDefiniteInvocations((ResolvedCall)$this$updateResultDataFlowInfoUsingEffects, bindingTrace, moduleDescriptor2);
    }

    private static final <D extends CallableDescriptor> KotlinType completeConstraintSystem$typeInSystem(ConstraintSystem.Builder $this$completeConstraintSystem_u24typeInSystem, MutableResolvedCall<D> $this_completeConstraintSystem, KotlinType type2) {
        KotlinType kotlinType;
        KotlinType kotlinType2 = type2;
        if (kotlinType2 != null) {
            KotlinType it = kotlinType2;
            boolean bl = false;
            Map<CallHandle, TypeSubstitutor> map2 = $this$completeConstraintSystem_u24typeInSystem.getTypeVariableSubstitutors();
            Call call2 = $this_completeConstraintSystem.getCall();
            Intrinsics.checkNotNullExpressionValue(call2, "call");
            TypeSubstitutor typeSubstitutor2 = map2.get(TypeVariableKt.toHandle(call2));
            if (typeSubstitutor2 == null) {
                throw new IllegalStateException(("No substitutor for call: " + $this_completeConstraintSystem.getCall()).toString());
            }
            TypeSubstitutor substitutor2 = typeSubstitutor2;
            kotlinType = substitutor2.substitute(it, Variance.INVARIANT);
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    private static final <D extends CallableDescriptor> void completeConstraintSystem$updateSystemIfNeeded(MutableResolvedCall<D> $this_completeConstraintSystem, Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem> buildSystemWithAdditionalConstraints) {
        ConstraintSystem constraintSystem = $this_completeConstraintSystem.getConstraintSystem();
        Intrinsics.checkNotNull(constraintSystem);
        ConstraintSystem system2 = buildSystemWithAdditionalConstraints.invoke(ConstraintSystem.DefaultImpls.toBuilder$default(constraintSystem, null, 1, null));
        if (system2 != null) {
            $this_completeConstraintSystem.setConstraintSystem(system2);
        }
    }

    private static final KtExpression updateRecordedTypeForArgument$deparenthesizeOrGetSelector(StatementFilter $statementFilter, KtExpression expression2) {
        KtExpression deparenthesized = KtPsiUtil.deparenthesizeOnce(expression2);
        if (!Intrinsics.areEqual(deparenthesized, expression2)) {
            return deparenthesized;
        }
        if (expression2 instanceof KtBlockExpression) {
            return StatementFilterKt.getLastStatementInABlock($statementFilter, (KtBlockExpression)expression2);
        }
        KtQualifiedExpression ktQualifiedExpression = expression2 instanceof KtQualifiedExpression ? (KtQualifiedExpression)expression2 : null;
        return ktQualifiedExpression != null ? ktQualifiedExpression.getSelectorExpression() : null;
    }

    public static final /* synthetic */ KotlinType access$completeConstraintSystem$typeInSystem(ConstraintSystem.Builder $receiver, MutableResolvedCall $this_completeConstraintSystem, KotlinType type2) {
        return CallCompleter.completeConstraintSystem$typeInSystem($receiver, $this_completeConstraintSystem, type2);
    }

    public static final /* synthetic */ ModuleDescriptor access$getModuleDescriptor$p(CallCompleter $this) {
        return $this.moduleDescriptor;
    }
}

