/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.badge;

import io.docops.docopsextensionssupport.badge.BadgeFormatException;
import io.docops.docopsextensionssupport.badge.BadgeKt;
import io.docops.docopsextensionssupport.badge.FormBadge;
import io.docops.docopsextensionssupport.badge.SimpleIconControllerKt;
import io.docops.docopsextensionssupport.web.panel.PanelGeneratorKt;
import io.micrometer.core.annotation.Timed;
import io.micrometer.observation.annotation.Observed;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.silentsoft.badge4j.Badge;
import org.silentsoft.badge4j.Style;
import org.silentsoft.simpleicons.Icon;
import org.silentsoft.simpleicons.SimpleIcons;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.w3c.dom.Document;

@Controller
@RequestMapping(value={"/api"})
@Observed(name="badge.controller")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0012J\u001a\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0012\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0016J\u001a\u0010\u000e\u001a\u00020\b2\b\b\u0001\u0010\u000f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0012\u00a8\u0006\u0016"}, d2={"Lio/docops/docopsextensionssupport/badge/BadgeController;", "", "()V", "badgeAgain", "", "formBadge", "Lio/docops/docopsextensionssupport/badge/FormBadge;", "getBadgeByForm", "", "badge", "servletResponse", "Ljakarta/servlet/http/HttpServletResponse;", "getBadgeLogo", "input", "getBadgeParams", "payload", "getLogoFromUrl", "url", "makeBadgeAndSource", "txt", "svg", "makeBadgeMessageOnly", "docops-extension-server"})
public class BadgeController {
    @PutMapping(value={"/badge/item"}, produces={"image/svg+xml"})
    @ResponseBody
    @Timed(value="docops.badge.put", percentiles={0.5, 0.95}, histogram=true)
    public void getBadgeByForm(@RequestBody @NotNull FormBadge badge, @NotNull HttpServletResponse servletResponse) {
        Intrinsics.checkNotNullParameter((Object)badge, (String)"badge");
        Intrinsics.checkNotNullParameter((Object)servletResponse, (String)"servletResponse");
        String fillColor = badge.getMessageColor();
        if (fillColor == null) {
            fillColor = "GREEN";
        }
        String src = this.makeBadgeMessageOnly(badge);
        String badgeSource = StringsKt.trimIndent((String)("\n[badge]\n----\n" + badge.getLabel() + "|" + badge.getMessage() + "|" + badge.getUrl() + "|" + badge.getLabelColor() + "|" + fillColor + "|" + badge.getLogo() + "\n----\n"));
        String contents = this.makeBadgeAndSource(badgeSource, src);
        servletResponse.setContentType("text/html");
        servletResponse.setCharacterEncoding("UTF-8");
        servletResponse.setStatus(200);
        PrintWriter writer = servletResponse.getWriter();
        writer.print(contents);
        writer.flush();
    }

    @NotNull
    public String makeBadgeAndSource(@NotNull String txt, @NotNull String svg) {
        Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
        Intrinsics.checkNotNullParameter((Object)svg, (String)"svg");
        return StringsKt.trimIndent((String)("\n        <div id='imageblock'>\n        " + svg + "\n        </div>\n        <br/>\n        <h3>Badge Source</h3>\n        <div class='pure-u-1 pure-u-md-20-24'>\n        <pre>\n        <code class=\"asciidoc\">\n" + txt + "\n        </code>\n        </pre>\n        <script>\n        var badgeSource = `" + txt + "`;\n        </script>\n        </div>\n    "));
    }

    @GetMapping(value={"/badge/item"}, produces={"image/svg+xml"})
    @Timed(value="docops.badge.get", percentiles={0.5, 0.95}, histogram=true)
    public void getBadgeParams(@RequestParam @NotNull String payload, @NotNull HttpServletResponse servletResponse) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)servletResponse, (String)"servletResponse");
        String data = PanelGeneratorKt.uncompressString((String)payload);
        String[] stringArray = new String[]{"|"};
        List split = StringsKt.split$default((CharSequence)data, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (split.size() != 6) {
            throw new BadgeFormatException("Badge Format invalid, expecting 5 pipe delimited values [" + data + "]");
        }
        String message = (String)split.get(1);
        String label = (String)split.get(0);
        String mcolor = "GREEN";
        String color = ((Object)StringsKt.trim((CharSequence)((String)split.get(3)))).toString();
        String c = ((Object)StringsKt.trim((CharSequence)((String)split.get(4)))).toString();
        if (((CharSequence)c).length() > 0) {
            mcolor = c;
        }
        String logo = ((Object)StringsKt.trim((CharSequence)((String)split.get(5)))).toString();
        String src = this.badgeAgain(new FormBadge(label, message, "", color, mcolor, logo));
        servletResponse.setContentType("image/svg+xml");
        servletResponse.setCharacterEncoding("UTF-8");
        servletResponse.setStatus(200);
        PrintWriter writer = servletResponse.getWriter();
        writer.print(src);
        writer.flush();
    }

    private String badgeAgain(FormBadge formBadge) {
        String logo = this.getBadgeLogo(formBadge.getLogo());
        String[] stringArray = new String[]{formBadge.getUrl()};
        String string = Badge.builder().label(BadgeKt.labelOrNull((FormBadge)formBadge)).labelColor(formBadge.getLabelColor()).message(formBadge.getMessage()).color(formBadge.getMessageColor()).style(Style.Plastic).links(stringArray).logo(logo).build();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder()\n            .l\u2026ogo)\n            .build()");
        return string;
    }

    private String makeBadgeMessageOnly(FormBadge formBadge) {
        String logo = this.getBadgeLogo(formBadge.getLogo());
        String[] stringArray = new String[]{formBadge.getUrl()};
        String string = Badge.builder().label(BadgeKt.labelOrNull((FormBadge)formBadge)).labelColor(formBadge.getLabelColor()).message(formBadge.getMessage()).color(formBadge.getMessageColor()).style(Style.Plastic).links(stringArray).logo(logo).build();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder()\n            .l\u2026ogo)\n            .build()");
        return string;
    }

    @NotNull
    public String getBadgeLogo(@Nullable String input) {
        Object logo;
        block3: {
            block4: {
                byte[] byArray;
                logo = null;
                logo = "data:image/svg+xml;charset=utf-8,%3Csvg xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg' viewBox%3D'0 0 200 150'%2F%3E";
                String string = input;
                if (string == null) break block3;
                String it = string;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)input, (String)"<", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)input, (String)">", (boolean)false, (int)2, null)) break block4;
                Icon simpleIcon = SimpleIcons.get((String)StringsKt.replace$default((String)StringsKt.replace$default((String)input, (String)"<", (String)"", (boolean)false, (int)4, null), (String)">", (String)"", (boolean)false, (int)4, null));
                if (simpleIcon == null) break block3;
                String ico = simpleIcon.getSvg();
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                String string2 = ico;
                if (string2 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ico");
                    byte[] byArray2 = ico.getBytes(Charsets.UTF_8);
                    byArray = byArray2;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
                } else {
                    byArray = null;
                }
                Document xml = documentBuilder.parse(new ByteArrayInputStream(byArray));
                String src = null;
                src = "";
                Document document = xml;
                if (document != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"xml");
                    Document it2 = xml;
                    boolean bl2 = false;
                    String string3 = simpleIcon.getHex();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"simpleIcon.hex");
                    src = SimpleIconControllerKt.manipulateSVG((Document)xml, (String)string3);
                }
                Base64.Encoder encoder = Base64.getEncoder();
                byte[] byArray3 = src.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"this as java.lang.String).getBytes(charset)");
                logo = "data:image/svg+xml;base64," + encoder.encodeToString(byArray3);
                break block3;
            }
            if (!StringsKt.startsWith$default((String)input, (String)"http", (boolean)false, (int)2, null)) break block3;
            logo = this.getLogoFromUrl(input);
            Base64.Encoder encoder = Base64.getEncoder();
            byte[] byArray = ((String)logo).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            logo = "data:image/svg+xml;base64," + encoder.encodeToString(byArray);
        }
        return logo;
    }

    @NotNull
    public String getLogoFromUrl(@NotNull String url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofSeconds(20L)).build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(10L)).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            String string2 = response.body();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            val respon\u2026response.body()\n        }");
            string = string2;
        }
        catch (Exception e) {
            e.printStackTrace();
            string = "";
        }
        return string;
    }
}

