/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.web;

import io.docops.asciidoctorj.extension.adr.ADRParser;
import io.docops.asciidoctorj.extension.adr.AdrMaker;
import io.docops.asciidoctorj.extension.adr.model.Adr;
import io.micrometer.core.annotation.Timed;
import io.micrometer.observation.annotation.Observed;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api"})
@Observed(name="adr.controller")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J^\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u00062\b\b\u0001\u0010\t\u001a\u00020\u00062\b\b\u0001\u0010\n\u001a\u00020\u00062\b\b\u0001\u0010\u000b\u001a\u00020\u00062\b\b\u0001\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016\u00a8\u0006\u0014"}, d2={"Lio/docops/docopsextensionssupport/web/AdrController;", "", "()V", "adr", "", "title", "", "date", "status", "decision", "consequences", "participants", "context", "servletRequest", "Ljakarta/servlet/http/HttpServletRequest;", "servletResponse", "Ljakarta/servlet/http/HttpServletResponse;", "makeAdrSource", "txt", "svg", "docops-extension-server"})
@SourceDebugExtension(value={"SMAP\nAdrController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdrController.kt\nio/docops/docopsextensionssupport/web/AdrController\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,87:1\n215#2,2:88\n*S KotlinDebug\n*F\n+ 1 AdrController.kt\nio/docops/docopsextensionssupport/web/AdrController\n*L\n48#1:88,2\n*E\n"})
public class AdrController {
    @PutMapping(value={"/adr"}, produces={"text/html"})
    @ResponseBody
    @Timed(value="docops.adr", percentiles={0.5, 0.95}, histogram=true)
    @Observed(name="AdrController.adr", contextualName="creating-adr", lowCardinalityKeyValues={"decision", "status"})
    public void adr(@RequestParam(value="title") @NotNull String title, @RequestParam(value="date") @NotNull String date, @RequestParam(value="status") @NotNull String status, @RequestParam(value="decision") @NotNull String decision, @RequestParam(value="consequences") @NotNull String consequences, @RequestParam(value="participants") @NotNull String participants, @RequestParam(value="context") @NotNull String context, @NotNull HttpServletRequest servletRequest, @NotNull HttpServletResponse servletResponse) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)decision, (String)"decision");
        Intrinsics.checkNotNullParameter((Object)consequences, (String)"consequences");
        Intrinsics.checkNotNullParameter((Object)participants, (String)"participants");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)servletRequest, (String)"servletRequest");
        Intrinsics.checkNotNullParameter((Object)servletResponse, (String)"servletResponse");
        try {
            String adrText = StringsKt.trimIndent((String)("\n                \nTitle: " + title + "\nDate: " + date + "\nStatus: " + status + "\nContext: " + context + "\nDecision: " + decision + "\nConsequences: " + consequences + "\nParticipants: " + participants + " \n        "));
            Adr adr = ADRParser.parse$default((ADRParser)new ADRParser(), (String)adrText, null, (int)2, null);
            String svg = null;
            svg = AdrMaker.makeAdrSvg$default((AdrMaker)new AdrMaker(), (Adr)adr, (boolean)false, (int)2, null);
            Map $this$forEach$iv = adr.getUrlMap();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                int t = ((Number)entry.getKey()).intValue();
                String u = (String)entry.getValue();
                svg = StringsKt.replace$default((String)svg, (String)("_" + t + "_"), (String)u, (boolean)false, (int)4, null);
            }
            String results = this.makeAdrSource(adrText, svg);
            servletResponse.setContentType("text/html");
            servletResponse.setCharacterEncoding("UTF-8");
            servletResponse.setStatus(200);
            PrintWriter writer = servletResponse.getWriter();
            writer.print(results);
            writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @NotNull
    public String makeAdrSource(@NotNull String txt, @NotNull String svg) {
        Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
        Intrinsics.checkNotNullParameter((Object)svg, (String)"svg");
        return StringsKt.trimIndent((String)("\n        <div id='imageblock'>\n        " + svg + "\n        </div>\n        <br/>\n        <h3>Adr Source</h3>\n        <div class='pure-u-1 pure-u-md-20-24'>\n        <pre>\n        <code class=\"kotlin\">\n        " + txt + "\n        </code>\n        </pre>\n        </div>\n        <script>\n        var adrSource = `[adr]\\n----\\n" + txt + "\\n----`;\n        document.querySelectorAll('pre code').forEach((el) => {\n            hljs.highlightElement(el);\n        });\n        </script>\n    "));
    }
}

