/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.web.panel;

import io.docops.asciidoc.buttons.dsl.Panels;
import io.docops.asciidoc.buttons.service.PanelService;
import io.docops.asciidoc.buttons.service.ScriptLoader;
import io.docops.asciidoc.buttons.theme.ButtonType;
import io.docops.docopsextensionssupport.support.CircleImageBuilderKt;
import io.docops.docopsextensionssupport.support.ColorDivCreator;
import io.docops.docopsextensionssupport.support.ColorDivCreatorKt;
import io.docops.docopsextensionssupport.support.LineImageBuilderKt;
import io.docops.docopsextensionssupport.support.TagLineImageBuilderKt;
import io.docops.docopsextensionssupport.web.panel.PanelGeneratorKt;
import io.micrometer.core.annotation.Timed;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.annotation.Observed;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api"})
@Observed(name="panel.controller")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0012J$\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u000b2\b\b\u0001\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J$\u0010\u0015\u001a\u00020\u00102\b\b\u0001\u0010\u0016\u001a\u00020\u000b2\b\b\u0001\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/docops/docopsextensionssupport/web/panel/PanelGenerator;", "", "observationRegistry", "Lio/micrometer/observation/ObservationRegistry;", "(Lio/micrometer/observation/ObservationRegistry;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "scriptLoader", "Lio/docops/asciidoc/buttons/service/ScriptLoader;", "contentsToImageStr", "", "contents", "isPDf", "", "getPanel", "", "data", "type", "servletResponse", "Ljakarta/servlet/http/HttpServletResponse;", "panColor", "color", "label", "panelImage", "httpServletRequest", "Ljakarta/servlet/http/HttpServletRequest;", "panelsPlain", "putColorGen", "docops-extension-server"})
@SourceDebugExtension(value={"SMAP\nPanelGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PanelGenerator.kt\nio/docops/docopsextensionssupport/web/panel/PanelGenerator\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,259:1\n17#2,6:260\n17#2,6:266\n*S KotlinDebug\n*F\n+ 1 PanelGenerator.kt\nio/docops/docopsextensionssupport/web/panel/PanelGenerator\n*L\n40#1:260,6\n58#1:266,6\n*E\n"})
public class PanelGenerator {
    @NotNull
    private final ObservationRegistry observationRegistry;
    @NotNull
    private final ScriptLoader scriptLoader;
    private final Logger log;

    public PanelGenerator(@NotNull ObservationRegistry observationRegistry) {
        Intrinsics.checkNotNullParameter((Object)observationRegistry, (String)"observationRegistry");
        this.observationRegistry = observationRegistry;
        this.scriptLoader = new ScriptLoader();
        this.log = LoggerFactory.getLogger(PanelGenerator.class);
    }

    @GetMapping(value={"/panel"})
    @ResponseBody
    @Timed(value="docops.panel", percentiles={0.5, 0.95}, histogram=true)
    public void getPanel(@RequestParam(value="data") @NotNull String data, @RequestParam(value="type") @NotNull String type, @NotNull HttpServletResponse servletResponse) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)servletResponse, (String)"servletResponse");
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        boolean isPDF = Intrinsics.areEqual((Object)"PDF", (Object)type);
        String contents = PanelGeneratorKt.uncompressString((String)data);
        String imgSrc = this.contentsToImageStr(contents, this.scriptLoader, isPDF);
        servletResponse.setContentType("image/svg+xml");
        servletResponse.setCharacterEncoding("UTF-8");
        servletResponse.setStatus(200);
        PrintWriter writer = servletResponse.getWriter();
        writer.print(imgSrc);
        writer.flush();
        long timings = System.currentTimeMillis() - start$iv;
        this.log.info("getPanel Total Time : " + timings + " ms");
    }

    @PutMapping(value={"/colorgen"})
    @ResponseBody
    @Timed(value="docops.panel.generator.color", percentiles={0.5, 0.95}, histogram=true)
    public void putColorGen(@NotNull HttpServletRequest httpServletRequest, @NotNull HttpServletResponse servletResponse) {
        Intrinsics.checkNotNullParameter((Object)httpServletRequest, (String)"httpServletRequest");
        Intrinsics.checkNotNullParameter((Object)servletResponse, (String)"servletResponse");
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        try {
            String newWinParam;
            boolean bold = false;
            boolean underline = false;
            boolean italics = false;
            boolean newWin = false;
            Map params = httpServletRequest.getParameterMap();
            String[] stringArray = (String[])params.get("points");
            String string = stringArray != null ? stringArray[0] : null;
            Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type kotlin.String");
            String pts = string;
            String[] stringArray2 = (String[])params.get("buttonType");
            String string2 = stringArray2 != null ? stringArray2[0] : null;
            Intrinsics.checkNotNull((Object)string2);
            String btnType = string2;
            String[] stringArray3 = (String[])params.get("columns");
            String string3 = stringArray3 != null ? stringArray3[0] : null;
            Intrinsics.checkNotNull((Object)string3);
            String columns = string3;
            String[] stringArray4 = (String[])params.get("sortBy");
            String string4 = stringArray4 != null ? stringArray4[0] : null;
            Intrinsics.checkNotNull((Object)string4);
            String groupBY = string4;
            String[] stringArray5 = (String[])params.get("order");
            String string5 = stringArray5 != null ? stringArray5[0] : null;
            Intrinsics.checkNotNull((Object)string5);
            String orderBy = string5;
            String[] stringArray6 = (String[])params.get("case");
            String string6 = stringArray6 != null ? stringArray6[0] : null;
            Intrinsics.checkNotNull((Object)string6);
            String string7 = string6;
            String[] stringArray7 = (String[])params.get("dropShadow");
            String string8 = stringArray7 != null ? stringArray7[0] : null;
            Intrinsics.checkNotNull((Object)string8);
            String dropShadow = string8;
            ButtonType buttonKind = ButtonType.valueOf((String)btnType);
            String[] stringArray8 = (String[])params.get("color");
            String string9 = stringArray8 != null ? stringArray8[0] : null;
            Intrinsics.checkNotNull((Object)string9);
            String color = string9;
            String[] weight = (String[])params.get("bold");
            if (weight != null) {
                bold = true;
            }
            String[] stringArray9 = (String[])params.get("italic");
            String italic = stringArray9 != null ? stringArray9[0] : null;
            String[] stringArray10 = (String[])params.get("underline");
            String und = stringArray10 != null ? stringArray10[0] : null;
            String[] stringArray11 = (String[])params.get("newWin");
            String string10 = newWinParam = stringArray11 != null ? stringArray11[0] : null;
            if (Intrinsics.areEqual((Object)"on", (Object)italic)) {
                italics = true;
            }
            if (Intrinsics.areEqual((Object)"on", (Object)und)) {
                underline = true;
            }
            if (Intrinsics.areEqual((Object)"on", (Object)newWinParam)) {
                newWin = true;
            }
            String[] stringArray12 = (String[])params.get("font");
            String string11 = stringArray12 != null ? stringArray12[0] : null;
            Intrinsics.checkNotNull((Object)string11);
            String font = string11;
            String[] stringArray13 = (String[])params.get("fpoint");
            String string12 = stringArray13 != null ? stringArray13[0] : null;
            Intrinsics.checkNotNull((Object)string12);
            String fpoint = string12;
            String[] stringArray14 = (String[])params.get("size");
            String string13 = stringArray14 != null ? stringArray14[0] : null;
            Intrinsics.checkNotNull((Object)string13);
            String size = string13;
            String[] stringArray15 = (String[])params.get("spacing");
            String string14 = stringArray15 != null ? stringArray15[0] : null;
            Intrinsics.checkNotNull((Object)string14);
            String spacing = string14;
            int n = Integer.parseInt(pts);
            boolean bl2 = bold;
            boolean bl3 = italics;
            boolean bl4 = underline;
            String string15 = size + fpoint;
            boolean bl5 = newWin;
            ColorDivCreator cd = new ColorDivCreator(n, buttonKind, columns, groupBY, orderBy, dropShadow, color, bl2, bl3, font, bl4, string15, string7, bl5, spacing);
            String panel = cd.genPanels();
            servletResponse.setContentType("text/html");
            servletResponse.setCharacterEncoding("UTF-8");
            servletResponse.setStatus(200);
            PrintWriter writer = servletResponse.getWriter();
            writer.print(panel);
            writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            servletResponse.setContentType("text/html");
            servletResponse.setCharacterEncoding("UTF-8");
            servletResponse.setStatus(400);
            PrintWriter writer = servletResponse.getWriter();
            writer.print("\n        <input class=\"checker\" type=\"checkbox\" id=\"o\" checked hidden>\n        <div class=\"modal\">\n          <div class=\"modal-body\">\n            <div class=\"modal-content\">Invalid selection(s) for panel!</div>\n            <div class=\"modal-footer\">\n              <label for=\"o\" class='mlabel'>close</label>\n            </div>\n          </div>\n        </div>\n    ");
            writer.flush();
        }
        long timings = System.currentTimeMillis() - start$iv;
        this.log.info("putColorGen Total Time : " + timings + " ms");
    }

    @PutMapping(value={"/panelimage"})
    @ResponseBody
    @Timed(value="docops.panel.image", percentiles={0.5, 0.95}, histogram=true)
    public void panelImage(@NotNull HttpServletRequest httpServletRequest, @NotNull HttpServletResponse servletResponse) {
        String string;
        String transparentParam;
        Intrinsics.checkNotNullParameter((Object)httpServletRequest, (String)"httpServletRequest");
        Intrinsics.checkNotNullParameter((Object)servletResponse, (String)"servletResponse");
        Map params = httpServletRequest.getParameterMap();
        String[] stringArray = (String[])params.get("fillColor");
        String string2 = stringArray != null ? stringArray[0] : null;
        Intrinsics.checkNotNull((Object)string2);
        String fillColor = string2;
        String[] stringArray2 = (String[])params.get("imageType");
        String string3 = stringArray2 != null ? stringArray2[0] : null;
        Intrinsics.checkNotNull((Object)string3);
        String imageType = string3;
        String[] stringArray3 = (String[])params.get("fontColor");
        String string4 = stringArray3 != null ? stringArray3[0] : null;
        Intrinsics.checkNotNull((Object)string4);
        String fontColor = string4;
        String[] stringArray4 = (String[])params.get("line1");
        String string5 = stringArray4 != null ? stringArray4[0] : null;
        Intrinsics.checkNotNull((Object)string5);
        String line1 = string5;
        String[] stringArray5 = (String[])params.get("line2");
        String string6 = stringArray5 != null ? stringArray5[0] : null;
        Intrinsics.checkNotNull((Object)string6);
        String line2 = string6;
        String[] stringArray6 = (String[])params.get("line3");
        String string7 = stringArray6 != null ? stringArray6[0] : null;
        Intrinsics.checkNotNull((Object)string7);
        String line3 = string7;
        String[] stringArray7 = (String[])params.get("transparent");
        String string8 = transparentParam = stringArray7 != null ? stringArray7[0] : null;
        if (Intrinsics.areEqual((Object)"on", (Object)transparentParam)) {
            fillColor = "none";
        }
        String contents = Intrinsics.areEqual((Object)(string = imageType), (Object)"CIRCLE") ? CircleImageBuilderKt.makePanelRoundMiddleImage((String)fillColor, (String)fontColor, (String)line1, (String)line2, (String)line3) : (Intrinsics.areEqual((Object)string, (Object)"TAGLINE") ? TagLineImageBuilderKt.makeTagLine((String)fillColor, (String)fontColor, (String)line1, (String)line2, (String)line3) : LineImageBuilderKt.makeLineImage((String)fillColor, (String)fontColor, (String)line1, (String)line2, (String)line3));
        servletResponse.setContentType("text/html");
        servletResponse.setCharacterEncoding("UTF-8");
        servletResponse.setStatus(200);
        PrintWriter writer = servletResponse.getWriter();
        writer.print(contents);
        writer.flush();
    }

    @PostMapping(value={"/panel/plain"})
    @ResponseBody
    @Timed(value="docops.panel.plain", percentiles={0.5, 0.95}, histogram=true)
    public void panelsPlain(@NotNull HttpServletRequest httpServletRequest, @NotNull HttpServletResponse servletResponse) {
        Intrinsics.checkNotNullParameter((Object)httpServletRequest, (String)"httpServletRequest");
        Intrinsics.checkNotNullParameter((Object)servletResponse, (String)"servletResponse");
        String string = StreamUtils.copyToString((InputStream)((InputStream)httpServletRequest.getInputStream()), (Charset)Charset.defaultCharset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"copyToString(httpServlet\u2026Charset.defaultCharset())");
        String contents = string;
        String imgSrc = this.contentsToImageStr(contents, this.scriptLoader, false);
        servletResponse.setContentType("text/html");
        servletResponse.setCharacterEncoding("UTF-8");
        servletResponse.setStatus(200);
        PrintWriter writer = servletResponse.getWriter();
        writer.print("<div>\n                " + imgSrc + "\n                </div>");
        writer.flush();
    }

    @GetMapping(value={"/panel/pancolor"})
    @ResponseBody
    @Timed(value="docops.panel.pancolor", percentiles={0.5, 0.95}, histogram=true)
    public void panColor(@RequestParam(value="color") @NotNull String color, @RequestParam(value="label") @NotNull String label, @NotNull HttpServletResponse servletResponse) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)servletResponse, (String)"servletResponse");
        String imgSrc = StringsKt.trimIndent((String)("\n                <svg xmlns=\"http://www.w3.org/2000/svg\" width=\"300\" height=\"20\">\n                    <rect x=\"0\" y=\"0\" width=\"300\" height=\"20\" fill=\"" + color + "\"  rx=\"5\" ry=\"5\"/>\n                    <a href=\"https://www.apple.com\">\n                        <text x=\"150\" y=\"15\" text-anchor=\"middle\">" + label + "</text>\n                    </a>\n                 </svg>\n            "));
        servletResponse.setContentType("image/svg+xml");
        servletResponse.setCharacterEncoding("UTF-8");
        servletResponse.setStatus(200);
        PrintWriter writer = servletResponse.getWriter();
        writer.print(imgSrc);
    }

    private String contentsToImageStr(String contents, ScriptLoader scriptLoader, boolean isPDf) {
        try {
            Panels panels = ColorDivCreatorKt.sourceToPanel((String)contents, (ScriptLoader)scriptLoader);
            PanelService panelService = new PanelService();
            panels.setPdf(isPDf);
            return panelService.fromPanelToSvg(panels);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

