/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.web.panel;

import io.micrometer.core.annotation.Timed;
import io.micrometer.observation.annotation.Observed;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Observed(name="panel.twoToneImageBuilderController")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017\u00a8\u0006\u0011"}, d2={"Lio/docops/docopsextensionssupport/web/panel/TwoToneImageBuilderController;", "", "()V", "makeImage", "", "fillColor1", "fillColor2", "text1", "text2", "line1Size", "line2Size", "panelImageTone", "", "httpServletRequest", "Ljakarta/servlet/http/HttpServletRequest;", "servletResponse", "Ljakarta/servlet/http/HttpServletResponse;", "docops-extension-server"})
public class TwoToneImageBuilderController {
    @PutMapping(value={"/panelimagetone"})
    @ResponseBody
    @Timed(value="docops.panel.image.tone", percentiles={0.5, 0.95}, histogram=true)
    public void panelImageTone(@NotNull HttpServletRequest httpServletRequest, @NotNull HttpServletResponse servletResponse) {
        Intrinsics.checkNotNullParameter((Object)httpServletRequest, (String)"httpServletRequest");
        Intrinsics.checkNotNullParameter((Object)servletResponse, (String)"servletResponse");
        Map params = httpServletRequest.getParameterMap();
        String[] stringArray = (String[])params.get("fillColor1");
        String string = stringArray != null ? stringArray[0] : null;
        Intrinsics.checkNotNull((Object)string);
        String fillColor1 = string;
        String[] stringArray2 = (String[])params.get("fillColor2");
        String string2 = stringArray2 != null ? stringArray2[0] : null;
        Intrinsics.checkNotNull((Object)string2);
        String fillColor2 = string2;
        String[] stringArray3 = (String[])params.get("line1");
        String string3 = stringArray3 != null ? stringArray3[0] : null;
        Intrinsics.checkNotNull((Object)string3);
        String line1 = string3;
        String[] stringArray4 = (String[])params.get("line2");
        String string4 = stringArray4 != null ? stringArray4[0] : null;
        Intrinsics.checkNotNull((Object)string4);
        String line2 = string4;
        String[] stringArray5 = (String[])params.get("line1Size");
        String string5 = stringArray5 != null ? stringArray5[0] : null;
        Intrinsics.checkNotNull((Object)string5);
        String line1Size = string5;
        String[] stringArray6 = (String[])params.get("line2Size");
        String string6 = stringArray6 != null ? stringArray6[0] : null;
        Intrinsics.checkNotNull((Object)string6);
        String line2Size = string6;
        String contents = this.makeImage(fillColor1, fillColor2, line1, line2, line1Size, line2Size);
        servletResponse.setContentType("image/svg+xml");
        servletResponse.setCharacterEncoding("UTF-8");
        servletResponse.setStatus(200);
        PrintWriter writer = servletResponse.getWriter();
        writer.print(contents);
        writer.flush();
    }

    @NotNull
    public String makeImage(@NotNull String fillColor1, @NotNull String fillColor2, @NotNull String text1, @NotNull String text2, @NotNull String line1Size, @NotNull String line2Size) {
        Intrinsics.checkNotNullParameter((Object)fillColor1, (String)"fillColor1");
        Intrinsics.checkNotNullParameter((Object)fillColor2, (String)"fillColor2");
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)line1Size, (String)"line1Size");
        Intrinsics.checkNotNullParameter((Object)line2Size, (String)"line2Size");
        return StringsKt.trimIndent((String)("\n            <?xml version=\"1.0\" encoding=\"UTF-8\"?>\n            <svg id=\"panelText\" width=\"300px\" height=\"191px\" viewBox=\"0 0 300 191\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n                <title>ICON</title>\n                <style>\n                    .oddstyle {\n                        font: bold " + line1Size + "px Arial, Helvetica, sans-serif;\n                        fill: " + fillColor2 + ";\n                    }\n                    .evenstyle {\n                        font: bold " + line2Size + "px Arial, Helvetica, sans-serif;\n                        fill: " + fillColor1 + ";\n                    }\n                </style>\n                <g id=\"Page-1\" stroke=\"none\" stroke-width=\"1\" fill=\"#FFFFFF\" fill-rule=\"evenodd\">\n                    <rect width=\"100%\" height=\"100%\" fill=\"none\" />\n                    <rect width=\"100%\" height=\"50%\" fill=\"" + fillColor1 + "\"/>\n                    <rect y=\"95.5\" width=\"100%\" height=\"50%\" fill=\"" + fillColor2 + "\" />\n                    <text text-anchor=\"middle\" x=\"150\" y=\"67.75\" fill=\"blue\" class=\"oddstyle\">" + text1 + "</text>\n                    <text text-anchor=\"middle\" x=\"150\" y=\"163.25\" class=\"evenstyle\">" + text2 + "</text>\n                </g>\n            </svg>\n        "));
    }
}

