/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.releasestrategy;

import com.fasterxml.jackson.databind.ObjectMapper;
import freemarker.template.Template;
import io.docops.docopsextensionssupport.badge.BadgeControllerKt;
import io.docops.docopsextensionssupport.releasestrategy.Release;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseEnum;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseRoadMapMaker;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseStrategy;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseStrategyKt;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseTimelineGroupedMaker;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseTimelineMaker;
import io.docops.docopsextensionssupport.releasestrategy.SelectedStrategy;
import io.docops.docopsextensionssupport.svgsupport.SvgToPng;
import io.docops.docopsextensionssupport.web.panel.PanelGeneratorKt;
import jakarta.servlet.http.HttpServletRequest;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/api/release"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J.\u0010\u0011\u001a\u00020\f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\f2\b\b\u0001\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u001a\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\b\b\u0001\u0010\u001d\u001a\u00020\fH\u0017J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0012J\u0012\u0010!\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Lio/docops/docopsextensionssupport/releasestrategy/ReleaseController;", "", "freeMarkerConfigurer", "Lorg/springframework/web/servlet/view/freemarker/FreeMarkerConfigurer;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lorg/springframework/web/servlet/view/freemarker/FreeMarkerConfigurer;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getFreeMarkerConfigurer", "()Lorg/springframework/web/servlet/view/freemarker/FreeMarkerConfigurer;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "createRoadMap", "", "releaseStrategy", "Lio/docops/docopsextensionssupport/releasestrategy/ReleaseStrategy;", "isPdf", "", "createStrategy", "model", "Lorg/springframework/ui/ModelMap;", "title", "style", "servletRequest", "Ljakarta/servlet/http/HttpServletRequest;", "createTimelineGrouped", "createTimelineSvg", "getRelease", "Lorg/springframework/http/ResponseEntity;", "", "payload", "getReleaseTypes", "", "Lio/docops/docopsextensionssupport/releasestrategy/Release;", "putStrategy", "docops-extension-server"})
@SourceDebugExtension(value={"SMAP\nReleaseController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReleaseController.kt\nio/docops/docopsextensionssupport/releasestrategy/ReleaseController\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n13579#2,2:136\n766#3:138\n857#3,2:139\n1855#3,2:141\n*S KotlinDebug\n*F\n+ 1 ReleaseController.kt\nio/docops/docopsextensionssupport/releasestrategy/ReleaseController\n*L\n94#1:136,2\n116#1:138\n116#1:139,2\n117#1:141,2\n*E\n"})
public class ReleaseController {
    @NotNull
    private final FreeMarkerConfigurer freeMarkerConfigurer;
    @NotNull
    private final ObjectMapper objectMapper;

    @Autowired
    public ReleaseController(@NotNull FreeMarkerConfigurer freeMarkerConfigurer, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)freeMarkerConfigurer, (String)"freeMarkerConfigurer");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.freeMarkerConfigurer = freeMarkerConfigurer;
        this.objectMapper = objectMapper;
    }

    @NotNull
    public FreeMarkerConfigurer getFreeMarkerConfigurer() {
        return this.freeMarkerConfigurer;
    }

    @NotNull
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @GetMapping(value={"/"}, produces={"image/png"})
    @NotNull
    public ResponseEntity<byte[]> getRelease(@RequestParam(name="payload") @NotNull String payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        String string = URLDecoder.decode(payload, "UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(payload,\"UTF-8\")");
        String data = PanelGeneratorKt.uncompressString((String)string);
        ReleaseStrategy release = (ReleaseStrategy)this.getObjectMapper().readValue(data, ReleaseStrategy.class);
        String output = "";
        switch (release.getStyle()) {
            case "TL": {
                Intrinsics.checkNotNullExpressionValue((Object)release, (String)"release");
                output = this.createTimelineSvg(release, true);
                break;
            }
            case "R": {
                Intrinsics.checkNotNullExpressionValue((Object)release, (String)"release");
                output = this.createRoadMap(release, true);
                break;
            }
            case "TLG": {
                Intrinsics.checkNotNullExpressionValue((Object)release, (String)"release");
                output = this.createTimelineGrouped(release, true);
            }
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setCacheControl(CacheControl.noCache().getHeaderValue());
        headers.setContentType(MediaType.IMAGE_PNG);
        Pair res = BadgeControllerKt.findHeightWidth((String)output);
        byte[] baos = new SvgToPng().toPngFromSvg(output, res);
        return new ResponseEntity((Object)baos, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    @PutMapping(value={"/"}, produces={"image/svg+xml"})
    @ResponseBody
    @NotNull
    public String putStrategy(@RequestBody @NotNull ReleaseStrategy releaseStrategy) {
        Intrinsics.checkNotNullParameter((Object)releaseStrategy, (String)"releaseStrategy");
        switch (releaseStrategy.getStyle()) {
            case "TL": {
                return ReleaseController.createTimelineSvg$default((ReleaseController)this, (ReleaseStrategy)releaseStrategy, (boolean)false, (int)2, null);
            }
            case "R": {
                return ReleaseController.createRoadMap$default((ReleaseController)this, (ReleaseStrategy)releaseStrategy, (boolean)false, (int)2, null);
            }
            case "TLG": {
                return ReleaseController.createTimelineGrouped$default((ReleaseController)this, (ReleaseStrategy)releaseStrategy, (boolean)false, (int)2, null);
            }
        }
        return ReleaseController.createTimelineSvg$default((ReleaseController)this, (ReleaseStrategy)releaseStrategy, (boolean)false, (int)2, null);
    }

    @PutMapping(value={"/build"}, produces={"text/html"})
    @ResponseBody
    @NotNull
    public String createStrategy(@ModelAttribute @NotNull ModelMap model, @RequestParam(value="title") @NotNull String title, @RequestParam(value="style") @NotNull String style, @NotNull HttpServletRequest servletRequest) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)servletRequest, (String)"servletRequest");
        this.getReleaseTypes(servletRequest);
        List releases = this.getReleaseTypes(servletRequest);
        ReleaseStrategy releaseStrategy = new ReleaseStrategy(title, releases, style);
        ((Map)model).put("releaseStrategy", releaseStrategy);
        String svg = "";
        switch (style) {
            case "TL": {
                svg = ReleaseController.createTimelineSvg$default((ReleaseController)this, (ReleaseStrategy)releaseStrategy, (boolean)false, (int)2, null);
                break;
            }
            case "R": {
                svg = ReleaseController.createRoadMap$default((ReleaseController)this, (ReleaseStrategy)releaseStrategy, (boolean)false, (int)2, null);
                break;
            }
            case "TLG": {
                svg = ReleaseController.createTimelineGrouped$default((ReleaseController)this, (ReleaseStrategy)releaseStrategy, (boolean)false, (int)2, null);
            }
        }
        ((Map)model).put("svg", svg);
        Object object = (Map)model;
        String string = "bsvg";
        Base64.Encoder encoder = Base64.getEncoder();
        String string2 = svg;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        string2 = encoder.encodeToString(byArray);
        object.put(string, string2);
        List selectedStrategy = new ArrayList();
        ReleaseEnum[] $this$forEach$iv = ReleaseEnum.values();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ReleaseEnum element$iv;
            ReleaseEnum it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            selectedStrategy.add(new SelectedStrategy(it.name(), false));
        }
        ((Map)model).put("releaseTypes", ReleaseEnum.values());
        ((Map)model).put("sourceJson", this.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)releaseStrategy));
        ((Map)model).put("styles", ReleaseStrategyKt.styles((ReleaseStrategy)releaseStrategy));
        StringWriter writer = new StringWriter();
        Template tpl = this.getFreeMarkerConfigurer().getConfiguration().getTemplate("release/filled.ftlh");
        tpl.process((Object)model, (Writer)writer);
        String string3 = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"writer.toString()");
        return string3;
    }

    @NotNull
    public String createTimelineSvg(@NotNull ReleaseStrategy releaseStrategy, boolean isPdf) {
        Intrinsics.checkNotNullParameter((Object)releaseStrategy, (String)"releaseStrategy");
        return new ReleaseTimelineMaker().make(releaseStrategy, isPdf);
    }

    public static /* synthetic */ String createTimelineSvg$default(ReleaseController releaseController, ReleaseStrategy releaseStrategy, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createTimelineSvg");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return releaseController.createTimelineSvg(releaseStrategy, bl);
    }

    @NotNull
    public String createTimelineGrouped(@NotNull ReleaseStrategy releaseStrategy, boolean isPdf) {
        Intrinsics.checkNotNullParameter((Object)releaseStrategy, (String)"releaseStrategy");
        return new ReleaseTimelineGroupedMaker().make(releaseStrategy, isPdf);
    }

    public static /* synthetic */ String createTimelineGrouped$default(ReleaseController releaseController, ReleaseStrategy releaseStrategy, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createTimelineGrouped");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return releaseController.createTimelineGrouped(releaseStrategy, bl);
    }

    @NotNull
    public String createRoadMap(@NotNull ReleaseStrategy releaseStrategy, boolean isPdf) {
        Intrinsics.checkNotNullParameter((Object)releaseStrategy, (String)"releaseStrategy");
        return new ReleaseRoadMapMaker().make(releaseStrategy, isPdf);
    }

    public static /* synthetic */ String createRoadMap$default(ReleaseController releaseController, ReleaseStrategy releaseStrategy, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createRoadMap");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return releaseController.createRoadMap(releaseStrategy, bl);
    }

    /*
     * WARNING - void declaration
     */
    private List<Release> getReleaseTypes(HttpServletRequest servletRequest) {
        String[] it;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String addLine = servletRequest.getParameter("addLine");
        String addType = servletRequest.getParameter("addType");
        List releases = new ArrayList();
        Enumeration enumeration = servletRequest.getParameterNames();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"servletRequest.parameterNames");
        ArrayList arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(this)");
        Object[] objectArray = (Object[])arrayList;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String[])element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!StringsKt.startsWith$default((String)it, (String)"type_", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List types = (List)destination$iv$iv;
        Iterable $this$forEach$iv = types;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl = false;
            String string = servletRequest.getParameter(it2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"servletRequest.getParameter(it)");
            ReleaseEnum type = ReleaseEnum.valueOf((String)string);
            Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
            it = new String[]{"type_"};
            List splitType = StringsKt.split$default((CharSequence)it2, (String[])it, (boolean)false, (int)0, (int)6, null);
            String dateEntry = servletRequest.getParameter("date_" + splitType.get(1));
            String goal = servletRequest.getParameter("goal_" + splitType.get(1));
            String[] stringArray = servletRequest.getParameterValues("line_" + splitType.get(1));
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"servletRequest.getParame\u2026s(\"line_${splitType[1]}\")");
            List lineArr = ArraysKt.toMutableList((Object[])stringArray);
            if (addLine != null && ((CharSequence)addLine).length() > 0 && Intrinsics.areEqual((Object)addLine, (Object)("line_" + splitType.get(1)))) {
                lineArr.add("");
            }
            Intrinsics.checkNotNullExpressionValue((Object)dateEntry, (String)"dateEntry");
            Intrinsics.checkNotNullExpressionValue((Object)goal, (String)"goal");
            releases.add(new Release(type, lineArr, dateEntry, true, goal));
        }
        if (addType != null && Intrinsics.areEqual((Object)addType, (Object)"increase")) {
            objectArray = new String[]{""};
            releases.add(new Release(ReleaseEnum.M1, CollectionsKt.mutableListOf((Object[])objectArray), "TBD", false, "Our goal is ...", 8, null));
        }
        return releases;
    }
}

