/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.releasestrategy;

import io.docops.docopsextensionssupport.releasestrategy.Release;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseStrategy;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseStrategyKt;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0016\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0018\u001a\u00020\u0004H\u0002J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\bH\u0002\u00a8\u0006\u001a"}, d2={"Lio/docops/docopsextensionssupport/releasestrategy/ReleaseTimelineGroupedMaker;", "", "()V", "buildReleaseItem", "", "release", "Lio/docops/docopsextensionssupport/releasestrategy/Release;", "currentIndex", "", "isPdf", "", "row", "id", "defs", "determineHeight", "releaseStrategy", "Lio/docops/docopsextensionssupport/releasestrategy/ReleaseStrategy;", "determineWidth", "head", "width", "height", "make", "shadeColor", "strokeColor", "tail", "title", "docops-extension-server"})
@SourceDebugExtension(value={"SMAP\nReleaseTimelineGroupedMaker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReleaseTimelineGroupedMaker.kt\nio/docops/docopsextensionssupport/releasestrategy/ReleaseTimelineGroupedMaker\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n215#2:192\n216#2:196\n215#2,2:200\n1864#3,3:193\n1864#3,3:197\n*S KotlinDebug\n*F\n+ 1 ReleaseTimelineGroupedMaker.kt\nio/docops/docopsextensionssupport/releasestrategy/ReleaseTimelineGroupedMaker\n*L\n15#1:192\n15#1:196\n104#1:200,2\n16#1:193,3\n38#1:197,3\n*E\n"})
public final class ReleaseTimelineGroupedMaker {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String make(@NotNull ReleaseStrategy releaseStrategy, boolean isPdf) {
        Intrinsics.checkNotNullParameter((Object)releaseStrategy, (String)"releaseStrategy");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String id = string;
        int width = this.determineWidth(releaseStrategy);
        int height = this.determineHeight(releaseStrategy);
        StringBuilder str = new StringBuilder(this.head(width, height, id));
        str.append(this.defs(isPdf, id));
        str.append(this.title(releaseStrategy.getTitle(), width));
        int row = 0;
        Map $this$forEach$iv = ReleaseStrategyKt.grouped((ReleaseStrategy)releaseStrategy);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            char t2 = ((Character)entry.getKey()).charValue();
            List u = (List)entry.getValue();
            Iterable $this$forEachIndexed$iv = u;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void release;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Release release2 = (Release)item$iv;
                int index = n;
                boolean bl2 = false;
                str.append(this.buildReleaseItem((Release)release, index, isPdf, row, id));
            }
            ++row;
        }
        str.append(this.tail());
        String string2 = str.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"str.toString()");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final String buildReleaseItem(Release release, int currentIndex, boolean isPdf, int row, String id) {
        int startY = 60;
        if (row > 0) {
            startY = row * 240 + 60;
        }
        int startX = 20;
        if (currentIndex > 0) {
            startX = currentIndex * 500;
        }
        String goal = (String)release.getLines().get(0);
        StringBuilder lineText = new StringBuilder();
        int lineStart = 0;
        lineStart = 15;
        Iterable $this$forEachIndexed$iv = release.getLines();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void s;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            lineText.append(StringsKt.trimIndent((String)("\n                <tspan x=\"" + lineStart + "\" dy=\"10\" class=\"entry\" font-size=\"10px\" font-weight=\"normal\"\n                   font-family=\"Arial, 'Helvetica Neue', Helvetica, sans-serif\" text-anchor=\"start\">- " + (String)s + "</tspan>\n            ")));
            if (index <= 7) {
                lineStart += 5;
                continue;
            }
            lineStart -= 5;
        }
        int x = 200;
        String anchor = "text-anchor=\"middle\"";
        if (isPdf) {
            x = 15;
            anchor = "";
        }
        return StringsKt.trimIndent((String)("\n         <g transform=\"translate(" + startX + "," + startY + ")\" class=\"" + this.shadeColor(release) + "\">\n             <text text-anchor=\"middle\" x=\"200\" y=\"-12\" class=\"milestoneTLG\">" + release.getDate() + "</text>\n             <path d=\"m 0,0 h 400 v 200 h -400 l 0,0 l 50,-100 z\" stroke=\"" + this.strokeColor(release) + "\" fill=\"#fcfcfc\"/>\n             <path d=\"m 400,0 v 200 l 100,-100 z\" fill=\"" + this.strokeColor(release) + "\" stroke=\"" + this.strokeColor(release) + "\" />\n            <text x=\"410\" y=\"110\" class=\"milestoneTLG\" font-size=\"36px\" fill=\"#fcfcfc\">" + release.getType() + "</text>\n            <text " + anchor + " x=\"" + x + "\" y=\"12\" class=\"milestoneTLG lines\" font-size=\"10px\" font-family='Arial, \"Helvetica Neue\", Helvetica, sans-serif' font-weight=\"bold\">" + release.getGoal() + "\n                " + lineText + "\n            </text>\n        </g>\n        "));
    }

    private final String shadeColor(Release release) {
        return StringsKt.startsWith$default((String)release.getType().toString(), (String)"M", (boolean)false, (int)2, null) ? "shadM" : (StringsKt.startsWith$default((String)release.getType().toString(), (String)"R", (boolean)false, (int)2, null) ? "shadR" : (StringsKt.startsWith$default((String)release.getType().toString(), (String)"G", (boolean)false, (int)2, null) ? "shadG" : ""));
    }

    private final String strokeColor(Release release) {
        return StringsKt.startsWith$default((String)release.getType().toString(), (String)"M", (boolean)false, (int)2, null) ? "#c30213" : (StringsKt.startsWith$default((String)release.getType().toString(), (String)"R", (boolean)false, (int)2, null) ? "rgb(51, 182, 169)" : (StringsKt.startsWith$default((String)release.getType().toString(), (String)"G", (boolean)false, (int)2, null) ? "rgb(84, 210, 0)" : ""));
    }

    private final int determineWidth(ReleaseStrategy releaseStrategy) {
        Map groups = ReleaseStrategyKt.grouped((ReleaseStrategy)releaseStrategy);
        int maxLen = 0;
        Map $this$forEach$iv = groups;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            char t2 = ((Character)entry.getKey()).charValue();
            List u = (List)entry.getValue();
            maxLen = Math.max(maxLen, u.size());
        }
        return maxLen * 550;
    }

    private final int determineHeight(ReleaseStrategy releaseStrategy) {
        return releaseStrategy.getReleases().size() * 400;
    }

    private final String head(int width, int height, String id) {
        return StringsKt.trimIndent((String)("\n            <svg width=\"" + width + "\" height=\"" + height + "\" viewBox='0 0 " + width + " " + height + "' xmlns='http://www.w3.org/2000/svg' role='img'\n     aria-label='Docops: Release Strategy' id=\"ID" + id + "\">\n    <title>Docops: Release Strategy</title>\n        "));
    }

    private final String title(String title, int width) {
        return StringsKt.trimIndent((String)("\n        <text x=\"" + width / 2 + "\" y=\"18\" fill=\"#000000\" text-anchor=\"middle\"  font-size=\"18px\">" + title + "</text>\n    "));
    }

    private final String tail() {
        return "</svg>";
    }

    private final String defs(boolean isPdf, String id) {
        String style = "";
        if (!isPdf) {
            style = StringsKt.trimIndent((String)("\n                <style>\n            #ID" + id + " .shadM {\n                fill: #c30213;\n                filter: drop-shadow(0 2mm 1mm #c30213);\n            }\n            #ID" + id + " .shadR {\n                fill: rgb(51, 182, 169);\n                filter: drop-shadow(0 2mm 1mm rgb(51, 182, 169));\n            }\n\n            #ID" + id + " .shadG {\n                fill: rgb(84, 210, 0);\n                filter: drop-shadow(0 2mm 1mm rgb(84, 210, 0));\n            }\n            #ID" + id + " .milestone {\n                font-family: Arial, \"Helvetica Neue\", Helvetica, sans-serif;\n                font-weight: bold;\n            }\n            #ID" + id + " .lines {\n                font-size: 10px;\n            }\n\n            #ID" + id + " .milestone > .entry {\n                text-anchor: start;\n                font-weight: normal;\n            }\n        </style>\n            "));
        }
        return StringsKt.trimIndent((String)("\n             <defs>\n             <filter id=\"Bevel2\" filterUnits=\"objectBoundingBox\" x=\"-10%\" y=\"-10%\" width=\"150%\" height=\"150%\">\n                 <feGaussianBlur in=\"SourceAlpha\" stdDeviation=\"0.5\" result=\"blur\"/>\n                 <feSpecularLighting in=\"blur\" surfaceScale=\"5\" specularConstant=\"0.5\" specularExponent=\"10\" result=\"specOut\" lighting-color=\"white\">\n                     <fePointLight x=\"-5000\" y=\"-10000\" z=\"0000\"/>\n                 </feSpecularLighting>\n                 <feComposite in=\"specOut\" in2=\"SourceAlpha\" operator=\"in\" result=\"specOut2\"/>\n                 <feComposite in=\"SourceGraphic\" in2=\"specOut2\" operator=\"arithmetic\" k1=\"0\" k2=\"1\" k3=\"1\" k4=\"0\" result=\"litPaint\" />\n             </filter>\n             <linearGradient id=\"ID0756d7d2-2648-4a67-89af-c133b3a8d4c9\" x2=\"1\" y2=\"1\">\n                 <stop class=\"stop1\" offset=\"0%\" stop-color=\"#a48bdb\">\n                     <animate attributeName=\"stop-color\"\n                              values=\"#a48bdb;#7651c9;#4918B8;#a48bdb;#7651c9;#4918B8;\" dur=\"20s\" repeatCount=\"indefinite\">\n                     </animate>\n                 </stop>\n                 <stop class=\"stop2\" offset=\"50%\" stop-color=\"#7651c9\">\n                     <animate attributeName=\"stop-color\"\n                              values=\"#a48bdb;#7651c9;#4918B8;#a48bdb;#7651c9;#4918B8;\" dur=\"20s\" repeatCount=\"indefinite\">\n                     </animate>\n                 </stop>\n                 <stop class=\"stop3\" offset=\"100%\" stop-color=\"#4918B8\">\n                     <animate attributeName=\"stop-color\"\n                              values=\"#a48bdb;#7651c9;#4918B8;#a48bdb;#7651c9;#4918B8;\" dur=\"20s\" repeatCount=\"indefinite\">\n                     </animate>\n                 </stop>\n                 <animateTransform attributeName=\"gradientTransform\" type=\"rotate\" values=\"360 .5 .5;0 .5 .5\"\n                                   dur=\"10s\" repeatCount=\"indefinite\" />\n             </linearGradient>\n             " + style + "\n         </defs>\n         "));
    }
}

