/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.support;

import java.awt.Color;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u00042\b\b\u0001\u0010\u0007\u001a\u00020\u0006H\u0017J\u001c\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\fH\u0012J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0012\u00a8\u0006\u0010"}, d2={"Lio/docops/docopsextensionssupport/support/ColorToGradientController;", "", "()V", "colors", "Lorg/springframework/http/ResponseEntity;", "", "", "color", "gradientFromColor", "randomColor", "", "shade", "Ljava/awt/Color;", "tint", "factor", "", "docops-extension-server"})
public class ColorToGradientController {
    @GetMapping(value={"/grad/{color}"})
    @NotNull
    public ResponseEntity<Map<String, String>> colors(@PathVariable(value="color") @NotNull String color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        ResponseEntity responseEntity = ResponseEntity.accepted().body((Object)this.gradientFromColor(color));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"accepted().body(gradientFromColor(color))");
        return responseEntity;
    }

    @NotNull
    public Map<String, String> gradientFromColor(@NotNull String color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Color decoded = Color.decode(color);
        Intrinsics.checkNotNullExpressionValue((Object)decoded, (String)"decoded");
        String tinted1 = this.tint(decoded, 0.5);
        String tinted2 = this.tint(decoded, 0.25);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"color1", (Object)tinted1), TuplesKt.to((Object)"color2", (Object)tinted2), TuplesKt.to((Object)"color3", (Object)color)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private String shade(Color color) {
        double rs = (double)color.getRed() * 0.5;
        double gs = (double)color.getGreen() * 0.5;
        double bs = (double)color.getBlue() * 0.5;
        String string = Integer.toString((int)rs, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
        String string2 = Integer.toString((int)gs, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
        String string3 = Integer.toString((int)bs, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this, checkRadix(radix))");
        return "#" + string + string2 + string3;
    }

    private String tint(Color color, double factor) {
        double rs = (double)color.getRed() + factor * (double)(255 - color.getRed());
        double gs = (double)color.getGreen() + factor * (double)(255 - color.getGreen());
        double bs = (double)color.getBlue() + factor * (double)(255 - color.getBlue());
        String string = Integer.toString((int)rs, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
        String string2 = Integer.toString((int)gs, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
        String string3 = Integer.toString((int)bs, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this, checkRadix(radix))");
        return "#" + string + string2 + string3;
    }

    public void randomColor() {
        int color = (int)(Math.random() * (double)0xFFFFFF) | 0xFF000000;
    }
}

