/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.roadmap;

import io.docops.docopsextensionssupport.roadmap.RoadMapMakerKt;
import io.docops.docopsextensionssupport.roadmap.RoadMapParser;
import io.docops.docopsextensionssupport.roadmap.RoadMapParserKt;
import io.docops.docopsextensionssupport.roadmap.RoadMaps;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J(\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\b\u0010\u000f\u001a\u00020\u0004H\u0002J&\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004J \u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0004H\u0002J\b\u0010\u0015\u001a\u00020\u0004H\u0002\u00a8\u0006\u0016"}, d2={"Lio/docops/docopsextensionssupport/roadmap/RoadMapMaker;", "", "()V", "defs", "", "draw", "roadmaps", "Lio/docops/docopsextensionssupport/roadmap/RoadMaps;", "scale", "title", "numChars", "head", "", "joinXmlLines", "str", "makeNow", "makeRoadMapImage", "source", "row", "index", "", "tail", "docops-extension-server"})
@SourceDebugExtension(value={"SMAP\nRoadMapMaker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoadMapMaker.kt\nio/docops/docopsextensionssupport/roadmap/RoadMapMaker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,288:1\n1855#2,2:289\n*S KotlinDebug\n*F\n+ 1 RoadMapMaker.kt\nio/docops/docopsextensionssupport/roadmap/RoadMapMaker\n*L\n38#1:289,2\n*E\n"})
public final class RoadMapMaker {
    @NotNull
    public final String makeRoadMapImage(@NotNull String source, @NotNull String scale, @NotNull String title, @NotNull String numChars) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)numChars, (String)"numChars");
        RoadMaps roadmaps = new RoadMapParser().parse(source);
        return this.draw(roadmaps, scale, title, numChars);
    }

    private final String draw(RoadMaps roadmaps, String scale, String title, String numChars) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.head(roadmaps, Float.parseFloat(scale)));
        sb.append(this.defs());
        sb.append("<g transform='scale(" + scale + ")'>");
        sb.append("<rect width=\"100%\" height=\"100%\" fill=\"#fbfbfb\"/>");
        sb.append(this.makeNow());
        int n = RoadMapParserKt.maxLength((RoadMaps)roadmaps);
        int n2 = 0;
        while (n2 < n) {
            int index = n2++;
            boolean bl = false;
            sb.append(this.row(index, roadmaps, numChars));
        }
        sb.append(StringsKt.trimIndent((String)("\n        <text x=\"105\" y=\"100\" class=\"now\">NOW</text>\n        <text x=\"304.5\" y=\"100\" class=\"next\" text-anchor=\"middle\">NEXT</text>\n        <text x=\"504.5\" y=\"100\" class=\"later\" text-anchor=\"middle\">LATER</text>\n         <rect x=\"0\" y=\"0\" stroke-width=\"0\" fill=\"url(#headerSix)\"  height=\"80\" width=\"100%\" opacity=\"0.4\"/>\n        <text x=\"306\" y=\"60\" font-family=\" Arial, Helvetica, sans-serif\" font-size=\"46\" class=\"glass\" fill=\"#45618E\" text-anchor=\"middle\">" + title + "</text>\n        ")));
        sb.append("</g>");
        sb.append(this.tail());
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return this.joinXmlLines(string);
    }

    private final String joinXmlLines(String str) {
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEach$iv = StringsKt.lines((CharSequence)str);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            sb.append(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String head(RoadMaps roadmaps, float scale) {
        float width = (float)612 * scale;
        float height = (float)(RoadMapParserKt.maxLength((RoadMaps)roadmaps) * 105 + 106) * scale;
        return "<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"" + width + "\" height=\"" + height + "\" viewBox=\"0 0 " + width + " " + height + "\">";
    }

    private final String row(int index, RoadMaps roadmaps, String numChars) {
        String spans;
        List lines;
        Object text;
        StringBuilder sb = new StringBuilder("<g transform=\"translate(26," + 105 * (index + 1) + ")\">");
        String now = "<rect x=\"0\" y=\"0\" fill=\"#fcfcfc\" class=\"nowBox\" height=\"100\" width=\"184\"/>";
        String next = "<rect x=\"190\" y=\"0\" fill=\"#fcfcfc\" class=\"nextBox\" height=\"100\" width=\"184\"/>";
        String later = "<rect x=\"380\" y=\"0\" fill=\"#fcfcfc\" class=\"laterBox\" height=\"100\" width=\"184\"/>";
        if (roadmaps.getNow().size() - 1 >= index) {
            sb.append(now);
            text = "<text x=\"2\" y=\"2\" class=\"primaryRoad\" fill=\"#421A56\">";
            lines = RoadMapMakerKt.linesToUrlIfExist((List)RoadMapMakerKt.wrapText((String)CollectionsKt.joinToString$default((Iterable)((Iterable)roadmaps.getNow().get(index)), (CharSequence)"", null, null, (int)0, null, null, (int)62, null), (float)Float.parseFloat(numChars)), (Map)roadmaps.getUrlMap());
            spans = RoadMapMakerKt.linesToMultiLineText((List)lines, (int)12, (int)2);
            text = (String)text + spans;
            text = (String)text + "</text>";
            sb.append((String)text);
        }
        if (roadmaps.getNext().size() - 1 >= index) {
            sb.append(next);
            text = "<text x=\"192\" y=\"2\" class=\"secondaryRoad\">";
            lines = RoadMapMakerKt.linesToUrlIfExist((List)RoadMapMakerKt.wrapText((String)CollectionsKt.joinToString$default((Iterable)((Iterable)roadmaps.getNext().get(index)), (CharSequence)"", null, null, (int)0, null, null, (int)62, null), (float)Float.parseFloat(numChars)), (Map)roadmaps.getUrlMap());
            spans = RoadMapMakerKt.linesToMultiLineText((List)lines, (int)12, (int)192);
            text = (String)text + spans;
            text = (String)text + "</text>";
            sb.append((String)text);
        }
        if (roadmaps.getLater().size() - 1 >= index) {
            sb.append(later);
            text = "<text x=\"382\" y=\"2\" class=\"tertiaryRoad\">";
            lines = RoadMapMakerKt.linesToUrlIfExist((List)RoadMapMakerKt.wrapText((String)CollectionsKt.joinToString$default((Iterable)((Iterable)roadmaps.getLater().get(index)), (CharSequence)"", null, null, (int)0, null, null, (int)62, null), (float)Float.parseFloat(numChars)), (Map)roadmaps.getUrlMap());
            spans = RoadMapMakerKt.linesToMultiLineText((List)lines, (int)12, (int)382);
            text = (String)text + spans;
            text = (String)text + "</text>";
            sb.append((String)text);
        }
        sb.append("</g>");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String makeNow() {
        return "";
    }

    private final String tail() {
        return "</svg>";
    }

    private final String defs() {
        return "    <defs>\n    <linearGradient id=\"headerTitleBar\" x2=\"0%\" y2=\"100%\">\n        <stop class=\"stop1\" offset=\"0%\" stop-color=\"#f8d8c4\"/>\n        <stop class=\"stop2\" offset=\"50%\" stop-color=\"#f5c5a7\"/>\n        <stop class=\"stop3\" offset=\"100%\" stop-color=\"#f2b28a\"/>\n    </linearGradient>\n    <linearGradient id=\"headerSix\" x2=\"0%\" y2=\"100%\">\n        <stop class=\"stop1\" offset=\"0%\" stop-color=\"#e5c6fc\"/>\n        <stop class=\"stop2\" offset=\"50%\" stop-color=\"#d8aafb\"/>\n        <stop class=\"stop3\" offset=\"100%\" stop-color=\"#cc8efa\"/>\n    </linearGradient>\n    <linearGradient id=\"headerSeven\" x2=\"0%\" y2=\"100%\">\n        <stop class=\"stop1\" offset=\"0%\" stop-color=\"#ffe5f9\"/>\n        <stop class=\"stop2\" offset=\"50%\" stop-color=\"#ffd8f6\"/>\n        <stop class=\"stop3\" offset=\"100%\" stop-color=\"#ffccf4\"/>\n    </linearGradient>\n    <filter id=\"Bevel2\" filterUnits=\"objectBoundingBox\" x=\"-10%\" y=\"-10%\" width=\"150%\" height=\"150%\">\n        <feGaussianBlur in=\"SourceAlpha\" stdDeviation=\"0.5\" result=\"blur\"/>\n        <feSpecularLighting in=\"blur\" surfaceScale=\"5\" specularConstant=\"0.5\" specularExponent=\"10\" result=\"specOut\" lighting-color=\"white\">\n            <fePointLight x=\"-5000\" y=\"-10000\" z=\"0000\"/>\n        </feSpecularLighting>\n        <feComposite in=\"specOut\" in2=\"SourceAlpha\" operator=\"in\" result=\"specOut2\"/>\n        <feComposite in=\"SourceGraphic\" in2=\"specOut2\" operator=\"arithmetic\" k1=\"0\" k2=\"1\" k3=\"1\" k4=\"0\" result=\"litPaint\" />\n    </filter>\n\n    <style>\n    .now { fill: #45a98f; font-family: Arial, Helvetica, sans-serif; stroke: #45a98f; text-anchor: middle; font-weight: bold; }\n    .nowBox { fill: none; font-family: Arial, Helvetica, sans-serif; stroke: #45a98f; }\n    .next { fill: #e0349c; font-family: Arial, Helvetica, sans-serif; stroke: #e0349c; text-anchor: middle; font-weight: bold; }\n    .nextBox { fill: none; font-family: Arial, Helvetica, sans-serif; stroke: #e0349c; text-anchor: middle; font-weight: bold; }\n    .later { fill: #e56516; font-family: Arial, Helvetica, sans-serif; stroke: #e56516; text-anchor: middle; font-weight: bold; }\n    .laterBox { fill: none; font-family: Arial, Helvetica, sans-serif; stroke: #e56516; text-anchor: middle; font-weight: bold; }\n    .primaryRoad { font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #45a98f; }\n    .secondaryRoad{ font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #e0349c; }\n    .tertiaryRoad { font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #e56516; }\n    .rmLink { fill: blue; text-decoration: underline; }\n    .glass:after, .glass:before {\n    content: \"\";\n    display: block;\n    position: absolute\n}\n\n.glass {\n    overflow: hidden;\n    color: #fff;\n    text-shadow: 0 1px 2px rgba(0, 0, 0, .7);\n    background-image: radial-gradient(circle at center, rgba(0, 167, 225, .25), rgba(0, 110, 149, .5));\n    box-shadow: 0 5px 10px rgba(0, 0, 0, .75), inset 0 0 0 2px rgba(0, 0, 0, .3), inset 0 -6px 6px -3px rgba(0, 129, 174, .2);\n    position: relative\n}\n\n.glass:after {\n    background: rgba(0, 167, 225, .2);\n    z-index: 0;\n    height: 100%;\n    width: 100%;\n    top: 0;\n    left: 0;\n    backdrop-filter: blur(3px) saturate(400%);\n    -webkit-backdrop-filter: blur(3px) saturate(400%)\n}\n\n.glass:before {\n    width: calc(100% - 4px);\n    height: 35px;\n    background-image: linear-gradient(rgba(255, 255, 255, .7), rgba(255, 255, 255, 0));\n    top: 2px;\n    left: 2px;\n    border-radius: 30px 30px 200px 200px;\n    opacity: .7\n}\n\n.glass:hover {\n    text-shadow: 0 1px 2px rgba(0, 0, 0, .9)\n}\n\n.glass:hover:before {\n    opacity: 1\n}\n\n.glass:active {\n    text-shadow: 0 0 2px rgba(0, 0, 0, .9);\n    box-shadow: 0 3px 8px rgba(0, 0, 0, .75), inset 0 0 0 2px rgba(0, 0, 0, .3), inset 0 -6px 6px -3px rgba(0, 129, 174, .2)\n}\n\n.glass:active:before {\n    height: 25px\n}\n</style>\n</defs>";
    }
}

