/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.timeline;

import io.docops.docopsextensionssupport.badge.BadgeControllerKt;
import io.docops.docopsextensionssupport.svgsupport.SvgToPng;
import io.docops.docopsextensionssupport.timeline.Entry;
import io.docops.docopsextensionssupport.timeline.TimelineMaker;
import io.docops.docopsextensionssupport.timeline.TimelineParser;
import io.docops.docopsextensionssupport.web.panel.PanelGeneratorKt;
import io.micrometer.core.annotation.Timed;
import io.micrometer.observation.annotation.Observed;
import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/timeline"})
@Observed(name="timeline.controller")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0001\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\u00072\b\b\u0001\u0010\t\u001a\u00020\u00072\b\b\u0001\u0010\n\u001a\u00020\u00072\b\b\u0001\u0010\u000b\u001a\u00020\u0007H\u0017J\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0001\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\u0007H\u0017J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0017\u00a8\u0006\u0010"}, d2={"Lio/docops/docopsextensionssupport/timeline/TimelineController;", "", "()V", "getTimeLine", "Lorg/springframework/http/ResponseEntity;", "", "payload", "", "title", "scale", "type", "numChars", "getTimeLineTable", "putTimeline", "httpServletRequest", "Ljakarta/servlet/http/HttpServletRequest;", "docops-extension-server"})
@SourceDebugExtension(value={"SMAP\nTimelineController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimelineController.kt\nio/docops/docopsextensionssupport/timeline/TimelineController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1855#2,2:98\n*S KotlinDebug\n*F\n+ 1 TimelineController.kt\nio/docops/docopsextensionssupport/timeline/TimelineController\n*L\n88#1:98,2\n*E\n"})
public class TimelineController {
    @PutMapping(value={"/"})
    @ResponseBody
    @Timed(value="docops.timeline.put.html", percentiles={0.5, 0.95}, histogram=true)
    @NotNull
    public ResponseEntity<byte[]> putTimeline(@NotNull HttpServletRequest httpServletRequest) {
        String numChars;
        Intrinsics.checkNotNullParameter((Object)httpServletRequest, (String)"httpServletRequest");
        String title = "title";
        String contents = httpServletRequest.getParameter("content");
        CharSequence charSequence = contents;
        if (charSequence == null || charSequence.length() == 0) {
            contents = StreamUtils.copyToString((InputStream)((InputStream)httpServletRequest.getInputStream()), (Charset)Charset.defaultCharset());
            String string = httpServletRequest.getParameter("title");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParameter(...)");
            title = string;
        }
        String scale = httpServletRequest.getParameter("scale");
        String chars = numChars = httpServletRequest.getParameter("numChars");
        if (numChars == null || ((CharSequence)numChars).length() == 0) {
            chars = "32";
        }
        TimelineMaker tm = new TimelineMaker();
        String string = contents;
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        Intrinsics.checkNotNull((Object)scale);
        string = chars;
        Intrinsics.checkNotNull((Object)string);
        String svg = tm.makeTimelineSvg(string2, title, scale, false, string);
        HttpHeaders headers = new HttpHeaders();
        headers.setCacheControl(CacheControl.noCache().getHeaderValue());
        headers.setContentType(MediaType.parseMediaType((String)"image/svg+xml"));
        String string3 = svg;
        byte[] byArray = string3.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return new ResponseEntity((Object)byArray, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/"})
    @ResponseBody
    @Timed(value="docops.roadmap.get.html", percentiles={0.5, 0.95}, histogram=true)
    @NotNull
    public ResponseEntity<byte[]> getTimeLine(@RequestParam(name="payload") @NotNull String payload, @RequestParam(name="title") @NotNull String title, @RequestParam(name="scale") @NotNull String scale, @RequestParam(value="type", required=false, defaultValue="SVG") @NotNull String type, @RequestParam(value="numChars", required=false, defaultValue="35") @NotNull String numChars) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)numChars, (String)"numChars");
        String string = URLDecoder.decode(payload, "UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
        String data = PanelGeneratorKt.uncompressString((String)string);
        TimelineMaker tm = new TimelineMaker();
        boolean isPdf = Intrinsics.areEqual((Object)"PDF", (Object)type);
        String svg = tm.makeTimelineSvg(data, title, scale, isPdf, numChars);
        if (isPdf) {
            HttpHeaders headers = new HttpHeaders();
            headers.setCacheControl(CacheControl.noCache().getHeaderValue());
            headers.setContentType(MediaType.IMAGE_PNG);
            Pair res = BadgeControllerKt.findHeightWidth((String)svg);
            byte[] baos = new SvgToPng().toPngFromSvg(svg, res);
            responseEntity = new ResponseEntity((Object)baos, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        } else {
            HttpHeaders headers = new HttpHeaders();
            headers.setCacheControl(CacheControl.noCache().getHeaderValue());
            headers.setContentType(MediaType.parseMediaType((String)"image/svg+xml"));
            String string2 = svg;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            responseEntity = new ResponseEntity((Object)byArray, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        return responseEntity;
    }

    @GetMapping(value={"/table"})
    @ResponseBody
    @Timed(value="docops.roadmap.table.data.html", percentiles={0.5, 0.95}, histogram=true)
    @NotNull
    public ResponseEntity<byte[]> getTimeLineTable(@RequestParam(name="payload") @NotNull String payload, @RequestParam(name="title") @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        String string = URLDecoder.decode(payload, "UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
        String data = PanelGeneratorKt.uncompressString((String)string);
        TimelineParser tm = new TimelineParser();
        List entries = tm.parse(data);
        StringBuilder sb = new StringBuilder("." + title + "\n");
        sb.append("[%header,cols=\"1,2\",stripes=even]\n");
        sb.append("!===\n");
        sb.append("|Date |Event\n");
        Iterable $this$forEach$iv = entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entry it = (Entry)element$iv;
            boolean bl = false;
            sb.append("a|" + it.getDate() + " |" + it.getText() + "\n");
        }
        sb.append("!===");
        HttpHeaders headers = new HttpHeaders();
        headers.setCacheControl(CacheControl.noCache().getHeaderValue());
        headers.setContentType(MediaType.TEXT_PLAIN);
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String string3 = string2;
        byte[] byArray = string3.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return new ResponseEntity((Object)byArray, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }
}

