/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.timeline;

import io.docops.asciidoc.utils.StringFunctionsKt;
import io.docops.docopsextensionssupport.support.ColorUtilKt;
import io.docops.docopsextensionssupport.timeline.Entry;
import io.docops.docopsextensionssupport.timeline.EntryKt;
import io.docops.docopsextensionssupport.timeline.TimelineMaker;
import io.docops.docopsextensionssupport.timeline.TimelineParser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J6\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J*\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J(\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J.\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0004J(\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\b\u0010\u001b\u001a\u00020\u0004H\u0002\u00a8\u0006\u001d"}, d2={"Lio/docops/docopsextensionssupport/timeline/TimelineMaker;", "", "()V", "buildRoad", "", "width", "", "defs", "Lkotlin/Pair;", "", "entries", "", "Lio/docops/docopsextensionssupport/timeline/Entry;", "isPdf", "", "even", "index", "entry", "color", "chars", "head", "scale", "makeEntry", "makeTimelineSvg", "source", "title", "odd", "tail", "Companion", "docops-extension-server"})
@SourceDebugExtension(value={"SMAP\nTimelineMaker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimelineMaker.kt\nio/docops/docopsextensionssupport/timeline/TimelineMaker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n1864#2,3:258\n1864#2,3:261\n1864#2,3:264\n*S KotlinDebug\n*F\n+ 1 TimelineMaker.kt\nio/docops/docopsextensionssupport/timeline/TimelineMaker\n*L\n36#1:258,3\n127#1:261,3\n144#1:264,3\n*E\n"})
public final class TimelineMaker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> DEFAULT_COLORS;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String makeTimelineSvg(@NotNull String source, @NotNull String title, @NotNull String scale, boolean isPdf, @NotNull String chars) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        List entries = new TimelineParser().parse(source);
        StringBuilder sb = new StringBuilder();
        Pair head = this.head(entries, scale);
        sb.append((String)head.getFirst());
        Pair defs = this.defs(entries, isPdf);
        Map colors = (Map)defs.getSecond();
        sb.append((String)defs.getFirst());
        sb.append("<g transform=\"scale(" + scale + ")\">");
        sb.append("<text x=\"460\" y=\"24\" text-anchor=\"middle\" style=\"font-size: 24px;font-family: Arial, sans-serif;\" class=\"edge\">" + StringFunctionsKt.escapeXml((String)title) + "</text>");
        sb.append("<g transform=\"translate(0,24)\">");
        sb.append(this.buildRoad(((Number)head.getSecond()).intValue() - 100));
        Iterable $this$forEachIndexed$iv = entries;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void entry;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Entry entry2 = (Entry)item$iv;
            int index = n;
            boolean bl = false;
            Object v = colors.get(index);
            Intrinsics.checkNotNull(v);
            String color = (String)v;
            sb.append(this.makeEntry(index, (Entry)entry, color, chars));
        }
        sb.append("</g>");
        sb.append("</g>");
        sb.append(this.tail());
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String makeEntry(int index, Entry entry, String color, String chars) {
        return index % 2 == 0 ? this.odd(index, entry, color, chars) : this.even(index, entry, color, chars);
    }

    private final String odd(int index, Entry entry, String color, String chars) {
        int x = 80;
        if (index > 0) {
            x = 140 * index + 80;
        }
        String text = EntryKt.toTextWithSpan((Entry)entry, (float)Float.parseFloat(chars), (int)-68, (int)42, (String)"odd");
        return StringsKt.trimIndent((String)("\n      <g transform=\"translate(" + x + ",200)\" class=\"odd\">\n        <circle cx=\"0\" cy=\"0\" r=\"20\" fill=\"#fcfcfc\" class=\"cricleedge\"/>\n        <circle cx=\"0\" cy=\"0\" r=\"17\" fill=\"url(#grad" + index + ")\" class=\"cricleedge\"/>\n        <line x1=\"0\" x2=\"0\" y1=\"-20\" y2=\"-80\" stroke=\"" + color + "\" stroke-width=\"2\"/>\n        <circle cx=\"0\" cy=\"-80\" r=\"3\" fill=\"" + color + "\" />\n        <text x=\"-36\" y=\"-86\" font-size=\"10px\" fill='#000000'>" + entry.getDate() + "</text>\n        <rect x=\"-70\" y=\"30\" width=\"170\" height=\"150\" class=\"edge\" fill=\"url(#headerTimeline" + index + ")\" stroke=\"" + color + "\" stroke-width=\"2\"  rx=\"5\"/>\n        " + text + "\n        <rect id=\"button\" x=\"-71\" y=\"21\" width=\"40\" height=\"20\" ry=\"5\" rx=\"5\" filter=\"url(#buttonBlur)\" fill=\"" + color + "\" class=\"edge\"/>\n\n        <rect id=\"buttongrad\" x=\"-71\" y=\"21\" width=\"40\" height=\"20\" ry=\"5\" rx=\"5\" fill=\"url(#overlayGrad)\"/>\n        <text id=\"label\" x=\"-51.5\" y=\"35\" text-anchor=\"middle\" font-size=\"14px\" fill=\"#fcfcfc\">" + entry.getIndex() + "</text>\n\n        <rect id=\"buttontop\" x=\"-69\" y=\"22\" width=\"36\" height=\"5\" ry=\"5\" rx=\"5\" fill=\"url(#topshineGrad)\"\n              filter=\"url(#topshineBlur)\"/>\n        <rect id=\"buttonbottom\" x=\"-69\" y=\"35\" width=\"36\" height=\"3\" fill=\"#ffffff\" ry=\"5\" rx=\"5\"\n              fill-opacity=\"0.3\" filter=\"url(#bottomshine)\"/>\n    </g>\n    \n        "));
    }

    private final String even(int index, Entry entry, String color, String chars) {
        int x = 80;
        if (index > 0) {
            x = 140 * index + 80;
        }
        String text = EntryKt.toTextWithSpan((Entry)entry, (float)Float.parseFloat(chars), (int)-68, (int)-168, (String)"even");
        return StringsKt.trimIndent((String)("\n        <g transform=\"translate(" + x + ",200)\" class=\"even\">\n        <circle cx=\"0\" cy=\"0\" r=\"20\" fill=\"#fcfcfc\" class=\"cricleedge\"/>\n        <circle cx=\"0\" cy=\"0\" r=\"17\" fill=\"url(#grad" + index + ")\" class=\"cricleedge\"/>\n        <line x1=\"0\" x2=\"0\" y1=\"20\" y2=\"80\" stroke=\"" + color + "\" stroke-width=\"2\"/>\n        <circle cx=\"0\" cy=\"80\" r=\"3\" fill=\"" + color + "\" />\n        <text x=\"-30\" y=\"96\" font-size=\"10px\" fill='#000000'>" + entry.getDate() + "</text>\n        <rect x=\"-70\" y=\"-180\" width=\"170\" height=\"150\" class=\"edge\" fill=\"url(#headerTimeline" + index + ")\" stroke=\"" + color + "\" stroke-width=\"2\"  rx='5'/>\n        " + text + "\n        <rect id=\"button\" x=\"-71\" y=\"-189\" width=\"40\" height=\"20\" ry=\"5\" rx=\"5\" filter=\"url(#buttonBlur)\" fill=\"" + color + "\" class=\"edge\"/>\n\n        <rect id=\"buttongrad\" x=\"-71\" y=\"-189\" width=\"40\" height=\"20\" ry=\"5\" rx=\"5\" fill=\"url(#overlayGrad)\"/>\n        <text id=\"label\" x=\"-51.5\" y=\"-175\" text-anchor=\"middle\" font-size=\"14px\" fill=\"#fcfcfc\">" + entry.getIndex() + "</text>\n\n        <rect id=\"buttontop\" x=\"-69\" y=\"-188\" width=\"36\" height=\"5\" ry=\"5\" rx=\"5\" fill=\"url(#topshineGrad)\"\n              filter=\"url(#topshineBlur)\"/>\n        <rect id=\"buttonbottom\" x=\"-69\" y=\"-175\" width=\"36\" height=\"3\" fill=\"#ffffff\" ry=\"5\" rx=\"5\"\n              fill-opacity=\"0.3\" filter=\"url(#bottomshine)\"/>\n        \n    </g>\n    \n        "));
    }

    private final String buildRoad(int width) {
        return StringsKt.trimIndent((String)("\n    <g transform=\"translate(30,200)\">\n        <path d=\"M0,0 h" + width + "\" stroke=\"#aaaaaa\" stroke-width=\"28\"/>\n        <line x1=\"10\" y1=\"0\" x2=\"" + (width - 10) + "\" y2=\"0\" stroke=\"#fcfcfc\"\n        stroke-width=\"10\" fill=\"#ffffff\" stroke-dasharray=\"24 24 24\" marker-end=\"url(#triangle)\"/>\n    </g>\n    \n        "));
    }

    private final Pair<String, Integer> head(List<Entry> entries, String scale) {
        int width = 0;
        Iterable $this$forEachIndexed$iv = entries;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Entry entry = (Entry)item$iv;
            int index = n;
            boolean bl = false;
            width = 140 * index + 80;
        }
        float scaleF = Float.parseFloat(scale);
        float height = (float)424 * Float.parseFloat(scale);
        return new Pair((Object)StringsKt.trimIndent((String)("\n        <svg width=\"" + (float)(width += 140) * scaleF + "\" height=\"" + height + "\" viewBox=\"0 0 " + (float)width * scaleF + " " + height + "\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n        <desc>https://docops.io/extension</desc>\n    ")), (Object)width);
    }

    private final String tail() {
        return "</svg>";
    }

    private final Pair<String, Map<Integer, String>> defs(List<Entry> entries, boolean isPdf) {
        Map colors = new LinkedHashMap();
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEachIndexed$iv = entries;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Entry entry = (Entry)item$iv;
            int index = n;
            boolean bl = false;
            String color = ColorUtilKt.getRandomColorHex();
            Integer n2 = index;
            colors.put(n2, color);
            Map colorMap = ColorUtilKt.gradientFromColor((String)color);
            sb.append(StringsKt.trimIndent((String)("\n         <radialGradient id=\"grad" + index + "\" cx=\"50%\" cy=\"50%\" r=\"50%\" fx=\"50%\" fy=\"20%\">\n            <stop offset=\"30%\" style=\"stop-color:" + colorMap.get("color1") + "; stop-opacity:1\" />\n            <stop offset=\"60%\" style=\"stop-color:" + color + "; stop-opacity:1\" />\n        </radialGradient>\n        <linearGradient id=\"headerTimeline" + index + "\" x2=\"0%\" y2=\"100%\">\n            <stop class=\"stop1\" offset=\"0%\" stop-color=\"" + colorMap.get("color1") + "\"/>\n            <stop class=\"stop2\" offset=\"50%\" stop-color=\"" + colorMap.get("color2") + "\"/>\n            <stop class=\"stop3\" offset=\"100%\" stop-color=\"" + colorMap.get("color3") + "\"/>\n        </linearGradient>\n            ")));
        }
        String style = "<style>\n    .edge { filter: drop-shadow(0 2mm 2mm #66557c); }\n    .cricleedge { filter: drop-shadow(0 2mm 2mm #a899bd); }\n    .odd { font-size:10px; font-family: Arial, sans-serif; fill: #fcfcfc;}\n    .even { font-size:10px; font-family: Arial, sans-serif; fill: #fcfcfc;}\n    .rmLink { fill: blue; text-decoration: underline; }\n</style>";
        if (isPdf) {
            style = "";
        }
        return new Pair((Object)StringsKt.trimIndent((String)("\n        <defs>\n        <filter id=\"buttonBlur\">\n            <feGaussianBlur in=\"SourceAlpha\" stdDeviation=\"2\" result=\"blur\"/>\n            <feOffset in=\"blur\" dy=\"2\" result=\"offsetBlur\"/>\n            <feMerge>\n                <feMergeNode in=\"offsetBlur\"/>\n                <feMergeNode in=\"SourceGraphic\"/>\n            </feMerge>\n        </filter>\n\n        <linearGradient id=\"overlayGrad\" gradientUnits=\"userSpaceOnUse\" x1=\"95\" y1=\"-20\" x2=\"95\" y2=\"70\">\n            <stop offset=\"0\" stop-color=\"#000000\" stop-opacity=\"0.5\"/>\n            <stop offset=\"1\" stop-color=\"#000000\" stop-opacity=\"0\"/>\n        </linearGradient>\n\n        <filter id=\"topshineBlur\">\n            <feGaussianBlur stdDeviation=\"0.93\"/>\n        </filter>\n\n        <linearGradient id=\"topshineGrad\" gradientUnits=\"userSpaceOnUse\" x1=\"95\" y1=\"0\" x2=\"95\" y2=\"40\">\n            <stop offset=\"0\" stop-color=\"#ffffff\" stop-opacity=\"1\"/>\n            <stop offset=\"1\" stop-color=\"#ffffff\" stop-opacity=\"0\"/>\n        </linearGradient>\n\n        <filter id=\"bottomshine\">\n            <feGaussianBlur stdDeviation=\"0.95\"/>\n        </filter>\n        <marker\n                id=\"triangle\"\n                viewBox=\"0 0 10 10\"\n                refX=\"1\"\n                refY=\"5\"\n                markerUnits=\"strokeWidth\"\n                markerWidth=\"5\"\n                markerHeight=\"5\"\n                orient=\"auto\">\n            <path d=\"M 0 0 L 10 5 L 0 10 z\" fill=\"#aaaaaa\" />\n         </marker>   \n        " + sb + "\n        " + style + "\n    </defs>\n    \n    ")), (Object)colors);
    }

    public static final /* synthetic */ List access$getDEFAULT_COLORS$cp() {
        return DEFAULT_COLORS;
    }

    static {
        Object[] objectArray = new String[]{"#45618E", "#A43B3B", "#FFD373", "#F7E67A", "#01FF90", "#FF6F36", "#EAA213", "#FFAF10", "#FF7F00", "#6D4F98"};
        DEFAULT_COLORS = CollectionsKt.mutableListOf((Object[])objectArray);
    }
}

