/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.web;

import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.core.DiagramDescription;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"}, produces={"image/svg+xml"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0012J\u001a\u0010\t\u001a\u00020\u00042\b\b\u0001\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0012J\u001e\u0010\r\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\u000f"}, d2={"Lio/docops/docopsextensionssupport/web/StatsJsonToImageController;", "", "()V", "extracted", "", "svg", "", "servletResponse", "Ljakarta/servlet/http/HttpServletResponse;", "getImage", "payload", "mageImage", "httpEntity", "makeImage", "Lorg/springframework/http/HttpEntity;", "docops-extension-server"})
public class StatsJsonToImageController {
    @PostMapping(value={"jsonToSvg"}, consumes={"application/json", "application/x-www-form-urlencoded"}, produces={"text/html"})
    public void makeImage(@NotNull HttpEntity<String> httpEntity, @NotNull HttpServletResponse servletResponse) {
        Intrinsics.checkNotNullParameter(httpEntity, (String)"httpEntity");
        Intrinsics.checkNotNullParameter((Object)servletResponse, (String)"servletResponse");
        Object object = httpEntity.getBody();
        Intrinsics.checkNotNull((Object)object);
        String svg = this.mageImage((String)object);
        this.extracted(svg, servletResponse);
    }

    private void extracted(String svg, HttpServletResponse servletResponse) {
        String resp = StringsKt.trimIndent((String)("\n                <div id='imageblock'>\n                " + svg + "      \n                </div>\n            "));
        servletResponse.setContentType("text/html");
        servletResponse.setCharacterEncoding("UTF-8");
        servletResponse.setStatus(200);
        PrintWriter writer = servletResponse.getWriter();
        writer.print(resp);
        writer.flush();
    }

    @GetMapping(value={"jsonToSvg"})
    public void getImage(@RequestParam(value="payload") @NotNull String payload, @NotNull HttpServletResponse servletResponse) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)servletResponse, (String)"servletResponse");
        String string = URLDecoder.decode(payload, Charset.defaultCharset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
        String svg = this.mageImage(string);
        this.extracted(svg, servletResponse);
    }

    private String mageImage(String httpEntity) {
        String source = StringsKt.trimIndent((String)("@startjson\n    <style>\n    jsonDiagram {\n        node {\n        BackgroundColor #FFFFFF\n        LineColor #12B3DB\n        FontColor #0070AD\n        FontName Helvetica\n        FontSize 12\n        FontStyle normal\n        RoundCorner 5\n        LineThickness 1\n        \n        separator {\n          LineThickness 0.5\n          LineColor black\n        }\n      }\n      arrow {\n        BackGroundColor lightblue\n        LineColor green\n        LineThickness 2\n      }\n      highlight {\n        BackGroundColor red\n        FontColor white\n        FontStyle italic\n      }\n    }\n    </style>\n            " + httpEntity + "\n@endjson"));
        SourceStringReader reader = new SourceStringReader(source);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DiagramDescription desc = reader.outputImage((OutputStream)os, new FileFormatOption(FileFormat.SVG));
        os.close();
        byte[] byArray = os.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        byte[] byArray2 = byArray;
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        Charset charset2 = charset;
        return new String(byArray2, charset2);
    }
}

