/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.web.panel;

import io.docops.asciidoc.buttons.models.Button;
import io.docops.asciidoc.buttons.theme.Theme;
import io.micrometer.core.annotation.Timed;
import io.micrometer.observation.annotation.Observed;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Observed(name="panel.twoToneImageBuilderController")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J8\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017\u00a8\u0006\u0019"}, d2={"Lio/docops/docopsextensionssupport/web/panel/TwoToneImageBuilderController;", "", "()V", "generateRectPathData", "", "width", "", "height", "topLetRound", "topRightRound", "bottomRightRound", "bottomLeftRound", "makeImage", "fillColor1", "fillColor2", "text1", "text2", "line1Size", "line2Size", "panelImageTone", "", "httpServletRequest", "Ljakarta/servlet/http/HttpServletRequest;", "servletResponse", "Ljakarta/servlet/http/HttpServletResponse;", "docops-extension-server"})
public class TwoToneImageBuilderController {
    @PutMapping(value={"/panelimagetone"})
    @ResponseBody
    @Timed(value="docops.panel.image.tone", percentiles={0.5, 0.95}, histogram=true)
    public void panelImageTone(@NotNull HttpServletRequest httpServletRequest, @NotNull HttpServletResponse servletResponse) {
        Intrinsics.checkNotNullParameter((Object)httpServletRequest, (String)"httpServletRequest");
        Intrinsics.checkNotNullParameter((Object)servletResponse, (String)"servletResponse");
        Map params = httpServletRequest.getParameterMap();
        String[] stringArray = (String[])params.get("fillColor1");
        String string = stringArray != null ? stringArray[0] : null;
        Intrinsics.checkNotNull((Object)string);
        String fillColor1 = string;
        String[] stringArray2 = (String[])params.get("fillColor2");
        String string2 = stringArray2 != null ? stringArray2[0] : null;
        Intrinsics.checkNotNull((Object)string2);
        String fillColor2 = string2;
        String[] stringArray3 = (String[])params.get("line1");
        String string3 = stringArray3 != null ? stringArray3[0] : null;
        Intrinsics.checkNotNull((Object)string3);
        String line1 = string3;
        String[] stringArray4 = (String[])params.get("line2");
        String string4 = stringArray4 != null ? stringArray4[0] : null;
        Intrinsics.checkNotNull((Object)string4);
        String line2 = string4;
        String[] stringArray5 = (String[])params.get("line1Size");
        String string5 = stringArray5 != null ? stringArray5[0] : null;
        Intrinsics.checkNotNull((Object)string5);
        String line1Size = string5;
        String[] stringArray6 = (String[])params.get("line2Size");
        String string6 = stringArray6 != null ? stringArray6[0] : null;
        Intrinsics.checkNotNull((Object)string6);
        String line2Size = string6;
        String contents = this.makeImage(fillColor1, fillColor2, line1, line2, line1Size, line2Size);
        servletResponse.setContentType("image/svg+xml");
        servletResponse.setCharacterEncoding("UTF-8");
        servletResponse.setStatus(200);
        PrintWriter writer = servletResponse.getWriter();
        writer.print(contents);
        writer.flush();
    }

    @NotNull
    public String makeImage(@NotNull String fillColor1, @NotNull String fillColor2, @NotNull String text1, @NotNull String text2, @NotNull String line1Size, @NotNull String line2Size) {
        Intrinsics.checkNotNullParameter((Object)fillColor1, (String)"fillColor1");
        Intrinsics.checkNotNullParameter((Object)fillColor2, (String)"fillColor2");
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)line1Size, (String)"line1Size");
        Intrinsics.checkNotNullParameter((Object)line2Size, (String)"line2Size");
        Button btn1 = new Button("", "", "", (List)new ArrayList(), "", "", null, fillColor1, null, null, null, null, null, null, false, null, null, null, 261888, null);
        Button btn2 = new Button("", "", "", (List)new ArrayList(), "", "", null, fillColor2, null, null, null, null, null, null, false, null, null, null, 261888, null);
        Theme theme = new Theme();
        String color1 = theme.buildGradientStyle(btn1);
        String color2 = theme.buildGradientStyle(btn2);
        String def1 = theme.buildGradientDef(btn1);
        String def2 = theme.buildGradientDef(btn2);
        return StringsKt.trimIndent((String)("\n            <?xml version=\"1.0\" encoding=\"UTF-8\"?>\n            <svg id=\"" + theme.getId() + "\" width=\"300px\" height=\"191px\" viewBox=\"0 0 300 191\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n                <title>ICON</title>\n                <defs>\n                " + def1 + "\n                                    \n                " + def2 + "\n                </defs>\n                <style>\n                    .twotone:hover {\n                        fill: red;\n                    }\n                    .oddstyle {\n                        font: bold " + line1Size + "px Arial, Helvetica, sans-serif;\n                        fill: " + fillColor2 + ";\n                    }\n                    .evenstyle {\n                        font: bold " + line2Size + "px Arial, Helvetica, sans-serif;\n                        fill: " + fillColor1 + ";\n                    }\n                    \n                    " + color1 + "\n                    \n                    " + color2 + "\n                    \n                </style>\n                <g id=\"Page-1\" stroke=\"none\" stroke-width=\"1\" fill=\"#FFFFFF\" fill-rule=\"evenodd\" class='twotone'>\n                    <path d=\"" + this.generateRectPathData((float)300, 191.0f, 22.0f, 22.0f, 0.0f, 0.0f) + "\" fill=\"none\"/>\n                    <path d=\"" + this.generateRectPathData((float)300, (float)(191 / 2), 22.0f, 22.0f, 0.0f, 0.0f) + "\" class=\"" + btn1.getId() + "_cls\"/>\n                    <rect y=\"95.5\" width=\"100%\" height=\"50%\"  class=\"" + btn2.getId() + "_cls\" />\n                    <text text-anchor=\"middle\" x=\"150\" y=\"67.75\" fill=\"#000\" opacity=\"0.25\" class=\"oddstyle\">" + text1 + "</text>\n                    <text text-anchor=\"middle\" x=\"151\" y=\"64.75\" fill=\"blue\" class=\"oddstyle\">" + text1 + "</text>\n                    <text text-anchor=\"middle\" x=\"150\" y=\"166.25\" fill=\"#000\" opacity=\"0.25\" class=\"evenstyle\">" + text2 + "</text>\n                    <text text-anchor=\"middle\" x=\"151\" y=\"163.25\" class=\"evenstyle\">" + text2 + "</text>\n                </g>\n            </svg>\n        "));
    }

    @NotNull
    public String generateRectPathData(float width, float height, float topLetRound, float topRightRound, float bottomRightRound, float bottomLeftRound) {
        return "M 0 " + topLetRound + " \n A " + topLetRound + " " + topLetRound + " 0 0 1 " + topLetRound + " 0\n L " + (width - topRightRound) + " 0\n A " + topRightRound + " " + topRightRound + " 0 0 1 " + width + " " + topRightRound + "\n L " + width + " " + (height - bottomRightRound) + "\n A " + bottomRightRound + " " + bottomRightRound + " 0 0 1 " + (width - bottomRightRound) + " " + height + "\n L " + bottomLeftRound + " " + height + "\n A " + bottomLeftRound + " " + bottomLeftRound + " 0 0 1 0 " + (height - bottomLeftRound) + "\n Z";
    }
}

